/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.types;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.access.types.ExtendedType;
import org.apache.cayenne.access.types.ExtendedTypeDecorator;
import org.apache.cayenne.access.types.ExtendedTypeFactory;
import org.apache.cayenne.access.types.ExtendedTypeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SerializableTypeFactory
implements ExtendedTypeFactory {
    private ExtendedTypeMap map;

    SerializableTypeFactory(ExtendedTypeMap map) {
        this.map = map;
    }

    @Override
    public ExtendedType getType(Class<?> objectClass) {
        if (Serializable.class.isAssignableFrom(objectClass)) {
            ExtendedType bytesType = this.map.getExplictlyRegisteredType("byte[]");
            if (bytesType instanceof SerializableType) {
                throw new IllegalStateException("Can't create Serializable ExtendedType for " + objectClass.getName() + ": no ExtendedType exists for byte[]");
            }
            return new SerializableType(objectClass, bytesType);
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class SerializableType
    extends ExtendedTypeDecorator {
        private Class<?> javaClass;

        SerializableType(Class<?> javaClass, ExtendedType bytesType) {
            super(bytesType);
            this.javaClass = javaClass;
        }

        @Override
        public String getClassName() {
            return this.javaClass.getName();
        }

        @Override
        Object fromJavaObject(Object object) {
            ByteArrayOutputStream bytes = new ByteArrayOutputStream(){

                public synchronized byte[] toByteArray() {
                    return this.buf;
                }
            };
            try {
                ObjectOutputStream out = new ObjectOutputStream(bytes);
                out.writeObject(object);
                out.close();
            }
            catch (Exception e) {
                throw new CayenneRuntimeException("Error serializing object", e);
            }
            return bytes.toByteArray();
        }

        @Override
        Object toJavaObject(Object object) {
            byte[] bytes = (byte[])object;
            try {
                return bytes != null && bytes.length > 0 ? new ObjectInputStream(new ByteArrayInputStream(bytes)).readObject() : null;
            }
            catch (Exception e) {
                throw new CayenneRuntimeException("Error deserializing object", e);
            }
        }
    }
}

