/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.action;

import java.awt.event.ActionEvent;
import org.apache.cayenne.access.DataDomain;
import org.apache.cayenne.map.event.DomainEvent;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.event.DomainDisplayEvent;
import org.apache.cayenne.modeler.undo.CreateDomainUndoableEdit;
import org.apache.cayenne.modeler.util.CayenneAction;
import org.apache.cayenne.project.ApplicationProject;
import org.apache.cayenne.project.NamedObjectFactory;
import org.apache.cayenne.project.ProjectPath;

public class CreateDomainAction
extends CayenneAction {
    public static String getActionName() {
        return "Create DataDomain";
    }

    public CreateDomainAction(Application application) {
        super(CreateDomainAction.getActionName(), application);
    }

    public String getIconName() {
        return "icon-dom.gif";
    }

    public void performAction(ActionEvent e) {
        ApplicationProject project = (ApplicationProject)this.getCurrentProject();
        ProjectController mediator = this.getProjectController();
        DataDomain domain = (DataDomain)NamedObjectFactory.createObject(DataDomain.class, (Object)project.getConfiguration());
        domain.getEntityResolver().setIndexedByClass(false);
        this.createDomain(domain);
        this.application.getUndoManager().addEdit(new CreateDomainUndoableEdit(domain));
    }

    public void createDomain(DataDomain domain) {
        ApplicationProject project = (ApplicationProject)this.getCurrentProject();
        ProjectController mediator = this.getProjectController();
        project.getConfiguration().addDomain(domain);
        mediator.fireDomainEvent(new DomainEvent((Object)this, domain, 2));
        mediator.fireDomainDisplayEvent(new DomainDisplayEvent((Object)this, domain));
    }

    public boolean enableForPath(ProjectPath path) {
        if (path == null) {
            return false;
        }
        return path.firstInstanceOf(ApplicationProject.class) != null;
    }
}

