/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.action;

import java.awt.event.ActionEvent;
import org.apache.cayenne.map.Attribute;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.Embeddable;
import org.apache.cayenne.map.EmbeddableAttribute;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.event.AttributeEvent;
import org.apache.cayenne.map.event.EmbeddableAttributeEvent;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.action.MultipleObjectsAction;
import org.apache.cayenne.modeler.action.RemoveAction;
import org.apache.cayenne.modeler.dialog.ConfirmRemoveDialog;
import org.apache.cayenne.modeler.undo.RemoveAttributeUndoableEdit;
import org.apache.cayenne.modeler.util.ProjectUtil;
import org.apache.cayenne.project.ProjectPath;

public class RemoveAttributeAction
extends RemoveAction
implements MultipleObjectsAction {
    private static final String ACTION_NAME = "Remove Attribute";
    private static final String ACTION_NAME_MULTIPLE = "Remove Attributes";

    public static String getActionName() {
        return ACTION_NAME;
    }

    public String getActionName(boolean multiple) {
        return multiple ? ACTION_NAME_MULTIPLE : ACTION_NAME;
    }

    public RemoveAttributeAction(Application application) {
        super(ACTION_NAME, application);
    }

    public boolean enableForPath(ProjectPath path) {
        if (path == null) {
            return false;
        }
        return path.getObject() instanceof Attribute;
    }

    public void performAction(ActionEvent e, boolean allowAsking) {
        ConfirmRemoveDialog dialog = this.getConfirmDeleteDialog(allowAsking);
        ProjectController mediator = this.getProjectController();
        EmbeddableAttribute[] embAttrs = this.getProjectController().getCurrentEmbAttrs();
        ObjAttribute[] attrs = this.getProjectController().getCurrentObjAttributes();
        if (embAttrs != null && embAttrs.length > 0) {
            if (embAttrs.length == 1 && dialog.shouldDelete("Embeddable Attribute", embAttrs[0].getName()) || embAttrs.length > 1 && dialog.shouldDelete("selected EmbAttributes")) {
                Embeddable embeddable = mediator.getCurrentEmbeddable();
                EmbeddableAttribute[] eAttrs = this.getProjectController().getCurrentEmbAttrs();
                this.application.getUndoManager().addEdit(new RemoveAttributeUndoableEdit(embeddable, eAttrs));
                this.removeEmbeddableAttributes(embeddable, eAttrs);
            }
        } else if (attrs != null && attrs.length > 0) {
            if (attrs.length == 1 && dialog.shouldDelete("ObjAttribute", attrs[0].getName()) || attrs.length > 1 && dialog.shouldDelete("selected ObjAttributes")) {
                ObjEntity entity = mediator.getCurrentObjEntity();
                ObjAttribute[] attribs = mediator.getCurrentObjAttributes();
                this.application.getUndoManager().addEdit(new RemoveAttributeUndoableEdit(mediator.getCurrentDataDomain(), mediator.getCurrentDataMap(), entity, attribs));
                this.removeObjAttributes(entity, attribs);
            }
        } else {
            DbAttribute[] dbAttrs = this.getProjectController().getCurrentDbAttributes();
            if (dbAttrs != null && dbAttrs.length > 0 && (dbAttrs.length == 1 && dialog.shouldDelete("DbAttribute", dbAttrs[0].getName()) || dbAttrs.length > 1 && dialog.shouldDelete("selected DbAttributes"))) {
                DbEntity entity = mediator.getCurrentDbEntity();
                DbAttribute[] attribs = mediator.getCurrentDbAttributes();
                ProjectPath[] paths = this.getProjectController().getCurrentPaths();
                this.application.getUndoManager().addEdit(new RemoveAttributeUndoableEdit(mediator.getCurrentDataDomain(), mediator.getCurrentDataMap(), entity, attribs));
                this.removeDbAttributes(mediator.getCurrentDataMap(), entity, attribs);
            }
        }
    }

    public void removeDbAttributes(DataMap dataMap, DbEntity entity, DbAttribute[] attribs) {
        ProjectController mediator = this.getProjectController();
        for (DbAttribute attrib : attribs) {
            entity.removeAttribute(attrib.getName());
            AttributeEvent e = new AttributeEvent((Object)Application.getFrame(), (Attribute)attrib, (Entity)entity, 3);
            mediator.fireDbAttributeEvent(e);
        }
        ProjectUtil.cleanObjMappings(dataMap);
    }

    public void removeObjAttributes(ObjEntity entity, ObjAttribute[] attribs) {
        ProjectController mediator = this.getProjectController();
        for (ObjAttribute attrib : attribs) {
            entity.removeAttribute(attrib.getName());
            AttributeEvent e = new AttributeEvent((Object)Application.getFrame(), (Attribute)attrib, (Entity)entity, 3);
            mediator.fireObjAttributeEvent(e);
        }
    }

    public void removeEmbeddableAttributes(Embeddable embeddable, EmbeddableAttribute[] attrs) {
        ProjectController mediator = this.getProjectController();
        for (EmbeddableAttribute attrib : attrs) {
            embeddable.removeAttribute(attrib.getName());
            EmbeddableAttributeEvent e = new EmbeddableAttributeEvent((Object)Application.getFrame(), attrib, embeddable, 3);
            mediator.fireEmbeddableAttributeEvent(e);
        }
    }
}

