/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.event.QueryEvent;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.editor.RawQueryPropertiesPanel;
import org.apache.cayenne.modeler.editor.SelectPropertiesPanel;
import org.apache.cayenne.modeler.event.QueryDisplayEvent;
import org.apache.cayenne.modeler.event.QueryDisplayListener;
import org.apache.cayenne.modeler.util.CayenneWidgetFactory;
import org.apache.cayenne.modeler.util.CellRenderers;
import org.apache.cayenne.modeler.util.Comparators;
import org.apache.cayenne.modeler.util.ProjectUtil;
import org.apache.cayenne.modeler.util.TextAdapter;
import org.apache.cayenne.query.AbstractQuery;
import org.apache.cayenne.query.CapsStrategy;
import org.apache.cayenne.query.ProcedureQuery;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.util.Util;
import org.apache.cayenne.validation.ValidationException;

public class ProcedureQueryView
extends JPanel {
    private static final String DEFAULT_CAPS_LABEL = "Database Default";
    private static final String LOWER_CAPS_LABEL = "Force Lower Case";
    private static final String UPPER_CAPS_LABEL = "Force Upper Case";
    private static final CapsStrategy[] LABEL_CAPITALIZATION = new CapsStrategy[]{CapsStrategy.DEFAULT, CapsStrategy.LOWER, CapsStrategy.UPPER};
    private static final Map<CapsStrategy, String> labelCapsLabels = new HashMap<CapsStrategy, String>();
    protected ProjectController mediator;
    protected TextAdapter name;
    protected JComboBox queryRoot;
    protected SelectPropertiesPanel properties;

    public ProcedureQueryView(ProjectController mediator) {
        this.mediator = mediator;
        this.initView();
        this.initController();
    }

    private void initView() {
        this.name = new TextAdapter(new JTextField()){

            protected void updateModel(String text) {
                ProcedureQueryView.this.setQueryName(text);
            }
        };
        this.queryRoot = CayenneWidgetFactory.createUndoableComboBox();
        this.queryRoot.setRenderer(CellRenderers.listRendererWithIcons());
        this.properties = new ProcedureQueryPropertiesPanel(this.mediator);
        CellConstraints cc = new CellConstraints();
        FormLayout layout = new FormLayout("right:max(80dlu;pref), 3dlu, fill:max(200dlu;pref)", "p, 3dlu, p, 3dlu, p");
        PanelBuilder builder = new PanelBuilder(layout);
        builder.setDefaultDialogBorder();
        builder.addSeparator("ProcedureQuery Settings", cc.xywh(1, 1, 3, 1));
        builder.addLabel("Query Name:", cc.xy(1, 3));
        builder.add((Component)this.name.getComponent(), cc.xy(3, 3));
        builder.addLabel("Procedure:", cc.xy(1, 5));
        builder.add((Component)this.queryRoot, cc.xy(3, 5));
        this.setLayout(new BorderLayout());
        this.add((Component)builder.getPanel(), "North");
        this.add((Component)this.properties, "Center");
    }

    private void initController() {
        this.queryRoot.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                AbstractQuery query = (AbstractQuery)ProcedureQueryView.this.mediator.getCurrentQuery();
                if (query != null) {
                    query.setRoot(ProcedureQueryView.this.queryRoot.getModel().getSelectedItem());
                    ProcedureQueryView.this.mediator.fireQueryEvent(new QueryEvent((Object)this, (Query)query));
                }
            }
        });
        this.mediator.addQueryDisplayListener(new QueryDisplayListener(){

            public void currentQueryChanged(QueryDisplayEvent e) {
                ProcedureQueryView.this.initFromModel();
            }
        });
    }

    void initFromModel() {
        Query query = this.mediator.getCurrentQuery();
        if (!(query instanceof ProcedureQuery)) {
            this.setVisible(false);
            return;
        }
        ProcedureQuery procedureQuery = (ProcedureQuery)query;
        this.properties.setEnabled(true);
        this.name.setText(procedureQuery.getName());
        DataMap map = this.mediator.getCurrentDataMap();
        Object[] roots = map.getProcedures().toArray();
        if (roots.length > 1) {
            Arrays.sort(roots, Comparators.getDataMapChildrenComparator());
        }
        DefaultComboBoxModel<Object> model = new DefaultComboBoxModel<Object>(roots);
        model.setSelectedItem(procedureQuery.getRoot());
        this.queryRoot.setModel(model);
        this.properties.initFromModel((Query)procedureQuery);
        this.setVisible(true);
    }

    void setQueryName(String newName) {
        AbstractQuery query;
        if (newName != null && newName.trim().length() == 0) {
            newName = null;
        }
        if ((query = (AbstractQuery)this.mediator.getCurrentQuery()) == null) {
            return;
        }
        if (Util.nullSafeEquals((Object)newName, (Object)query.getName())) {
            return;
        }
        if (newName == null) {
            throw new ValidationException("Query name is required.");
        }
        DataMap map = this.mediator.getCurrentDataMap();
        if (map.getQuery(newName) != null) {
            throw new ValidationException("There is another query named '" + newName + "'. Use a different name.");
        }
        QueryEvent e = new QueryEvent((Object)this, (Query)query, query.getName(), map);
        ProjectUtil.setQueryName(map, (Query)query, newName);
        this.mediator.fireQueryEvent(e);
    }

    ObjEntity getEntity(ProcedureQuery query) {
        String entityName = query.getResultEntityName();
        if (entityName == null) {
            return null;
        }
        DataMap map = this.mediator.getCurrentDataMap();
        if (map == null) {
            return null;
        }
        return map.getObjEntity(entityName);
    }

    void setEntity(ObjEntity entity) {
        Query query = this.mediator.getCurrentQuery();
        if (query instanceof ProcedureQuery) {
            ProcedureQuery procedureQuery = (ProcedureQuery)query;
            procedureQuery.setResultEntityName(entity != null ? entity.getName() : null);
            this.mediator.fireQueryEvent(new QueryEvent((Object)this, (Query)procedureQuery));
        }
    }

    static {
        labelCapsLabels.put(CapsStrategy.DEFAULT, DEFAULT_CAPS_LABEL);
        labelCapsLabels.put(CapsStrategy.LOWER, LOWER_CAPS_LABEL);
        labelCapsLabels.put(CapsStrategy.UPPER, UPPER_CAPS_LABEL);
    }

    final class ProcedureQueryPropertiesPanel
    extends RawQueryPropertiesPanel {
        private JComboBox labelCase;

        ProcedureQueryPropertiesPanel(ProjectController mediator) {
            super(mediator);
        }

        protected PanelBuilder createPanelBuilder() {
            RowSpec[] extraRows;
            this.labelCase = CayenneWidgetFactory.createUndoableComboBox();
            this.labelCase.setRenderer(new LabelCapsRenderer());
            this.labelCase.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    Object value = ProcedureQueryPropertiesPanel.this.labelCase.getModel().getSelectedItem();
                    ProcedureQueryPropertiesPanel.this.setQueryProperty("columnNamesCapitalization", value);
                }
            });
            PanelBuilder builder = super.createPanelBuilder();
            for (RowSpec extraRow : extraRows = RowSpec.decodeSpecs((String)"3dlu, p")) {
                builder.appendRow(extraRow);
            }
            CellConstraints cc = new CellConstraints();
            builder.addLabel("Row Label Case:", cc.xy(1, 17));
            builder.add((Component)this.labelCase, cc.xywh(3, 17, 5, 1));
            return builder;
        }

        public void initFromModel(Query query) {
            super.initFromModel(query);
            if (query instanceof ProcedureQuery) {
                ProcedureQuery template = (ProcedureQuery)query;
                DefaultComboBoxModel<CapsStrategy> labelCaseModel = new DefaultComboBoxModel<CapsStrategy>(LABEL_CAPITALIZATION);
                labelCaseModel.setSelectedItem(template.getColumnNamesCapitalization());
                this.labelCase.setModel(labelCaseModel);
            }
        }

        protected void setEntity(ObjEntity entity) {
            ProcedureQueryView.this.setEntity(entity);
        }

        public ObjEntity getEntity(Query query) {
            if (query instanceof ProcedureQuery) {
                return ProcedureQueryView.this.getEntity((ProcedureQuery)query);
            }
            return null;
        }
    }

    final class LabelCapsRenderer
    extends DefaultListCellRenderer {
        LabelCapsRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object object, int arg2, boolean arg3, boolean arg4) {
            object = labelCapsLabels.get(object);
            return super.getListCellRendererComponent((JList<?>)list, object, arg2, arg3, arg4);
        }
    }
}

