/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.jdbc;

import java.sql.ResultSet;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.access.jdbc.EntityRowReader;
import org.apache.cayenne.access.jdbc.RowDescriptor;
import org.apache.cayenne.map.EntityInheritanceTree;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.query.EntityResultSegment;

class InheritanceAwareEntityRowReader
extends EntityRowReader {
    private EntityInheritanceTree entityInheritanceTree;

    public InheritanceAwareEntityRowReader(RowDescriptor descriptor, EntityResultSegment segmentMetadata) {
        super(descriptor, segmentMetadata);
        this.entityInheritanceTree = segmentMetadata.getClassDescriptor().getEntityInheritanceTree();
    }

    void postprocessRow(ResultSet resultSet, DataRow dataRow) throws Exception {
        ObjEntity entity;
        if (this.postProcessor != null) {
            this.postProcessor.postprocessRow(resultSet, dataRow);
        }
        dataRow.setEntityName((entity = this.entityInheritanceTree.entityMatchingRow(dataRow)) != null ? entity.getName() : this.entityName);
    }
}

