/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.project;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.cayenne.conf.ConfigStatus;
import org.apache.cayenne.project.ApplicationProject;
import org.apache.cayenne.project.DataMapProject;
import org.apache.cayenne.project.FlatProjectView;
import org.apache.cayenne.project.ProjectException;
import org.apache.cayenne.project.ProjectFile;
import org.apache.cayenne.project.ProjectPath;
import org.apache.cayenne.project.validator.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Project {
    public static final String CURRENT_PROJECT_VERSION = "3.0.0.1";
    static final int UPGRADE_STATUS_OLD = -1;
    static final int UPGRADE_STATUS_CURRENT = 0;
    static final int UPGRADE_STATUS_NEW = 1;
    protected File projectDir;
    protected List<ProjectFile> files = new ArrayList<ProjectFile>();
    protected int upgradeStatus;
    protected List<String> upgradeMessages;
    protected boolean modified;

    public static Project createProject(File projectFile) {
        String fileName = projectFile.getName();
        if (fileName.endsWith("cayenne.xml")) {
            return new ApplicationProject(projectFile);
        }
        if (fileName.endsWith(".map.xml")) {
            return new DataMapProject(projectFile);
        }
        throw new ProjectException("Unsupported project file: " + projectFile);
    }

    protected Project() {
    }

    public Project(File projectFile) {
        this.initialize(projectFile);
        this.postInitialize(projectFile);
    }

    protected void initialize(File projectFile) {
        if (projectFile != null) {
            File parent = projectFile.getParentFile();
            if (parent == null) {
                parent = new File(System.getProperty("user.dir"));
            }
            if (!parent.isDirectory()) {
                throw new ProjectException("Project directory does not exist or is not a directory: " + parent);
            }
            try {
                this.projectDir = parent.getCanonicalFile();
            }
            catch (IOException e) {
                throw new ProjectException("Error creating project.", e);
            }
        }
    }

    protected void postInitialize(File projectFile) {
        this.files = Collections.synchronizedList(this.buildFileList());
        this.upgradeMessages = Collections.synchronizedList(new ArrayList());
        this.checkForUpgrades();
    }

    public boolean isLocationUndefined() {
        return this.getMainFile() == null;
    }

    public int getUpgradeStatus() {
        return this.upgradeStatus;
    }

    public List<String> getUpgradeMessages() {
        return this.upgradeMessages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasRenamedFiles() {
        if (this.files == null) {
            return false;
        }
        List<ProjectFile> list = this.files;
        synchronized (list) {
            for (ProjectFile file : this.files) {
                if (!file.isRenamed()) continue;
                return true;
            }
        }
        return false;
    }

    public List<ProjectFile> buildFileList() {
        ArrayList<ProjectFile> projectFiles = new ArrayList<ProjectFile>();
        Iterator nodes = this.treeNodes();
        while (nodes.hasNext()) {
            ProjectPath nodePath = (ProjectPath)nodes.next();
            Object obj = nodePath.getObject();
            ProjectFile f = this.projectFileForObject(obj);
            if (f == null) continue;
            projectFiles.add(f);
        }
        return projectFiles;
    }

    public Validator getValidator() {
        return new Validator(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProjectFile findFile(Object obj) {
        if (obj == null) {
            return null;
        }
        List<ProjectFile> list = this.files;
        synchronized (list) {
            for (ProjectFile file : this.files) {
                if (file.getObject() != obj) continue;
                return file;
            }
        }
        return null;
    }

    public File resolveFile(String symbolicName) {
        try {
            if (File.separatorChar != '/') {
                symbolicName = symbolicName.replace('/', File.separatorChar);
            }
            return new File(this.projectDir, symbolicName).getCanonicalFile();
        }
        catch (IOException e) {
            return null;
        }
    }

    public String resolveSymbolicName(File file) {
        String symbolicName = null;
        try {
            String otherPath = file.getCanonicalFile().getPath();
            String thisPath = this.projectDir.getPath();
            if (otherPath.length() + 1 <= thisPath.length() || !otherPath.startsWith(thisPath)) {
                return null;
            }
            symbolicName = otherPath.substring(thisPath.length() + 1);
            if (symbolicName != null && File.separatorChar != '/') {
                symbolicName = symbolicName.replace(File.separatorChar, '/');
            }
            return symbolicName;
        }
        catch (IOException e) {
            return null;
        }
    }

    public File getProjectDirectory() {
        return this.projectDir;
    }

    public void setProjectDirectory(File dir) {
        this.projectDir = dir;
    }

    public File getMainFile() {
        if (this.projectDir == null) {
            return null;
        }
        ProjectFile f = this.projectFileForObject(this);
        return f != null ? this.resolveFile(f.getLocation()) : null;
    }

    public abstract ConfigStatus getLoadStatus();

    public abstract ProjectFile projectFileForObject(Object var1);

    public abstract List getChildren();

    public abstract void checkForUpgrades();

    public Iterator treeNodes() {
        return FlatProjectView.getInstance().flattenProjectTree(this).iterator();
    }

    public abstract void upgrade() throws ProjectException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() throws ProjectException {
        if (this.isLocationUndefined()) {
            throw new ProjectException("Project location is undefined.");
        }
        ArrayList<ProjectFile> filesToSave = new ArrayList<ProjectFile>();
        ArrayList<Object> wrappedObjects = new ArrayList<Object>();
        this.prepareSave(filesToSave, wrappedObjects);
        this.processSave(filesToSave);
        ArrayList<File> savedFiles = new ArrayList<File>();
        for (ProjectFile file : filesToSave) {
            savedFiles.add(file.saveCommit());
        }
        this.processDelete(wrappedObjects, savedFiles);
        List<ProjectFile> freshList = this.buildFileList();
        for (ProjectFile file : freshList) {
            file.synchronizeLocation();
        }
        this.files = freshList;
        List<String> list = this.upgradeMessages;
        synchronized (list) {
            this.upgradeMessages.clear();
        }
        this.setModified(false);
    }

    protected void prepareSave(List<ProjectFile> filesToSave, List<Object> wrappedObjects) throws ProjectException {
        Iterator nodes = this.treeNodes();
        while (nodes.hasNext()) {
            ProjectPath nodePath = (ProjectPath)nodes.next();
            Object obj = nodePath.getObject();
            ProjectFile existingFile = this.findFile(obj);
            if (existingFile == null) {
                ProjectFile newFile = this.projectFileForObject(obj);
                if (newFile == null) continue;
                filesToSave.add(newFile);
                continue;
            }
            if (!existingFile.canHandleObject()) continue;
            wrappedObjects.add(existingFile.getObject());
            filesToSave.add(existingFile);
        }
    }

    protected void processSave(List<ProjectFile> modifiedFiles) throws ProjectException {
        for (ProjectFile file : modifiedFiles) {
            file.willSave();
        }
        try {
            for (ProjectFile file : modifiedFiles) {
                file.saveTemp();
            }
        }
        catch (Exception ex) {
            for (ProjectFile file : modifiedFiles) {
                file.saveUndo();
            }
            throw new ProjectException("Project save failed and was cancelled.", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processDelete(List<Object> existingObjects, List<File> savedFiles) {
        List<ProjectFile> list = this.files;
        synchronized (list) {
            for (ProjectFile f : this.files) {
                File file = f.resolveOldFile();
                if (file == null || savedFiles.contains(file)) continue;
                boolean delete2 = false;
                if (f.isRenamed()) {
                    delete2 = true;
                } else if (f.getObject() == null) {
                    delete2 = true;
                } else if (!existingObjects.contains(f.getObject())) {
                    delete2 = true;
                } else if (!f.canHandleObject()) {
                    delete2 = true;
                }
                if (!delete2) continue;
                this.deleteFile(file);
            }
        }
    }

    protected boolean deleteFile(File f) {
        return f.exists() ? f.delete() : true;
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean modified) {
        this.modified = modified;
    }
}

