/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils.converters;

import junit.framework.TestCase;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.converters.BooleanConverter;

public class BooleanConverterTestCase
extends TestCase {
    public static final String[] STANDARD_TRUES = new String[]{"yes", "y", "true", "on", "1"};
    public static final String[] STANDARD_FALSES = new String[]{"no", "n", "false", "off", "0"};

    public BooleanConverterTestCase(String name) {
        super(name);
    }

    public void testAdditionalStrings() {
        String[] trueStrings = new String[]{"sure"};
        String[] falseStrings = new String[]{"nope"};
        BooleanConverter converter = new BooleanConverter(trueStrings, falseStrings, BooleanConverter.NO_DEFAULT);
        this.testConversionValues(converter, new String[]{"sure", "Sure"}, new String[]{"nope", "nOpE"});
        try {
            converter.convert(Boolean.class, (Object)"true");
            BooleanConverterTestCase.fail((String)"Converting obsolete true value should have generated an exception");
        }
        catch (ConversionException conversionException) {
            // empty catch block
        }
        try {
            converter.convert(Boolean.class, (Object)"bogus");
            BooleanConverterTestCase.fail((String)"Converting invalid string should have generated an exception");
        }
        catch (ConversionException conversionException) {
            // empty catch block
        }
    }

    public void testCaseInsensitivity() {
        BooleanConverter converter = new BooleanConverter();
        this.testConversionValues(converter, new String[]{"Yes", "TRUE"}, new String[]{"NO", "fAlSe"});
    }

    public void testConversionToOtherType() {
        BooleanConverter converter = new BooleanConverter();
        try {
            converter.convert(Integer.class, (Object)STANDARD_TRUES[0]);
            BooleanConverterTestCase.fail((String)"Could convert to unsupported type!");
        }
        catch (ConversionException conversionException) {
            // empty catch block
        }
    }

    protected void testConversionValues(BooleanConverter converter, String[] trueValues, String[] falseValues) {
        for (String trueValue : trueValues) {
            BooleanConverterTestCase.assertEquals((Object)Boolean.TRUE, (Object)converter.convert(Boolean.class, (Object)trueValue));
        }
        for (String falseValue : falseValues) {
            BooleanConverterTestCase.assertEquals((Object)Boolean.FALSE, (Object)converter.convert(Boolean.class, (Object)falseValue));
        }
    }

    public void testDefaultValue() {
        Boolean defaultValue = Boolean.TRUE;
        BooleanConverter converter = new BooleanConverter((Object)defaultValue);
        BooleanConverterTestCase.assertSame((Object)defaultValue, (Object)converter.convert(Boolean.class, (Object)"bogus"));
        this.testConversionValues(converter, STANDARD_TRUES, STANDARD_FALSES);
    }

    public void testInvalidString() {
        BooleanConverter converter = new BooleanConverter();
        try {
            converter.convert(Boolean.class, (Object)"bogus");
            BooleanConverterTestCase.fail((String)"Converting invalid string should have generated an exception");
        }
        catch (ConversionException conversionException) {
            // empty catch block
        }
    }

    public void testPrimitiveTargetClass() {
        BooleanConverter converter = new BooleanConverter();
        BooleanConverterTestCase.assertTrue((String)"Wrong result", (boolean)((Boolean)converter.convert(Boolean.TYPE, (Object)STANDARD_TRUES[0])));
    }

    public void testStandardValues() {
        BooleanConverter converter = new BooleanConverter();
        this.testConversionValues(converter, STANDARD_TRUES, STANDARD_FALSES);
    }
}

