/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils2.locale.converters;

import java.text.ParseException;
import java.util.Locale;
import org.apache.commons.beanutils2.ConversionException;
import org.apache.commons.beanutils2.locale.converters.DecimalLocaleConverter;

public class FloatLocaleConverter
extends DecimalLocaleConverter<Float> {
    public static Builder builder() {
        return new Builder();
    }

    private FloatLocaleConverter(Float defaultValue, Locale locale, String pattern, boolean useDefault, boolean locPattern) {
        super(defaultValue, locale, pattern, useDefault, locPattern);
    }

    @Override
    protected Float parse(Object value, String pattern) throws ParseException {
        double posDouble;
        Object parsed = super.parse(value, pattern);
        double doubleValue = ((Number)parsed).doubleValue();
        double d = posDouble = doubleValue >= 0.0 ? doubleValue : doubleValue * -1.0;
        if (posDouble != 0.0 && (posDouble < (double)1.4E-45f || posDouble > 3.4028234663852886E38)) {
            throw new ConversionException("Supplied number is not of type Float: " + parsed);
        }
        return Float.valueOf(((Number)parsed).floatValue());
    }

    public static class Builder
    extends DecimalLocaleConverter.Builder<Builder, Float> {
        @Override
        public FloatLocaleConverter get() {
            return new FloatLocaleConverter((Float)this.defaultValue, this.locale, this.pattern, this.useDefault || this.defaultValue != null, this.localizedPattern);
        }
    }
}

