/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.compress.AbstractTest;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.compress.archivers.zip.ZipMethod;
import org.apache.commons.compress.compressors.zstandard.ZstdCompressorInputStream;
import org.apache.commons.compress.compressors.zstandard.ZstdCompressorOutputStream;
import org.apache.commons.compress.compressors.zstandard.ZstdUtils;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;

class ZipCompressMethodZstdTest
extends AbstractTest {
    private static final int DEFAULT_LEVEL = 3;

    ZipCompressMethodZstdTest() {
    }

    private static void compress(InputStream input, OutputStream output) throws IOException {
        ZstdCompressorOutputStream outputStream = new ZstdCompressorOutputStream(output, 3, true);
        IOUtils.copyLarge((InputStream)input, (OutputStream)outputStream);
        outputStream.flush();
    }

    @Test
    void testZstdInputStream() throws IOException {
        Path file = ZipCompressMethodZstdTest.getPath("COMPRESS-692/compress-692.zip");
        try (ZipFile zip = ((ZipFile.Builder)ZipFile.builder().setFile(file.toFile())).get();){
            ZipArchiveEntry entry = (ZipArchiveEntry)zip.getEntries().nextElement();
            Assert.assertEquals((String)"Unexpected first entry", (Object)"dolor.txt", (Object)entry.getName());
            Assert.assertTrue((String)"entry can't be read", (boolean)zip.canReadEntryData(entry));
            Assert.assertEquals((String)"Unexpected method", (long)ZipMethod.ZSTD.getCode(), (long)entry.getMethod());
            try (InputStream inputStream = zip.getInputStream(entry);){
                long uncompSize = entry.getSize();
                byte[] buf = new byte[(int)uncompSize];
                inputStream.read(buf);
                String uncompData = new String(buf);
                Assert.assertTrue((boolean)uncompData.startsWith("dolor sit amet"));
                Assert.assertTrue((boolean)uncompData.endsWith("ex ea commodo"));
                Assert.assertEquals((long)6066L, (long)uncompData.length());
            }
        }
    }

    @ParameterizedTest
    @EnumSource(names={"ZSTD", "ZSTD_DEPRECATED"})
    void testZstdMethod(ZipMethod zipMethod) throws IOException {
        String zipContentFile = "Name.txt";
        byte[] simpleText = "This is a Simple Test File.".getBytes();
        File file = Files.createTempFile("", ".zip", new FileAttribute[0]).toFile();
        try (ZipArchiveOutputStream zipOutputStream = new ZipArchiveOutputStream(file);){
            ZipArchiveEntry archiveEntry = new ZipArchiveEntry("Name.txt");
            archiveEntry.setMethod(zipMethod.getCode());
            archiveEntry.setSize((long)simpleText.length);
            zipOutputStream.putArchiveEntry(archiveEntry);
            ZipCompressMethodZstdTest.compress(new ByteArrayInputStream(simpleText), (OutputStream)zipOutputStream);
            zipOutputStream.closeArchiveEntry();
        }
        try (ZipFile zipFile = ((ZipFile.Builder)ZipFile.builder().setFile(file)).get();){
            ZipArchiveEntry entry = zipFile.getEntry("Name.txt");
            Assert.assertEquals((long)entry.getMethod(), (long)zipMethod.getCode());
            InputStream inputStream = zipFile.getInputStream(entry);
            Assert.assertTrue((String)"Input stream must be a ZstdInputStream", (boolean)(inputStream instanceof ZstdCompressorInputStream));
        }
    }

    @ParameterizedTest
    @EnumSource(names={"ZSTD", "ZSTD_DEPRECATED"})
    void testZstdMethodInZipFile(ZipMethod zipMethod) throws IOException {
        String zipContentFile = "Name.txt";
        byte[] simpleText = "This is a Simple Test File.".getBytes();
        File file = Files.createTempFile("", ".zip", new FileAttribute[0]).toFile();
        try (ZipArchiveOutputStream zipOutputStream = new ZipArchiveOutputStream(file);){
            ZipArchiveEntry archiveEntry = new ZipArchiveEntry("Name.txt");
            archiveEntry.setMethod(zipMethod.getCode());
            archiveEntry.setSize((long)simpleText.length);
            zipOutputStream.putArchiveEntry(archiveEntry);
            ZipCompressMethodZstdTest.compress(new ByteArrayInputStream(simpleText), (OutputStream)zipOutputStream);
            zipOutputStream.closeArchiveEntry();
        }
        try (ZipFile zipFile = ((ZipFile.Builder)ZipFile.builder().setFile(file)).get();){
            ZipArchiveEntry entry = zipFile.getEntry("Name.txt");
            Assert.assertEquals((long)entry.getMethod(), (long)zipMethod.getCode());
            InputStream inputStream = zipFile.getInputStream(entry);
            Assert.assertTrue((boolean)(inputStream instanceof ZstdCompressorInputStream));
            long dataOffset = entry.getDataOffset();
            int uncompressedSize = (int)entry.getSize();
            Assert.assertEquals((long)simpleText.length, (long)uncompressedSize);
            byte[] uncompressedData = new byte[uncompressedSize];
            inputStream.read(uncompressedData, 0, uncompressedSize);
            Assert.assertEquals((Object)new String(simpleText), (Object)new String(uncompressedData));
            try (FileInputStream fileInputStream = new FileInputStream(file);){
                fileInputStream.skip(dataOffset);
                byte[] compressedData = new byte[4];
                fileInputStream.read(compressedData);
                Assert.assertTrue((String)"Compressed data must begin with the magic bytes of Zstd", (boolean)ZstdUtils.matches((byte[])compressedData, (int)4));
            }
        }
    }
}

