/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors.zstandard;

import com.github.luben.zstd.ZstdOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.apache.commons.compress.AbstractTest;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.compressors.CompressorOutputStream;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.apache.commons.compress.compressors.zstandard.ZstdCompressorInputStream;
import org.apache.commons.compress.compressors.zstandard.ZstdCompressorOutputStream;
import org.apache.commons.compress.compressors.zstandard.ZstdConstants;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.function.IOFunction;
import org.apache.commons.lang3.ArrayUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junitpioneer.jupiter.cartesian.CartesianTest;

class ZstdRoundtripTest
extends AbstractTest {
    ZstdRoundtripTest() {
    }

    private void roundtrip(OutputStreamCreator oc) throws IOException {
        Path input = ZstdRoundtripTest.getPath("bla.tar");
        File output = this.newTempFile(input.getFileName() + ".zstd");
        try (FileOutputStream os = new FileOutputStream(output);
             ZstdCompressorOutputStream zos = (ZstdCompressorOutputStream)oc.apply(os);){
            zos.write(input);
            zos.close();
            Assertions.assertTrue((boolean)zos.isClosed());
        }
        try (ZstdCompressorInputStream zis = new ZstdCompressorInputStream(Files.newInputStream(output.toPath(), new OpenOption[0]));){
            byte[] expected = Files.readAllBytes(input);
            byte[] actual = IOUtils.toByteArray((InputStream)zis);
            Assertions.assertArrayEquals((byte[])expected, (byte[])actual);
        }
    }

    @Test
    void testDirectRoundtrip() throws Exception {
        this.roundtrip(ZstdCompressorOutputStream::new);
    }

    @Test
    void testFactoryRoundtrip() throws Exception {
        Path input = ZstdRoundtripTest.getPath("bla.tar");
        File output = this.newTempFile(input.getFileName() + ".zstd");
        try (OutputStream os = Files.newOutputStream(output.toPath(), new OpenOption[0]);
             CompressorOutputStream zos = new CompressorStreamFactory().createCompressorOutputStream("zstd", os);){
            zos.write(input);
        }
        try (InputStream inputStream = Files.newInputStream(output.toPath(), new OpenOption[0]);
             CompressorInputStream zis = new CompressorStreamFactory().createCompressorInputStream("zstd", inputStream);){
            byte[] expected = Files.readAllBytes(input);
            byte[] actual = IOUtils.toByteArray((InputStream)zis);
            Assertions.assertArrayEquals((byte[])expected, (byte[])actual);
        }
    }

    @Test
    void testRoundtripSetChainLogNonDefaultMax() throws Exception {
        this.roundtrip(os -> ((ZstdCompressorOutputStream.Builder)ZstdCompressorOutputStream.builder().setOutputStream((OutputStream)os)).setChainLog(ZstdConstants.ZSTD_CHAINLOG_MAX).get());
    }

    @Test
    void testRoundtripSetChainLogNonDefaultMin() throws Exception {
        this.roundtrip(os -> ((ZstdCompressorOutputStream.Builder)ZstdCompressorOutputStream.builder().setOutputStream((OutputStream)os)).setChainLog(ZstdConstants.ZSTD_CHAINLOG_MIN).get());
    }

    @Test
    void testRoundtripSetChecksumNonDefault() throws Exception {
        this.roundtrip(os -> ((ZstdCompressorOutputStream.Builder)ZstdCompressorOutputStream.builder().setOutputStream((OutputStream)os)).setChecksum(true).get());
    }

    @Test
    void testRoundtripSetCloseFrameOnFlushNonDefault() throws Exception {
        this.roundtrip(os -> ((ZstdCompressorOutputStream.Builder)ZstdCompressorOutputStream.builder().setOutputStream((OutputStream)os)).setCloseFrameOnFlush(true).get());
    }

    @Test
    void testRoundtripSetHashLogNonDefaultMax() throws Exception {
        this.roundtrip(os -> ((ZstdCompressorOutputStream.Builder)ZstdCompressorOutputStream.builder().setOutputStream((OutputStream)os)).setHashLog(ZstdConstants.ZSTD_HASHLOG_MAX).get());
    }

    @Test
    void testRoundtripSetHashLogNonDefaultMin() throws Exception {
        this.roundtrip(os -> ((ZstdCompressorOutputStream.Builder)ZstdCompressorOutputStream.builder().setOutputStream((OutputStream)os)).setHashLog(ZstdConstants.ZSTD_HASHLOG_MIN).get());
    }

    @Test
    void testRoundtripSetJobSizeNonDefault() throws Exception {
        this.roundtrip(os -> ((ZstdCompressorOutputStream.Builder)ZstdCompressorOutputStream.builder().setOutputStream((OutputStream)os)).setJobSize(1).get());
    }

    @Test
    void testRoundtripSetLevelNonDefault() throws Exception {
        this.roundtrip(os -> ((ZstdCompressorOutputStream.Builder)ZstdCompressorOutputStream.builder().setOutputStream((OutputStream)os)).setLevel(1).get());
    }

    @Test
    void testRoundtripSetMinMatchNonDefaultMax() throws Exception {
        this.roundtrip(os -> ((ZstdCompressorOutputStream.Builder)ZstdCompressorOutputStream.builder().setOutputStream((OutputStream)os)).setMinMatch(7).get());
    }

    @Test
    void testRoundtripSetMinMatchNonDefaultMin() throws Exception {
        this.roundtrip(os -> ((ZstdCompressorOutputStream.Builder)ZstdCompressorOutputStream.builder().setOutputStream((OutputStream)os)).setMinMatch(3).get());
    }

    @Test
    void testRoundtripSetOverlapLogNonDefault() throws Exception {
        this.roundtrip(os -> ((ZstdCompressorOutputStream.Builder)ZstdCompressorOutputStream.builder().setOutputStream((OutputStream)os)).setOverlapLog(1).get());
    }

    @Test
    void testRoundtripSetSearchLogNonDefault() throws Exception {
        this.roundtrip(os -> ((ZstdCompressorOutputStream.Builder)ZstdCompressorOutputStream.builder().setOutputStream((OutputStream)os)).setSearchLog(1).get());
    }

    @Test
    void testRoundtripSetStrategyNonDefault() throws Exception {
        this.roundtrip(os -> ((ZstdCompressorOutputStream.Builder)ZstdCompressorOutputStream.builder().setOutputStream((OutputStream)os)).setStrategy(1).get());
    }

    @Test
    @Disabled(value="com.github.luben.zstd.ZstdIOException: Frame requires too much memory for decoding")
    void testRoundtripSetWindowLogNonDefaultMax() throws Exception {
        this.roundtrip(os -> ((ZstdCompressorOutputStream.Builder)ZstdCompressorOutputStream.builder().setOutputStream((OutputStream)os)).setWindowLog(ZstdConstants.ZSTD_WINDOWLOG_MAX).get());
    }

    @Test
    void testRoundtripSetWindowLogNonDefaultMin() throws Exception {
        this.roundtrip(os -> ((ZstdCompressorOutputStream.Builder)ZstdCompressorOutputStream.builder().setOutputStream((OutputStream)os)).setWindowLog(ZstdConstants.ZSTD_WINDOWLOG_MIN).get());
    }

    @Test
    void testRoundtripSetWorkersNonDefault() throws Exception {
        this.roundtrip(os -> ((ZstdCompressorOutputStream.Builder)ZstdCompressorOutputStream.builder().setOutputStream((OutputStream)os)).setWorkers(1).get());
    }

    @Test
    void testRoundtripSetZstdDict() throws Exception {
        this.roundtrip(os -> ((ZstdCompressorOutputStream.Builder)ZstdCompressorOutputStream.builder().setOutputStream((OutputStream)os)).setDict(null).get());
        this.roundtrip(os -> ((ZstdCompressorOutputStream.Builder)ZstdCompressorOutputStream.builder().setOutputStream((OutputStream)os)).setDict(ArrayUtils.EMPTY_BYTE_ARRAY).get());
        this.roundtrip(os -> ((ZstdCompressorOutputStream.Builder)ZstdCompressorOutputStream.builder().setOutputStream((OutputStream)os)).setDict(new byte[512]).get());
    }

    @CartesianTest
    void testRoundtripWithAll(@CartesianTest.Values(ints={0, 1, 2, 3, 4, 5, 6, 7, 8, 9}) int level, @CartesianTest.Values(booleans={false, true}) boolean checksum, @CartesianTest.Values(booleans={false, true}) boolean closeFrameOnFlush, @CartesianTest.Values(ints={0, 1, 2, 3, 4, 5, 6, 7, 8, 9}) int strategy, @CartesianTest.Values(ints={0, 6, 9}) int overlapLog) throws Exception {
        this.roundtrip(os -> ((ZstdCompressorOutputStream.Builder)ZstdCompressorOutputStream.builder().setChainLog(0).setChecksum(checksum).setCloseFrameOnFlush(closeFrameOnFlush).setDict(null).setHashLog(0).setJobSize(0).setLevel(level).setMinMatch(0).setOutputStream((OutputStream)os)).setOverlapLog(overlapLog).setSearchLog(0).setStrategy(strategy).setWindowLog(0).setWorkers(0).get());
    }

    @Test
    void testRoundtripWithChecksum() throws Exception {
        this.roundtrip(os -> new ZstdCompressorOutputStream((OutputStream)os, 3, false, true));
        this.roundtrip(os -> ((ZstdCompressorOutputStream.Builder)ZstdCompressorOutputStream.builder().setOutputStream((OutputStream)os)).setLevel(3).setCloseFrameOnFlush(true).setChecksum(true).get());
    }

    @Test
    void testRoundtripWithCloseFrameOnFlush() throws Exception {
        this.roundtrip(os -> new ZstdCompressorOutputStream((OutputStream)os, 3, true));
        this.roundtrip(os -> ((ZstdCompressorOutputStream.Builder)ZstdCompressorOutputStream.builder().setOutputStream((OutputStream)os)).setLevel(3).setCloseFrameOnFlush(true).get());
    }

    @Test
    void testRoundtripWithCustomLevel() throws Exception {
        this.roundtrip(os -> new ZstdCompressorOutputStream((OutputStream)os, 1));
        this.roundtrip(os -> ((ZstdCompressorOutputStream.Builder)ZstdCompressorOutputStream.builder().setOutputStream((OutputStream)os)).setLevel(1).get());
    }

    @Test
    void testRoundtripWithZstdOutputStream() throws Exception {
        this.roundtrip(os -> ((ZstdCompressorOutputStream.Builder)ZstdCompressorOutputStream.builder().setOutputStream((OutputStream)new ZstdOutputStream((OutputStream)os))).get());
        this.roundtrip(os -> new ZstdCompressorOutputStream((OutputStream)new ZstdOutputStream((OutputStream)os)));
    }

    private static interface OutputStreamCreator
    extends IOFunction<FileOutputStream, ZstdCompressorOutputStream> {
    }
}

