/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp2;

import java.lang.management.ManagementFactory;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.management.MBeanServer;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.commons.dbcp2.BasicDataSourceFactory;
import org.apache.commons.dbcp2.PoolableConnection;
import org.apache.commons.dbcp2.StackMessageLog;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestBasicDataSourceFactory {
    private void checkConnectionPoolProperties(GenericObjectPool<PoolableConnection> cp) {
        Assertions.assertEquals((int)10, (int)cp.getMaxTotal());
        Assertions.assertEquals((int)8, (int)cp.getMaxIdle());
        Assertions.assertEquals((int)0, (int)cp.getMinIdle());
        Assertions.assertEquals((Object)Duration.ofMillis(500L), (Object)cp.getMaxWaitDuration());
        Assertions.assertEquals((int)5, (int)cp.getNumIdle());
        Assertions.assertTrue((boolean)cp.getTestOnBorrow());
        Assertions.assertFalse((boolean)cp.getTestOnReturn());
        Assertions.assertEquals((Object)Duration.ofSeconds(1L), (Object)cp.getDurationBetweenEvictionRuns());
        Assertions.assertEquals((Object)Duration.ofSeconds(2L), (Object)cp.getMinEvictableIdleDuration());
        Assertions.assertEquals((Object)Duration.ofSeconds(3L), (Object)cp.getSoftMinEvictableIdleDuration());
        Assertions.assertEquals((int)2, (int)cp.getNumTestsPerEvictionRun());
        Assertions.assertTrue((boolean)cp.getTestWhileIdle());
        Assertions.assertTrue((boolean)cp.getRemoveAbandonedOnBorrow());
        Assertions.assertTrue((boolean)cp.getRemoveAbandonedOnMaintenance());
        Assertions.assertEquals((Object)Duration.ofSeconds(3000L), (Object)cp.getRemoveAbandonedTimeoutDuration());
        Assertions.assertTrue((boolean)cp.getLogAbandoned());
        Assertions.assertTrue((boolean)cp.getLifo());
    }

    private void checkDataSourceProperties(BasicDataSource ds) throws Exception {
        Assertions.assertEquals((Object)"org.apache.commons.dbcp2.TesterDriver", (Object)ds.getDriverClassName());
        Assertions.assertEquals((Object)"jdbc:apache:commons:testdriver", (Object)ds.getUrl());
        Assertions.assertEquals((int)10, (int)ds.getMaxTotal());
        Assertions.assertEquals((int)8, (int)ds.getMaxIdle());
        Assertions.assertEquals((int)0, (int)ds.getMinIdle());
        Assertions.assertEquals((Object)Duration.ofMillis(500L), (Object)ds.getMaxWaitDuration());
        Assertions.assertEquals((int)5, (int)ds.getInitialSize());
        Assertions.assertEquals((int)5, (int)ds.getNumIdle());
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)ds.getDefaultAutoCommit());
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)ds.getDefaultReadOnly());
        Assertions.assertEquals((int)2, (int)ds.getDefaultTransactionIsolation());
        Assertions.assertEquals((Object)"test", (Object)ds.getDefaultCatalog());
        Assertions.assertEquals((Object)"testSchema", (Object)ds.getDefaultSchema());
        Assertions.assertTrue((boolean)ds.getTestOnBorrow());
        Assertions.assertFalse((boolean)ds.getTestOnReturn());
        Assertions.assertEquals((Object)"userName", (Object)ds.getUsername());
        Assertions.assertEquals((Object)"userName", (Object)ds.getUserName());
        Assertions.assertEquals((Object)"password", (Object)ds.getPassword());
        Assertions.assertEquals((Object)"SELECT DUMMY FROM DUAL", (Object)ds.getValidationQuery());
        Assertions.assertEquals((Object)Duration.ofSeconds(100L), (Object)ds.getValidationQueryTimeoutDuration());
        Assertions.assertEquals((int)2, (int)ds.getConnectionInitSqls().size());
        Assertions.assertEquals((Object)"SELECT 1", ds.getConnectionInitSqls().get(0));
        Assertions.assertEquals((Object)"SELECT 2", ds.getConnectionInitSqls().get(1));
        Assertions.assertEquals((Object)Duration.ofMillis(1000L), (Object)ds.getDurationBetweenEvictionRuns());
        Assertions.assertEquals((Object)Duration.ofMillis(2000L), (Object)ds.getMinEvictableIdleDuration());
        Assertions.assertEquals((Object)Duration.ofMillis(3000L), (Object)ds.getSoftMinEvictableIdleDuration());
        Assertions.assertEquals((int)2, (int)ds.getNumTestsPerEvictionRun());
        Assertions.assertTrue((boolean)ds.getTestWhileIdle());
        Assertions.assertTrue((boolean)ds.isAccessToUnderlyingConnectionAllowed());
        Assertions.assertTrue((boolean)ds.getRemoveAbandonedOnBorrow());
        Assertions.assertTrue((boolean)ds.getRemoveAbandonedOnMaintenance());
        Assertions.assertEquals((Object)Duration.ofSeconds(3000L), (Object)ds.getRemoveAbandonedTimeoutDuration());
        Assertions.assertTrue((boolean)ds.getLogAbandoned());
        Assertions.assertTrue((boolean)ds.getAbandonedUsageTracking());
        Assertions.assertTrue((boolean)ds.isPoolPreparedStatements());
        Assertions.assertTrue((boolean)ds.isClearStatementPoolOnReturn());
        Assertions.assertEquals((int)10, (int)ds.getMaxOpenPreparedStatements());
        Assertions.assertTrue((boolean)ds.getLifo());
        Assertions.assertTrue((boolean)ds.getFastFailValidation());
        Assertions.assertTrue((boolean)ds.getDisconnectionSqlCodes().contains("XXX"));
        Assertions.assertTrue((boolean)ds.getDisconnectionSqlCodes().contains("YYY"));
        Assertions.assertEquals((Object)"org.apache.commons.dbcp2:name=test", (Object)ds.getJmxName());
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        mbs.unregisterMBean(ds.getRegisteredJmxName());
    }

    private Properties getTestProperties() {
        Properties properties = new Properties();
        properties.setProperty("driverClassName", "org.apache.commons.dbcp2.TesterDriver");
        properties.setProperty("url", "jdbc:apache:commons:testdriver");
        properties.setProperty("maxTotal", "10");
        properties.setProperty("maxIdle", "8");
        properties.setProperty("minIdle", "0");
        properties.setProperty("maxWaitMillis", "500");
        properties.setProperty("initialSize", "5");
        properties.setProperty("defaultAutoCommit", "true");
        properties.setProperty("defaultReadOnly", "false");
        properties.setProperty("defaultTransactionIsolation", "READ_COMMITTED");
        properties.setProperty("defaultCatalog", "test");
        properties.setProperty("defaultSchema", "testSchema");
        properties.setProperty("testOnBorrow", "true");
        properties.setProperty("testOnReturn", "false");
        properties.setProperty("username", "userName");
        properties.setProperty("password", "password");
        properties.setProperty("validationQuery", "SELECT DUMMY FROM DUAL");
        properties.setProperty("validationQueryTimeout", "100");
        properties.setProperty("connectionInitSqls", "SELECT 1;SELECT 2");
        properties.setProperty("timeBetweenEvictionRunsMillis", "1000");
        properties.setProperty("minEvictableIdleTimeMillis", "2000");
        properties.setProperty("softMinEvictableIdleTimeMillis", "3000");
        properties.setProperty("numTestsPerEvictionRun", "2");
        properties.setProperty("testWhileIdle", "true");
        properties.setProperty("accessToUnderlyingConnectionAllowed", "true");
        properties.setProperty("removeAbandonedOnBorrow", "true");
        properties.setProperty("removeAbandonedOnMaintenance", "true");
        properties.setProperty("removeAbandonedTimeout", "3000");
        properties.setProperty("logAbandoned", "true");
        properties.setProperty("abandonedUsageTracking", "true");
        properties.setProperty("poolPreparedStatements", "true");
        properties.setProperty("clearStatementPoolOnReturn", "true");
        properties.setProperty("maxOpenPreparedStatements", "10");
        properties.setProperty("lifo", "true");
        properties.setProperty("fastFailValidation", "true");
        properties.setProperty("disconnectionSqlCodes", "XXX,YYY");
        properties.setProperty("jmxName", "org.apache.commons.dbcp2:name=test");
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAllProperties() throws Exception {
        try {
            StackMessageLog.lock();
            StackMessageLog.clear();
            Reference ref = new Reference("javax.sql.DataSource", BasicDataSourceFactory.class.getName(), null);
            Properties properties = this.getTestProperties();
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                ref.add(new StringRefAddr((String)entry.getKey(), (String)entry.getValue()));
            }
            BasicDataSourceFactory basicDataSourceFactory = new BasicDataSourceFactory();
            try (BasicDataSource ds = (BasicDataSource)basicDataSourceFactory.getObjectInstance((Object)ref, null, null, null);){
                this.checkDataSourceProperties(ds);
                this.checkConnectionPoolProperties((GenericObjectPool<PoolableConnection>)ds.getConnectionPool());
                List<String> messages = StackMessageLog.getAll();
                Assertions.assertEquals((int)0, (int)messages.size());
            }
        }
        finally {
            StackMessageLog.clear();
            StackMessageLog.unLock();
        }
    }

    @Test
    public void testNoProperties() throws Exception {
        Properties properties = new Properties();
        try (BasicDataSource ds = BasicDataSourceFactory.createDataSource((Properties)properties);){
            Assertions.assertNotNull((Object)ds);
        }
    }

    @Test
    public void testProperties() throws Exception {
        try (BasicDataSource ds = BasicDataSourceFactory.createDataSource((Properties)this.getTestProperties());){
            this.checkDataSourceProperties(ds);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testValidateProperties() throws Exception {
        try {
            StackMessageLog.lock();
            StackMessageLog.clear();
            Reference ref = new Reference("javax.sql.DataSource", BasicDataSourceFactory.class.getName(), null);
            ref.add(new StringRefAddr("foo", "bar"));
            ref.add(new StringRefAddr("maxWait", "100"));
            ref.add(new StringRefAddr("driverClassName", "org.apache.commons.dbcp2.TesterDriver"));
            BasicDataSourceFactory basicDataSourceFactory = new BasicDataSourceFactory();
            basicDataSourceFactory.getObjectInstance((Object)ref, null, null, null);
            List<String> messages = StackMessageLog.getAll();
            Assertions.assertEquals((int)2, (int)messages.size(), (String)messages.toString());
            for (String message : messages) {
                if (message.contains("maxWait")) {
                    Assertions.assertTrue((boolean)message.contains("use maxWaitMillis"));
                    continue;
                }
                Assertions.assertTrue((boolean)message.contains("foo"));
                Assertions.assertTrue((boolean)message.contains("Ignoring unknown property"));
            }
        }
        finally {
            StackMessageLog.clear();
            StackMessageLog.unLock();
        }
    }
}

