/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp2;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import org.apache.commons.dbcp2.PoolingConnection;

public class PStmtKey {
    private final String sql;
    private final Integer resultSetType;
    private final Integer resultSetConcurrency;
    private final Integer resultSetHoldability;
    private final String catalog;
    private final Integer autoGeneratedKeys;
    private final int[] columnIndexes;
    private final String[] columnNames;
    private final PoolingConnection.StatementType statementType;
    private StatementBuilder builder;

    public PStmtKey(String sql) {
        this(sql, null, PoolingConnection.StatementType.PREPARED_STATEMENT);
    }

    public PStmtKey(String sql, String catalog) {
        this(sql, catalog, PoolingConnection.StatementType.PREPARED_STATEMENT);
    }

    public PStmtKey(String sql, String catalog, PoolingConnection.StatementType statementType) {
        this.sql = sql;
        this.catalog = catalog;
        this.statementType = statementType;
        this.autoGeneratedKeys = null;
        this.columnIndexes = null;
        this.columnNames = null;
        this.resultSetType = null;
        this.resultSetConcurrency = null;
        this.resultSetHoldability = null;
        if (statementType == PoolingConnection.StatementType.PREPARED_STATEMENT) {
            this.builder = new PreparedStatementSQL();
        } else if (statementType == PoolingConnection.StatementType.CALLABLE_STATEMENT) {
            this.builder = new PreparedCallSQL();
        }
    }

    public PStmtKey(String sql, String catalog, int autoGeneratedKeys) {
        this(sql, catalog, PoolingConnection.StatementType.PREPARED_STATEMENT, (Integer)autoGeneratedKeys);
    }

    public PStmtKey(String sql, String catalog, PoolingConnection.StatementType statementType, Integer autoGeneratedKeys) {
        this.sql = sql;
        this.catalog = catalog;
        this.statementType = statementType;
        this.autoGeneratedKeys = autoGeneratedKeys;
        this.columnIndexes = null;
        this.columnNames = null;
        this.resultSetType = null;
        this.resultSetConcurrency = null;
        this.resultSetHoldability = null;
        if (statementType == PoolingConnection.StatementType.PREPARED_STATEMENT) {
            this.builder = new PreparedStatementWithAutoGeneratedKeys();
        } else if (statementType == PoolingConnection.StatementType.CALLABLE_STATEMENT) {
            this.builder = new PreparedCallSQL();
        }
    }

    public PStmtKey(String sql, String catalog, int[] columnIndexes) {
        this.sql = sql;
        this.catalog = catalog;
        this.statementType = PoolingConnection.StatementType.PREPARED_STATEMENT;
        this.autoGeneratedKeys = null;
        this.columnIndexes = columnIndexes == null ? null : Arrays.copyOf(columnIndexes, columnIndexes.length);
        this.columnNames = null;
        this.resultSetType = null;
        this.resultSetConcurrency = null;
        this.resultSetHoldability = null;
        this.builder = new PreparedStatementWithColumnIndexes();
    }

    public PStmtKey(String sql, String catalog, String[] columnNames) {
        this.sql = sql;
        this.catalog = catalog;
        this.statementType = PoolingConnection.StatementType.PREPARED_STATEMENT;
        this.autoGeneratedKeys = null;
        this.columnIndexes = null;
        this.columnNames = columnNames == null ? null : Arrays.copyOf(columnNames, columnNames.length);
        this.resultSetType = null;
        this.resultSetConcurrency = null;
        this.resultSetHoldability = null;
        this.builder = new PreparedStatementWithColumnNames();
    }

    public PStmtKey(String sql, int resultSetType, int resultSetConcurrency) {
        this(sql, null, resultSetType, resultSetConcurrency, PoolingConnection.StatementType.PREPARED_STATEMENT);
    }

    public PStmtKey(String sql, String catalog, int resultSetType, int resultSetConcurrency) {
        this(sql, catalog, resultSetType, resultSetConcurrency, PoolingConnection.StatementType.PREPARED_STATEMENT);
    }

    public PStmtKey(String sql, String catalog, int resultSetType, int resultSetConcurrency, PoolingConnection.StatementType statementType) {
        this.sql = sql;
        this.catalog = catalog;
        this.resultSetType = resultSetType;
        this.resultSetConcurrency = resultSetConcurrency;
        this.resultSetHoldability = null;
        this.statementType = statementType;
        this.autoGeneratedKeys = null;
        this.columnIndexes = null;
        this.columnNames = null;
        if (statementType == PoolingConnection.StatementType.PREPARED_STATEMENT) {
            this.builder = new PreparedStatementWithResultSetConcurrency();
        } else if (statementType == PoolingConnection.StatementType.CALLABLE_STATEMENT) {
            this.builder = new PreparedCallWithResultSetConcurrency();
        }
    }

    public PStmtKey(String sql, String catalog, int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        this(sql, catalog, resultSetType, resultSetConcurrency, resultSetHoldability, PoolingConnection.StatementType.PREPARED_STATEMENT);
    }

    public PStmtKey(String sql, String catalog, int resultSetType, int resultSetConcurrency, int resultSetHoldability, PoolingConnection.StatementType statementType) {
        this.sql = sql;
        this.catalog = catalog;
        this.resultSetType = resultSetType;
        this.resultSetConcurrency = resultSetConcurrency;
        this.resultSetHoldability = resultSetHoldability;
        this.statementType = statementType;
        this.autoGeneratedKeys = null;
        this.columnIndexes = null;
        this.columnNames = null;
        if (statementType == PoolingConnection.StatementType.PREPARED_STATEMENT) {
            this.builder = new PreparedStatementWithResultSetHoldability();
        } else if (statementType == PoolingConnection.StatementType.CALLABLE_STATEMENT) {
            this.builder = new PreparedCallWithResultSetHoldability();
        }
    }

    public String getSql() {
        return this.sql;
    }

    public Integer getResultSetType() {
        return this.resultSetType;
    }

    public Integer getResultSetConcurrency() {
        return this.resultSetConcurrency;
    }

    public Integer getResultSetHoldability() {
        return this.resultSetHoldability;
    }

    public Integer getAutoGeneratedKeys() {
        return this.autoGeneratedKeys;
    }

    public int[] getColumnIndexes() {
        return this.columnIndexes;
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public PoolingConnection.StatementType getStmtType() {
        return this.statementType;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PStmtKey other = (PStmtKey)obj;
        if (this.catalog == null ? other.catalog != null : !this.catalog.equals(other.catalog)) {
            return false;
        }
        if (this.resultSetConcurrency == null ? other.resultSetConcurrency != null : !this.resultSetConcurrency.equals(other.resultSetConcurrency)) {
            return false;
        }
        if (this.resultSetType == null ? other.resultSetType != null : !this.resultSetType.equals(other.resultSetType)) {
            return false;
        }
        if (this.resultSetHoldability == null ? other.resultSetHoldability != null : !this.resultSetHoldability.equals(other.resultSetHoldability)) {
            return false;
        }
        if (this.autoGeneratedKeys == null ? other.autoGeneratedKeys != null : !this.autoGeneratedKeys.equals(other.autoGeneratedKeys)) {
            return false;
        }
        if (!Arrays.equals(this.columnIndexes, other.columnIndexes)) {
            return false;
        }
        if (!Arrays.equals(this.columnNames, other.columnNames)) {
            return false;
        }
        if (this.sql == null ? other.sql != null : !this.sql.equals(other.sql)) {
            return false;
        }
        return this.statementType == other.statementType;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.catalog == null ? 0 : this.catalog.hashCode());
        result = 31 * result + (this.resultSetConcurrency == null ? 0 : this.resultSetConcurrency.hashCode());
        result = 31 * result + (this.resultSetType == null ? 0 : this.resultSetType.hashCode());
        result = 31 * result + (this.resultSetHoldability == null ? 0 : this.resultSetHoldability.hashCode());
        result = 31 * result + (this.sql == null ? 0 : this.sql.hashCode());
        result = 31 * result + (this.autoGeneratedKeys == null ? 0 : this.autoGeneratedKeys.hashCode());
        result = 31 * result + Arrays.hashCode(this.columnIndexes);
        result = 31 * result + Arrays.hashCode(this.columnNames);
        result = 31 * result + this.statementType.hashCode();
        return result;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("PStmtKey: sql=");
        buf.append(this.sql);
        buf.append(", catalog=");
        buf.append(this.catalog);
        buf.append(", resultSetType=");
        buf.append(this.resultSetType);
        buf.append(", resultSetConcurrency=");
        buf.append(this.resultSetConcurrency);
        buf.append(", resultSetHoldability=");
        buf.append(this.resultSetHoldability);
        buf.append(", autoGeneratedKeys=");
        buf.append(this.autoGeneratedKeys);
        buf.append(", columnIndexes=");
        buf.append(Arrays.toString(this.columnIndexes));
        buf.append(", columnNames=");
        buf.append(Arrays.toString(this.columnNames));
        buf.append(", statementType=");
        buf.append((Object)this.statementType);
        return buf.toString();
    }

    public Statement createStatement(Connection connection) throws SQLException {
        if (this.builder == null) {
            throw new IllegalStateException("Prepared statement key is invalid.");
        }
        return this.builder.createStatement(connection);
    }

    private class PreparedCallWithResultSetHoldability
    implements StatementBuilder {
        private PreparedCallWithResultSetHoldability() {
        }

        @Override
        public Statement createStatement(Connection connection) throws SQLException {
            CallableStatement statement = connection.prepareCall(PStmtKey.this.sql, PStmtKey.this.resultSetType, PStmtKey.this.resultSetConcurrency, PStmtKey.this.resultSetHoldability);
            return statement;
        }
    }

    private class PreparedCallWithResultSetConcurrency
    implements StatementBuilder {
        private PreparedCallWithResultSetConcurrency() {
        }

        @Override
        public Statement createStatement(Connection connection) throws SQLException {
            CallableStatement statement = connection.prepareCall(PStmtKey.this.sql, PStmtKey.this.resultSetType, PStmtKey.this.resultSetConcurrency);
            return statement;
        }
    }

    private class PreparedCallSQL
    implements StatementBuilder {
        private PreparedCallSQL() {
        }

        @Override
        public Statement createStatement(Connection connection) throws SQLException {
            CallableStatement statement = connection.prepareCall(PStmtKey.this.sql);
            return statement;
        }
    }

    private class PreparedStatementWithColumnNames
    implements StatementBuilder {
        private PreparedStatementWithColumnNames() {
        }

        @Override
        public Statement createStatement(Connection connection) throws SQLException {
            PreparedStatement statement = connection.prepareStatement(PStmtKey.this.sql, PStmtKey.this.columnNames);
            return statement;
        }
    }

    private class PreparedStatementWithResultSetHoldability
    implements StatementBuilder {
        private PreparedStatementWithResultSetHoldability() {
        }

        @Override
        public Statement createStatement(Connection connection) throws SQLException {
            PreparedStatement statement = connection.prepareStatement(PStmtKey.this.sql, PStmtKey.this.resultSetType, PStmtKey.this.resultSetConcurrency, PStmtKey.this.resultSetHoldability);
            return statement;
        }
    }

    private class PreparedStatementWithResultSetConcurrency
    implements StatementBuilder {
        private PreparedStatementWithResultSetConcurrency() {
        }

        @Override
        public Statement createStatement(Connection connection) throws SQLException {
            PreparedStatement statement = connection.prepareStatement(PStmtKey.this.sql, PStmtKey.this.resultSetType, PStmtKey.this.resultSetConcurrency);
            return statement;
        }
    }

    private class PreparedStatementWithColumnIndexes
    implements StatementBuilder {
        private PreparedStatementWithColumnIndexes() {
        }

        @Override
        public Statement createStatement(Connection connection) throws SQLException {
            PreparedStatement statement = connection.prepareStatement(PStmtKey.this.sql, PStmtKey.this.columnIndexes);
            return statement;
        }
    }

    private class PreparedStatementWithAutoGeneratedKeys
    implements StatementBuilder {
        private PreparedStatementWithAutoGeneratedKeys() {
        }

        @Override
        public Statement createStatement(Connection connection) throws SQLException {
            PreparedStatement statement = connection.prepareStatement(PStmtKey.this.sql, PStmtKey.this.autoGeneratedKeys);
            return statement;
        }
    }

    private class PreparedStatementSQL
    implements StatementBuilder {
        private PreparedStatementSQL() {
        }

        @Override
        public Statement createStatement(Connection connection) throws SQLException {
            PreparedStatement statement = connection.prepareStatement(PStmtKey.this.sql);
            return statement;
        }
    }

    private static interface StatementBuilder {
        public Statement createStatement(Connection var1) throws SQLException;
    }
}

