/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.mail2.jakarta;

import jakarta.mail.Authenticator;
import jakarta.mail.Message;
import jakarta.mail.Session;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeMultipart;
import jakarta.mail.internet.ParseException;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.mail2.core.EmailConstants;
import org.apache.commons.mail2.core.EmailException;
import org.apache.commons.mail2.jakarta.AbstractEmailTest;
import org.apache.commons.mail2.jakarta.DefaultAuthenticator;
import org.apache.commons.mail2.jakarta.mocks.MockEmailConcrete;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class EmailTest
extends AbstractEmailTest {
    private static final String[] VALID_EMAILS = new String[]{"me@home.com", "joe.doe@apache.org", "someone_here@work-address.com.au"};
    private MockEmailConcrete email;

    @BeforeEach
    public void setUpEmailTest() {
        this.email = new MockEmailConcrete();
    }

    @Test
    public void testAddBcc() throws Exception {
        ArrayList<InternetAddress> arrExpected = new ArrayList<InternetAddress>();
        arrExpected.add(new InternetAddress("me@home.com"));
        arrExpected.add(new InternetAddress("joe.doe@apache.org"));
        arrExpected.add(new InternetAddress("someone_here@work-address.com.au"));
        for (String address : VALID_EMAILS) {
            this.email.addBcc(address);
        }
        Assertions.assertEquals((int)arrExpected.size(), (int)this.email.getBccAddresses().size());
        Assertions.assertEquals((Object)((Object)arrExpected).toString(), (Object)this.email.getBccAddresses().toString());
    }

    @Test
    public void testAddBcc2() throws Exception {
        String[] testEmailNames = new String[]{"Name1", "", null};
        ArrayList<InternetAddress> arrExpected = new ArrayList<InternetAddress>();
        arrExpected.add(new InternetAddress("me@home.com", "Name1"));
        arrExpected.add(new InternetAddress("joe.doe@apache.org"));
        arrExpected.add(new InternetAddress("someone_here@work-address.com.au"));
        for (int i = 0; i < VALID_EMAILS.length; ++i) {
            this.email.addBcc(VALID_EMAILS[i], testEmailNames[i]);
        }
        Assertions.assertEquals((int)arrExpected.size(), (int)this.email.getBccAddresses().size());
        Assertions.assertEquals((Object)((Object)arrExpected).toString(), (Object)this.email.getBccAddresses().toString());
    }

    @Test
    public void testAddBccArray() throws Exception {
        ArrayList<InternetAddress> arrExpected = new ArrayList<InternetAddress>();
        arrExpected.add(new InternetAddress("me@home.com"));
        arrExpected.add(new InternetAddress("joe.doe@apache.org"));
        arrExpected.add(new InternetAddress("someone_here@work-address.com.au"));
        this.email.addBcc(VALID_EMAILS);
        Assertions.assertEquals((int)arrExpected.size(), (int)this.email.getBccAddresses().size());
        Assertions.assertEquals((Object)((Object)arrExpected).toString(), (Object)this.email.getBccAddresses().toString());
    }

    @Test
    public void testAddBccBadEncoding() {
        Assertions.assertThrows(IllegalCharsetNameException.class, () -> this.email.addBcc("me@home.com", "me@home.com", "bad.encoding\uc5ec\n"));
    }

    @Test
    public void testAddBccWithEncoding() throws Exception {
        String testCharset = EmailConstants.ISO_8859_1;
        String[] testEmailNames = new String[]{"Name1", "", null};
        ArrayList<InternetAddress> arrExpected = new ArrayList<InternetAddress>();
        arrExpected.add(new InternetAddress("me@home.com", "Name1", testCharset));
        arrExpected.add(new InternetAddress("joe.doe@apache.org"));
        arrExpected.add(new InternetAddress("someone_here@work-address.com.au"));
        for (int i = 0; i < VALID_EMAILS.length; ++i) {
            this.email.addBcc(VALID_EMAILS[i], testEmailNames[i], testCharset);
        }
        Assertions.assertEquals((int)arrExpected.size(), (int)this.email.getBccAddresses().size());
        Assertions.assertEquals((Object)((Object)arrExpected).toString(), (Object)this.email.getBccAddresses().toString());
    }

    @Test
    public void testAddCc() throws Exception {
        ArrayList<InternetAddress> arrExpected = new ArrayList<InternetAddress>();
        arrExpected.add(new InternetAddress("me@home.com"));
        arrExpected.add(new InternetAddress("joe.doe@apache.org"));
        arrExpected.add(new InternetAddress("someone_here@work-address.com.au"));
        for (String address : VALID_EMAILS) {
            this.email.addCc(address);
        }
        Assertions.assertEquals((int)arrExpected.size(), (int)this.email.getCcAddresses().size());
        Assertions.assertEquals((Object)((Object)arrExpected).toString(), (Object)this.email.getCcAddresses().toString());
    }

    @Test
    public void testAddCc2() throws Exception {
        String[] testEmailNames = new String[]{"Name1", "", null};
        ArrayList<InternetAddress> arrExpected = new ArrayList<InternetAddress>();
        arrExpected.add(new InternetAddress("me@home.com", "Name1"));
        arrExpected.add(new InternetAddress("joe.doe@apache.org"));
        arrExpected.add(new InternetAddress("someone_here@work-address.com.au"));
        for (int i = 0; i < VALID_EMAILS.length; ++i) {
            this.email.addCc(VALID_EMAILS[i], testEmailNames[i]);
        }
        Assertions.assertEquals((int)arrExpected.size(), (int)this.email.getCcAddresses().size());
        Assertions.assertEquals((Object)((Object)arrExpected).toString(), (Object)this.email.getCcAddresses().toString());
    }

    @Test
    public void testAddCcArray() throws Exception {
        ArrayList<InternetAddress> arrExpected = new ArrayList<InternetAddress>();
        arrExpected.add(new InternetAddress("me@home.com"));
        arrExpected.add(new InternetAddress("joe.doe@apache.org"));
        arrExpected.add(new InternetAddress("someone_here@work-address.com.au"));
        this.email.addCc(VALID_EMAILS);
        Assertions.assertEquals((int)arrExpected.size(), (int)this.email.getCcAddresses().size());
        Assertions.assertEquals((Object)((Object)arrExpected).toString(), (Object)this.email.getCcAddresses().toString());
    }

    @Test
    public void testAddCcBadEncoding() {
        Assertions.assertThrows(IllegalCharsetNameException.class, () -> this.email.addCc("me@home.com", "me@home.com", "bad.encoding\uc5ec\n"));
    }

    @Test
    public void testAddCcWithEncoding() throws Exception {
        String testCharset = EmailConstants.ISO_8859_1;
        String[] testEmailNames = new String[]{"Name1", "", null};
        ArrayList<InternetAddress> arrExpected = new ArrayList<InternetAddress>();
        arrExpected.add(new InternetAddress("me@home.com", "Name1", testCharset));
        arrExpected.add(new InternetAddress("joe.doe@apache.org"));
        arrExpected.add(new InternetAddress("someone_here@work-address.com.au"));
        for (int i = 0; i < VALID_EMAILS.length; ++i) {
            this.email.addCc(VALID_EMAILS[i], testEmailNames[i], testCharset);
        }
        Assertions.assertEquals((int)arrExpected.size(), (int)this.email.getCcAddresses().size());
        Assertions.assertEquals((Object)((Object)arrExpected).toString(), (Object)this.email.getCcAddresses().toString());
    }

    @Test
    public void testAddHeader() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("X-Priority", "1");
        headers.put("Disposition-Notification-To", "me@home.com");
        headers.put("X-Mailer", "Sendmail");
        for (Map.Entry header : headers.entrySet()) {
            String name = (String)header.getKey();
            String value = (String)header.getValue();
            this.email.addHeader(name, value);
        }
        Assertions.assertEquals((int)headers.size(), (int)this.email.getHeaders().size());
        Assertions.assertEquals(headers, (Object)this.email.getHeaders());
    }

    @Test
    public void testAddHeaderEmptyName() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.email.addHeader("", "me@home.com"));
    }

    @Test
    public void testAddHeaderEmptyValue() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.email.addHeader("X-Mailer", ""));
    }

    @Test
    public void testAddHeaderNullName() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.email.addHeader(null, "me@home.com"));
    }

    @Test
    public void testAddHeaderNullValue() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.email.addHeader("X-Mailer", null));
    }

    @Test
    public void testAddReplyTo() throws Exception {
        ArrayList<InternetAddress> arrExpected = new ArrayList<InternetAddress>();
        arrExpected.add(new InternetAddress("me@home.com"));
        arrExpected.add(new InternetAddress("joe.doe@apache.org"));
        arrExpected.add(new InternetAddress("someone_here@work-address.com.au"));
        for (String address : VALID_EMAILS) {
            this.email.addReplyTo(address);
        }
        Assertions.assertEquals((int)arrExpected.size(), (int)this.email.getReplyToAddresses().size());
        Assertions.assertEquals((Object)((Object)arrExpected).toString(), (Object)this.email.getReplyToAddresses().toString());
    }

    @Test
    public void testAddReplyTo2() throws Exception {
        String[] testEmailNames = new String[]{"Name1", "", null};
        ArrayList<InternetAddress> arrExpected = new ArrayList<InternetAddress>();
        arrExpected.add(new InternetAddress("me@home.com", "Name1"));
        arrExpected.add(new InternetAddress("joe.doe@apache.org"));
        arrExpected.add(new InternetAddress("someone_here@work-address.com.au"));
        for (int i = 0; i < VALID_EMAILS.length; ++i) {
            this.email.addReplyTo(VALID_EMAILS[i], testEmailNames[i]);
        }
        Assertions.assertEquals((int)arrExpected.size(), (int)this.email.getReplyToAddresses().size());
        Assertions.assertEquals((Object)((Object)arrExpected).toString(), (Object)this.email.getReplyToAddresses().toString());
    }

    @Test
    public void testAddReplyToBadEncoding() {
        Assertions.assertThrows(IllegalCharsetNameException.class, () -> this.email.addReplyTo("me@home.com", "me@home.com", "bad.encoding\uc5ec\n"));
    }

    @Test
    public void testAddReplyToWithEncoding() throws Exception {
        String testCharset = EmailConstants.ISO_8859_1;
        String[] testEmailNames = new String[]{"Name1", "", null};
        ArrayList<InternetAddress> arrExpected = new ArrayList<InternetAddress>();
        arrExpected.add(new InternetAddress("me@home.com", "Name1", testCharset));
        arrExpected.add(new InternetAddress("joe.doe@apache.org"));
        arrExpected.add(new InternetAddress("someone_here@work-address.com.au"));
        for (int i = 0; i < VALID_EMAILS.length; ++i) {
            this.email.addReplyTo(VALID_EMAILS[i], testEmailNames[i], testCharset);
        }
        Assertions.assertEquals((int)arrExpected.size(), (int)this.email.getReplyToAddresses().size());
        Assertions.assertEquals((Object)((Object)arrExpected).toString(), (Object)this.email.getReplyToAddresses().toString());
    }

    @Test
    public void testAddTo() throws Exception {
        ArrayList<InternetAddress> arrExpected = new ArrayList<InternetAddress>();
        arrExpected.add(new InternetAddress("me@home.com"));
        arrExpected.add(new InternetAddress("joe.doe@apache.org"));
        arrExpected.add(new InternetAddress("someone_here@work-address.com.au"));
        for (String address : VALID_EMAILS) {
            this.email.addTo(address);
        }
        Assertions.assertEquals((int)arrExpected.size(), (int)this.email.getToAddresses().size());
        Assertions.assertEquals((Object)((Object)arrExpected).toString(), (Object)this.email.getToAddresses().toString());
    }

    @Test
    public void testAddTo2() throws Exception {
        String[] testEmailNames = new String[]{"Name1", "", null};
        ArrayList<InternetAddress> arrExpected = new ArrayList<InternetAddress>();
        arrExpected.add(new InternetAddress("me@home.com", "Name1"));
        arrExpected.add(new InternetAddress("joe.doe@apache.org"));
        arrExpected.add(new InternetAddress("someone_here@work-address.com.au"));
        for (int i = 0; i < VALID_EMAILS.length; ++i) {
            this.email.addTo(VALID_EMAILS[i], testEmailNames[i]);
        }
        Assertions.assertEquals((int)arrExpected.size(), (int)this.email.getToAddresses().size());
        Assertions.assertEquals((Object)((Object)arrExpected).toString(), (Object)this.email.getToAddresses().toString());
    }

    @Test
    public void testAddToArray() throws Exception {
        ArrayList<InternetAddress> arrExpected = new ArrayList<InternetAddress>();
        arrExpected.add(new InternetAddress("me@home.com"));
        arrExpected.add(new InternetAddress("joe.doe@apache.org"));
        arrExpected.add(new InternetAddress("someone_here@work-address.com.au"));
        this.email.addTo(VALID_EMAILS);
        Assertions.assertEquals((int)arrExpected.size(), (int)this.email.getToAddresses().size());
        Assertions.assertEquals((Object)((Object)arrExpected).toString(), (Object)this.email.getToAddresses().toString());
    }

    @Test
    public void testAddToBadEncoding() {
        Assertions.assertThrows(IllegalCharsetNameException.class, () -> this.email.addTo("me@home.com", "me@home.com", "bad.encoding\uc5ec\n"));
    }

    @Test
    public void testAddToWithEncoding() throws Exception {
        String testCharset = EmailConstants.ISO_8859_1;
        String[] testEmailNames = new String[]{"Name1", "", null};
        ArrayList<InternetAddress> arrExpected = new ArrayList<InternetAddress>();
        arrExpected.add(new InternetAddress("me@home.com", "Name1", testCharset));
        arrExpected.add(new InternetAddress("joe.doe@apache.org"));
        arrExpected.add(new InternetAddress("someone_here@work-address.com.au"));
        for (int i = 0; i < VALID_EMAILS.length; ++i) {
            this.email.addTo(VALID_EMAILS[i], testEmailNames[i], testCharset);
        }
        Assertions.assertEquals((int)arrExpected.size(), (int)this.email.getToAddresses().size());
        Assertions.assertEquals((Object)((Object)arrExpected).toString(), (Object)this.email.getToAddresses().toString());
    }

    @Test
    public void testCorrectContentTypeForPNG() throws Exception {
        this.email.setHostName(this.strTestMailServer);
        this.email.setSmtpPort(this.getMailServerPort());
        this.email.setFrom("a@b.com");
        this.email.addTo("c@d.com");
        this.email.setSubject("test mail");
        this.email.setCharset(StandardCharsets.ISO_8859_1.name());
        File png = new File("./target/test-classes/images/logos/maven-feather.png");
        this.email.setContent(png, "image/png");
        this.email.buildMimeMessage();
        MimeMessage msg = this.email.getMimeMessage();
        msg.saveChanges();
        Assertions.assertEquals((Object)"image/png", (Object)msg.getContentType());
    }

    @Test
    public void testDefaultCharsetAppliesToTextContent() throws Exception {
        this.email.setHostName(this.strTestMailServer);
        this.email.setSmtpPort(this.getMailServerPort());
        this.email.setFrom("a@b.com");
        this.email.addTo("c@d.com");
        this.email.setSubject("test mail");
        this.email.setCharset(StandardCharsets.ISO_8859_1.name());
        this.email.setContent("test content", "text/plain");
        this.email.buildMimeMessage();
        MimeMessage msg = this.email.getMimeMessage();
        msg.saveChanges();
        Assertions.assertEquals((Object)"text/plain; charset=ISO-8859-1", (Object)msg.getContentType());
    }

    @Test
    public void testDefaultCharsetCanBeOverriddenByContentType() throws Exception {
        this.email.setHostName(this.strTestMailServer);
        this.email.setSmtpPort(this.getMailServerPort());
        this.email.setFrom("a@b.com");
        this.email.addTo("c@d.com");
        this.email.setSubject("test mail");
        this.email.setCharset(StandardCharsets.ISO_8859_1.name());
        this.email.setContent("test content", "text/plain; charset=US-ASCII");
        this.email.buildMimeMessage();
        MimeMessage msg = this.email.getMimeMessage();
        msg.saveChanges();
        Assertions.assertEquals((Object)"text/plain; charset=US-ASCII", (Object)msg.getContentType());
    }

    @Test
    public void testDefaultCharsetIgnoredByNonTextContent() throws Exception {
        this.email.setHostName(this.strTestMailServer);
        this.email.setSmtpPort(this.getMailServerPort());
        this.email.setFrom("a@b.com");
        this.email.addTo("c@d.com");
        this.email.setSubject("test mail");
        this.email.setCharset(StandardCharsets.ISO_8859_1.name());
        this.email.setContent("test content", "application/octet-stream");
        this.email.buildMimeMessage();
        MimeMessage msg = this.email.getMimeMessage();
        msg.saveChanges();
        Assertions.assertEquals((Object)"application/octet-stream", (Object)msg.getContentType());
    }

    @Test
    public void testEndOflineCharactersInSubjectAreReplacedWithSpaces() {
        for (String invalidChar : this.endOfLineCombinations) {
            this.email.setSubject(invalidChar);
            Assertions.assertNotEquals((Object)invalidChar, (Object)this.email.getSubject());
        }
        Assertions.assertEquals((Object)"abcdefg", (Object)this.email.setSubject("abcdefg").getSubject());
        Assertions.assertEquals((Object)"abc defg", (Object)this.email.setSubject("abc\rdefg").getSubject());
        Assertions.assertEquals((Object)"abc defg", (Object)this.email.setSubject("abc\ndefg").getSubject());
        Assertions.assertEquals((Object)"abc  defg", (Object)this.email.setSubject("abc\r\ndefg").getSubject());
        Assertions.assertEquals((Object)"abc  defg", (Object)this.email.setSubject("abc\n\rdefg").getSubject());
    }

    @Test
    public void testFoldingHeaders() throws Exception {
        this.email.setHostName(this.strTestMailServer);
        this.email.setSmtpPort(this.getMailServerPort());
        this.email.setFrom("a@b.com");
        this.email.addTo("c@d.com");
        this.email.setSubject("test mail");
        String headerValue = "1234567890 1234567890 123456789 01234567890 123456789 0123456789 01234567890 01234567890";
        this.email.addHeader("X-LongHeader", "1234567890 1234567890 123456789 01234567890 123456789 0123456789 01234567890 01234567890");
        Assertions.assertEquals((int)1, (int)this.email.getHeaders().size());
        Assertions.assertFalse((boolean)((String)this.email.getHeaders().get("X-LongHeader")).contains("\r\n"));
        this.email.buildMimeMessage();
        MimeMessage msg = this.email.getMimeMessage();
        msg.saveChanges();
        String[] values = msg.getHeader("X-LongHeader");
        Assertions.assertEquals((int)1, (int)values.length);
        String[] lines = values[0].split("\\r\\n");
        Assertions.assertEquals((int)2, (int)lines.length);
        Assertions.assertEquals((int)values[0].indexOf("\n"), (int)values[0].lastIndexOf("\n"));
    }

    @Test
    public void testGetHeader() {
        Hashtable<String, String> ht = new Hashtable<String, String>();
        ht.put("X-Foo", "Bar");
        ht.put("X-Int", "1");
        this.email.setHeaders(ht);
        Assertions.assertEquals((Object)"Bar", (Object)this.email.getHeader("X-Foo"));
        Assertions.assertEquals((Object)"1", (Object)this.email.getHeader("X-Int"));
    }

    @Test
    public void testGetHeaders() {
        Hashtable<String, String> ht = new Hashtable<String, String>();
        ht.put("X-Foo", "Bar");
        ht.put("X-Int", "1");
        this.email.setHeaders(ht);
        Assertions.assertEquals((int)ht.size(), (int)this.email.getHeaders().size());
    }

    @Test
    public void testGetSetAuthentication() {
        String strUsername = "user.name";
        String strPassword = "user.pwd";
        this.email.setAuthentication("user.name", "user.pwd");
        DefaultAuthenticator retrievedAuth = (DefaultAuthenticator)this.email.getAuthenticator();
        Assertions.assertEquals((Object)"user.name", (Object)retrievedAuth.getPasswordAuthentication().getUserName());
        Assertions.assertEquals((Object)"user.pwd", (Object)retrievedAuth.getPasswordAuthentication().getPassword());
    }

    @Test
    public void testGetSetAuthenticator() {
        String strUsername = "user.name";
        String strPassword = "user.pwd";
        DefaultAuthenticator authenticator = new DefaultAuthenticator("user.name", "user.pwd");
        this.email.setAuthenticator((Authenticator)authenticator);
        DefaultAuthenticator retrievedAuth = (DefaultAuthenticator)this.email.getAuthenticator();
        Assertions.assertEquals((Object)"user.name", (Object)retrievedAuth.getPasswordAuthentication().getUserName());
        Assertions.assertEquals((Object)"user.pwd", (Object)retrievedAuth.getPasswordAuthentication().getPassword());
    }

    @Test
    public void testGetSetBounceAddress() {
        Assertions.assertNull((Object)this.email.getBounceAddress());
        String bounceAddress = "test_bounce@apache.org";
        this.email.setBounceAddress("test_bounce@apache.org");
        Assertions.assertEquals((Object)"test_bounce@apache.org", (Object)this.email.getBounceAddress());
    }

    @Test
    public void testGetSetCharset() {
        Charset set = StandardCharsets.US_ASCII;
        this.email.setCharset(set.name());
        Assertions.assertEquals((Object)set.name(), (Object)this.email.getCharsetName());
        set = StandardCharsets.UTF_8;
        this.email.setCharset(set.name());
        Assertions.assertEquals((Object)set.name(), (Object)this.email.getCharsetName());
    }

    @Test
    public void testGetSetDebug() {
        this.email.setDebug(true);
        Assertions.assertTrue((boolean)this.email.isDebug());
        this.email.setDebug(false);
        Assertions.assertFalse((boolean)this.email.isDebug());
    }

    @Test
    public void testGetSetHostName() {
        for (String validChar : this.testCharsValid) {
            this.email.setHostName(validChar);
            Assertions.assertEquals((Object)validChar, (Object)this.email.getHostName());
        }
    }

    @Test
    public void testGetSetInvalidBounceAddress() {
        Assertions.assertThrows(RuntimeException.class, () -> this.email.setBounceAddress("invalid-bounce-address"));
    }

    @Test
    public void testGetSetSentDate() {
        Date dtTest = Calendar.getInstance().getTime();
        this.email.setSentDate(dtTest);
        Assertions.assertEquals((Object)dtTest, (Object)this.email.getSentDate());
        this.email.setSentDate(null);
        Date sentDate = this.email.getSentDate();
        Assertions.assertTrue((Math.abs(sentDate.getTime() - dtTest.getTime()) < 1000L ? 1 : 0) != 0);
    }

    @Test
    public void testGetSetSession() throws Exception {
        Properties properties = new Properties(System.getProperties());
        properties.setProperty("mail.transport.protocol", "smtp");
        properties.setProperty("mail.smtp.port", String.valueOf(this.getMailServerPort()));
        properties.setProperty("mail.smtp.host", this.strTestMailServer);
        properties.setProperty("mail.debug", String.valueOf(false));
        Session mySession = Session.getInstance((Properties)properties, null);
        this.email.setMailSession(mySession);
        Assertions.assertEquals((Object)mySession, (Object)this.email.getMailSession());
    }

    @Test
    public void testGetSetSmtpPort() {
        this.email.setSmtpPort(1);
        Assertions.assertEquals((int)1, (int)Integer.parseInt(this.email.getSmtpPort()));
        this.email.setSmtpPort(Integer.MAX_VALUE);
        Assertions.assertEquals((int)Integer.MAX_VALUE, (int)Integer.parseInt(this.email.getSmtpPort()));
    }

    @Test
    public void testSendBadAuthSet() throws Exception {
        this.getMailServer();
        this.email = new MockEmailConcrete();
        this.email.setHostName(this.strTestMailServer);
        this.email.setSmtpPort(this.getMailServerPort());
        this.email.setFrom(this.strTestMailFrom);
        this.email.addTo(this.strTestMailTo);
        this.email.setAuthentication(null, null);
        Assertions.assertThrows(EmailException.class, () -> ((MockEmailConcrete)this.email).send());
    }

    @Test
    public void testSendBadHostName() {
        EmailException e = (EmailException)Assertions.assertThrows(EmailException.class, () -> {
            this.getMailServer();
            this.email = new MockEmailConcrete();
            this.email.setSubject("Test Email #1 Subject");
            this.email.setHostName("bad.host.com");
            this.email.setFrom("me@home.com");
            this.email.addTo("me@home.com");
            this.email.addCc("me@home.com");
            this.email.addBcc("me@home.com");
            this.email.addReplyTo("me@home.com");
            this.email.setContent("test string object", " ; charset=" + EmailConstants.US_ASCII);
            this.email.send();
        });
        Assertions.assertTrue((boolean)(e.getCause() instanceof ParseException));
        this.stopServer();
    }

    @Test
    public void testSendCorrectSmtpPortContainedInException() {
        EmailException e = (EmailException)Assertions.assertThrows(EmailException.class, () -> {
            this.getMailServer();
            this.email = new MockEmailConcrete();
            this.email.setHostName("bad.host.com");
            this.email.setSSLOnConnect(true);
            this.email.setFrom(this.strTestMailFrom);
            this.email.addTo(this.strTestMailTo);
            this.email.setAuthentication(null, null);
            this.email.send();
        });
        Assertions.assertTrue((boolean)e.getMessage().contains("bad.host.com:465"));
        this.stopServer();
    }

    @Test
    public void testSendDestinationNotSet() throws Exception {
        this.getMailServer();
        this.email = new MockEmailConcrete();
        this.email.setHostName(this.strTestMailServer);
        this.email.setSmtpPort(this.getMailServerPort());
        this.email.setFrom("me@home.com");
        Assertions.assertThrows(EmailException.class, () -> ((MockEmailConcrete)this.email).send());
    }

    @Test
    public void testSendFromNotSet() throws Exception {
        this.getMailServer();
        this.email = new MockEmailConcrete();
        this.email.setHostName(this.strTestMailServer);
        this.email.setSmtpPort(this.getMailServerPort());
        this.email.addTo("me@home.com");
        Assertions.assertThrows(EmailException.class, () -> ((MockEmailConcrete)this.email).send());
    }

    @Test
    public void testSendFromSetInSession() throws Exception {
        this.getMailServer();
        this.email = new MockEmailConcrete();
        this.email.setHostName(this.strTestMailServer);
        this.email.setSmtpPort(this.getMailServerPort());
        this.email.addTo("me@home.com");
        this.email.getMailSession().getProperties().setProperty("mail.from", "me@home.com");
        this.email.send();
    }

    @Test
    public void testSendNoHostName() {
        this.getMailServer();
        this.email = new MockEmailConcrete();
        Assertions.assertThrows(EmailException.class, () -> ((MockEmailConcrete)this.email).send());
    }

    @Test
    public void testSetBcc() throws Exception {
        ArrayList<InternetAddress> testInetEmailValid = new ArrayList<InternetAddress>();
        testInetEmailValid.add(new InternetAddress("me@home.com", "Name1"));
        testInetEmailValid.add(new InternetAddress("joe.doe@apache.org", "joe.doe@apache.org"));
        testInetEmailValid.add(new InternetAddress("someone_here@work-address.com.au", "someone_here@work-address.com.au"));
        this.email.setBcc(testInetEmailValid);
        Assertions.assertEquals(testInetEmailValid, (Object)this.email.getBccAddresses());
    }

    @Test
    public void testSetBccEmpty() {
        Assertions.assertThrows(EmailException.class, () -> this.email.setBcc(Collections.emptyList()));
    }

    @Test
    public void testSetBccNull() {
        Assertions.assertThrows(EmailException.class, () -> this.email.setBcc(null));
    }

    @Test
    public void testSetCc() throws Exception {
        ArrayList<InternetAddress> testEmailValid2 = new ArrayList<InternetAddress>();
        testEmailValid2.add(new InternetAddress("Name1 <me@home.com>"));
        testEmailValid2.add(new InternetAddress("\"joe.doe@apache.org\" <joe.doe@apache.org>"));
        testEmailValid2.add(new InternetAddress("\"someone_here@work.com.au\" <someone_here@work.com.au>"));
        this.email.setCc(testEmailValid2);
        Assertions.assertEquals(testEmailValid2, (Object)this.email.getCcAddresses());
    }

    @Test
    public void testSetCcEmpty() {
        Assertions.assertThrows(EmailException.class, () -> this.email.setCc(Collections.emptyList()));
    }

    @Test
    public void testSetCcNull() {
        Assertions.assertThrows(EmailException.class, () -> this.email.setCc(null));
    }

    @Test
    public void testSetContentEmptyMimeMultipart() {
        MimeMultipart part = new MimeMultipart();
        this.email.setContent(part);
        Assertions.assertEquals((Object)part, (Object)this.email.getEmailBody());
    }

    @Test
    public void testSetContentMimeMultipart() {
        MimeMultipart part = new MimeMultipart("abc123");
        this.email.setContent(part);
        Assertions.assertEquals((Object)part, (Object)this.email.getEmailBody());
    }

    @Test
    public void testSetContentNull() throws Exception {
        this.email.setContent(null);
        Assertions.assertNull((Object)this.email.getEmailBody());
    }

    @Test
    public void testSetContentObject() {
        String testObject = "test string object";
        String testContentType = " ; charset=" + EmailConstants.US_ASCII;
        this.email.setContent(testObject, testContentType);
        Assertions.assertEquals((Object)testObject, (Object)this.email.getContent());
        Assertions.assertEquals((Object)testContentType, (Object)this.email.getContentType());
        testObject = null;
        testContentType = " ; charset=" + EmailConstants.US_ASCII + " some more here";
        this.email.setContent(testObject, testContentType);
        Assertions.assertEquals((Object)testObject, (Object)this.email.getContent());
        Assertions.assertEquals((Object)testContentType, (Object)this.email.getContentType());
        testObject = "test string object";
        testContentType = null;
        this.email.setContent(testObject, testContentType);
        Assertions.assertEquals((Object)testObject, (Object)this.email.getContent());
        Assertions.assertEquals((Object)testContentType, (Object)this.email.getContentType());
        testObject = "test string object";
        testContentType = " something incorrect ";
        this.email.setContent(testObject, testContentType);
        Assertions.assertEquals((Object)testObject, (Object)this.email.getContent());
        Assertions.assertEquals((Object)testContentType, (Object)this.email.getContentType());
    }

    @Test
    public void testSetFrom() throws Exception {
        ArrayList<InternetAddress> arrExpected = new ArrayList<InternetAddress>();
        arrExpected.add(new InternetAddress("me@home.com", "me@home.com"));
        arrExpected.add(new InternetAddress("joe.doe@apache.org", "joe.doe@apache.org"));
        arrExpected.add(new InternetAddress("someone_here@work-address.com.au", "someone_here@work-address.com.au"));
        for (int i = 0; i < VALID_EMAILS.length; ++i) {
            this.email.setFrom(VALID_EMAILS[i]);
            Assertions.assertEquals(arrExpected.get(i), (Object)this.email.getFromAddress());
        }
    }

    @Test
    public void testSetFrom2() throws Exception {
        String[] testEmailNames = new String[]{"Name1", "", null};
        ArrayList<InternetAddress> arrExpected = new ArrayList<InternetAddress>();
        arrExpected.add(new InternetAddress("me@home.com", "Name1"));
        arrExpected.add(new InternetAddress("joe.doe@apache.org", "joe.doe@apache.org"));
        arrExpected.add(new InternetAddress("someone_here@work-address.com.au", "someone_here@work-address.com.au"));
        for (int i = 0; i < VALID_EMAILS.length; ++i) {
            this.email.setFrom(VALID_EMAILS[i], testEmailNames[i]);
            Assertions.assertEquals(arrExpected.get(i), (Object)this.email.getFromAddress());
        }
    }

    @Test
    public void testSetFromBadEncoding() {
        Assertions.assertThrows(IllegalCharsetNameException.class, () -> this.email.setFrom("me@home.com", "me@home.com", "bad.encoding\uc5ec\n"));
    }

    @Test
    public void testSetFromWithEncoding() throws Exception {
        String testValidEmail = "me@home.com";
        InternetAddress inetExpected = new InternetAddress("me@home.com", "me@home.com", EmailConstants.ISO_8859_1);
        this.email.setFrom("me@home.com", "me@home.com", EmailConstants.ISO_8859_1);
        Assertions.assertEquals((Object)inetExpected, (Object)this.email.getFromAddress());
    }

    @Test
    public void testSetHeaderEmptyName() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.email.setHeaders(Collections.singletonMap("", "me@home.com")));
    }

    @Test
    public void testSetHeaderEmptyValue() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.email.setHeaders(Collections.singletonMap("X-Mailer", "")));
    }

    @Test
    public void testSetHeaderNullName() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.email.setHeaders(Collections.singletonMap(null, "me@home.com")));
    }

    @Test
    public void testSetHeaderNullValue() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.email.setHeaders(Collections.singletonMap("X-Mailer", null)));
    }

    @Test
    public void testSetHeaders() {
        Hashtable<String, String> ht = new Hashtable<String, String>();
        ht.put("X-Priority", "1");
        ht.put("Disposition-Notification-To", "me@home.com");
        ht.put("X-Mailer", "Sendmail");
        this.email.setHeaders(ht);
        Assertions.assertEquals((int)ht.size(), (int)this.email.getHeaders().size());
        Assertions.assertEquals(ht, (Object)this.email.getHeaders());
    }

    @Test
    public void testSetNullAndEmptyBounceAddress() {
        Assertions.assertNull((Object)this.email.setBounceAddress(null).getBounceAddress());
        Assertions.assertEquals((Object)"", (Object)this.email.setBounceAddress("").getBounceAddress());
    }

    @Test
    public void testSetPopBeforeSmtp() {
        boolean boolPopBeforeSmtp = true;
        String strHost = "mail.home.com";
        String strUsername = "user.name";
        String strPassword = "user.passwd";
        this.email.setPopBeforeSmtp(true, "mail.home.com", "user.name", "user.passwd");
        Assertions.assertEquals((Object)true, (Object)this.email.isPopBeforeSmtp());
        Assertions.assertEquals((Object)"mail.home.com", (Object)this.email.getPopHost());
        Assertions.assertEquals((Object)"user.name", (Object)this.email.getPopUserName());
        Assertions.assertEquals((Object)"user.passwd", (Object)this.email.getPopPassword());
    }

    @Test
    public void testSetSmptPortNegative() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.email.setSmtpPort(-1));
    }

    @Test
    public void testSetSmtpPortMinValue() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.email.setSmtpPort(Integer.MIN_VALUE));
    }

    @Test
    public void testSetSmtpPortZero() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.email.setSmtpPort(0));
    }

    @Test
    public void testSetSubjectValid() {
        for (String validChar : this.testCharsValid) {
            this.email.setSubject(validChar);
            Assertions.assertEquals((Object)validChar, (Object)this.email.getSubject());
        }
        Assertions.assertNull((Object)this.email.setSubject(null).getSubject());
        Assertions.assertEquals((Object)"", (Object)this.email.setSubject("").getSubject());
        Assertions.assertEquals((Object)"   ", (Object)this.email.setSubject("   ").getSubject());
        Assertions.assertEquals((Object)"\t", (Object)this.email.setSubject("\t").getSubject());
    }

    @Test
    public void testSetTo() throws Exception {
        ArrayList<InternetAddress> testEmailValid2 = new ArrayList<InternetAddress>();
        testEmailValid2.add(new InternetAddress("me@home.com", "Name1"));
        testEmailValid2.add(new InternetAddress("joe.doe@apache.org", "joe.doe@apache.org"));
        testEmailValid2.add(new InternetAddress("someone_here@work-address.com.au", "someone_here@work-address.com.au"));
        this.email.setTo(testEmailValid2);
        Assertions.assertEquals((int)testEmailValid2.size(), (int)this.email.getToAddresses().size());
        Assertions.assertEquals((Object)((Object)testEmailValid2).toString(), (Object)this.email.getToAddresses().toString());
    }

    @Test
    public void testSetToEmpty() {
        Assertions.assertThrows(EmailException.class, () -> this.email.setTo(Collections.emptyList()));
    }

    @Test
    public void testSetToNull() {
        Assertions.assertThrows(EmailException.class, () -> this.email.setTo(null));
    }

    @Test
    public void testSocketConnectionTimeout() {
        Assertions.assertEquals((long)EmailConstants.SOCKET_TIMEOUT.toMillis(), (long)this.email.getSocketConnectionTimeout());
        this.email.setSocketConnectionTimeout(Duration.ofMillis(5678L));
        Assertions.assertEquals((int)5678, (int)this.email.getSocketConnectionTimeout());
    }

    @Test
    public void testSocketTimeout() {
        Assertions.assertEquals((long)EmailConstants.SOCKET_TIMEOUT.toMillis(), (long)this.email.getSocketTimeout());
        this.email.setSocketTimeout(Duration.ofMillis(5678L));
        Assertions.assertEquals((int)5678, (int)this.email.getSocketTimeout());
    }

    @Test
    public void testSupportForInternationalDomainNames() throws Exception {
        this.email.setHostName(this.strTestMailServer);
        this.email.setSmtpPort(this.getMailServerPort());
        this.email.setFrom("from@d\u00f6m\u00e4in.example");
        this.email.addTo("to@d\u00f6m\u00e4in.example");
        this.email.addCc("cc@d\u00f6m\u00e4in.example");
        this.email.addBcc("bcc@d\u00f6m\u00e4in.example");
        this.email.setSubject("test mail");
        this.email.setSubject("testSupportForInternationalDomainNames");
        this.email.setMsg("This is a test mail ... :-)");
        this.email.buildMimeMessage();
        MimeMessage msg = this.email.getMimeMessage();
        Assertions.assertEquals((Object)"from@xn--dmin-moa0i.example", (Object)msg.getFrom()[0].toString());
        Assertions.assertEquals((Object)"to@xn--dmin-moa0i.example", (Object)msg.getRecipients(Message.RecipientType.TO)[0].toString());
        Assertions.assertEquals((Object)"cc@xn--dmin-moa0i.example", (Object)msg.getRecipients(Message.RecipientType.CC)[0].toString());
        Assertions.assertEquals((Object)"bcc@xn--dmin-moa0i.example", (Object)msg.getRecipients(Message.RecipientType.BCC)[0].toString());
    }

    @Test
    public void testToInternetAddressArray() throws Exception {
        ArrayList<InternetAddress> testInetEmailValid = new ArrayList<InternetAddress>();
        testInetEmailValid.add(new InternetAddress("me@home.com", "Name1"));
        testInetEmailValid.add(new InternetAddress("joe.doe@apache.org", "joe.doe@apache.org"));
        testInetEmailValid.add(new InternetAddress("someone_here@work-address.com.au", "someone_here@work-address.com.au"));
        this.email.setBcc(testInetEmailValid);
        Assertions.assertEquals((int)testInetEmailValid.size(), (int)this.email.getBccAddresses().size());
    }
}

