/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.fileupload;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.FileUpload;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.MockHttpServletRequest;
import org.apache.commons.fileupload.MultipartStream;
import org.apache.commons.fileupload.Util;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.fileupload.util.Streams;
import org.junit.Assert;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;

public class SizesTest {
    @Test
    public void testFileSizeLimit() throws IOException, FileUploadException {
        String request = "-----1234\r\nContent-Disposition: form-data; name=\"file\"; filename=\"foo.tab\"\r\nContent-Type: text/whatever\r\n\r\nThis is the content of the file\n\r\n-----1234--\r\n";
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)new DiskFileItemFactory());
        upload.setFileSizeMax(-1L);
        MockHttpServletRequest req = new MockHttpServletRequest("-----1234\r\nContent-Disposition: form-data; name=\"file\"; filename=\"foo.tab\"\r\nContent-Type: text/whatever\r\n\r\nThis is the content of the file\n\r\n-----1234--\r\n".getBytes("US-ASCII"), "multipart/form-data; boundary=---1234");
        List fileItems = upload.parseRequest((HttpServletRequest)req);
        Assert.assertEquals((long)1L, (long)fileItems.size());
        FileItem item = (FileItem)fileItems.get(0);
        Assert.assertEquals((Object)"This is the content of the file\n", (Object)new String(item.get()));
        upload = new ServletFileUpload((FileItemFactory)new DiskFileItemFactory());
        upload.setFileSizeMax(40L);
        req = new MockHttpServletRequest("-----1234\r\nContent-Disposition: form-data; name=\"file\"; filename=\"foo.tab\"\r\nContent-Type: text/whatever\r\n\r\nThis is the content of the file\n\r\n-----1234--\r\n".getBytes("US-ASCII"), "multipart/form-data; boundary=---1234");
        fileItems = upload.parseRequest((HttpServletRequest)req);
        Assert.assertEquals((long)1L, (long)fileItems.size());
        item = (FileItem)fileItems.get(0);
        Assert.assertEquals((Object)"This is the content of the file\n", (Object)new String(item.get()));
        upload = new ServletFileUpload((FileItemFactory)new DiskFileItemFactory());
        upload.setFileSizeMax(30L);
        req = new MockHttpServletRequest("-----1234\r\nContent-Disposition: form-data; name=\"file\"; filename=\"foo.tab\"\r\nContent-Type: text/whatever\r\n\r\nThis is the content of the file\n\r\n-----1234--\r\n".getBytes("US-ASCII"), "multipart/form-data; boundary=---1234");
        try {
            upload.parseRequest((HttpServletRequest)req);
            Assert.fail((String)"Expected exception.");
        }
        catch (FileUploadBase.FileSizeLimitExceededException e) {
            Assert.assertEquals((long)30L, (long)e.getPermittedSize());
        }
    }

    @Test
    public void testFileSizeLimitWithFakedContentLength() throws IOException, FileUploadException {
        String request = "-----1234\r\nContent-Disposition: form-data; name=\"file\"; filename=\"foo.tab\"\r\nContent-Type: text/whatever\r\nContent-Length: 10\r\n\r\nThis is the content of the file\n\r\n-----1234--\r\n";
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)new DiskFileItemFactory());
        upload.setFileSizeMax(-1L);
        MockHttpServletRequest req = new MockHttpServletRequest("-----1234\r\nContent-Disposition: form-data; name=\"file\"; filename=\"foo.tab\"\r\nContent-Type: text/whatever\r\nContent-Length: 10\r\n\r\nThis is the content of the file\n\r\n-----1234--\r\n".getBytes("US-ASCII"), "multipart/form-data; boundary=---1234");
        List fileItems = upload.parseRequest((HttpServletRequest)req);
        Assert.assertEquals((long)1L, (long)fileItems.size());
        FileItem item = (FileItem)fileItems.get(0);
        Assert.assertEquals((Object)"This is the content of the file\n", (Object)new String(item.get()));
        upload = new ServletFileUpload((FileItemFactory)new DiskFileItemFactory());
        upload.setFileSizeMax(40L);
        req = new MockHttpServletRequest("-----1234\r\nContent-Disposition: form-data; name=\"file\"; filename=\"foo.tab\"\r\nContent-Type: text/whatever\r\nContent-Length: 10\r\n\r\nThis is the content of the file\n\r\n-----1234--\r\n".getBytes("US-ASCII"), "multipart/form-data; boundary=---1234");
        fileItems = upload.parseRequest((HttpServletRequest)req);
        Assert.assertEquals((long)1L, (long)fileItems.size());
        item = (FileItem)fileItems.get(0);
        Assert.assertEquals((Object)"This is the content of the file\n", (Object)new String(item.get()));
        upload = new ServletFileUpload((FileItemFactory)new DiskFileItemFactory());
        upload.setFileSizeMax(5L);
        req = new MockHttpServletRequest("-----1234\r\nContent-Disposition: form-data; name=\"file\"; filename=\"foo.tab\"\r\nContent-Type: text/whatever\r\nContent-Length: 10\r\n\r\nThis is the content of the file\n\r\n-----1234--\r\n".getBytes("US-ASCII"), "multipart/form-data; boundary=---1234");
        try {
            upload.parseRequest((HttpServletRequest)req);
            Assert.fail((String)"Expected exception.");
        }
        catch (FileUploadBase.FileSizeLimitExceededException e) {
            Assert.assertEquals((long)5L, (long)e.getPermittedSize());
        }
        upload = new ServletFileUpload((FileItemFactory)new DiskFileItemFactory());
        upload.setFileSizeMax(15L);
        req = new MockHttpServletRequest("-----1234\r\nContent-Disposition: form-data; name=\"file\"; filename=\"foo.tab\"\r\nContent-Type: text/whatever\r\nContent-Length: 10\r\n\r\nThis is the content of the file\n\r\n-----1234--\r\n".getBytes("US-ASCII"), "multipart/form-data; boundary=---1234");
        try {
            upload.parseRequest((HttpServletRequest)req);
            Assert.fail((String)"Expected exception.");
        }
        catch (FileUploadBase.FileSizeLimitExceededException e) {
            Assert.assertEquals((long)15L, (long)e.getPermittedSize());
        }
    }

    @Test
    public void testFileUpload() throws IOException, FileUploadException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int add = 16;
        int num = 0;
        for (int i = 0; i < 16384; i += add) {
            if (++add == 32) {
                add = 16;
            }
            String header = "-----1234\r\nContent-Disposition: form-data; name=\"field" + num++ + "\"\r\n\r\n";
            baos.write(header.getBytes("US-ASCII"));
            for (int j = 0; j < i; ++j) {
                baos.write((byte)j);
            }
            baos.write("\r\n".getBytes("US-ASCII"));
        }
        baos.write("-----1234--\r\n".getBytes("US-ASCII"));
        List<FileItem> fileItems = Util.parseUpload((FileUpload)new ServletFileUpload((FileItemFactory)new DiskFileItemFactory()), baos.toByteArray());
        Iterator<FileItem> fileIter = fileItems.iterator();
        add = 16;
        num = 0;
        for (int i = 0; i < 16384; i += add) {
            if (++add == 32) {
                add = 16;
            }
            FileItem item = fileIter.next();
            Assert.assertEquals((Object)("field" + num++), (Object)item.getFieldName());
            byte[] bytes = item.get();
            Assert.assertEquals((long)i, (long)bytes.length);
            for (int j = 0; j < i; ++j) {
                Assert.assertEquals((long)((byte)j), (long)bytes[j]);
            }
        }
        Assert.assertTrue((!fileIter.hasNext() ? 1 : 0) != 0);
    }

    @Test
    public void testMaxSizeLimit() throws IOException, FileUploadException {
        String request = "-----1234\r\nContent-Disposition: form-data; name=\"file1\"; filename=\"foo1.tab\"\r\nContent-Type: text/whatever\r\nContent-Length: 10\r\n\r\nThis is the content of the file\n\r\n-----1234\r\nContent-Disposition: form-data; name=\"file2\"; filename=\"foo2.tab\"\r\nContent-Type: text/whatever\r\n\r\nThis is the content of the file\n\r\n-----1234--\r\n";
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)new DiskFileItemFactory());
        upload.setFileSizeMax(-1L);
        upload.setSizeMax(200L);
        MockHttpServletRequest req = new MockHttpServletRequest("-----1234\r\nContent-Disposition: form-data; name=\"file1\"; filename=\"foo1.tab\"\r\nContent-Type: text/whatever\r\nContent-Length: 10\r\n\r\nThis is the content of the file\n\r\n-----1234\r\nContent-Disposition: form-data; name=\"file2\"; filename=\"foo2.tab\"\r\nContent-Type: text/whatever\r\n\r\nThis is the content of the file\n\r\n-----1234--\r\n".getBytes("US-ASCII"), "multipart/form-data; boundary=---1234");
        Assert.assertEquals((long)200L, (long)((FileUploadBase.SizeLimitExceededException)Assertions.assertThrows(FileUploadBase.SizeLimitExceededException.class, () -> upload.parseRequest((HttpServletRequest)req))).getPermittedSize());
    }

    @Test
    public void testMaxSizeLimitUnknownContentLength() throws IOException, FileUploadException {
        ByteArrayOutputStream baos;
        String request = "-----1234\r\nContent-Disposition: form-data; name=\"file1\"; filename=\"foo1.tab\"\r\nContent-Type: text/whatever\r\nContent-Length: 10\r\n\r\nThis is the content of the file\n\r\n-----1234\r\nContent-Disposition: form-data; name=\"file2\"; filename=\"foo2.tab\"\r\nContent-Type: text/whatever\r\n\r\nThis is the content of the file\n\r\n-----1234--\r\n";
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)new DiskFileItemFactory());
        upload.setFileSizeMax(-1L);
        upload.setSizeMax(300L);
        MockHttpServletRequest req = new MockHttpServletRequest("-----1234\r\nContent-Disposition: form-data; name=\"file1\"; filename=\"foo1.tab\"\r\nContent-Type: text/whatever\r\nContent-Length: 10\r\n\r\nThis is the content of the file\n\r\n-----1234\r\nContent-Disposition: form-data; name=\"file2\"; filename=\"foo2.tab\"\r\nContent-Type: text/whatever\r\n\r\nThis is the content of the file\n\r\n-----1234--\r\n".getBytes("US-ASCII"), "multipart/form-data; boundary=---1234");
        req.setContentLength(-1L);
        req.setReadLimit(10);
        FileItemIterator it = upload.getItemIterator((HttpServletRequest)req);
        Assert.assertTrue((boolean)it.hasNext());
        FileItemStream item = it.next();
        Assert.assertFalse((boolean)item.isFormField());
        Assert.assertEquals((Object)"file1", (Object)item.getFieldName());
        Assert.assertEquals((Object)"foo1.tab", (Object)item.getName());
        try (InputStream stream = item.openStream();){
            baos = new ByteArrayOutputStream();
            Streams.copy((InputStream)stream, (OutputStream)baos, (boolean)true);
        }
        Assertions.assertDoesNotThrow(() -> ((FileItemIterator)it).hasNext());
        item = it.next();
        try {
            stream = item.openStream();
            try {
                baos = new ByteArrayOutputStream();
                Assertions.assertThrows(FileUploadBase.FileUploadIOException.class, () -> Streams.copy((InputStream)stream, (OutputStream)baos, (boolean)true));
                Assertions.assertThrows(MultipartStream.MalformedStreamException.class, stream::close);
            }
            finally {
                if (stream != null) {
                    stream.close();
                }
            }
        }
        catch (MultipartStream.MalformedStreamException malformedStreamException) {
            // empty catch block
        }
    }

    @Test
    public void testPartHeaderSizeMaxLimit() throws IOException, FileUploadException {
        String request = "-----1234\r\nContent-Disposition: form-data; name=\"file1\"; filename=\"foo1.tab\"\r\nContent-Type: text/whatever\r\nContent-Length: 10\r\n\r\nThis is the content of the file\n\r\n-----1234\r\nContent-Disposition: form-data; name=\"file2\"; filename=\"foo2.tab\"\r\nContent-Type: text/whatever\r\n\r\nThis is the content of the file\n\r\n-----1234--\r\n";
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)new DiskFileItemFactory());
        upload.setFileSizeMax(-1L);
        upload.setSizeMax(-1L);
        upload.setPartHeaderSizeMax(100);
        MockHttpServletRequest req = new MockHttpServletRequest("-----1234\r\nContent-Disposition: form-data; name=\"file1\"; filename=\"foo1.tab\"\r\nContent-Type: text/whatever\r\nContent-Length: 10\r\n\r\nThis is the content of the file\n\r\n-----1234\r\nContent-Disposition: form-data; name=\"file2\"; filename=\"foo2.tab\"\r\nContent-Type: text/whatever\r\n\r\nThis is the content of the file\n\r\n-----1234--\r\n".getBytes("US-ASCII"), "multipart/form-data; boundary=---1234");
        Assert.assertEquals((long)100L, (long)((FileUploadBase.SizeLimitExceededException)Assertions.assertThrows(FileUploadBase.SizeLimitExceededException.class, () -> upload.parseRequest((HttpServletRequest)req))).getPermittedSize());
    }
}

