/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.euclidean.threed.shape;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.geometry.core.Transform;
import org.apache.commons.geometry.euclidean.threed.AffineTransformMatrix3D;
import org.apache.commons.geometry.euclidean.threed.ConvexVolume;
import org.apache.commons.geometry.euclidean.threed.PlaneConvexSubset;
import org.apache.commons.geometry.euclidean.threed.Planes;
import org.apache.commons.geometry.euclidean.threed.Vector3D;
import org.apache.commons.geometry.euclidean.threed.rotation.QuaternionRotation;
import org.apache.commons.numbers.core.Precision;

public final class Parallelepiped
extends ConvexVolume {
    private static final List<Vector3D> UNIT_CUBE_VERTICES = Arrays.asList(Vector3D.of(-0.5, -0.5, -0.5), Vector3D.of(0.5, -0.5, -0.5), Vector3D.of(0.5, 0.5, -0.5), Vector3D.of(-0.5, 0.5, -0.5), Vector3D.of(-0.5, -0.5, 0.5), Vector3D.of(0.5, -0.5, 0.5), Vector3D.of(0.5, 0.5, 0.5), Vector3D.of(-0.5, 0.5, 0.5));

    private Parallelepiped(List<PlaneConvexSubset> boundaries) {
        super(boundaries);
    }

    public static Parallelepiped unitCube(Precision.DoubleEquivalence precision) {
        return Parallelepiped.fromTransformedUnitCube(AffineTransformMatrix3D.identity(), precision);
    }

    public static Parallelepiped axisAligned(Vector3D a, Vector3D b, Precision.DoubleEquivalence precision) {
        double minX = Math.min(a.getX(), b.getX());
        double maxX = Math.max(a.getX(), b.getX());
        double minY = Math.min(a.getY(), b.getY());
        double maxY = Math.max(a.getY(), b.getY());
        double minZ = Math.min(a.getZ(), b.getZ());
        double maxZ = Math.max(a.getZ(), b.getZ());
        double xDelta = maxX - minX;
        double yDelta = maxY - minY;
        double zDelta = maxZ - minZ;
        Vector3D scale = Vector3D.of(xDelta, yDelta, zDelta);
        Vector3D position = Vector3D.of(0.5 * xDelta + minX, 0.5 * yDelta + minY, 0.5 * zDelta + minZ);
        return Parallelepiped.builder(precision).setScale(scale).setPosition(position).build();
    }

    public static Parallelepiped fromTransformedUnitCube(Transform<Vector3D> transform, Precision.DoubleEquivalence precision) {
        List vertices = UNIT_CUBE_VERTICES.stream().map(transform).collect(Collectors.toList());
        boolean reverse = !transform.preservesOrientation();
        Parallelepiped.ensureNonZeroSideLength((Vector3D)vertices.get(0), (Vector3D)vertices.get(1), precision);
        Parallelepiped.ensureNonZeroSideLength((Vector3D)vertices.get(1), (Vector3D)vertices.get(2), precision);
        Parallelepiped.ensureNonZeroSideLength((Vector3D)vertices.get(0), (Vector3D)vertices.get(4), precision);
        List<PlaneConvexSubset> boundaries = Arrays.asList(Parallelepiped.createFace(0, 4, 7, 3, vertices, reverse, precision), Parallelepiped.createFace(1, 2, 6, 5, vertices, reverse, precision), Parallelepiped.createFace(0, 1, 5, 4, vertices, reverse, precision), Parallelepiped.createFace(3, 7, 6, 2, vertices, reverse, precision), Parallelepiped.createFace(0, 3, 2, 1, vertices, reverse, precision), Parallelepiped.createFace(4, 5, 6, 7, vertices, reverse, precision));
        return new Parallelepiped(boundaries);
    }

    public static Builder builder(Precision.DoubleEquivalence precision) {
        return new Builder(precision);
    }

    private static PlaneConvexSubset createFace(int a, int b, int c, int d, List<? extends Vector3D> vertices, boolean reverse, Precision.DoubleEquivalence precision) {
        Vector3D pa = vertices.get(a);
        Vector3D pb = vertices.get(b);
        Vector3D pc = vertices.get(c);
        Vector3D pd = vertices.get(d);
        List<Vector3D> loop = reverse ? Arrays.asList(pd, pc, pb, pa) : Arrays.asList(pa, pb, pc, pd);
        return Planes.convexPolygonFromVertices(loop, precision);
    }

    private static void ensureNonZeroSideLength(Vector3D a, Vector3D b, Precision.DoubleEquivalence precision) {
        if (precision.eqZero(a.distance(b))) {
            throw new IllegalArgumentException(MessageFormat.format("Parallelepiped has zero size: vertices {0} and {1} are equivalent", a, b));
        }
    }

    public static final class Builder {
        private Vector3D scale = Vector3D.of(1.0, 1.0, 1.0);
        private QuaternionRotation rotation = QuaternionRotation.identity();
        private Vector3D position = Vector3D.ZERO;
        private final Precision.DoubleEquivalence precision;

        private Builder(Precision.DoubleEquivalence precision) {
            this.precision = precision;
        }

        public Builder setPosition(Vector3D pos) {
            this.position = pos;
            return this;
        }

        public Builder setScale(Vector3D scaleFactors) {
            this.scale = scaleFactors;
            return this;
        }

        public Builder setScale(double x, double y, double z) {
            return this.setScale(Vector3D.of(x, y, z));
        }

        public Builder setScale(double scaleFactor) {
            return this.setScale(scaleFactor, scaleFactor, scaleFactor);
        }

        public Builder setRotation(QuaternionRotation rot) {
            this.rotation = rot;
            return this;
        }

        public Parallelepiped build() {
            AffineTransformMatrix3D transform = AffineTransformMatrix3D.createScale(this.scale).rotate(this.rotation).translate(this.position);
            return Parallelepiped.fromTransformedUnitCube(transform, this.precision);
        }
    }
}

