/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl2;

import java.io.File;
import java.io.FileWriter;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import org.apache.commons.jexl2.ClassCreatorTest;
import org.apache.commons.jexl2.JexlEngine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassCreator {
    private final JexlEngine jexl;
    private final File base;
    private File packageDir = null;
    private int seed = 0;
    private String className = null;
    private String sourceName = null;
    private ClassLoader loader = null;
    public static final boolean canRun = ClassCreator.comSunToolsJavacMain();

    private static boolean comSunToolsJavacMain() {
        try {
            Class<?> javac = ClassCreatorTest.class.getClassLoader().loadClass("com.sun.tools.javac.Main");
            return javac != null;
        }
        catch (Exception xany) {
            return false;
        }
    }

    public ClassCreator(JexlEngine theJexl, File theBase) throws Exception {
        this.jexl = theJexl;
        this.base = theBase;
    }

    public void clear() {
        this.seed = 0;
        this.packageDir = null;
        this.className = null;
        this.sourceName = null;
        this.packageDir = null;
        this.loader = null;
    }

    public void setSeed(int s) {
        this.seed = s;
        this.className = "foo" + s;
        this.sourceName = this.className + ".java";
        this.packageDir = new File(this.base, this.seed + "/org/apache/commons/jexl2/generated");
        this.packageDir.mkdirs();
        this.loader = null;
    }

    public String getClassName() {
        return "org.apache.commons.jexl2.generated." + this.className;
    }

    public Class<?> getClassInstance() throws Exception {
        return this.getClassLoader().loadClass("org.apache.commons.jexl2.generated." + this.className);
    }

    public ClassLoader getClassLoader() throws Exception {
        if (this.loader == null) {
            URL classpath = new File(this.base, Integer.toString(this.seed)).toURI().toURL();
            this.loader = new URLClassLoader(new URL[]{classpath}, null);
        }
        return this.loader;
    }

    public Class<?> createClass() throws Exception {
        this.generate();
        Class<?> clazz = this.compile();
        if (clazz == null) {
            throw new Exception("failed to compile foo" + this.seed);
        }
        Object v = this.validate(clazz);
        if (v instanceof Integer && (Integer)v == this.seed) {
            return clazz;
        }
        throw new Exception("failed to validate foo" + this.seed);
    }

    void generate() throws Exception {
        FileWriter aWriter = new FileWriter(new File(this.packageDir, this.sourceName), false);
        aWriter.write("package org.apache.commons.jexl2.generated;");
        aWriter.write("public class " + this.className + "{\n");
        aWriter.write("private int value =");
        aWriter.write(Integer.toString(this.seed));
        aWriter.write(";\n");
        aWriter.write(" public void setValue(int v) {");
        aWriter.write(" value = v;");
        aWriter.write(" }\n");
        aWriter.write(" public int getValue() {");
        aWriter.write(" return value;");
        aWriter.write(" }\n");
        aWriter.write(" }\n");
        aWriter.flush();
        aWriter.close();
    }

    Class<?> compile() throws Exception {
        String source = this.packageDir.getPath() + "/" + this.sourceName;
        Class<?> javac = this.getClassLoader().loadClass("com.sun.tools.javac.Main");
        if (javac == null) {
            return null;
        }
        Integer r = (Integer)this.jexl.invokeMethod(javac, "compile", new Object[]{source});
        if (r >= 0) {
            return this.getClassLoader().loadClass("org.apache.commons.jexl2.generated." + this.className);
        }
        return null;
    }

    Object validate(Class<?> clazz) throws Exception {
        Class[] params = new Class[]{};
        Object[] paramsObj = new Object[]{};
        Object iClass = clazz.newInstance();
        Method thisMethod = clazz.getDeclaredMethod("getValue", params);
        return thisMethod.invoke(iClass, paramsObj);
    }
}

