/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3;

import org.apache.commons.jexl3.JexlException;
import org.apache.commons.jexl3.JexlTestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Assert;
import org.junit.Test;

public class ParseFailuresTest
extends JexlTestCase {
    static final Log LOGGER = LogFactory.getLog((String)ParseFailuresTest.class.getName());

    public ParseFailuresTest() {
        super("ParseFailuresTest");
    }

    @Test
    public void testMalformedExpression1() throws Exception {
        String badExpression = "eq";
        try {
            this.JEXL.createExpression("eq");
            Assert.fail((String)"Parsing \"eq\" should result in a JexlException");
        }
        catch (JexlException pe) {
            LOGGER.debug((Object)pe);
        }
    }

    @Test
    public void testMalformedExpression2() throws Exception {
        String badExpression = "?";
        try {
            this.JEXL.createExpression("?");
            Assert.fail((String)"Parsing \"?\" should result in a JexlException");
        }
        catch (JexlException pe) {
            LOGGER.debug((Object)pe);
        }
    }

    @Test
    public void testMalformedScript1() throws Exception {
        String badScript = "eq";
        try {
            this.JEXL.createScript("eq");
            Assert.fail((String)"Parsing \"eq\" should result in a JexlException");
        }
        catch (JexlException pe) {
            LOGGER.debug((Object)pe);
        }
    }

    @Test
    public void testMalformedScript2() throws Exception {
        String badScript = "?";
        try {
            this.JEXL.createScript("?");
            Assert.fail((String)"Parsing \"?\" should result in a JexlException");
        }
        catch (JexlException pe) {
            LOGGER.debug((Object)pe);
        }
    }

    @Test
    public void testMalformedScript3() throws Exception {
        String badScript = "foo=1;bar=2;a?b:c:d;";
        try {
            this.JEXL.createScript("foo=1;bar=2;a?b:c:d;");
            Assert.fail((String)"Parsing \"foo=1;bar=2;a?b:c:d;\" should result in a JexlException");
        }
        catch (JexlException pe) {
            LOGGER.debug((Object)pe);
        }
    }
}

