/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3.jexl342;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.commons.jexl3.JexlBuilder;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.JexlException;
import org.apache.commons.jexl3.JexlInfo;
import org.apache.commons.jexl3.JexlScript;
import org.apache.commons.jexl3.introspection.JexlUberspect;
import org.apache.commons.jexl3.jexl342.ReferenceUberspect;
import org.junit.Assert;
import org.junit.Test;

public class OptionalTest {
    @Test
    public void test342() {
        JexlBuilder builder = new JexlBuilder();
        JexlUberspect uber = builder.create().getUberspect();
        JexlEngine jexl = builder.uberspect((JexlUberspect)new ReferenceUberspect(uber)).safe(false).create();
        JexlInfo info = new JexlInfo("test352", 1, 1);
        Thing thing = new Thing();
        JexlScript script = jexl.createScript(info.at(53, 1), "thing.name.length()", new String[]{"thing"});
        Object result = script.execute(null, new Object[]{thing});
        Assert.assertNull((Object)result);
        thing.name = "foo";
        result = script.execute(null, new Object[]{thing});
        Assert.assertEquals((Object)3, (Object)result);
        try {
            script = jexl.createScript(info.at(62, 1), "thing.name.size()", new String[]{"thing"});
            result = script.execute(null, new Object[]{thing});
            Assert.fail((String)"should have thrown");
        }
        catch (JexlException.Method xmethod) {
            Assert.assertEquals((Object)"size", (Object)xmethod.getDetail());
            Assert.assertEquals((Object)"test352@62:11 unsolvable function/method 'size'", (Object)xmethod.getMessage());
        }
        try {
            script = jexl.createScript(info.at(71, 1), "thing.name?.size()", new String[]{"thing"});
            result = script.execute(null, new Object[]{thing});
        }
        catch (JexlException.Method xmethod) {
            Assert.fail((String)"should not have thrown");
        }
        thing.name = null;
        script = jexl.createScript(info, "thing.names.size()", new String[]{"thing"});
        result = script.execute(null, new Object[]{thing});
        Assert.assertNull((Object)result);
        thing.name = "froboz";
        result = script.execute(null, new Object[]{thing});
        Assert.assertEquals((Object)1, (Object)result);
    }

    public static class Thing {
        String name = null;

        public Optional<String> findName() {
            return Optional.ofNullable(this.name);
        }

        public Optional<List<String>> findNames() {
            if (this.name == null) {
                return Optional.empty();
            }
            return Optional.of(Collections.singletonList(this.name));
        }
    }
}

