/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool2.pool407;

import java.time.Duration;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.pool407.AbstractKeyedPool407Factory;
import org.apache.commons.pool2.pool407.AbstractPool407Test;
import org.apache.commons.pool2.pool407.KeyedPool407;
import org.apache.commons.pool2.pool407.KeyedPool407Fixture;
import org.apache.commons.pool2.pool407.KeyedPool407NormalFactory;
import org.apache.commons.pool2.pool407.KeyedPool407NullObjectFactory;
import org.apache.commons.pool2.pool407.KeyedPool407NullPoolableObjectFactory;
import org.apache.commons.pool2.pool407.Pool407Constants;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

public class KeyedPool407Test
extends AbstractPool407Test {
    private static final String KEY = "key";

    protected void assertShutdown(ExecutorService executor, Duration poolConfigMaxWait, AbstractKeyedPool407Factory factory) throws Exception {
        executor.shutdown();
        boolean termination = executor.awaitTermination(10L, TimeUnit.SECONDS);
        KeyedPool407Fixture obj = (KeyedPool407Fixture)factory.create(KEY);
        PooledObject pooledObject = obj != null ? factory.makeObject(KEY) : null;
        this.assertShutdown(termination, poolConfigMaxWait, obj, pooledObject);
    }

    private void test(AbstractKeyedPool407Factory factory, int poolSize, Duration poolConfigMaxWait) throws Exception {
        ExecutorService executor = Executors.newFixedThreadPool(poolSize);
        try (KeyedPool407 pool = new KeyedPool407(factory, poolConfigMaxWait);){
            for (int i = 0; i < poolSize; ++i) {
                executor.execute(new KeyedPool407RoundtripRunnable(pool));
            }
            this.assertShutdown(executor, poolConfigMaxWait, factory);
        }
    }

    @Test
    public void testNormalFactoryNonNullFixtureWaitMax() throws Exception {
        this.test(new KeyedPool407NormalFactory(new KeyedPool407Fixture()), 3, Pool407Constants.WAIT_FOREVER);
    }

    @Disabled
    @Test
    public void testNormalFactoryNullFixtureWaitMax() throws Exception {
        this.test(new KeyedPool407NormalFactory(null), 3, Pool407Constants.WAIT_FOREVER);
    }

    @Disabled
    @Test
    public void testNullObjectFactoryWaitMax() throws Exception {
        this.test(new KeyedPool407NullObjectFactory(), 3, Pool407Constants.WAIT_FOREVER);
    }

    @Disabled
    @Test
    public void testNullObjectFactoryWaitShort() throws Exception {
        this.test(new KeyedPool407NullObjectFactory(), 3, Pool407Constants.WAIT_SHORT);
    }

    @Disabled
    @Test
    public void testNullPoolableFactoryWaitMax() throws Exception {
        this.test(new KeyedPool407NullPoolableObjectFactory(), 3, Pool407Constants.WAIT_FOREVER);
    }

    @Disabled
    @Test
    public void testNullPoolableFactoryWaitShort() throws Exception {
        this.test(new KeyedPool407NullPoolableObjectFactory(), 3, Pool407Constants.WAIT_SHORT);
    }

    private static final class KeyedPool407RoundtripRunnable
    implements Runnable {
        private final KeyedPool407 pool;

        public KeyedPool407RoundtripRunnable(KeyedPool407 pool) {
            this.pool = pool;
        }

        @Override
        public void run() {
            try {
                KeyedPool407Fixture object = (KeyedPool407Fixture)this.pool.borrowObject(KeyedPool407Test.KEY);
                if (object != null) {
                    this.pool.returnObject(KeyedPool407Test.KEY, object);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

