/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool2.impl;

import org.apache.commons.pool2.BasePooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.PoolImplUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestPoolImplUtils {
    @Test
    public void testFactoryTypeSimple() {
        Class result = PoolImplUtils.getFactoryType(SimpleFactory.class);
        Assert.assertEquals(String.class, (Object)result);
    }

    @Test
    public void testFactoryTypeNotSimple() {
        Class result = PoolImplUtils.getFactoryType(NotSimpleFactory.class);
        Assert.assertEquals(Long.class, (Object)result);
    }

    private static class NotSimpleFactory
    extends FactoryF<Integer> {
        private NotSimpleFactory() {
        }

        public Long create() throws Exception {
            return null;
        }

        public PooledObject<Long> wrap(Long obj) {
            return null;
        }
    }

    private static abstract class FactoryF<F>
    extends FactoryDE<Long, F> {
        private FactoryF() {
        }
    }

    private static abstract class FactoryDE<D, E>
    extends FactoryC<D> {
        private FactoryDE() {
        }
    }

    private static abstract class FactoryC<C>
    extends FactoryBA<C, String> {
        private FactoryC() {
        }
    }

    private static abstract class FactoryBA<A, B>
    extends FactoryAB<B, A> {
        private FactoryBA() {
        }
    }

    private static abstract class FactoryAB<A, B>
    extends BasePooledObjectFactory<B> {
        private FactoryAB() {
        }
    }

    private static class SimpleFactory
    extends BasePooledObjectFactory<String> {
        private SimpleFactory() {
        }

        public String create() throws Exception {
            return null;
        }

        public PooledObject<String> wrap(String obj) {
            return null;
        }
    }
}

