/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator.routines;

import org.apache.commons.validator.routines.CodeValidator;
import org.apache.commons.validator.routines.RegexValidator;
import org.apache.commons.validator.routines.checkdigit.CheckDigit;
import org.apache.commons.validator.routines.checkdigit.EAN13CheckDigit;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class CodeValidatorTest {
    CodeValidatorTest() {
    }

    @Test
    void testCheckDigit() {
        CodeValidator validator = new CodeValidator((String)null, -1, -1, (CheckDigit)null);
        String invalidEAN = "9781930110992";
        String validEAN = "9781930110991";
        Assertions.assertNull((Object)validator.getCheckDigit(), (String)"No CheckDigit");
        Assertions.assertEquals((Object)"9781930110992", (Object)validator.validate("9781930110992"), (String)"No CheckDigit invalid");
        Assertions.assertEquals((Object)"9781930110991", (Object)validator.validate("9781930110991"), (String)"No CheckDigit valid");
        Assertions.assertTrue((boolean)validator.isValid("9781930110992"), (String)"No CheckDigit (is) invalid");
        Assertions.assertTrue((boolean)validator.isValid("9781930110991"), (String)"No CheckDigit (is) valid");
        validator = new CodeValidator((String)null, -1, EAN13CheckDigit.EAN13_CHECK_DIGIT);
        Assertions.assertNotNull((Object)validator.getCheckDigit(), (String)"EAN CheckDigit");
        Assertions.assertNull((Object)validator.validate("9781930110992"), (String)"EAN CheckDigit invalid");
        Assertions.assertEquals((Object)"9781930110991", (Object)validator.validate("9781930110991"), (String)"EAN CheckDigit valid");
        Assertions.assertFalse((boolean)validator.isValid("9781930110992"), (String)"EAN CheckDigit (is) invalid");
        Assertions.assertTrue((boolean)validator.isValid("9781930110991"), (String)"EAN CheckDigit (is) valid");
        Assertions.assertNull((Object)validator.validate("978193011099X"), (String)"EAN CheckDigit ex");
    }

    @Test
    void testConstructors() {
        RegexValidator regex = new RegexValidator("^[0-9]*$");
        CodeValidator validator = new CodeValidator(regex, EAN13CheckDigit.EAN13_CHECK_DIGIT);
        Assertions.assertEquals((Object)regex, (Object)validator.getRegexValidator(), (String)"Constructor 1 - regex");
        Assertions.assertEquals((int)-1, (int)validator.getMinLength(), (String)"Constructor 1 - min length");
        Assertions.assertEquals((int)-1, (int)validator.getMaxLength(), (String)"Constructor 1 - max length");
        Assertions.assertEquals((Object)EAN13CheckDigit.EAN13_CHECK_DIGIT, (Object)validator.getCheckDigit(), (String)"Constructor 1 - check digit");
        validator = new CodeValidator(regex, 13, EAN13CheckDigit.EAN13_CHECK_DIGIT);
        Assertions.assertEquals((Object)regex, (Object)validator.getRegexValidator(), (String)"Constructor 2 - regex");
        Assertions.assertEquals((int)13, (int)validator.getMinLength(), (String)"Constructor 2 - min length");
        Assertions.assertEquals((int)13, (int)validator.getMaxLength(), (String)"Constructor 2 - max length");
        Assertions.assertEquals((Object)EAN13CheckDigit.EAN13_CHECK_DIGIT, (Object)validator.getCheckDigit(), (String)"Constructor 2 - check digit");
        validator = new CodeValidator(regex, 10, 20, EAN13CheckDigit.EAN13_CHECK_DIGIT);
        Assertions.assertEquals((Object)regex, (Object)validator.getRegexValidator(), (String)"Constructor 3 - regex");
        Assertions.assertEquals((int)10, (int)validator.getMinLength(), (String)"Constructor 3 - min length");
        Assertions.assertEquals((int)20, (int)validator.getMaxLength(), (String)"Constructor 3 - max length");
        Assertions.assertEquals((Object)EAN13CheckDigit.EAN13_CHECK_DIGIT, (Object)validator.getCheckDigit(), (String)"Constructor 3 - check digit");
        validator = new CodeValidator("^[0-9]*$", EAN13CheckDigit.EAN13_CHECK_DIGIT);
        Assertions.assertEquals((Object)validator.getRegexValidator().toString(), (Object)"RegexValidator{^[0-9]*$}", (String)"Constructor 4 - regex");
        Assertions.assertEquals((int)-1, (int)validator.getMinLength(), (String)"Constructor 4 - min length");
        Assertions.assertEquals((int)-1, (int)validator.getMaxLength(), (String)"Constructor 4 - max length");
        Assertions.assertEquals((Object)EAN13CheckDigit.EAN13_CHECK_DIGIT, (Object)validator.getCheckDigit(), (String)"Constructor 4 - check digit");
        validator = new CodeValidator("^[0-9]*$", 13, EAN13CheckDigit.EAN13_CHECK_DIGIT);
        Assertions.assertEquals((Object)validator.getRegexValidator().toString(), (Object)"RegexValidator{^[0-9]*$}", (String)"Constructor 5 - regex");
        Assertions.assertEquals((int)13, (int)validator.getMinLength(), (String)"Constructor 5 - min length");
        Assertions.assertEquals((int)13, (int)validator.getMaxLength(), (String)"Constructor 5 - max length");
        Assertions.assertEquals((Object)EAN13CheckDigit.EAN13_CHECK_DIGIT, (Object)validator.getCheckDigit(), (String)"Constructor 5 - check digit");
        validator = new CodeValidator("^[0-9]*$", 10, 20, EAN13CheckDigit.EAN13_CHECK_DIGIT);
        Assertions.assertEquals((Object)validator.getRegexValidator().toString(), (Object)"RegexValidator{^[0-9]*$}", (String)"Constructor 6 - regex");
        Assertions.assertEquals((int)10, (int)validator.getMinLength(), (String)"Constructor 6 - min length");
        Assertions.assertEquals((int)20, (int)validator.getMaxLength(), (String)"Constructor 6 - max length");
        Assertions.assertEquals((Object)EAN13CheckDigit.EAN13_CHECK_DIGIT, (Object)validator.getCheckDigit(), (String)"Constructor 6 - check digit");
    }

    @Test
    void testLength() {
        CodeValidator validator = new CodeValidator((String)null, -1, -1, (CheckDigit)null);
        String length10 = "1234567890";
        String length11 = "12345678901";
        String length12 = "123456789012";
        String length20 = "12345678901234567890";
        String length21 = "123456789012345678901";
        String length22 = "1234567890123456789012";
        Assertions.assertEquals((int)-1, (int)validator.getMinLength(), (String)"No min");
        Assertions.assertEquals((int)-1, (int)validator.getMaxLength(), (String)"No max");
        Assertions.assertEquals((Object)"1234567890", (Object)validator.validate("1234567890"), (String)"No Length 10");
        Assertions.assertEquals((Object)"12345678901", (Object)validator.validate("12345678901"), (String)"No Length 11");
        Assertions.assertEquals((Object)"123456789012", (Object)validator.validate("123456789012"), (String)"No Length 12");
        Assertions.assertEquals((Object)"12345678901234567890", (Object)validator.validate("12345678901234567890"), (String)"No Length 20");
        Assertions.assertEquals((Object)"123456789012345678901", (Object)validator.validate("123456789012345678901"), (String)"No Length 21");
        Assertions.assertEquals((Object)"1234567890123456789012", (Object)validator.validate("1234567890123456789012"), (String)"No Length 22");
        validator = new CodeValidator((String)null, 11, -1, (CheckDigit)null);
        Assertions.assertEquals((int)11, (int)validator.getMinLength(), (String)"Min 11 - min");
        Assertions.assertEquals((int)-1, (int)validator.getMaxLength(), (String)"Min 11 - max");
        Assertions.assertNull((Object)validator.validate("1234567890"), (String)"Min 11 - 10");
        Assertions.assertEquals((Object)"12345678901", (Object)validator.validate("12345678901"), (String)"Min 11 - 11");
        Assertions.assertEquals((Object)"123456789012", (Object)validator.validate("123456789012"), (String)"Min 11 - 12");
        Assertions.assertEquals((Object)"12345678901234567890", (Object)validator.validate("12345678901234567890"), (String)"Min 11 - 20");
        Assertions.assertEquals((Object)"123456789012345678901", (Object)validator.validate("123456789012345678901"), (String)"Min 11 - 21");
        Assertions.assertEquals((Object)"1234567890123456789012", (Object)validator.validate("1234567890123456789012"), (String)"Min 11 - 22");
        validator = new CodeValidator((String)null, -1, 21, (CheckDigit)null);
        Assertions.assertEquals((int)-1, (int)validator.getMinLength(), (String)"Max 21 - min");
        Assertions.assertEquals((int)21, (int)validator.getMaxLength(), (String)"Max 21 - max");
        Assertions.assertEquals((Object)"1234567890", (Object)validator.validate("1234567890"), (String)"Max 21 - 10");
        Assertions.assertEquals((Object)"12345678901", (Object)validator.validate("12345678901"), (String)"Max 21 - 11");
        Assertions.assertEquals((Object)"123456789012", (Object)validator.validate("123456789012"), (String)"Max 21 - 12");
        Assertions.assertEquals((Object)"12345678901234567890", (Object)validator.validate("12345678901234567890"), (String)"Max 21 - 20");
        Assertions.assertEquals((Object)"123456789012345678901", (Object)validator.validate("123456789012345678901"), (String)"Max 21 - 21");
        Assertions.assertNull((Object)validator.validate("1234567890123456789012"), (String)"Max 21 - 22");
        validator = new CodeValidator((String)null, 11, 21, (CheckDigit)null);
        Assertions.assertEquals((int)11, (int)validator.getMinLength(), (String)"Min 11 / Max 21 - min");
        Assertions.assertEquals((int)21, (int)validator.getMaxLength(), (String)"Min 11 / Max 21 - max");
        Assertions.assertNull((Object)validator.validate("1234567890"), (String)"Min 11 / Max 21 - 10");
        Assertions.assertEquals((Object)"12345678901", (Object)validator.validate("12345678901"), (String)"Min 11 / Max 21 - 11");
        Assertions.assertEquals((Object)"123456789012", (Object)validator.validate("123456789012"), (String)"Min 11 / Max 21 - 12");
        Assertions.assertEquals((Object)"12345678901234567890", (Object)validator.validate("12345678901234567890"), (String)"Min 11 / Max 21 - 20");
        Assertions.assertEquals((Object)"123456789012345678901", (Object)validator.validate("123456789012345678901"), (String)"Min 11 / Max 21 - 21");
        Assertions.assertNull((Object)validator.validate("1234567890123456789012"), (String)"Min 11 / Max 21 - 22");
        validator = new CodeValidator((String)null, 11, 11, (CheckDigit)null);
        Assertions.assertEquals((int)11, (int)validator.getMinLength(), (String)"Exact 11 - min");
        Assertions.assertEquals((int)11, (int)validator.getMaxLength(), (String)"Exact 11 - max");
        Assertions.assertNull((Object)validator.validate("1234567890"), (String)"Exact 11 - 10");
        Assertions.assertEquals((Object)"12345678901", (Object)validator.validate("12345678901"), (String)"Exact 11 - 11");
        Assertions.assertNull((Object)validator.validate("123456789012"), (String)"Exact 11 - 12");
    }

    @Test
    void testNoInput() {
        CodeValidator validator = new CodeValidator((String)null, -1, -1, (CheckDigit)null);
        Assertions.assertNull((Object)validator.validate(null), (String)"Null");
        Assertions.assertNull((Object)validator.validate(""), (String)"Zero Length");
        Assertions.assertNull((Object)validator.validate("   "), (String)"Spaces");
        Assertions.assertEquals((Object)validator.validate(" A  "), (Object)"A", (String)"Trimmed");
    }

    @Test
    void testRegex() {
        CodeValidator validator = new CodeValidator((String)null, -1, -1, (CheckDigit)null);
        String value2 = "12";
        String value3 = "123";
        String value4 = "1234";
        String value5 = "12345";
        String invalid = "12a4";
        Assertions.assertNull((Object)validator.getRegexValidator(), (String)"No Regex");
        Assertions.assertEquals((Object)"12", (Object)validator.validate("12"), (String)"No Regex 2");
        Assertions.assertEquals((Object)"123", (Object)validator.validate("123"), (String)"No Regex 3");
        Assertions.assertEquals((Object)"1234", (Object)validator.validate("1234"), (String)"No Regex 4");
        Assertions.assertEquals((Object)"12345", (Object)validator.validate("12345"), (String)"No Regex 5");
        Assertions.assertEquals((Object)"12a4", (Object)validator.validate("12a4"), (String)"No Regex invalid");
        String regex = "^([0-9]{3,4})$";
        validator = new CodeValidator(regex, -1, -1, (CheckDigit)null);
        Assertions.assertNotNull((Object)validator.getRegexValidator(), (String)"No Regex");
        Assertions.assertNull((Object)validator.validate("12"), (String)"Regex 2");
        Assertions.assertEquals((Object)"123", (Object)validator.validate("123"), (String)"Regex 3");
        Assertions.assertEquals((Object)"1234", (Object)validator.validate("1234"), (String)"Regex 4");
        Assertions.assertNull((Object)validator.validate("12345"), (String)"Regex 5");
        Assertions.assertNull((Object)validator.validate("12a4"), (String)"Regex invalid");
        regex = "^([0-9]{3})(?:[-\\s])([0-9]{3})$";
        validator = new CodeValidator(new RegexValidator(regex), 6, (CheckDigit)null);
        Assertions.assertEquals((Object)validator.validate("123-456"), (Object)"123456", (String)"Reformat 123-456");
        Assertions.assertEquals((Object)validator.validate("123 456"), (Object)"123456", (String)"Reformat 123 456");
        Assertions.assertNull((Object)validator.validate("123456"), (String)"Reformat 123456");
        Assertions.assertNull((Object)validator.validate("123.456"), (String)"Reformat 123.456");
        regex = "^(?:([0-9]{3})(?:[-\\s])([0-9]{3}))|([0-9]{6})$";
        validator = new CodeValidator(new RegexValidator(regex), 6, (CheckDigit)null);
        Assertions.assertEquals((Object)validator.getRegexValidator().toString(), (Object)("RegexValidator{" + regex + "}"), (String)"Reformat 2 Regex");
        Assertions.assertEquals((Object)validator.validate("123-456"), (Object)"123456", (String)"Reformat 2 123-456");
        Assertions.assertEquals((Object)validator.validate("123 456"), (Object)"123456", (String)"Reformat 2 123 456");
        Assertions.assertEquals((Object)validator.validate("123456"), (Object)"123456", (String)"Reformat 2 123456");
    }

    @Test
    void testValidator294Part1() {
        CodeValidator validator = new CodeValidator((String)null, 0, -1, (CheckDigit)null);
        Assertions.assertNull((Object)validator.validate(null), (String)"Null");
        validator = new CodeValidator((String)null, -1, 0, (CheckDigit)null);
        Assertions.assertNull((Object)validator.validate(null), (String)"Null");
    }

    @Test
    void testValidator294Part2() {
        CodeValidator validator = new CodeValidator((String)null, -1, 0, (CheckDigit)null);
        Assertions.assertNull((Object)validator.validate(null), (String)"Null");
    }
}

