/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator.routines;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.validator.ResultPair;
import org.apache.commons.validator.routines.DomainValidator;
import org.apache.commons.validator.routines.EmailValidator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

public class EmailValidatorTest {
    protected static final String FORM_KEY = "emailForm";
    protected static final String ACTION = "email";
    private static final ResultPair[] TEST_EMAIL_FROM_PERL = new ResultPair[]{new ResultPair("abigail@example.com", true), new ResultPair("abigail@example.com ", true), new ResultPair(" abigail@example.com", true), new ResultPair("abigail @example.com ", true), new ResultPair("*@example.net", true), new ResultPair("\"\\\"\"@foo.bar", true), new ResultPair("fred&barny@example.com", true), new ResultPair("---@example.com", true), new ResultPair("foo-bar@example.net", true), new ResultPair("\"127.0.0.1\"@[127.0.0.1]", true), new ResultPair("Abigail <abigail@example.com>", true), new ResultPair("Abigail<abigail@example.com>", true), new ResultPair("Abigail<@a,@b,@c:abigail@example.com>", true), new ResultPair("\"This is a phrase\"<abigail@example.com>", true), new ResultPair("\"Abigail \"<abigail@example.com>", true), new ResultPair("\"Joe & J. Harvey\" <example @Org>", true), new ResultPair("Abigail <abigail @ example.com>", true), new ResultPair("Abigail made this <  abigail   @   example  .    com    >", true), new ResultPair("Abigail(the bitch)@example.com", true), new ResultPair("Abigail <abigail @ example . (bar) com >", true), new ResultPair("Abigail < (one)  abigail (two) @(three) example . (bar) com (quz) >", true), new ResultPair("Abigail (foo) (((baz)(nested) (comment)) ! ) < (one)  abigail (two) @(three) example . (bar) com (quz) >", true), new ResultPair("Abigail <abigail(fo\\(o)@example.com>", true), new ResultPair("Abigail <abigail(fo\\)o)@example.com> ", true), new ResultPair("(foo) abigail@example.com", true), new ResultPair("abigail@example.com (foo)", true), new ResultPair("\"Abi\\\"gail\" <abigail@example.com>", true), new ResultPair("abigail@[example.com]", true), new ResultPair("abigail@[exa\\[ple.com]", true), new ResultPair("abigail@[exa\\]ple.com]", true), new ResultPair("\":sysmail\"@  Some-Group. Some-Org", true), new ResultPair("Muhammed.(I am  the greatest) Ali @(the) Vegas.WBA", true), new ResultPair("mailbox.sub1.sub2@this-domain", true), new ResultPair("sub-net.mailbox@sub-domain.domain", true), new ResultPair("name:;", true), new ResultPair("':;", true), new ResultPair("name:   ;", true), new ResultPair("Alfred Neuman <Neuman@BBN-TENEXA>", true), new ResultPair("Neuman@BBN-TENEXA", true), new ResultPair("\"George, Ted\" <Shared@Group.Arpanet>", true), new ResultPair("Wilt . (the  Stilt) Chamberlain@NBA.US", true), new ResultPair("Cruisers:  Port@Portugal, Jones@SEA;", true), new ResultPair("$@[]", true), new ResultPair("*()@[]", true), new ResultPair("\"quoted ( brackets\" ( a comment )@example.com", true), new ResultPair("\"Joe & J. Harvey\"\\x0D\\x0A     <ddd\\@ Org>", true), new ResultPair("\"Joe &\\x0D\\x0A J. Harvey\" <ddd \\@ Org>", true), new ResultPair("Gourmets:  Pompous Person <WhoZiWhatZit\\@Cordon-Bleu>,\\x0D\\x0A        Childs\\@WGBH.Boston, \"Galloping Gourmet\"\\@\\x0D\\x0A        ANT.Down-Under (Australian National Television),\\x0D\\x0A        Cheapie\\@Discount-Liquors;", true), new ResultPair("   Just a string", false), new ResultPair("string", false), new ResultPair("(comment)", false), new ResultPair("()@example.com", false), new ResultPair("fred(&)barny@example.com", false), new ResultPair("fred\\ barny@example.com", false), new ResultPair("Abigail <abi gail @ example.com>", false), new ResultPair("Abigail <abigail(fo(o)@example.com>", false), new ResultPair("Abigail <abigail(fo) o)@example.com>", false), new ResultPair("\"Abi\"gail\" <abigail@example.com>", false), new ResultPair("abigail@[exa]ple.com]", false), new ResultPair("abigail@[exa[ple.com]", false), new ResultPair("abigail@[exaple].com]", false), new ResultPair("abigail@", false), new ResultPair("@example.com", false), new ResultPair("phrase: abigail@example.com abigail@example.com ;", false), new ResultPair("invalid\ufffdchar@example.com", false)};
    private EmailValidator validator;

    public static void main(String[] args) {
        EmailValidator validator = EmailValidator.getInstance();
        for (String arg : args) {
            System.out.printf("%s: %s%n", arg, validator.isValid(arg));
        }
    }

    @BeforeEach
    public void setUp() {
        this.validator = EmailValidator.getInstance();
    }

    @Test
    void testEmail() {
        Assertions.assertTrue((boolean)this.validator.isValid("jsmith@apache.org"));
    }

    @Test
    void testEmailAtTLD() {
        EmailValidator val = EmailValidator.getInstance((boolean)false, (boolean)true);
        Assertions.assertTrue((boolean)val.isValid("test@com"));
    }

    @Test
    void testEmailExtension() {
        Assertions.assertTrue((boolean)this.validator.isValid("jsmith@apache.org"));
        Assertions.assertTrue((boolean)this.validator.isValid("jsmith@apache.com"));
        Assertions.assertTrue((boolean)this.validator.isValid("jsmith@apache.net"));
        Assertions.assertTrue((boolean)this.validator.isValid("jsmith@apache.info"));
        Assertions.assertFalse((boolean)this.validator.isValid("jsmith@apache."));
        Assertions.assertFalse((boolean)this.validator.isValid("jsmith@apache.c"));
        Assertions.assertTrue((boolean)this.validator.isValid("someone@yahoo.museum"));
        Assertions.assertFalse((boolean)this.validator.isValid("someone@yahoo.mu-seum"));
    }

    @Disabled(value="VALIDATOR-267")
    @Test
    void testEmailFromPerl() {
        int errors = 0;
        for (ResultPair element : TEST_EMAIL_FROM_PERL) {
            String item = element.item;
            boolean exp = element.valid;
            boolean act = this.validator.isValid(item);
            if (act == exp) continue;
            System.out.printf("%s: expected %s actual %s%n", item, exp, act);
            ++errors;
        }
        Assertions.assertEquals((int)0, (int)errors, (String)"Expected 0 errors");
    }

    @Test
    void testEmailLocalhost() {
        EmailValidator noLocal = EmailValidator.getInstance((boolean)false);
        EmailValidator allowLocal = EmailValidator.getInstance((boolean)true);
        Assertions.assertEquals((Object)this.validator, (Object)noLocal);
        Assertions.assertTrue((boolean)allowLocal.isValid("joe@localhost.localdomain"), (String)"@localhost.localdomain should be accepted but wasn't");
        Assertions.assertTrue((boolean)allowLocal.isValid("joe@localhost"), (String)"@localhost should be accepted but wasn't");
        Assertions.assertFalse((boolean)noLocal.isValid("joe@localhost.localdomain"), (String)"@localhost.localdomain should be accepted but wasn't");
        Assertions.assertFalse((boolean)noLocal.isValid("joe@localhost"), (String)"@localhost should be accepted but wasn't");
    }

    @Test
    void testEmailUserName() {
        Assertions.assertTrue((boolean)this.validator.isValid("joe1blow@apache.org"));
        Assertions.assertTrue((boolean)this.validator.isValid("joe$blow@apache.org"));
        Assertions.assertTrue((boolean)this.validator.isValid("joe-@apache.org"));
        Assertions.assertTrue((boolean)this.validator.isValid("joe_@apache.org"));
        Assertions.assertTrue((boolean)this.validator.isValid("joe+@apache.org"));
        Assertions.assertTrue((boolean)this.validator.isValid("joe!@apache.org"));
        Assertions.assertTrue((boolean)this.validator.isValid("joe*@apache.org"));
        Assertions.assertTrue((boolean)this.validator.isValid("joe'@apache.org"));
        Assertions.assertTrue((boolean)this.validator.isValid("joe%45@apache.org"));
        Assertions.assertTrue((boolean)this.validator.isValid("joe?@apache.org"));
        Assertions.assertTrue((boolean)this.validator.isValid("joe&@apache.org"));
        Assertions.assertTrue((boolean)this.validator.isValid("joe=@apache.org"));
        Assertions.assertTrue((boolean)this.validator.isValid("+joe@apache.org"));
        Assertions.assertTrue((boolean)this.validator.isValid("!joe@apache.org"));
        Assertions.assertTrue((boolean)this.validator.isValid("*joe@apache.org"));
        Assertions.assertTrue((boolean)this.validator.isValid("'joe@apache.org"));
        Assertions.assertTrue((boolean)this.validator.isValid("%joe45@apache.org"));
        Assertions.assertTrue((boolean)this.validator.isValid("?joe@apache.org"));
        Assertions.assertTrue((boolean)this.validator.isValid("&joe@apache.org"));
        Assertions.assertTrue((boolean)this.validator.isValid("=joe@apache.org"));
        Assertions.assertTrue((boolean)this.validator.isValid("+@apache.org"));
        Assertions.assertTrue((boolean)this.validator.isValid("!@apache.org"));
        Assertions.assertTrue((boolean)this.validator.isValid("*@apache.org"));
        Assertions.assertTrue((boolean)this.validator.isValid("'@apache.org"));
        Assertions.assertTrue((boolean)this.validator.isValid("%@apache.org"));
        Assertions.assertTrue((boolean)this.validator.isValid("?@apache.org"));
        Assertions.assertTrue((boolean)this.validator.isValid("&@apache.org"));
        Assertions.assertTrue((boolean)this.validator.isValid("=@apache.org"));
        Assertions.assertFalse((boolean)this.validator.isValid("joe.@apache.org"));
        Assertions.assertFalse((boolean)this.validator.isValid(".joe@apache.org"));
        Assertions.assertFalse((boolean)this.validator.isValid(".@apache.org"));
        Assertions.assertTrue((boolean)this.validator.isValid("joe.ok@apache.org"));
        Assertions.assertFalse((boolean)this.validator.isValid("joe..ok@apache.org"));
        Assertions.assertFalse((boolean)this.validator.isValid("..@apache.org"));
        Assertions.assertFalse((boolean)this.validator.isValid("joe(@apache.org"));
        Assertions.assertFalse((boolean)this.validator.isValid("joe)@apache.org"));
        Assertions.assertFalse((boolean)this.validator.isValid("joe,@apache.org"));
        Assertions.assertFalse((boolean)this.validator.isValid("joe;@apache.org"));
        Assertions.assertTrue((boolean)this.validator.isValid("\"joe.\"@apache.org"));
        Assertions.assertTrue((boolean)this.validator.isValid("\".joe\"@apache.org"));
        Assertions.assertTrue((boolean)this.validator.isValid("\"joe+\"@apache.org"));
        Assertions.assertTrue((boolean)this.validator.isValid("\"joe@\"@apache.org"));
        Assertions.assertTrue((boolean)this.validator.isValid("\"joe!\"@apache.org"));
        Assertions.assertTrue((boolean)this.validator.isValid("\"joe*\"@apache.org"));
        Assertions.assertTrue((boolean)this.validator.isValid("\"joe'\"@apache.org"));
        Assertions.assertTrue((boolean)this.validator.isValid("\"joe(\"@apache.org"));
        Assertions.assertTrue((boolean)this.validator.isValid("\"joe)\"@apache.org"));
        Assertions.assertTrue((boolean)this.validator.isValid("\"joe,\"@apache.org"));
        Assertions.assertTrue((boolean)this.validator.isValid("\"joe%45\"@apache.org"));
        Assertions.assertTrue((boolean)this.validator.isValid("\"joe;\"@apache.org"));
        Assertions.assertTrue((boolean)this.validator.isValid("\"joe?\"@apache.org"));
        Assertions.assertTrue((boolean)this.validator.isValid("\"joe&\"@apache.org"));
        Assertions.assertTrue((boolean)this.validator.isValid("\"joe=\"@apache.org"));
        Assertions.assertTrue((boolean)this.validator.isValid("\"..\"@apache.org"));
        Assertions.assertTrue((boolean)this.validator.isValid("\"john\\\"doe\"@apache.org"));
        Assertions.assertTrue((boolean)this.validator.isValid("john56789.john56789.john56789.john56789.john56789.john56789.john@example.com"));
        Assertions.assertFalse((boolean)this.validator.isValid("john56789.john56789.john56789.john56789.john56789.john56789.john5@example.com"));
        Assertions.assertTrue((boolean)this.validator.isValid("\\>escape\\\\special\\^characters\\<@example.com"));
        Assertions.assertTrue((boolean)this.validator.isValid("Abc\\@def@example.com"));
        Assertions.assertFalse((boolean)this.validator.isValid("Abc@def@example.com"));
        Assertions.assertTrue((boolean)this.validator.isValid("space\\ monkey@example.com"));
    }

    @Test
    void testEmailWithBogusCharacter() {
        Assertions.assertFalse((boolean)this.validator.isValid("andy.noble@\u008fdata-workshop.com"));
        Assertions.assertTrue((boolean)this.validator.isValid("andy.o'reilly@data-workshop.com"));
        Assertions.assertFalse((boolean)this.validator.isValid("andy@o'reilly.data-workshop.com"));
        Assertions.assertTrue((boolean)this.validator.isValid("foo+bar@i.am.not.in.us.example.com"));
        Assertions.assertFalse((boolean)this.validator.isValid("foo+bar@example+3.com"));
        Assertions.assertFalse((boolean)this.validator.isValid("test@%*.com"));
        Assertions.assertFalse((boolean)this.validator.isValid("test@^&#.com"));
    }

    @Test
    void testEmailWithCommas() {
        Assertions.assertFalse((boolean)this.validator.isValid("joeblow@apa,che.org"));
        Assertions.assertFalse((boolean)this.validator.isValid("joeblow@apache.o,rg"));
        Assertions.assertFalse((boolean)this.validator.isValid("joeblow@apache,org"));
    }

    @Test
    void testEmailWithControlChars() {
        for (char c = '\u0000'; c < ' '; c = (char)(c + '\u0001')) {
            Assertions.assertFalse((boolean)this.validator.isValid("foo" + c + "bar@domain.com"), (String)("Test control char " + c));
        }
        Assertions.assertFalse((boolean)this.validator.isValid("foo\u007fbar@domain.com"), (String)"Test control char 127");
    }

    @Test
    void testEmailWithDash() {
        Assertions.assertTrue((boolean)this.validator.isValid("andy.noble@data-workshop.com"));
        Assertions.assertFalse((boolean)this.validator.isValid("andy-noble@data-workshop.-com"));
        Assertions.assertFalse((boolean)this.validator.isValid("andy-noble@data-workshop.c-om"));
        Assertions.assertFalse((boolean)this.validator.isValid("andy-noble@data-workshop.co-m"));
    }

    @Test
    void testEmailWithDotEnd() {
        Assertions.assertFalse((boolean)this.validator.isValid("andy.noble@data-workshop.com."));
    }

    @Test
    void testEmailWithNumericAddress() {
        Assertions.assertTrue((boolean)this.validator.isValid("someone@[216.109.118.76]"));
        Assertions.assertTrue((boolean)this.validator.isValid("someone@yahoo.com"));
    }

    @Test
    void testEmailWithSlashes() {
        Assertions.assertTrue((boolean)this.validator.isValid("joe!/blow@apache.org"), (String)"/ and ! valid in username");
        Assertions.assertFalse((boolean)this.validator.isValid("joe@ap/ache.org"), (String)"/ not valid in domain");
        Assertions.assertFalse((boolean)this.validator.isValid("joe@apac!he.org"), (String)"! not valid in domain");
    }

    @Test
    void testEmailWithSpaces() {
        Assertions.assertFalse((boolean)this.validator.isValid("joeblow @apache.org"));
        Assertions.assertFalse((boolean)this.validator.isValid("joeblow@ apache.org"));
        Assertions.assertFalse((boolean)this.validator.isValid(" joeblow@apache.org"));
        Assertions.assertFalse((boolean)this.validator.isValid("joeblow@apache.org "));
        Assertions.assertFalse((boolean)this.validator.isValid("joe blow@apache.org "));
        Assertions.assertFalse((boolean)this.validator.isValid("joeblow@apa che.org "));
        Assertions.assertTrue((boolean)this.validator.isValid("\"joeblow \"@apache.org"));
        Assertions.assertTrue((boolean)this.validator.isValid("\" joeblow\"@apache.org"));
        Assertions.assertTrue((boolean)this.validator.isValid("\" joe blow \"@apache.org"));
    }

    @Test
    void testValidator235() {
        Assertions.assertTrue((boolean)this.validator.isValid("someone@xn--d1abbgf6aiiy.xn--p1ai"), (String)"xn--d1abbgf6aiiy.xn--p1ai should validate");
        Assertions.assertTrue((boolean)this.validator.isValid("someone@\u043f\u0440\u0435\u0437\u0438\u0434\u0435\u043d\u0442.\u0440\u0444"), (String)"\u043f\u0440\u0435\u0437\u0438\u0434\u0435\u043d\u0442.\u0440\u0444 should validate");
        Assertions.assertTrue((boolean)this.validator.isValid("someone@www.b\u00fccher.ch"), (String)"www.b\u00fccher.ch should validate");
        Assertions.assertFalse((boolean)this.validator.isValid("someone@www.\ufffd.ch"), (String)"www.\ufffd.ch FFFD should fail");
        Assertions.assertTrue((boolean)this.validator.isValid("someone@www.b\u00fccher.ch"), (String)"www.b\u00fccher.ch should validate");
        Assertions.assertFalse((boolean)this.validator.isValid("someone@www.\ufffd.ch"), (String)"www.\ufffd.ch FFFD should fail");
    }

    @Test
    void testValidator278() {
        Assertions.assertFalse((boolean)this.validator.isValid("someone@-test.com"));
        Assertions.assertFalse((boolean)this.validator.isValid("someone@test-.com"));
    }

    @Test
    void testValidator293() {
        Assertions.assertTrue((boolean)this.validator.isValid("abc-@abc.com"));
        Assertions.assertTrue((boolean)this.validator.isValid("abc_@abc.com"));
        Assertions.assertTrue((boolean)this.validator.isValid("abc-def@abc.com"));
        Assertions.assertTrue((boolean)this.validator.isValid("abc_def@abc.com"));
        Assertions.assertFalse((boolean)this.validator.isValid("abc@abc_def.com"));
    }

    @Test
    void testValidator315() {
        Assertions.assertFalse((boolean)this.validator.isValid("me@at&t.net"));
        Assertions.assertTrue((boolean)this.validator.isValid("me@att.net"));
    }

    @Test
    void testValidator359() {
        EmailValidator val = EmailValidator.getInstance((boolean)false, (boolean)true);
        Assertions.assertFalse((boolean)val.isValid("test@.com"));
    }

    @Test
    void testValidator365() {
        Assertions.assertFalse((boolean)this.validator.isValid("Loremipsumdolorsitametconsecteturadipiscingelit.Nullavitaeligulamattisrhoncusnuncegestasmattisleo.Donecnonsapieninmagnatristiquedictumaacturpis.Fusceorciduifacilisisutsapieneuconsequatpharetralectus.Quisqueenimestpulvinarutquamvitaeportamattisex.Nullamquismaurisplaceratconvallisjustoquisportamauris.Innullalacusconvalliseufringillautvenenatissitametdiam.Maecenasluctusligulascelerisquepulvinarfeugiat.Sedmolestienullaaliquetorciluctusidpharetranislfinibus.Suspendissemalesuadatinciduntduisitametportaarcusollicitudinnec.Donecetmassamagna.Curabitururnadiampretiumveldignissimporttitorfringillaeuneque.Duisantetelluspharetraidtinciduntinterdummolestiesitametfelis.Utquisquamsitametantesagittisdapibusacnonodio.Namrutrummolestiediamidmattis.Cumsociisnatoquepenatibusetmagnisdisparturientmontesnasceturridiculusmus.Morbiposueresedmetusacconsectetur.Etiamquisipsumvitaejustotempusmaximus.Sedultriciesplaceratvolutpat.Integerlacuslectusmaximusacornarequissagittissitametjusto.Cumsociisnatoquepenatibusetmagnisdisparturientmontesnasceturridiculusmus.Maecenasindictumpurussedrutrumex.Nullafacilisi.Integerfinibusfinibusmietpharetranislfaucibusvel.Maecenasegetdolorlacinialobortisjustovelullamcorpersem.Vivamusaliquetpurusidvariusornaresapienrisusrutrumnisitinciduntmollissemnequeidmetus.Etiamquiseleifendpurus.Nuncfelisnuncscelerisqueiddignissimnecfinibusalibero.Nuncsemperenimnequesitamethendreritpurusfacilisisac.Maurisdapibussemperfelisdignissimgravida.Aeneanultricesblanditnequealiquamfinibusodioscelerisqueac.Aliquamnecmassaeumaurisfaucibusfringilla.Etiamconsequatligulanisisitametaliquamnibhtemporquis.Nuncinterdumdignissimnullaatsodalesarcusagittiseu.Proinpharetrametusneclacuspulvinarsedvolutpatliberoornare.Sedligulanislpulvinarnonlectuseublanditfacilisisante.Sedmollisnislalacusauctorsuscipit.Inhachabitasseplateadictumst.Phasellussitametvelittemporvenenatisfeliseuegestasrisus.Aliquameteratsitametnibhcommodofinibus.Morbiefficiturodiovelpulvinariaculis.Aeneantemporipsummassaaconsecteturturpisfaucibusultrices.Praesentsodalesmaurisquisportafermentum.Etiamnisinislvenenatisvelauctorutullamcorperinjusto.Proinvelligulaerat.Phasellusvestibulumgravidamassanonfeugiat.Maecenaspharetraeuismodmetusegetefficitur.Suspendisseamet@gmail.com"));
    }

    @Test
    void testValidator374() {
        Assertions.assertTrue((boolean)this.validator.isValid("abc@school.school"));
    }

    @Test
    void testValidator473Part1() {
        IllegalArgumentException thrown = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> new EmailValidator(false, false, null));
        Assertions.assertEquals((Object)"DomainValidator cannot be null", (Object)thrown.getMessage());
    }

    @Test
    void testValidator473Part2() {
        ArrayList items = new ArrayList();
        IllegalArgumentException thrown = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> new EmailValidator(false, false, DomainValidator.getInstance((boolean)true, (List)items)));
        Assertions.assertEquals((Object)"DomainValidator must agree with allowLocal setting", (Object)thrown.getMessage());
    }

    @Test
    void testValidator473Part3() {
        ArrayList items = new ArrayList();
        IllegalArgumentException thrown = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> new EmailValidator(true, false, DomainValidator.getInstance((boolean)false, (List)items)));
        Assertions.assertEquals((Object)"DomainValidator must agree with allowLocal setting", (Object)thrown.getMessage());
    }

    @Test
    void testValidator473Part4() {
        Assertions.assertFalse((boolean)this.validator.isValidDomain("test.local"));
        ArrayList<DomainValidator.Item> items = new ArrayList<DomainValidator.Item>();
        items.add(new DomainValidator.Item(DomainValidator.ArrayType.GENERIC_PLUS, new String[]{"local"}));
        EmailValidator val = new EmailValidator(true, false, DomainValidator.getInstance((boolean)true, items));
        Assertions.assertTrue((boolean)val.isValidDomain("test.local"));
    }
}

