/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.ftps;

import java.io.IOException;
import java.net.SocketException;
import org.apache.commons.net.ftp.FTPSClient;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.VFS;
import org.apache.commons.vfs2.provider.ftps.AbstractFtpsProviderTestCase;
import org.apache.commons.vfs2.provider.ftps.FtpsProviderImplicitTestCase;
import org.apache.ftpserver.ftplet.FtpException;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class FtpsMultipleConnectionTest {
    @BeforeAll
    public static void setUpClass() throws FtpException {
        AbstractFtpsProviderTestCase.setUpClass(true);
    }

    @AfterAll
    public static void tearDownClass() {
        AbstractFtpsProviderTestCase.tearDownClass();
    }

    private FTPSClient init(FTPSClient client) {
        client.enterLocalPassiveMode();
        return client;
    }

    private FileObject resolveRoot() throws FileSystemException {
        return VFS.getManager().resolveFile(AbstractFtpsProviderTestCase.getConnectionUri(), new FtpsProviderImplicitTestCase().getFileSystemOptions());
    }

    @Test
    public void testConnectRoot() throws IOException {
        this.resolveRoot();
        this.resolveRoot();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUnderlyingConnect() throws SocketException, IOException {
        FTPSClient client1 = this.init(new FTPSClient(true));
        FTPSClient client2 = this.init(new FTPSClient(true));
        try {
            String hostname = "localhost";
            client1.connect("localhost", AbstractFtpsProviderTestCase.getSocketPort());
            client2.connect("localhost", AbstractFtpsProviderTestCase.getSocketPort());
        }
        finally {
            if (client1 != null) {
                client1.disconnect();
            }
            if (client2 != null) {
                client2.disconnect();
            }
        }
    }
}

