/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.gzip;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.commons.vfs2.FileContent;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.VFS;
import org.apache.commons.vfs2.provider.gzip.GzipFileObject;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class GzipTest {
    @Test
    public void testCreateGzipFileSystem() throws IOException {
        File gzFile = new File("src/test/resources/test-data/\u597d.txt.gz");
        FileSystemManager manager = VFS.getManager();
        try (FileObject localFileObject = manager.resolveFile(gzFile.getAbsolutePath());
             FileObject gzFileObjectDir = manager.createFileSystem(localFileObject);
             FileObject gzFileObject = gzFileObjectDir.resolveFile("\u597d.txt");){
            Assertions.assertInstanceOf(GzipFileObject.class, (Object)gzFileObjectDir);
            Assertions.assertTrue((boolean)gzFileObjectDir.isFolder());
            Assertions.assertInstanceOf(GzipFileObject.class, (Object)gzFileObject);
            Assertions.assertFalse((boolean)gzFileObject.isFolder());
            try (FileContent content = gzFileObject.getContent();){
                Assertions.assertEquals((Object)"aaa", (Object)content.getString(StandardCharsets.UTF_8));
            }
        }
    }
}

