/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.test;

import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.VfsTestUtils;
import org.apache.commons.vfs2.provider.GenericFileName;
import org.apache.commons.vfs2.provider.GenericURLFileNameParser;
import org.apache.commons.vfs2.provider.URLFileNameParser;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class GenericFileNameTest {
    @Test
    public void testBadlyFormedUri() throws Exception {
        this.testBadlyFormedUri("ftp:", "vfs.provider/missing-double-slashes.error");
        this.testBadlyFormedUri("ftp:/", "vfs.provider/missing-double-slashes.error");
        this.testBadlyFormedUri("ftp:a", "vfs.provider/missing-double-slashes.error");
        this.testBadlyFormedUri("ftp://", "vfs.provider/missing-hostname.error");
        this.testBadlyFormedUri("ftp://:21/file", "vfs.provider/missing-hostname.error");
        this.testBadlyFormedUri("ftp:///file", "vfs.provider/missing-hostname.error");
        this.testBadlyFormedUri("ftp://host:", "vfs.provider/missing-port.error");
        this.testBadlyFormedUri("ftp://host:/file", "vfs.provider/missing-port.error");
        this.testBadlyFormedUri("ftp://host:port/file", "vfs.provider/missing-port.error");
        this.testBadlyFormedUri("ftp://host:90a", "vfs.provider/missing-hostname-path-sep.error");
        this.testBadlyFormedUri("ftp://host?a", "vfs.provider/missing-hostname-path-sep.error");
    }

    private void testBadlyFormedUri(String uri, String errorMsg) {
        try {
            new URLFileNameParser(80).parseUri(null, null, uri);
            Assertions.fail();
        }
        catch (FileSystemException e) {
            VfsTestUtils.assertSameMessage(errorMsg, uri, (Throwable)e);
        }
    }

    @Test
    public void testIPv6BadlyFormedUri() {
        this.testBadlyFormedUri("ftp://[", "vfs.provider/unterminated-ipv6-hostname.error");
        this.testBadlyFormedUri("ftp://[fe80::8b2:d61e:e5c:b333", "vfs.provider/unterminated-ipv6-hostname.error");
        this.testBadlyFormedUri("ftp://fe80::8b2:d61e:e5c:b333]", "vfs.provider/missing-port.error");
        this.testBadlyFormedUri("ftp://[]", "vfs.provider/missing-hostname.error");
        this.testBadlyFormedUri("ftp://[[fe80::8b2:d61e:e5c:b333]]", "vfs.provider/missing-hostname-path-sep.error");
        this.testBadlyFormedUri("ftp://[][]", "vfs.provider/missing-hostname.error");
        this.testBadlyFormedUri("ftp://[fe80::8b2:d61e:e5c:b333][fe80::8b2:d61e:e5c:b333]", "vfs.provider/missing-hostname-path-sep.error");
    }

    @Test
    public void testParseIPv6InvalidHostsTolerance() throws Exception {
        GenericURLFileNameParser urlParser = new GenericURLFileNameParser(21);
        GenericFileName name = (GenericFileName)urlParser.parseUri(null, null, "ftp://[1:2e]:2222/test");
        Assertions.assertEquals((Object)"[1:2e]", (Object)name.getHostName());
        Assertions.assertEquals((int)2222, (int)name.getPort());
        Assertions.assertEquals((Object)"ftp://[1:2e]:2222/test", (Object)name.getURI());
        name = (GenericFileName)urlParser.parseUri(null, null, "ftp://[192.168.1.1]:2222/test");
        Assertions.assertEquals((Object)"[192.168.1.1]", (Object)name.getHostName());
        Assertions.assertEquals((int)2222, (int)name.getPort());
        Assertions.assertEquals((Object)"ftp://[192.168.1.1]:2222/test", (Object)name.getURI());
        name = (GenericFileName)urlParser.parseUri(null, null, "ftp://[::7:6:5:4:3:2:1:0]:2222/test");
        Assertions.assertEquals((Object)"[::7:6:5:4:3:2:1:0]", (Object)name.getHostName());
        Assertions.assertEquals((int)2222, (int)name.getPort());
        Assertions.assertEquals((Object)"ftp://[::7:6:5:4:3:2:1:0]:2222/test", (Object)name.getURI());
        name = (GenericFileName)urlParser.parseUri(null, null, "ftp://[3ffe:0:0:0:0:0:0:0:1]:2222/test");
        Assertions.assertEquals((Object)"[3ffe:0:0:0:0:0:0:0:1]", (Object)name.getHostName());
        Assertions.assertEquals((int)2222, (int)name.getPort());
        Assertions.assertEquals((Object)"ftp://[3ffe:0:0:0:0:0:0:0:1]:2222/test", (Object)name.getURI());
        name = (GenericFileName)urlParser.parseUri(null, null, "ftp://[3ffe::10000]:2222/test");
        Assertions.assertEquals((Object)"[3ffe::10000]", (Object)name.getHostName());
        Assertions.assertEquals((int)2222, (int)name.getPort());
        Assertions.assertEquals((Object)"ftp://[3ffe::10000]:2222/test", (Object)name.getURI());
        name = (GenericFileName)urlParser.parseUri(null, null, "ftp://[ ]:2222/test");
        Assertions.assertEquals((Object)"[ ]", (Object)name.getHostName());
        Assertions.assertEquals((int)2222, (int)name.getPort());
        Assertions.assertEquals((Object)"ftp://[ ]:2222/test", (Object)name.getURI());
        name = (GenericFileName)urlParser.parseUri(null, null, "ftp://[:]:2222/test");
        Assertions.assertEquals((Object)"[:]", (Object)name.getHostName());
        Assertions.assertEquals((int)2222, (int)name.getPort());
        Assertions.assertEquals((Object)"ftp://[:]:2222/test", (Object)name.getURI());
        name = (GenericFileName)urlParser.parseUri(null, null, "ftp://[:::]:2222/test");
        Assertions.assertEquals((Object)"[:::]", (Object)name.getHostName());
        Assertions.assertEquals((int)2222, (int)name.getPort());
        Assertions.assertEquals((Object)"ftp://[:::]:2222/test", (Object)name.getURI());
        name = (GenericFileName)urlParser.parseUri(null, null, "ftp://[xyz]:2222/test");
        Assertions.assertEquals((Object)"[xyz]", (Object)name.getHostName());
        Assertions.assertEquals((int)2222, (int)name.getPort());
        Assertions.assertEquals((Object)"ftp://[xyz]:2222/test", (Object)name.getURI());
    }

    @Test
    public void testParseIPv6Uri() throws Exception {
        GenericURLFileNameParser urlParser = new GenericURLFileNameParser(21);
        GenericFileName name = (GenericFileName)urlParser.parseUri(null, null, "ftp://[fe80::3dd0:7f8e:57b7:34d5]:2222/test");
        Assertions.assertEquals((Object)"[fe80::3dd0:7f8e:57b7:34d5]", (Object)name.getHostName());
        Assertions.assertEquals((int)2222, (int)name.getPort());
        Assertions.assertEquals((Object)"/test", (Object)name.getPath());
        Assertions.assertEquals((Object)"ftp://[fe80::3dd0:7f8e:57b7:34d5]:2222/", (Object)name.getRootURI());
        Assertions.assertEquals((Object)"ftp://[fe80::3dd0:7f8e:57b7:34d5]:2222/test", (Object)name.getURI());
        name = (GenericFileName)urlParser.parseUri(null, null, "http://user:password@[fe80::3dd0:7f8e:57b7:34d5]:2222/test?param1=value1&param2=value2#fragment");
        Assertions.assertEquals((Object)"[fe80::3dd0:7f8e:57b7:34d5]", (Object)name.getHostName());
        Assertions.assertEquals((int)2222, (int)name.getPort());
        Assertions.assertEquals((Object)"/test", (Object)name.getPath());
        Assertions.assertEquals((Object)"http://user:password@[fe80::3dd0:7f8e:57b7:34d5]:2222/", (Object)name.getRootURI());
        Assertions.assertEquals((Object)"http://user:password@[fe80::3dd0:7f8e:57b7:34d5]:2222/test?param1=value1&param2=value2#fragment", (Object)name.getURI());
        name = (GenericFileName)urlParser.parseUri(null, null, "ftp://[2001:658:22a:cafe::]:2222/test");
        Assertions.assertEquals((Object)"[2001:658:22a:cafe::]", (Object)name.getHostName());
        Assertions.assertEquals((int)2222, (int)name.getPort());
        Assertions.assertEquals((Object)"ftp://[2001:658:22a:cafe::]:2222/test", (Object)name.getURI());
        name = (GenericFileName)urlParser.parseUri(null, null, "ftp://[::1]:2222/test");
        Assertions.assertEquals((Object)"[::1]", (Object)name.getHostName());
        Assertions.assertEquals((int)2222, (int)name.getPort());
        Assertions.assertEquals((Object)"ftp://[::1]:2222/test", (Object)name.getURI());
        name = (GenericFileName)urlParser.parseUri(null, null, "ftp://[::]:2222/test");
        Assertions.assertEquals((Object)"[::]", (Object)name.getHostName());
        Assertions.assertEquals((int)2222, (int)name.getPort());
        Assertions.assertEquals((Object)"ftp://[::]:2222/test", (Object)name.getURI());
        name = (GenericFileName)urlParser.parseUri(null, null, "ftp://[0:0:0:0:0:0:13.1.68.3]:2222/test");
        Assertions.assertEquals((Object)"[0:0:0:0:0:0:13.1.68.3]", (Object)name.getHostName());
        Assertions.assertEquals((int)2222, (int)name.getPort());
        Assertions.assertEquals((Object)"ftp://[0:0:0:0:0:0:13.1.68.3]:2222/test", (Object)name.getURI());
        name = (GenericFileName)urlParser.parseUri(null, null, "ftp://[::13.1.68.3]:2222/test");
        Assertions.assertEquals((Object)"[::13.1.68.3]", (Object)name.getHostName());
        Assertions.assertEquals((int)2222, (int)name.getPort());
        Assertions.assertEquals((Object)"ftp://[::13.1.68.3]:2222/test", (Object)name.getURI());
        name = (GenericFileName)urlParser.parseUri(null, null, "ftp://[::FFFF:129.144.52.38]:2222/test");
        Assertions.assertEquals((Object)"[::ffff:129.144.52.38]", (Object)name.getHostName());
        Assertions.assertEquals((int)2222, (int)name.getPort());
        Assertions.assertEquals((Object)"ftp://[::ffff:129.144.52.38]:2222/test", (Object)name.getURI());
        name = (GenericFileName)urlParser.parseUri(null, null, "ftp://[FF01::101]:2222/test");
        Assertions.assertEquals((Object)"[ff01::101]", (Object)name.getHostName());
        Assertions.assertEquals((int)2222, (int)name.getPort());
        Assertions.assertEquals((Object)"ftp://[ff01::101]:2222/test", (Object)name.getURI());
        name = (GenericFileName)urlParser.parseUri(null, null, "ftp://[FF01::101]:2222");
        Assertions.assertEquals((Object)"[ff01::101]", (Object)name.getHostName());
        Assertions.assertEquals((int)2222, (int)name.getPort());
        Assertions.assertEquals((Object)"ftp://[ff01::101]:2222/", (Object)name.getURI());
        name = (GenericFileName)urlParser.parseUri(null, null, "ftp://[FF01::101]");
        Assertions.assertEquals((Object)"[ff01::101]", (Object)name.getHostName());
        Assertions.assertEquals((int)21, (int)name.getPort());
        Assertions.assertEquals((Object)"ftp://[ff01::101]/", (Object)name.getURI());
        name = (GenericFileName)urlParser.parseUri(null, null, "ftp://[fe80::8b2:d61e:e5c:b333%15]");
        Assertions.assertEquals((Object)"[fe80::8b2:d61e:e5c:b333%15]", (Object)name.getHostName());
        Assertions.assertEquals((int)21, (int)name.getPort());
        Assertions.assertEquals((Object)"ftp://[fe80::8b2:d61e:e5c:b333%15]/", (Object)name.getURI());
        name = (GenericFileName)urlParser.parseUri(null, null, "ftp://[fe80::8b2:d61e:e5c:b333%15]/tests%3A+test+1");
        Assertions.assertEquals((Object)"[fe80::8b2:d61e:e5c:b333%15]", (Object)name.getHostName());
        Assertions.assertEquals((int)21, (int)name.getPort());
        Assertions.assertEquals((Object)"ftp://[fe80::8b2:d61e:e5c:b333%15]/tests:+test+1", (Object)name.getURI());
    }

    @Test
    public void testParseUri() throws Exception {
        URLFileNameParser urlParser = new URLFileNameParser(21);
        GenericFileName name = (GenericFileName)urlParser.parseUri(null, null, "ftp://hostname/file");
        Assertions.assertEquals((Object)"ftp", (Object)name.getScheme());
        Assertions.assertNull((Object)name.getUserName());
        Assertions.assertNull((Object)name.getPassword());
        Assertions.assertEquals((Object)"hostname", (Object)name.getHostName());
        Assertions.assertEquals((int)21, (int)name.getPort());
        Assertions.assertEquals((int)name.getDefaultPort(), (int)name.getPort());
        Assertions.assertEquals((Object)"/file", (Object)name.getPath());
        Assertions.assertEquals((Object)"ftp://hostname/", (Object)name.getRootURI());
        Assertions.assertEquals((Object)"ftp://hostname/file", (Object)name.getURI());
        name = (GenericFileName)urlParser.parseUri(null, null, "ftp://hostname:9090/file");
        Assertions.assertEquals((Object)"ftp", (Object)name.getScheme());
        Assertions.assertNull((Object)name.getUserName());
        Assertions.assertNull((Object)name.getPassword());
        Assertions.assertEquals((Object)"hostname", (Object)name.getHostName());
        Assertions.assertEquals((int)9090, (int)name.getPort());
        Assertions.assertEquals((Object)"/file", (Object)name.getPath());
        Assertions.assertEquals((Object)"ftp://hostname:9090/", (Object)name.getRootURI());
        Assertions.assertEquals((Object)"ftp://hostname:9090/file", (Object)name.getURI());
        name = (GenericFileName)urlParser.parseUri(null, null, "ftp://hostname");
        Assertions.assertEquals((Object)"ftp", (Object)name.getScheme());
        Assertions.assertNull((Object)name.getUserName());
        Assertions.assertNull((Object)name.getPassword());
        Assertions.assertEquals((Object)"hostname", (Object)name.getHostName());
        Assertions.assertEquals((int)21, (int)name.getPort());
        Assertions.assertEquals((Object)"/", (Object)name.getPath());
        Assertions.assertEquals((Object)"ftp://hostname/", (Object)name.getRootURI());
        Assertions.assertEquals((Object)"ftp://hostname/", (Object)name.getURI());
        name = (GenericFileName)urlParser.parseUri(null, null, "ftp://user@hostname/file");
        Assertions.assertEquals((Object)"ftp", (Object)name.getScheme());
        Assertions.assertEquals((Object)"user", (Object)name.getUserName());
        Assertions.assertNull((Object)name.getPassword());
        Assertions.assertEquals((Object)"hostname", (Object)name.getHostName());
        Assertions.assertEquals((int)21, (int)name.getPort());
        Assertions.assertEquals((Object)"/file", (Object)name.getPath());
        Assertions.assertEquals((Object)"ftp://user@hostname/", (Object)name.getRootURI());
        Assertions.assertEquals((Object)"ftp://user@hostname/file", (Object)name.getURI());
        name = (GenericFileName)urlParser.parseUri(null, null, "ftp://user:password@hostname/file");
        Assertions.assertEquals((Object)"ftp", (Object)name.getScheme());
        Assertions.assertEquals((Object)"user", (Object)name.getUserName());
        Assertions.assertEquals((Object)"password", (Object)name.getPassword());
        Assertions.assertEquals((Object)"hostname", (Object)name.getHostName());
        Assertions.assertEquals((int)21, (int)name.getPort());
        Assertions.assertEquals((Object)"/file", (Object)name.getPath());
        Assertions.assertEquals((Object)"ftp://user:password@hostname/", (Object)name.getRootURI());
        Assertions.assertEquals((Object)"ftp://user:password@hostname/file", (Object)name.getURI());
        name = (GenericFileName)urlParser.parseUri(null, null, "ftp://%75ser%3A:%40@hostname");
        Assertions.assertEquals((Object)"ftp", (Object)name.getScheme());
        Assertions.assertEquals((Object)"user:", (Object)name.getUserName());
        Assertions.assertEquals((Object)"@", (Object)name.getPassword());
        Assertions.assertEquals((Object)"hostname", (Object)name.getHostName());
        Assertions.assertEquals((int)21, (int)name.getPort());
        Assertions.assertEquals((Object)"/", (Object)name.getPath());
        Assertions.assertEquals((Object)"ftp://user::%40@hostname/", (Object)name.getRootURI());
        Assertions.assertEquals((Object)"ftp://user::%40@hostname/", (Object)name.getURI());
        name = (GenericFileName)urlParser.parseUri(null, null, "ftp://p0~p1_p2-p3.p4/file");
        Assertions.assertEquals((Object)"ftp", (Object)name.getScheme());
        Assertions.assertNull((Object)name.getUserName());
        Assertions.assertNull((Object)name.getPassword());
        Assertions.assertEquals((Object)"p0~p1_p2-p3.p4", (Object)name.getHostName());
        Assertions.assertEquals((int)21, (int)name.getPort());
        Assertions.assertEquals((Object)"/file", (Object)name.getPath());
        Assertions.assertEquals((Object)"ftp://p0~p1_p2-p3.p4/", (Object)name.getRootURI());
        Assertions.assertEquals((Object)"ftp://p0~p1_p2-p3.p4/file", (Object)name.getURI());
        name = (GenericFileName)urlParser.parseUri(null, null, "ftp://p0!p1'p2(p3)*p4/file");
        Assertions.assertEquals((Object)"ftp", (Object)name.getScheme());
        Assertions.assertNull((Object)name.getUserName());
        Assertions.assertNull((Object)name.getPassword());
        Assertions.assertEquals((Object)"p0!p1'p2(p3)*p4", (Object)name.getHostName());
        Assertions.assertEquals((int)21, (int)name.getPort());
        Assertions.assertEquals((Object)"/file", (Object)name.getPath());
        Assertions.assertEquals((Object)"ftp://p0!p1'p2(p3)*p4/", (Object)name.getRootURI());
        Assertions.assertEquals((Object)"ftp://p0!p1'p2(p3)*p4/file", (Object)name.getURI());
    }
}

