/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.swizzle.stream;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import org.codehaus.swizzle.stream.DelimitedTokenReplacementInputStream;
import org.codehaus.swizzle.stream.StreamTokenHandler;
import org.codehaus.swizzle.stream.StringTokenHandler;

public class ExecuteMacroInputStream
extends DelimitedTokenReplacementInputStream {
    public ExecuteMacroInputStream(InputStream in, String begin, String end, Map macros) {
        super(in, begin, end, new MacroLibrary(macros));
    }

    public static class IncludeUrlMacro
    implements StreamTokenHandler {
        public InputStream processToken(String token) throws IOException {
            Macro macro = new Macro(token);
            String urlString = macro.getArg("url");
            URL url = new URL(urlString);
            return url.openStream();
        }
    }

    public static class IncludeFileMacro
    implements StreamTokenHandler {
        public InputStream processToken(String token) throws IOException {
            Macro macro = new Macro(token);
            String path = macro.getArg("path");
            File file = new File(path);
            return new FileInputStream(file);
        }
    }

    public static class UnknownMacro
    extends StringTokenHandler {
        public String handleToken(String token) throws IOException {
            return "{" + token + "}";
        }
    }

    public static class Macro {
        private final String name;
        private final Map args;

        public Macro(String token) throws IOException {
            this.name = token.substring(0, token.indexOf(":"));
            token = token.substring(this.name.length() + 1);
            String parameters = token.replace('|', '\n');
            Properties args = new Properties();
            args.load(new ByteArrayInputStream(parameters.getBytes()));
            this.args = args;
        }

        public String getName() {
            return this.name;
        }

        public Map getArgs() {
            return this.args;
        }

        public String getArg(String key) {
            return (String)this.args.get(key);
        }
    }

    public static class MacroLibrary
    implements StreamTokenHandler {
        private final Map macros;

        public MacroLibrary(Map macros) {
            this.macros = macros;
        }

        public InputStream processToken(String token) throws IOException {
            String macroName = token.substring(0, token.indexOf(":"));
            StreamTokenHandler macro = (StreamTokenHandler)this.macros.get(macroName);
            if (macro == null) {
                macro = new UnknownMacro();
            }
            return macro.processToken(token);
        }
    }
}

