/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.impl.internal.store.offheap;

import java.io.ObjectOutputStream;
import java.nio.ByteBuffer;
import org.ehcache.core.spi.store.Store;
import org.ehcache.impl.internal.store.BinaryValueHolder;
import org.ehcache.impl.internal.store.offheap.OffHeapValueHolder;

final class BinaryOffHeapValueHolder<V>
extends OffHeapValueHolder<V>
implements BinaryValueHolder {
    private final ByteBuffer binaryValue;
    private final V value;

    BinaryOffHeapValueHolder(long id, V value, ByteBuffer binaryValue, long creationTime, long expireTime, long lastAccessTime) {
        super(id, creationTime, expireTime);
        this.value = value;
        this.setLastAccessTime(lastAccessTime);
        this.binaryValue = binaryValue;
    }

    @Override
    public ByteBuffer getBinaryValue() throws IllegalStateException {
        return this.binaryValue.duplicate();
    }

    @Override
    public boolean isBinaryValueAvailable() {
        return true;
    }

    @Override
    void updateMetadata(Store.ValueHolder<V> valueFlushed) {
        throw new UnsupportedOperationException();
    }

    @Override
    void writeBack() {
        throw new UnsupportedOperationException();
    }

    @Override
    void forceDeserialization() {
        throw new UnsupportedOperationException();
    }

    @Override
    void detach() {
        throw new UnsupportedOperationException();
    }

    @Override
    public V get() {
        return this.value;
    }

    private void writeObject(ObjectOutputStream out) {
        throw new UnsupportedOperationException("This subclass of AbstractValueHolder is NOT serializable");
    }
}

