/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.core.exception;

import java.util.EnumMap;
import java.util.Map;

public class ProcessingException
extends Exception {
    private static final long serialVersionUID = 1L;
    private static final Map<TYPE, String> TYPE_MAP = new EnumMap<TYPE, String>(TYPE.class);
    private TYPE type;

    public ProcessingException(String message) {
        super(message);
    }

    public ProcessingException(String message, TYPE type) {
        super(message);
        this.type = type;
    }

    public ProcessingException(TYPE type) {
        this.type = type;
    }

    public ProcessingException(String message, Throwable e) {
        super(message, e);
    }

    public ProcessingException(String message, Throwable e, TYPE type) {
        super(message, e);
        this.type = type;
    }

    public void setType(TYPE type) {
        this.type = type;
    }

    public TYPE getType() {
        return this.type;
    }

    @Override
    public String getMessage() {
        if (this.type != null && TYPE_MAP.get((Object)this.type) != null) {
            return TYPE_MAP.get((Object)this.type);
        }
        return super.getMessage();
    }

    static {
        TYPE_MAP.put(TYPE.BAD_REQUEST, "The specified request is not understood");
        TYPE_MAP.put(TYPE.INVALID_REQUEST, "The request was invalid or malformed");
        TYPE_MAP.put(TYPE.TOKEN_REPLAY, "Security token already used (replay)");
        TYPE_MAP.put(TYPE.TOKEN_EXPIRED, "Security token expired");
        TYPE_MAP.put(TYPE.ISSUER_NOT_TRUSTED, "Security token issuer not trusted");
        TYPE_MAP.put(TYPE.TOKEN_INVALID, "Security token has been revoked");
        TYPE_MAP.put(TYPE.TOKEN_NO_SIGNATURE, "Security token has no signature");
    }

    public static enum TYPE {
        TOKEN_EXPIRED,
        TOKEN_REPLAY,
        BAD_REQUEST,
        INVALID_REQUEST,
        ISSUER_NOT_TRUSTED,
        TOKEN_INVALID,
        TOKEN_NO_SIGNATURE;

    }
}

