/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.cpc;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.datasketches.common.TestUtil;
import org.apache.datasketches.cpc.CpcSketch;
import org.apache.datasketches.cpc.Flavor;
import org.apache.datasketches.memory.Memory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class CpcSketchCrossLanguageTest {
    @Test(groups={"generate_java_files"})
    public void generateBinariesForCompatibilityTesting() throws IOException {
        int[] nArr = new int[]{0, 100, 200, 2000, 20000};
        Flavor[] flavorArr = new Flavor[]{Flavor.EMPTY, Flavor.SPARSE, Flavor.HYBRID, Flavor.PINNED, Flavor.SLIDING};
        int flavorIdx = 0;
        for (int n : nArr) {
            CpcSketch sk = new CpcSketch(11);
            for (int i = 0; i < n; ++i) {
                sk.update((long)i);
            }
            Assert.assertEquals((Object)sk.getFlavor(), (Object)flavorArr[flavorIdx++]);
            Files.newOutputStream(TestUtil.javaPath.resolve("cpc_n" + n + "_java.sk"), new OpenOption[0]).write(sk.toByteArray());
        }
    }

    @Test(groups={"generate_java_files"})
    void negativeIntEquivalence() throws Exception {
        CpcSketch sk = new CpcSketch();
        int v1 = -1;
        sk.update((long)v1);
        int v2 = -1;
        sk.update((long)v2);
        int v3 = -1;
        sk.update((long)v3);
        long v4 = -1L;
        sk.update(v4);
        Assert.assertEquals((double)sk.getEstimate(), (double)1.0, (double)0.01);
        Files.newOutputStream(TestUtil.javaPath.resolve("cpc_negative_one_java.sk"), new OpenOption[0]).write(sk.toByteArray());
    }

    @Test(groups={"check_cpp_files"})
    public void allFlavors() throws IOException {
        int[] nArr = new int[]{0, 100, 200, 2000, 20000};
        Flavor[] flavorArr = new Flavor[]{Flavor.EMPTY, Flavor.SPARSE, Flavor.HYBRID, Flavor.PINNED, Flavor.SLIDING};
        int flavorIdx = 0;
        for (int n : nArr) {
            byte[] bytes = Files.readAllBytes(TestUtil.cppPath.resolve("cpc_n" + n + "_cpp.sk"));
            CpcSketch sketch = CpcSketch.heapify((Memory)Memory.wrap((byte[])bytes));
            Assert.assertEquals((Object)sketch.getFlavor(), (Object)flavorArr[flavorIdx++]);
            Assert.assertEquals((double)sketch.getEstimate(), (double)n, (double)((double)n * 0.02));
        }
    }
}

