/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.kll;

import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.kll.KllDirectFloatsSketch;
import org.apache.datasketches.kll.KllFloatsSketch;
import org.apache.datasketches.kll.KllHeapFloatsSketch;
import org.apache.datasketches.kll.KllHelper;
import org.apache.datasketches.kll.KllPreambleUtil;
import org.apache.datasketches.kll.KllSketch;
import org.apache.datasketches.memory.DefaultMemoryRequestServer;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.MemoryRequestServer;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.quantilescommon.FloatsSketchSortedView;
import org.apache.datasketches.quantilescommon.FloatsSortedViewIterator;
import org.testng.Assert;
import org.testng.annotations.Test;

public class KllMiscDirectFloatsTest {
    static final String LS = System.getProperty("line.separator");
    private static final DefaultMemoryRequestServer memReqSvr = new DefaultMemoryRequestServer();
    private static final boolean enablePrinting = false;

    @Test
    public void checkBounds() {
        KllFloatsSketch kll = KllMiscDirectFloatsTest.getDirectFloatsSketch(200, 0);
        for (int i = 0; i < 1000; ++i) {
            kll.update((float)i);
        }
        double eps = kll.getNormalizedRankError(false);
        float est = kll.getQuantile(0.5);
        float ub = kll.getQuantileUpperBound(0.5);
        float lb = kll.getQuantileLowerBound(0.5);
        Assert.assertEquals((float)ub, (float)kll.getQuantile(0.5 + eps));
        Assert.assertEquals((float)lb, (float)kll.getQuantile(0.5 - eps));
        KllMiscDirectFloatsTest.println("Ext     : " + est);
        KllMiscDirectFloatsTest.println("UB      : " + ub);
        KllMiscDirectFloatsTest.println("LB      : " + lb);
        double rest = kll.getRank(est);
        double restUB = kll.getRankUpperBound(rest);
        double restLB = kll.getRankLowerBound(rest);
        Assert.assertTrue((restUB - rest < 2.0 * eps ? 1 : 0) != 0);
        Assert.assertTrue((rest - restLB < 2.0 * eps ? 1 : 0) != 0);
    }

    public void visualCheckToString() {
        int k = 20;
        KllFloatsSketch sk = KllMiscDirectFloatsTest.getDirectFloatsSketch(20, 0);
        for (int i = 0; i < 10; ++i) {
            sk.update((float)(i + 1));
        }
        KllMiscDirectFloatsTest.println(sk.toString(true, true));
        KllFloatsSketch sk2 = KllMiscDirectFloatsTest.getDirectFloatsSketch(20, 0);
        for (int i = 0; i < 400; ++i) {
            sk2.update((float)(i + 1));
        }
        KllMiscDirectFloatsTest.println("\n" + sk2.toString(true, true));
        sk2.merge((KllSketch)sk);
        String s2 = sk2.toString(true, true);
        KllMiscDirectFloatsTest.println(LS + s2);
    }

    @Test
    public void viewDirectCompactions() {
        int k = 20;
        int u = 108;
        KllFloatsSketch sk = KllMiscDirectFloatsTest.getDirectFloatsSketch(k, 0);
        for (int i = 1; i <= u; ++i) {
            sk.update((float)i);
            if (sk.levelsArr[0] != 0) continue;
            KllMiscDirectFloatsTest.println(sk.toString(true, true));
            sk.update((float)(++i));
            KllMiscDirectFloatsTest.println(sk.toString(true, true));
            Assert.assertEquals((float)sk.getFloatItemsArray()[sk.levelsArr[0]], (float)i);
        }
    }

    @Test
    public void viewCompactionAndSortedView() {
        int k = 20;
        KllFloatsSketch sk = KllMiscDirectFloatsTest.getDirectFloatsSketch(k, 0);
        KllMiscDirectFloatsTest.show(sk, 20);
        FloatsSketchSortedView sv = sk.getSortedView();
        FloatsSortedViewIterator itr = sv.iterator();
        KllMiscDirectFloatsTest.printf("%12s%12s\n", "Value", "CumWeight");
        while (itr.next()) {
            float v = itr.getQuantile();
            long wt = itr.getWeight();
            KllMiscDirectFloatsTest.printf("%12.1f%12d\n", Float.valueOf(v), wt);
        }
    }

    private static void show(KllFloatsSketch sk, int limit) {
        for (int i = (int)sk.getN(); i < limit; ++i) {
            sk.update((float)(i + 1));
        }
        KllMiscDirectFloatsTest.println(sk.toString(true, true));
    }

    @Test
    public void checkSketchInitializeFloatHeap() {
        int k = 20;
        KllFloatsSketch sk = KllMiscDirectFloatsTest.getDirectFloatsSketch(k, 0);
        for (int i = 1; i <= k + 1; ++i) {
            sk.update((float)i);
        }
        Assert.assertEquals((int)sk.getK(), (int)k);
        Assert.assertEquals((long)sk.getN(), (long)(k + 1));
        Assert.assertEquals((int)sk.getNumRetained(), (int)11);
        Assert.assertFalse((boolean)sk.isEmpty());
        Assert.assertTrue((boolean)sk.isEstimationMode());
        Assert.assertEquals((int)sk.getMinK(), (int)k);
        Assert.assertEquals((int)sk.getFloatItemsArray().length, (int)33);
        Assert.assertEquals((int)sk.getLevelsArray(sk.sketchStructure).length, (int)3);
        Assert.assertEquals((float)sk.getMaxItem(), (float)21.0f);
        Assert.assertEquals((float)sk.getMinItem(), (float)1.0f);
        Assert.assertEquals((int)sk.getNumLevels(), (int)2);
        Assert.assertFalse((boolean)sk.isLevelZeroSorted());
        sk = KllMiscDirectFloatsTest.getDirectFloatsSketch(k, 0);
        Assert.assertEquals((int)sk.getK(), (int)k);
        Assert.assertEquals((long)sk.getN(), (long)0L);
        Assert.assertEquals((int)sk.getNumRetained(), (int)0);
        Assert.assertTrue((boolean)sk.isEmpty());
        Assert.assertFalse((boolean)sk.isEstimationMode());
        Assert.assertEquals((int)sk.getMinK(), (int)k);
        Assert.assertEquals((int)sk.getFloatItemsArray().length, (int)20);
        Assert.assertEquals((int)sk.getLevelsArray(sk.sketchStructure).length, (int)2);
        try {
            sk.getMaxItem();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sk.getMinItem();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        Assert.assertEquals((int)sk.getNumLevels(), (int)1);
        Assert.assertFalse((boolean)sk.isLevelZeroSorted());
        sk = KllMiscDirectFloatsTest.getDirectFloatsSketch(k, 0);
        sk.update(1.0f);
        Assert.assertEquals((int)sk.getK(), (int)k);
        Assert.assertEquals((long)sk.getN(), (long)1L);
        Assert.assertEquals((int)sk.getNumRetained(), (int)1);
        Assert.assertFalse((boolean)sk.isEmpty());
        Assert.assertFalse((boolean)sk.isEstimationMode());
        Assert.assertEquals((int)sk.getMinK(), (int)k);
        Assert.assertEquals((int)sk.getFloatItemsArray().length, (int)20);
        Assert.assertEquals((int)sk.getLevelsArray(sk.sketchStructure).length, (int)2);
        Assert.assertEquals((float)sk.getMaxItem(), (float)1.0f);
        Assert.assertEquals((float)sk.getMinItem(), (float)1.0f);
        Assert.assertEquals((int)sk.getNumLevels(), (int)1);
        Assert.assertFalse((boolean)sk.isLevelZeroSorted());
    }

    @Test
    public void checkSketchInitializeFloatHeapifyCompactMem() {
        int k = 20;
        KllFloatsSketch sk2 = KllMiscDirectFloatsTest.getDirectFloatsSketch(k, 0);
        for (int i = 1; i <= k + 1; ++i) {
            sk2.update((float)i);
        }
        byte[] compBytes = sk2.toByteArray();
        WritableMemory wmem = WritableMemory.writableWrap((byte[])compBytes);
        KllFloatsSketch sk = KllFloatsSketch.heapify((Memory)wmem);
        Assert.assertEquals((int)sk.getK(), (int)k);
        Assert.assertEquals((long)sk.getN(), (long)(k + 1));
        Assert.assertEquals((int)sk.getNumRetained(), (int)11);
        Assert.assertFalse((boolean)sk.isEmpty());
        Assert.assertTrue((boolean)sk.isEstimationMode());
        Assert.assertEquals((int)sk.getMinK(), (int)k);
        Assert.assertEquals((int)sk.getFloatItemsArray().length, (int)33);
        Assert.assertEquals((int)sk.getLevelsArray(sk.sketchStructure).length, (int)3);
        Assert.assertEquals((float)sk.getMaxItem(), (float)21.0f);
        Assert.assertEquals((float)sk.getMinItem(), (float)1.0f);
        Assert.assertEquals((int)sk.getNumLevels(), (int)2);
        Assert.assertFalse((boolean)sk.isLevelZeroSorted());
        sk2 = KllMiscDirectFloatsTest.getDirectFloatsSketch(k, 0);
        compBytes = sk2.toByteArray();
        wmem = WritableMemory.writableWrap((byte[])compBytes);
        sk = KllFloatsSketch.heapify((Memory)wmem);
        Assert.assertEquals((int)sk.getK(), (int)k);
        Assert.assertEquals((long)sk.getN(), (long)0L);
        Assert.assertEquals((int)sk.getNumRetained(), (int)0);
        Assert.assertTrue((boolean)sk.isEmpty());
        Assert.assertFalse((boolean)sk.isEstimationMode());
        Assert.assertEquals((int)sk.getMinK(), (int)k);
        Assert.assertEquals((int)sk.getFloatItemsArray().length, (int)20);
        Assert.assertEquals((int)sk.getLevelsArray(sk.sketchStructure).length, (int)2);
        try {
            sk.getMaxItem();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sk.getMinItem();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        Assert.assertEquals((int)sk.getNumLevels(), (int)1);
        Assert.assertFalse((boolean)sk.isLevelZeroSorted());
        sk2 = KllMiscDirectFloatsTest.getDirectFloatsSketch(k, 0);
        sk2.update(1.0f);
        compBytes = sk2.toByteArray();
        wmem = WritableMemory.writableWrap((byte[])compBytes);
        sk = KllFloatsSketch.heapify((Memory)wmem);
        Assert.assertEquals((int)sk.getK(), (int)k);
        Assert.assertEquals((long)sk.getN(), (long)1L);
        Assert.assertEquals((int)sk.getNumRetained(), (int)1);
        Assert.assertFalse((boolean)sk.isEmpty());
        Assert.assertFalse((boolean)sk.isEstimationMode());
        Assert.assertEquals((int)sk.getMinK(), (int)k);
        Assert.assertEquals((int)sk.getFloatItemsArray().length, (int)20);
        Assert.assertEquals((int)sk.getLevelsArray(sk.sketchStructure).length, (int)2);
        Assert.assertEquals((float)sk.getMaxItem(), (float)1.0f);
        Assert.assertEquals((float)sk.getMinItem(), (float)1.0f);
        Assert.assertEquals((int)sk.getNumLevels(), (int)1);
        Assert.assertFalse((boolean)sk.isLevelZeroSorted());
    }

    @Test
    public void checkSketchInitializeFloatHeapifyUpdatableMem() {
        int k = 20;
        KllFloatsSketch sk2 = KllMiscDirectFloatsTest.getDirectFloatsSketch(k, 0);
        for (int i = 1; i <= k + 1; ++i) {
            sk2.update((float)i);
        }
        byte[] compBytes = KllHelper.toByteArray((KllSketch)sk2, (boolean)true);
        WritableMemory wmem = WritableMemory.writableWrap((byte[])compBytes);
        KllHeapFloatsSketch sk = KllHeapFloatsSketch.heapifyImpl((Memory)wmem);
        Assert.assertEquals((int)sk.getK(), (int)k);
        Assert.assertEquals((long)sk.getN(), (long)(k + 1));
        Assert.assertEquals((int)sk.getNumRetained(), (int)11);
        Assert.assertFalse((boolean)sk.isEmpty());
        Assert.assertTrue((boolean)sk.isEstimationMode());
        Assert.assertEquals((int)sk.getMinK(), (int)k);
        Assert.assertEquals((int)sk.getFloatItemsArray().length, (int)33);
        Assert.assertEquals((int)sk.getLevelsArray(sk.sketchStructure).length, (int)3);
        Assert.assertEquals((float)sk.getMaxItem(), (float)21.0f);
        Assert.assertEquals((float)sk.getMinItem(), (float)1.0f);
        Assert.assertEquals((int)sk.getNumLevels(), (int)2);
        Assert.assertFalse((boolean)sk.isLevelZeroSorted());
        sk2 = KllMiscDirectFloatsTest.getDirectFloatsSketch(k, 0);
        compBytes = KllHelper.toByteArray((KllSketch)sk2, (boolean)true);
        wmem = WritableMemory.writableWrap((byte[])compBytes);
        sk = KllHeapFloatsSketch.heapifyImpl((Memory)wmem);
        Assert.assertEquals((int)sk.getK(), (int)k);
        Assert.assertEquals((long)sk.getN(), (long)0L);
        Assert.assertEquals((int)sk.getNumRetained(), (int)0);
        Assert.assertTrue((boolean)sk.isEmpty());
        Assert.assertFalse((boolean)sk.isEstimationMode());
        Assert.assertEquals((int)sk.getMinK(), (int)k);
        Assert.assertEquals((int)sk.getFloatItemsArray().length, (int)20);
        Assert.assertEquals((int)sk.getLevelsArray(sk.sketchStructure).length, (int)2);
        try {
            sk.getMaxItem();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sk.getMinItem();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        Assert.assertEquals((int)sk.getNumLevels(), (int)1);
        Assert.assertFalse((boolean)sk.isLevelZeroSorted());
        sk2 = KllMiscDirectFloatsTest.getDirectFloatsSketch(k, 0);
        sk2.update(1.0f);
        compBytes = KllHelper.toByteArray((KllSketch)sk2, (boolean)true);
        wmem = WritableMemory.writableWrap((byte[])compBytes);
        sk = KllHeapFloatsSketch.heapifyImpl((Memory)wmem);
        Assert.assertEquals((int)sk.getK(), (int)k);
        Assert.assertEquals((long)sk.getN(), (long)1L);
        Assert.assertEquals((int)sk.getNumRetained(), (int)1);
        Assert.assertFalse((boolean)sk.isEmpty());
        Assert.assertFalse((boolean)sk.isEstimationMode());
        Assert.assertEquals((int)sk.getMinK(), (int)k);
        Assert.assertEquals((int)sk.getFloatItemsArray().length, (int)20);
        Assert.assertEquals((int)sk.getLevelsArray(sk.sketchStructure).length, (int)2);
        Assert.assertEquals((float)sk.getMaxItem(), (float)1.0f);
        Assert.assertEquals((float)sk.getMinItem(), (float)1.0f);
        Assert.assertEquals((int)sk.getNumLevels(), (int)1);
        Assert.assertFalse((boolean)sk.isLevelZeroSorted());
    }

    @Test
    public void checkMemoryToStringFloatUpdatable() {
        int k = 20;
        KllMiscDirectFloatsTest.println("#### CASE: FLOAT FULL UPDATABLE");
        KllFloatsSketch sk = KllMiscDirectFloatsTest.getDirectFloatsSketch(k, 0);
        for (int i = 1; i <= k + 1; ++i) {
            sk.update((float)i);
        }
        byte[] upBytes = KllHelper.toByteArray((KllSketch)sk, (boolean)true);
        WritableMemory wmem = WritableMemory.writableWrap((byte[])upBytes);
        String s = KllPreambleUtil.toString((Memory)wmem, (KllSketch.SketchType)KllSketch.SketchType.FLOATS_SKETCH, (boolean)true);
        KllMiscDirectFloatsTest.println("step 1: sketch to byte[]/memory & analyze memory");
        KllMiscDirectFloatsTest.println(s);
        KllFloatsSketch sk2 = KllFloatsSketch.writableWrap((WritableMemory)wmem, (MemoryRequestServer)memReqSvr);
        byte[] upBytes2 = KllHelper.toByteArray((KllSketch)sk2, (boolean)true);
        wmem = WritableMemory.writableWrap((byte[])upBytes2);
        s = KllPreambleUtil.toString((Memory)wmem, (KllSketch.SketchType)KllSketch.SketchType.FLOATS_SKETCH, (boolean)true);
        KllMiscDirectFloatsTest.println("step 2: memory to heap sketch, to byte[]/memory & analyze memory. Should match above");
        KllMiscDirectFloatsTest.println(s);
        Assert.assertEquals((byte[])upBytes, (byte[])upBytes2);
        KllMiscDirectFloatsTest.println("#### CASE: FLOAT EMPTY UPDATABLE");
        sk = KllMiscDirectFloatsTest.getDirectFloatsSketch(k, 0);
        upBytes = KllHelper.toByteArray((KllSketch)sk, (boolean)true);
        wmem = WritableMemory.writableWrap((byte[])upBytes);
        s = KllPreambleUtil.toString((Memory)wmem, (KllSketch.SketchType)KllSketch.SketchType.FLOATS_SKETCH, (boolean)true);
        KllMiscDirectFloatsTest.println("step 1: sketch to byte[]/memory & analyze memory");
        KllMiscDirectFloatsTest.println(s);
        sk2 = KllFloatsSketch.writableWrap((WritableMemory)wmem, (MemoryRequestServer)memReqSvr);
        upBytes2 = KllHelper.toByteArray((KllSketch)sk2, (boolean)true);
        wmem = WritableMemory.writableWrap((byte[])upBytes2);
        s = KllPreambleUtil.toString((Memory)wmem, (KllSketch.SketchType)KllSketch.SketchType.FLOATS_SKETCH, (boolean)true);
        KllMiscDirectFloatsTest.println("step 2: memory to heap sketch, to byte[]/memory & analyze memory. Should match above");
        KllMiscDirectFloatsTest.println(s);
        Assert.assertEquals((byte[])upBytes, (byte[])upBytes2);
        KllMiscDirectFloatsTest.println("#### CASE: FLOAT SINGLE UPDATABL");
        sk = KllMiscDirectFloatsTest.getDirectFloatsSketch(k, 0);
        sk.update(1.0f);
        upBytes = KllHelper.toByteArray((KllSketch)sk, (boolean)true);
        wmem = WritableMemory.writableWrap((byte[])upBytes);
        s = KllPreambleUtil.toString((Memory)wmem, (KllSketch.SketchType)KllSketch.SketchType.FLOATS_SKETCH, (boolean)true);
        KllMiscDirectFloatsTest.println("step 1: sketch to byte[]/memory & analyze memory");
        KllMiscDirectFloatsTest.println(s);
        sk2 = KllFloatsSketch.writableWrap((WritableMemory)wmem, (MemoryRequestServer)memReqSvr);
        upBytes2 = KllHelper.toByteArray((KllSketch)sk2, (boolean)true);
        wmem = WritableMemory.writableWrap((byte[])upBytes2);
        s = KllPreambleUtil.toString((Memory)wmem, (KllSketch.SketchType)KllSketch.SketchType.FLOATS_SKETCH, (boolean)true);
        KllMiscDirectFloatsTest.println("step 2: memory to heap sketch, to byte[]/memory & analyze memory. Should match above");
        KllMiscDirectFloatsTest.println(s);
        Assert.assertEquals((byte[])upBytes, (byte[])upBytes2);
    }

    @Test
    public void checkSimpleMerge() {
        int i;
        int k = 20;
        int n1 = 21;
        int n2 = 21;
        KllFloatsSketch sk1 = KllMiscDirectFloatsTest.getDirectFloatsSketch(k, 0);
        KllFloatsSketch sk2 = KllMiscDirectFloatsTest.getDirectFloatsSketch(k, 0);
        for (i = 1; i <= n1; ++i) {
            sk1.update((float)i);
        }
        for (i = 1; i <= n2; ++i) {
            sk2.update((float)(i + 100));
        }
        KllMiscDirectFloatsTest.println(sk1.toString(true, true));
        KllMiscDirectFloatsTest.println(sk2.toString(true, true));
        sk1.merge((KllSketch)sk2);
        KllMiscDirectFloatsTest.println(sk1.toString(true, true));
        Assert.assertEquals((float)sk1.getMaxItem(), (float)121.0f);
        Assert.assertEquals((float)sk1.getMinItem(), (float)1.0f);
    }

    @Test
    public void checkSizes() {
        KllFloatsSketch sk = KllMiscDirectFloatsTest.getDirectFloatsSketch(20, 0);
        for (int i = 1; i <= 21; ++i) {
            sk.update((float)i);
        }
        byte[] byteArr1 = KllHelper.toByteArray((KllSketch)sk, (boolean)true);
        int size1 = sk.currentSerializedSizeBytes(true);
        Assert.assertEquals((int)size1, (int)byteArr1.length);
        byte[] byteArr2 = sk.toByteArray();
        int size2 = sk.currentSerializedSizeBytes(false);
        Assert.assertEquals((int)size2, (int)byteArr2.length);
    }

    @Test
    public void checkNewInstance() {
        int k = 200;
        WritableMemory dstMem = WritableMemory.allocate((int)3000);
        KllFloatsSketch sk = KllFloatsSketch.newDirectInstance((int)k, (WritableMemory)dstMem, (MemoryRequestServer)memReqSvr);
        for (int i = 1; i <= 10000; ++i) {
            sk.update((float)i);
        }
        Assert.assertEquals((float)sk.getMinItem(), (float)1.0f);
        Assert.assertEquals((float)sk.getMaxItem(), (float)10000.0f);
    }

    @Test
    public void checkDifferentM() {
        int k = 20;
        int m = 4;
        WritableMemory dstMem = WritableMemory.allocate((int)1000);
        KllDirectFloatsSketch sk = KllDirectFloatsSketch.newDirectUpdatableInstance((int)k, (int)m, (WritableMemory)dstMem, (MemoryRequestServer)memReqSvr);
        for (int i = 1; i <= 200; ++i) {
            sk.update((float)i);
        }
        Assert.assertEquals((double)sk.getMinItem(), (double)1.0);
        Assert.assertEquals((double)sk.getMaxItem(), (double)200.0);
    }

    private static KllFloatsSketch getDirectFloatsSketch(int k, int n) {
        KllFloatsSketch sk = KllFloatsSketch.newHeapInstance((int)k);
        for (int i = 1; i <= n; ++i) {
            sk.update((float)i);
        }
        byte[] byteArr = KllHelper.toByteArray((KllSketch)sk, (boolean)true);
        WritableMemory wmem = WritableMemory.writableWrap((byte[])byteArr);
        KllFloatsSketch dfsk = KllFloatsSketch.writableWrap((WritableMemory)wmem, (MemoryRequestServer)memReqSvr);
        return dfsk;
    }

    @Test
    public void printlnTest() {
        String s = "PRINTING:  printf in " + this.getClass().getName();
        KllMiscDirectFloatsTest.println(s);
        KllMiscDirectFloatsTest.printf("%s\n", s);
    }

    private static final void printf(String format, Object ... args) {
    }

    private static final void println(Object o) {
    }
}

