/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hll;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.datasketches.common.TestUtil;
import org.apache.datasketches.hll.HllSketch;
import org.apache.datasketches.hll.TgtHllType;
import org.apache.datasketches.memory.Memory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class HllSketchCrossLanguageTest {
    @Test(groups={"generate_java_files"})
    public void generateBinariesForCompatibilityTesting() throws IOException {
        int[] nArr;
        for (int n : nArr = new int[]{0, 1, 10, 100, 1000, 10000, 100000, 1000000}) {
            int i;
            HllSketch hll4 = new HllSketch(12, TgtHllType.HLL_4);
            HllSketch hll6 = new HllSketch(12, TgtHllType.HLL_6);
            HllSketch hll8 = new HllSketch(12, TgtHllType.HLL_8);
            for (i = 0; i < n; ++i) {
                hll4.update((long)i);
            }
            for (i = 0; i < n; ++i) {
                hll6.update((long)i);
            }
            for (i = 0; i < n; ++i) {
                hll8.update((long)i);
            }
            Files.newOutputStream(TestUtil.javaPath.resolve("hll4_n" + n + "_java.sk"), new OpenOption[0]).write(hll4.toCompactByteArray());
            Files.newOutputStream(TestUtil.javaPath.resolve("hll6_n" + n + "_java.sk"), new OpenOption[0]).write(hll6.toCompactByteArray());
            Files.newOutputStream(TestUtil.javaPath.resolve("hll8_n" + n + "_java.sk"), new OpenOption[0]).write(hll8.toCompactByteArray());
        }
    }

    @Test(groups={"check_cpp_files"})
    public void hll4() throws IOException {
        int[] nArr;
        for (int n : nArr = new int[]{0, 10, 100, 1000, 10000, 100000, 1000000}) {
            byte[] bytes = Files.readAllBytes(TestUtil.cppPath.resolve("hll4_n" + n + "_cpp.sk"));
            HllSketch sketch = HllSketch.heapify((Memory)Memory.wrap((byte[])bytes));
            Assert.assertEquals((int)sketch.getLgConfigK(), (int)12);
            Assert.assertTrue((boolean)(n == 0 ? sketch.isEmpty() : !sketch.isEmpty()));
            Assert.assertEquals((double)sketch.getEstimate(), (double)n, (double)((double)n * 0.02));
        }
    }

    @Test(groups={"check_cpp_files"})
    public void hll6() throws IOException {
        int[] nArr;
        for (int n : nArr = new int[]{0, 10, 100, 1000, 10000, 100000, 1000000}) {
            byte[] bytes = Files.readAllBytes(TestUtil.cppPath.resolve("hll6_n" + n + "_cpp.sk"));
            HllSketch sketch = HllSketch.heapify((Memory)Memory.wrap((byte[])bytes));
            Assert.assertEquals((int)sketch.getLgConfigK(), (int)12);
            Assert.assertTrue((boolean)(n == 0 ? sketch.isEmpty() : !sketch.isEmpty()));
            Assert.assertEquals((double)sketch.getEstimate(), (double)n, (double)((double)n * 0.02));
        }
    }

    @Test(groups={"check_cpp_files"})
    public void hll8() throws IOException {
        int[] nArr;
        for (int n : nArr = new int[]{0, 10, 100, 1000, 10000, 100000, 1000000}) {
            byte[] bytes = Files.readAllBytes(TestUtil.cppPath.resolve("hll8_n" + n + "_cpp.sk"));
            HllSketch sketch = HllSketch.heapify((Memory)Memory.wrap((byte[])bytes));
            Assert.assertEquals((int)sketch.getLgConfigK(), (int)12);
            Assert.assertTrue((boolean)(n == 0 ? sketch.isEmpty() : !sketch.isEmpty()));
            Assert.assertEquals((double)sketch.getEstimate(), (double)n, (double)((double)n * 0.02));
        }
    }
}

