/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.pig.quantiles;

import java.util.Arrays;
import java.util.Comparator;
import org.apache.datasketches.ArrayOfItemsSerDe;
import org.apache.datasketches.ArrayOfStringsSerDe;
import org.apache.datasketches.pig.quantiles.DoublesSketchToString;
import org.apache.datasketches.pig.quantiles.StringsSketchToString;
import org.apache.datasketches.quantiles.ItemsSketch;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.TupleFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class StringsSketchToStringTest {
    private static final TupleFactory TUPLE_FACTORY = TupleFactory.getInstance();
    private static final Comparator<String> COMPARATOR = Comparator.naturalOrder();
    private static final ArrayOfItemsSerDe<String> SER_DE = new ArrayOfStringsSerDe();

    @Test
    public void nullInputTuple() throws Exception {
        StringsSketchToString func = new StringsSketchToString();
        String result = (String)func.exec(null);
        Assert.assertNull((Object)result);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void emptyInputTuple() throws Exception {
        StringsSketchToString func = new StringsSketchToString();
        String result = (String)func.exec(TUPLE_FACTORY.newTuple());
        Assert.assertNull((Object)result);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void tooManyInputs() throws Exception {
        StringsSketchToString func = new StringsSketchToString();
        func.exec(TUPLE_FACTORY.newTuple(2));
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void wrongTypeForSketch() throws Exception {
        StringsSketchToString func = new StringsSketchToString();
        func.exec(TUPLE_FACTORY.newTuple(Arrays.asList(1.0)));
    }

    @Test
    public void normalCase() throws Exception {
        DoublesSketchToString func = new DoublesSketchToString();
        ItemsSketch sketch = ItemsSketch.getInstance(COMPARATOR);
        String result = (String)func.exec(TUPLE_FACTORY.newTuple((Object)new DataByteArray(sketch.toByteArray(SER_DE))));
        Assert.assertNotNull((Object)result);
    }
}

