/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbc4;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLTimeoutException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derby.client.am.ClientStatement;
import org.apache.derby.impl.jdbc.EmbedResultSet;
import org.apache.derby.impl.sql.execute.RowUtil;
import org.apache.derbyTesting.functionTests.tests.jdbc4.StatementTestSetup;
import org.apache.derbyTesting.functionTests.tests.jdbcapi.SetQueryTimeoutTest;
import org.apache.derbyTesting.functionTests.tests.jdbcapi.Wrapper41Statement;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.TestConfiguration;

public class StatementTest
extends BaseJDBCTestCase {
    private Statement stmt = null;

    public StatementTest(String name) {
        super(name);
    }

    protected void setUp() throws SQLException {
        this.getConnection().setAutoCommit(false);
        this.stmt = this.createStatement();
        StatementTest.assertFalse((String)"First statement must be open initially", (boolean)this.stmt.isClosed());
    }

    @Override
    protected void tearDown() throws Exception {
        if (this.stmt != null) {
            this.stmt.close();
            this.stmt = null;
        }
        super.tearDown();
    }

    public void testIsClosedBasic() throws SQLException {
        ResultSet rs = this.stmt.executeQuery("select count(*) from stmtTable");
        StatementTest.assertFalse((String)"Statement should still be open", (boolean)this.stmt.isClosed());
        rs.close();
        StatementTest.assertFalse((String)"Statement should be open after ResultSet has been closed", (boolean)this.stmt.isClosed());
        this.stmt.close();
        StatementTest.assertTrue((String)"Statement should be closed, close() has been called", (boolean)this.stmt.isClosed());
    }

    public void testIsClosedWithTwoStatementsOnSameConnection() throws SQLException {
        Statement stmt2 = this.createStatement();
        StatementTest.assertFalse((String)"Second statement must be open initially", (boolean)stmt2.isClosed());
        StatementTest.assertFalse((String)"First statement should not be closed when creating a second statement", (boolean)this.stmt.isClosed());
        ResultSet rs = stmt2.executeQuery("select count(*) from stmtTable");
        StatementTest.assertFalse((String)"Second statement should be open after call to execute()", (boolean)stmt2.isClosed());
        StatementTest.assertFalse((String)"First statement should be open after call to second statment's execute()", (boolean)this.stmt.isClosed());
        stmt2.close();
        StatementTest.assertTrue((String)"Second statement should be closed, close() has been called!", (boolean)stmt2.isClosed());
        StatementTest.assertFalse((String)"First statement should be open after call to second statment's close()", (boolean)this.stmt.isClosed());
    }

    public void testIsClosedWhenClosingConnection() throws SQLException {
        Statement stmt2 = this.createStatement();
        StatementTest.assertFalse((String)"Second statement must be open initially", (boolean)stmt2.isClosed());
        stmt2.execute("select count(*) from stmtTable");
        StatementTest.assertFalse((String)"Second statement should be open after call to execute()", (boolean)stmt2.isClosed());
        this.rollback();
        Connection con = this.getConnection();
        con.close();
        StatementTest.assertTrue((String)"Connection should be closed after close()", (boolean)con.isClosed());
        StatementTest.assertTrue((String)"First statement should be closed, as parent connection has been closed", (boolean)this.stmt.isClosed());
        StatementTest.assertTrue((String)"Second statement should be closed, as parent connection has been closed", (boolean)stmt2.isClosed());
    }

    public void testIsClosedWhenClosingConnectionInInvalidState() throws SQLException {
        this.stmt.executeQuery("select count(*) from stmtTable");
        Connection con = this.stmt.getConnection();
        try {
            con.close();
            StatementTest.fail((String)"Invalid transaction state exception was not thrown");
        }
        catch (SQLException sqle) {
            String expectedState = "25001";
            StatementTest.assertSQLState(expectedState, sqle);
        }
        StatementTest.assertFalse((String)"Statement should still be open, because Connection.close() failed", (boolean)this.stmt.isClosed());
        StatementTest.assertFalse((String)"Connection should still be open", (boolean)con.isClosed());
        con.commit();
        con.close();
        StatementTest.assertTrue((String)"Connection should be closed after close()", (boolean)con.isClosed());
        StatementTest.assertTrue((String)"Statement should be closed, because the connection has been closed", (boolean)this.stmt.isClosed());
        this.stmt.close();
        StatementTest.assertTrue((String)"Statement should still be closed", (boolean)this.stmt.isClosed());
    }

    public void testStatementExecuteAfterConnectionClose() throws SQLException {
        Connection con = this.stmt.getConnection();
        con.close();
        StatementTest.assertTrue((String)"Connection should be closed after close()", (boolean)con.isClosed());
        try {
            this.stmt.executeQuery("select count(*) from stmtTable");
        }
        catch (SQLException sqle) {
            StatementTest.assertEquals((String)"Unexpected SQL state for performing operations on a closed statement.", (String)"08003", (String)sqle.getSQLState());
        }
        StatementTest.assertTrue((String)"Statement should be closed, because the connection has been closed", (boolean)this.stmt.isClosed());
    }

    public void testIsWrapperForStatement() throws SQLException {
        StatementTest.assertTrue((boolean)this.stmt.isWrapperFor(Statement.class));
    }

    public void testIsNotWrapperForPreparedStatement() throws SQLException {
        StatementTest.assertFalse((boolean)this.stmt.isWrapperFor(PreparedStatement.class));
    }

    public void testIsNotWrapperForCallableStatement() throws SQLException {
        StatementTest.assertFalse((boolean)this.stmt.isWrapperFor(CallableStatement.class));
    }

    public void testIsNotWrapperForResultSet() throws SQLException {
        StatementTest.assertFalse((boolean)this.stmt.isWrapperFor(ResultSet.class));
    }

    public void testUnwrapStatement() throws SQLException {
        Statement stmt2 = this.stmt.unwrap(Statement.class);
        StatementTest.assertSame((String)"Unwrap returned wrong object.", (Object)this.stmt, (Object)stmt2);
    }

    public void testUnwrapPreparedStatement() {
        try {
            PreparedStatement ps = this.stmt.unwrap(PreparedStatement.class);
            StatementTest.fail((String)"Unwrap didn't fail.");
        }
        catch (SQLException e) {
            StatementTest.assertSQLState("XJ128", e);
        }
    }

    public void testUnwrapCallableStatement() {
        try {
            CallableStatement cs = this.stmt.unwrap(CallableStatement.class);
            StatementTest.fail((String)"Unwrap didn't fail.");
        }
        catch (SQLException e) {
            StatementTest.assertSQLState("XJ128", e);
        }
    }

    public void testUnwrapResultSet() throws SQLException {
        try {
            ResultSet rs = this.stmt.unwrap(ResultSet.class);
            StatementTest.fail((String)"Unwrap didn't fail.");
        }
        catch (SQLException e) {
            StatementTest.assertSQLState("XJ128", e);
        }
    }

    public void testPoolable() throws SQLException {
        StatementTest.assertFalse((String)"Statement cannot be poolable by default", (boolean)this.stmt.isPoolable());
        this.stmt.setPoolable(true);
        StatementTest.assertTrue((String)"Statement must be poolable", (boolean)this.stmt.isPoolable());
        this.stmt.setPoolable(false);
        StatementTest.assertFalse((String)"Statement cannot be poolable", (boolean)this.stmt.isPoolable());
    }

    public void test_jdbc4_1_queryTimeoutException() throws Exception {
        SQLException se = null;
        PreparedStatement ps = this.prepareStatement("select columnnumber from sys.syscolumns c, sys.systables t\nwhere t.tablename = 'SYSTABLES'\nand t.tableid = c.referenceid\nand mod( delay_st( 5, c.columnnumber ), 3 ) = 0");
        StatementTest.println("Testing timeout exception for a " + ps.getClass().getName());
        SetQueryTimeoutTest.StatementExecutor executor = new SetQueryTimeoutTest.StatementExecutor(ps, true, 1);
        executor.start();
        executor.join();
        ps.close();
        se = executor.getSQLException();
        StatementTest.assertNotNull((Object)se);
        StatementTest.assertEquals((String)SQLTimeoutException.class.getName(), (String)se.getClass().getName());
    }

    public void testCompletionClosure_jdbc4_1_implicitRSClosure() throws Exception {
        Connection conn = this.getConnection();
        conn.setHoldability(2);
        conn.setAutoCommit(true);
        PreparedStatement ps = conn.prepareStatement("values ( 1 )");
        StatementTest.println("Testing implicit closure WITH autocommit on a " + ps.getClass().getName());
        Wrapper41Statement wrapper = new Wrapper41Statement(ps);
        wrapper.closeOnCompletion();
        ResultSet rs = ps.executeQuery();
        rs.next();
        rs.next();
        StatementTest.assertTrue((boolean)rs.isClosed());
        StatementTest.assertTrue((boolean)ps.isClosed());
        conn.setAutoCommit(false);
        ps = conn.prepareStatement("values ( 1 )");
        StatementTest.println("Testing implicit closure WITHOUT autocommit on a " + ps.getClass().getName());
        wrapper = new Wrapper41Statement(ps);
        wrapper.closeOnCompletion();
        rs = ps.executeQuery();
        rs.next();
        rs.next();
        StatementTest.assertFalse((boolean)rs.isClosed());
        StatementTest.assertFalse((boolean)ps.isClosed());
        conn.commit();
        StatementTest.assertTrue((boolean)rs.isClosed());
        StatementTest.assertTrue((boolean)ps.isClosed());
    }

    public void testLargeUpdate_jdbc4_2() throws Exception {
        Connection conn = this.getConnection();
        StatementTest.largeUpdate_jdbc4_2(conn);
    }

    public static void largeUpdate_jdbc4_2(Connection conn) throws Exception {
    }

    private static void largeUpdateTest(StatementWrapper sw, long rowCountBase) throws Exception {
    }

    private static void largeUpdateTest(StatementWrapper sw, long rowCountBase, long rowCount) throws Exception {
        StringBuffer buffer = new StringBuffer();
        buffer.append("insert into bigintTable( col2 ) values ");
        for (long i = 0L; i < rowCount; ++i) {
            if (i > 0L) {
                buffer.append(", ");
            }
            buffer.append("( " + i + " )");
        }
        String text = buffer.toString();
        long expectedResult = rowCountBase + rowCount;
        StatementTest.vetUpdateSize(sw, (int)expectedResult, sw.getWrappedStatement().executeUpdate(text), expectedResult);
        StatementTest.vetUpdateSize(sw, (int)expectedResult, sw.getWrappedStatement().executeUpdate(text, 1), expectedResult);
        StatementTest.vetUpdateSize(sw, (int)expectedResult, sw.getWrappedStatement().executeUpdate(text, new int[]{1}), expectedResult);
        StatementTest.vetUpdateSize(sw, (int)expectedResult, sw.getWrappedStatement().executeUpdate(text, new String[]{"COL1"}), expectedResult);
        StatementTest.vetUpdateSize(sw, expectedResult, sw.executeLargeUpdate(text), expectedResult);
        StatementTest.vetUpdateSize(sw, expectedResult, sw.executeLargeUpdate(text, 1), expectedResult);
        StatementTest.vetUpdateSize(sw, expectedResult, sw.executeLargeUpdate(text, new int[]{1}), expectedResult);
        StatementTest.vetUpdateSize(sw, expectedResult, sw.executeLargeUpdate(text, new String[]{"COL1"}), expectedResult);
    }

    private static void vetUpdateSize(StatementWrapper sw, int expected, int actual, long longAnswer) throws Exception {
        StatementTest.assertEquals((int)expected, (int)actual);
        StatementTest.assertEquals((int)expected, (int)sw.getWrappedStatement().getUpdateCount());
        StatementTest.assertEquals((long)longAnswer, (long)sw.getLargeUpdateCount());
    }

    private static void vetUpdateSize(StatementWrapper sw, long expected, long actual, long longAnswer) throws Exception {
        StatementTest.assertEquals((long)expected, (long)actual);
        StatementTest.assertEquals((int)((int)expected), (int)sw.getWrappedStatement().getUpdateCount());
        StatementTest.assertEquals((long)longAnswer, (long)sw.getLargeUpdateCount());
    }

    private static void largeBatchTest(StatementWrapper sw, long rowCountBase) throws Exception {
    }

    private static void createBatch(StatementWrapper sw) throws Exception {
        sw.getWrappedStatement().clearBatch();
        StatementTest.truncate(sw);
        sw.getWrappedStatement().addBatch("insert into bigintTable( col2 ) values ( 1 )");
        sw.getWrappedStatement().addBatch("update bigintTable set col2 = 2");
        sw.getWrappedStatement().addBatch("insert into bigintTable( col2 ) values ( 3 ), ( 4 )");
    }

    private static void largeMaxRowsTest(StatementWrapper sw, long maxRows) throws Exception {
    }

    private static void largeBatchUpdateExceptionTest(StatementWrapper sw, long rowCountBase) throws Exception {
    }

    public static void setRowCountBase(Statement stmt, boolean onClient, long rowCountBase) throws Exception {
        if (onClient) {
            ClientStatement.setFetchedRowBase((long)rowCountBase);
        } else {
            stmt.execute("call setRowCountBase( " + rowCountBase + " )");
        }
    }

    private static void truncate(StatementWrapper sw) throws Exception {
        sw.getWrappedStatement().execute("truncate table bigintTable");
    }

    private static int[] squashLongs(long[] longs) {
        int count = longs == null ? 0 : longs.length;
        int[] ints = new int[count];
        for (int i = 0; i < count; ++i) {
            ints[i] = (int)longs[i];
        }
        return ints;
    }

    public static Test suite() {
        BaseTestSuite suite = new BaseTestSuite("StatementTest suite");
        suite.addTest((Test)new StatementTestSetup((Test)new BaseTestSuite(StatementTest.class)));
        suite.addTest(TestConfiguration.clientServerDecorator((Test)new StatementTestSetup((Test)new BaseTestSuite(StatementTest.class))));
        return suite;
    }

    public static void setRowCountBase(long newBase) {
        EmbedResultSet.setFetchedRowBase((long)newBase);
        RowUtil.setRowCountBase((long)newBase);
    }

    public static class StatementWrapper {
        private Statement _wrappedStatement;

        public StatementWrapper(Statement wrappedStatement) {
            this._wrappedStatement = wrappedStatement;
        }

        public Statement getWrappedStatement() {
            return this._wrappedStatement;
        }

        public long[] executeLargeBatch() throws SQLException {
            return (long[])this.invoke("executeLargeBatch", new Class[0], new Object[0]);
        }

        public long executeLargeUpdate(String sql) throws SQLException {
            return (Long)this.invoke("executeLargeUpdate", new Class[]{String.class}, new Object[]{sql});
        }

        public long executeLargeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
            return (Long)this.invoke("executeLargeUpdate", new Class[]{String.class, Integer.TYPE}, new Object[]{sql, autoGeneratedKeys});
        }

        public long executeLargeUpdate(String sql, int[] columnIndexes) throws SQLException {
            return (Long)this.invoke("executeLargeUpdate", new Class[]{String.class, columnIndexes.getClass()}, new Object[]{sql, columnIndexes});
        }

        public long executeLargeUpdate(String sql, String[] columnNames) throws SQLException {
            return (Long)this.invoke("executeLargeUpdate", new Class[]{String.class, columnNames.getClass()}, new Object[]{sql, columnNames});
        }

        public long getLargeMaxRows() throws SQLException {
            return (Long)this.invoke("getLargeMaxRows", new Class[0], new Object[0]);
        }

        public long getLargeUpdateCount() throws SQLException {
            return (Long)this.invoke("getLargeUpdateCount", new Class[0], new Object[0]);
        }

        public void setLargeMaxRows(long max) throws SQLException {
            this.invoke("setLargeMaxRows", new Class[]{Long.TYPE}, new Object[]{max});
        }

        protected Object invoke(String methodName, Class[] argTypes, Object[] argValues) throws SQLException {
            try {
                Method method = this._wrappedStatement.getClass().getMethod(methodName, argTypes);
                return method.invoke((Object)this._wrappedStatement, argValues);
            }
            catch (NoSuchMethodException nsme) {
                throw this.wrap(nsme);
            }
            catch (SecurityException se) {
                throw this.wrap(se);
            }
            catch (IllegalAccessException iae) {
                throw this.wrap(iae);
            }
            catch (IllegalArgumentException iare) {
                throw this.wrap(iare);
            }
            catch (InvocationTargetException ite) {
                throw this.wrap(ite);
            }
        }

        private SQLException wrap(Throwable t) {
            return new SQLException(t.getMessage(), t);
        }
    }
}

