/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.system.sttest.utils;

import java.io.IOException;
import java.io.PrintStream;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.apache.derby.tools.JDBCDisplayUtil;
import org.apache.derby.tools.ij;
import org.apache.derbyTesting.system.sttest.tools.MemCheck;

public class CompressTable {
    static boolean startByIJ = false;
    static String dbURL = "jdbc:derby:testDB";
    static String driver = "org.apache.derby.jdbc.EmbeddedDriver";

    public static void main(String[] args) throws SQLException, IOException, InterruptedException, Exception, Throwable {
        Connection conn = null;
        Object d = null;
        Class<?> clazz = Class.forName(driver);
        clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        try {
            conn = CompressTable.mystartJBMS();
        }
        catch (Throwable t) {
            return;
        }
        MemCheck mc = new MemCheck(200000);
        mc.start();
        CompressTable.compress(conn);
        System.exit(0);
    }

    public static Connection mystartJBMS() throws Throwable {
        Connection conn = null;
        if (startByIJ) {
            conn = ij.startJBMS();
        } else {
            try {
                conn = DriverManager.getConnection(dbURL + ";create=false");
                conn.setAutoCommit(false);
            }
            catch (SQLException se) {
                System.out.println("connect failed  for " + dbURL);
                JDBCDisplayUtil.ShowException((PrintStream)System.out, (Throwable)se);
            }
        }
        return conn;
    }

    static synchronized void compress(Connection conn) throws Exception {
        System.out.println("compressing table");
        try {
            conn.setAutoCommit(true);
            CallableStatement cs = conn.prepareCall("CALL SYSCS_UTIL.SYSCS_INPLACE_COMPRESS_TABLE(?, ?, ?, ?, ?)");
            cs.setString(1, "APP");
            cs.setString(2, "DATATYPES");
            cs.setShort(3, (short)1);
            cs.setShort(4, (short)1);
            cs.setShort(5, (short)1);
            cs.execute();
            cs.close();
        }
        catch (SQLException se) {
            System.out.println("compress table: FAIL -- unexpected exception:");
            JDBCDisplayUtil.ShowException((PrintStream)System.out, (Throwable)se);
        }
    }
}

