/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbc4;

import java.sql.Connection;
import java.sql.SQLDataException;
import java.sql.SQLException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.sql.SQLNonTransientConnectionException;
import java.sql.SQLSyntaxErrorException;
import java.sql.SQLTransactionRollbackException;
import java.sql.Statement;
import javax.sql.DataSource;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;
import org.apache.derbyTesting.junit.JDBCDataSource;
import org.apache.derbyTesting.junit.TestConfiguration;

public class TestJDBC40Exception
extends BaseJDBCTestCase {
    public TestJDBC40Exception(String name) {
        super(name);
    }

    public static Test suite() {
        Test suite = TestConfiguration.defaultSuite(TestJDBC40Exception.class);
        return DatabasePropertyTestSetup.setLockTimeouts(suite, -1, 2);
    }

    protected void setUp() throws SQLException {
        Statement s = this.createStatement();
        s.execute("create table EXCEPTION_TABLE1 (id integer primary key, data varchar (5))");
        s.execute("insert into EXCEPTION_TABLE1 (id, data)values (1, 'data1')");
        s.close();
    }

    @Override
    protected void tearDown() throws Exception {
        Statement s = this.createStatement();
        s.execute("drop table EXCEPTION_TABLE1");
        s.close();
        this.commit();
        super.tearDown();
    }

    public void testIntegrityConstraintViolationException() throws SQLException {
        try {
            this.createStatement().execute("insert into EXCEPTION_TABLE1 (id, data) values (1, 'data1')");
            TestJDBC40Exception.fail((String)"Statement didn't fail.");
        }
        catch (SQLIntegrityConstraintViolationException e) {
            TestJDBC40Exception.assertTrue((String)("Unexpected SQL State: " + e.getSQLState()), (boolean)e.getSQLState().startsWith("23"));
        }
    }

    public void testDataException() throws SQLException {
        try {
            this.createStatement().execute("insert into EXCEPTION_TABLE1 (id, data)values (2, 'data1234556')");
            TestJDBC40Exception.fail((String)"Statement didn't fail.");
        }
        catch (SQLDataException e) {
            TestJDBC40Exception.assertTrue((String)("Unexpected SQL State: " + e.getSQLState()), (boolean)e.getSQLState().startsWith("22"));
        }
    }

    public void testConnectionException() throws SQLException {
        Statement stmt = this.createStatement();
        this.getConnection().close();
        try {
            stmt.execute("select * from exception1");
            TestJDBC40Exception.fail((String)"Statement didn't fail.");
        }
        catch (SQLNonTransientConnectionException cone) {
            TestJDBC40Exception.assertTrue((String)("Unexpected SQL State: " + cone.getSQLState()), (boolean)cone.getSQLState().startsWith("08"));
        }
        if (TestJDBC40Exception.usingEmbedded()) {
            stmt = this.createStatement();
            TestConfiguration.getCurrent().shutdownDatabase();
            try {
                stmt.execute("select * from exception1");
                TestJDBC40Exception.fail((String)"Statement didn't fail.");
            }
            catch (SQLNonTransientConnectionException cone) {
                TestJDBC40Exception.assertTrue((String)("Unexpected SQL State: " + cone.getSQLState()), (boolean)cone.getSQLState().startsWith("08"));
            }
        }
        if (TestJDBC40Exception.usingDerbyNetClient()) {
            DataSource ds = JDBCDataSource.getDataSource();
            JDBCDataSource.setBeanProperty(ds, "portNumber", 0);
            try {
                ds.getConnection();
            }
            catch (SQLNonTransientConnectionException cone) {
                TestJDBC40Exception.assertTrue((String)("Unexpected SQL State: " + cone.getSQLState()), (boolean)cone.getSQLState().startsWith("08"));
            }
        }
    }

    public void testSyntaxErrorException() throws SQLException {
        try {
            this.createStatement().execute("insert into EXCEPTION_TABLE1 (id, data) values ('2', 'data1')");
            TestJDBC40Exception.fail((String)"Statement didn't fail.");
        }
        catch (SQLSyntaxErrorException e) {
            TestJDBC40Exception.assertTrue((String)("Unexpected SQL State: " + e.getSQLState()), (boolean)e.getSQLState().startsWith("42"));
        }
    }

    public void testTimeout() throws SQLException {
        Connection con1 = this.openDefaultConnection();
        Connection con2 = this.openDefaultConnection();
        con1.setAutoCommit(false);
        con2.setAutoCommit(false);
        con1.setTransactionIsolation(8);
        con2.setTransactionIsolation(8);
        con1.createStatement().execute("select * from EXCEPTION_TABLE1 for update");
        try {
            con2.createStatement().execute("select * from EXCEPTION_TABLE1 for update");
            TestJDBC40Exception.fail((String)"Statement didn't fail.");
        }
        catch (SQLTransactionRollbackException e) {
            TestJDBC40Exception.assertTrue((String)("Unexpected SQL State: " + e.getSQLState()), (boolean)e.getSQLState().startsWith("40"));
        }
        con1.rollback();
        con1.close();
        con2.rollback();
        con2.close();
    }
}

