/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.types;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.services.io.DerbyIOException;
import org.apache.derby.iapi.services.io.LimitReader;
import org.apache.derby.iapi.types.StreamHeaderGenerator;
import org.apache.derby.shared.common.sanity.SanityManager;

public final class ReaderToUTF8Stream
extends InputStream {
    private LimitReader reader;
    private static final int FIRST_READ = Integer.MIN_VALUE;
    private static final int READ_BUFFER_RESERVATION = 6;
    private static final int MARK_UNSET_OR_EXCEEDED = -1;
    private byte[] buffer;
    private int boff;
    private int blen = -1;
    private int mark = -1;
    private int readAheadLimit;
    private boolean eof;
    private boolean multipleBuffer;
    private final StreamHeaderGenerator hdrGen;
    private int headerLength;
    private final int charsToTruncate;
    private static final char SPACE = ' ';
    private final int valueLength;
    private final String typeName;
    private int charCount;

    public ReaderToUTF8Stream(Reader appReader, int valueLength, int numCharsToTruncate, String typeName, StreamHeaderGenerator headerGenerator) {
        this.reader = new LimitReader(appReader);
        this.charsToTruncate = numCharsToTruncate;
        this.valueLength = valueLength;
        this.typeName = typeName;
        this.hdrGen = headerGenerator;
        int absValueLength = Math.abs(valueLength);
        this.reader.setLimit(absValueLength);
        SanityManager.ASSERT(typeName != null && (typeName.equals("CHAR") || typeName.equals("VARCHAR") || typeName.equals("CLOB")) || typeName.equals("LONG VARCHAR"));
        int bz = 32768;
        if (absValueLength < bz / 3) {
            bz = this.hdrGen.getMaxHeaderLength() + Math.max(6, absValueLength * 3 + 3);
        }
        this.buffer = new byte[bz];
    }

    public ReaderToUTF8Stream(Reader appReader, int maximumLength, String typeName, StreamHeaderGenerator headerGenerator) {
        this(appReader, -1 * maximumLength, 0, typeName, headerGenerator);
        if (maximumLength < 0) {
            throw new IllegalArgumentException("Maximum length for a capped stream cannot be negative: " + maximumLength);
        }
    }

    @Override
    public int read() throws IOException {
        if (this.buffer == null) {
            throw new EOFException(MessageService.getTextMessage("XJ085.S", new Object[0]));
        }
        if (this.blen < 0) {
            this.fillBuffer(Integer.MIN_VALUE);
        }
        while (this.boff == this.blen) {
            if (this.eof) {
                this.close();
                return -1;
            }
            this.fillBuffer(0);
        }
        return this.buffer[this.boff++] & 0xFF;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.buffer == null) {
            throw new EOFException(MessageService.getTextMessage("XJ085.S", new Object[0]));
        }
        if (this.blen < 0) {
            this.fillBuffer(Integer.MIN_VALUE);
        }
        int readCount = 0;
        while (len > 0) {
            int copyBytes = this.blen - this.boff;
            if (copyBytes == 0) {
                if (this.eof) {
                    if (readCount > 0) {
                        return readCount;
                    }
                    this.close();
                    return -1;
                }
                this.fillBuffer(0);
                continue;
            }
            if (len < copyBytes) {
                copyBytes = len;
            }
            System.arraycopy(this.buffer, this.boff, b, off, copyBytes);
            this.boff += copyBytes;
            len -= copyBytes;
            readCount += copyBytes;
            off += copyBytes;
        }
        return readCount;
    }

    private void fillBuffer(int startingOffset) throws IOException {
        if (startingOffset == Integer.MIN_VALUE) {
            this.headerLength = this.hdrGen.expectsCharCount() && this.valueLength >= 0 ? this.hdrGen.generateInto(this.buffer, 0, this.valueLength) : this.hdrGen.generateInto(this.buffer, 0, -1L);
            startingOffset = this.headerLength;
        }
        int off = startingOffset;
        this.boff = 0;
        if (off == 0) {
            this.multipleBuffer = true;
        }
        if (this.mark >= 0) {
            int spaceRequired = this.readAheadLimit + 6;
            if (this.mark + spaceRequired > this.buffer.length) {
                if (this.blen != -1) {
                    this.boff = off = this.blen - this.mark;
                }
                byte[] oldBuf = this.buffer;
                if (spaceRequired > this.buffer.length) {
                    this.buffer = new byte[spaceRequired];
                }
                System.arraycopy(oldBuf, this.mark, this.buffer, 0, off);
                this.mark = 0;
            } else if (this.blen != -1) {
                this.mark = -1;
            }
        }
        while (off <= this.buffer.length - 6) {
            int c = this.reader.read();
            if (c < 0) {
                this.eof = true;
                break;
            }
            ++this.charCount;
            if (c >= 1 && c <= 127) {
                this.buffer[off++] = (byte)c;
                continue;
            }
            if (c > 2047) {
                this.buffer[off++] = (byte)(0xE0 | c >> 12 & 0xF);
                this.buffer[off++] = (byte)(0x80 | c >> 6 & 0x3F);
                this.buffer[off++] = (byte)(0x80 | c >> 0 & 0x3F);
                continue;
            }
            this.buffer[off++] = (byte)(0xC0 | c >> 6 & 0x1F);
            this.buffer[off++] = (byte)(0x80 | c >> 0 & 0x3F);
        }
        this.blen = off;
        if (this.eof) {
            this.checkSufficientData();
        }
    }

    private void checkSufficientData() throws IOException {
        int remainingBytes;
        if (this.charsToTruncate > 0) {
            this.reader.setLimit(this.charsToTruncate);
            this.truncate();
        }
        if ((remainingBytes = this.reader.clearLimit()) > 0 && this.valueLength > 0) {
            throw new DerbyIOException(MessageService.getTextMessage("XJ023.S", new Object[0]), "XJ023.S");
        }
        if (remainingBytes == 0 && this.reader.read() >= 0) {
            if (this.valueLength > -1) {
                throw new DerbyIOException(MessageService.getTextMessage("XJ023.S", new Object[0]), "XJ023.S");
            }
            if (this.canTruncate()) {
                this.truncate();
            } else {
                throw new DerbyIOException(MessageService.getTextMessage("22001", this.typeName, "<stream-value>", String.valueOf(Math.abs(this.valueLength))), "22001");
            }
        }
        if (!this.multipleBuffer) {
            int newValueLen = -1;
            if (this.hdrGen.expectsCharCount()) {
                if (this.charCount == 0) {
                    SanityManager.ASSERT(this.eof);
                }
                newValueLen = this.charCount;
            } else {
                newValueLen = this.blen - this.headerLength;
            }
            int newHeaderLength = this.hdrGen.generateInto(this.buffer, 0, newValueLen);
            if (newHeaderLength != this.headerLength) {
                throw new IOException("Data corruption detected; user data overwritten by header bytes");
            }
            this.blen += this.hdrGen.writeEOF(this.buffer, this.blen, newValueLen);
        } else {
            this.blen += this.hdrGen.writeEOF(this.buffer, this.blen, Math.max(this.valueLength, -1));
        }
    }

    private boolean canTruncate() {
        if (this.typeName.equals("CLOB")) {
            return true;
        }
        if (this.typeName.equals("VARCHAR")) {
            return true;
        }
        return this.typeName.equals("CHAR");
    }

    private void truncate() throws IOException {
        int c = 0;
        while ((c = this.reader.read()) >= 0) {
            if (c == 32) continue;
            throw new DerbyIOException(MessageService.getTextMessage("22001", this.typeName, "<stream-value>", String.valueOf(Math.abs(this.valueLength))), "22001");
        }
    }

    @Override
    public void close() {
        this.buffer = null;
    }

    @Override
    public final int available() {
        int remainingBytes = this.reader.getLimit();
        return this.buffer.length > remainingBytes ? remainingBytes : this.buffer.length;
    }

    @Override
    public void mark(int readAheadLimit) {
        if (readAheadLimit > 0) {
            this.readAheadLimit = readAheadLimit;
            this.mark = this.boff;
        } else {
            this.mark = -1;
            this.readAheadLimit = -1;
        }
    }

    @Override
    public void reset() throws IOException {
        if (this.buffer == null) {
            throw new EOFException(MessageService.getTextMessage("XJ085.S", new Object[0]));
        }
        if (this.mark == -1) {
            throw new IOException(MessageService.getTextMessage("I027", new Object[0]));
        }
        this.boff = this.mark;
        this.mark = -1;
        this.readAheadLimit = -1;
    }

    @Override
    public boolean markSupported() {
        return true;
    }
}

