/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.types;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.GregorianCalendar;
import org.apache.derby.iapi.db.DatabaseContext;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.cache.ClassSize;
import org.apache.derby.iapi.services.i18n.LocaleFinder;
import org.apache.derby.iapi.types.DataType;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.DataValueFactoryImpl;
import org.apache.derby.iapi.types.DateTimeDataValue;
import org.apache.derby.iapi.types.DateTimeParser;
import org.apache.derby.iapi.types.NumberDataValue;
import org.apache.derby.iapi.types.SQLDate;
import org.apache.derby.iapi.types.SQLInteger;
import org.apache.derby.iapi.types.SQLTimestamp;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.shared.common.sanity.SanityManager;

public final class SQLTime
extends DataType
implements DateTimeDataValue {
    private int encodedTime;
    private int encodedTimeFraction;
    private static final int BASE_MEMORY_USAGE = ClassSize.estimateBaseFromCatalog(SQLTime.class);
    private static final char IBM_EUR_SEPARATOR = '.';
    private static final char[] IBM_EUR_SEPARATOR_OR_END = new char[]{'.', '\u0000'};
    static final char JIS_SEPARATOR = ':';
    private static final char[] US_OR_JIS_MINUTE_END = new char[]{':', ' ', '\u0000'};
    private static final char[] ANY_SEPARATOR = new char[]{'.', ':', ' '};
    private static final String[] AM_PM = new String[]{"AM", "PM"};
    private static final char[] END_OF_STRING = new char[]{'\u0000'};

    @Override
    public int estimateMemoryUsage() {
        return BASE_MEMORY_USAGE;
    }

    @Override
    public String getString() {
        if (!this.isNull()) {
            return SQLTime.encodedTimeToString(this.encodedTime);
        }
        return null;
    }

    int getEncodedTime() {
        return this.encodedTime;
    }

    @Override
    public Timestamp getTimestamp(Calendar cal) {
        if (this.isNull()) {
            return null;
        }
        if (cal == null) {
            cal = new GregorianCalendar();
        } else {
            cal.clear();
            cal.setTimeInMillis(System.currentTimeMillis());
        }
        SQLTime.setTimeInCalendar(cal, this.encodedTime);
        cal.set(14, 0);
        return new Timestamp(cal.getTimeInMillis());
    }

    @Override
    public Object getObject() {
        return this.getTime(null);
    }

    @Override
    public int getLength() {
        return 8;
    }

    @Override
    public String getTypeName() {
        return "TIME";
    }

    @Override
    public int getTypeFormatId() {
        return 299;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        SanityManager.ASSERT(!this.isNull(), "writeExternal() is not supposed to be called for null values.");
        out.writeInt(this.encodedTime);
        out.writeInt(this.encodedTimeFraction);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        this.encodedTime = in.readInt();
        this.encodedTimeFraction = in.readInt();
    }

    @Override
    public DataValueDescriptor cloneValue(boolean forceMaterialization) {
        return new SQLTime(this.encodedTime, this.encodedTimeFraction);
    }

    @Override
    public DataValueDescriptor getNewNull() {
        return new SQLTime();
    }

    @Override
    public void restoreToNull() {
        this.encodedTime = -1;
        this.encodedTimeFraction = 0;
    }

    @Override
    public void setValueFromResultSet(ResultSet resultSet, int colNumber, boolean isNullable) throws SQLException, StandardException {
        this.restoreToNull();
        this.encodedTime = this.computeEncodedTime(resultSet.getTime(colNumber));
    }

    @Override
    public int compare(DataValueDescriptor other) throws StandardException {
        if (this.typePrecedence() < other.typePrecedence()) {
            return -other.compare(this);
        }
        boolean thisNull = this.isNull();
        boolean otherNull = other.isNull();
        if (thisNull || otherNull) {
            if (!thisNull) {
                return -1;
            }
            if (!otherNull) {
                return 1;
            }
            return 0;
        }
        int otherEncodedTime = 0;
        otherEncodedTime = other instanceof SQLTime ? ((SQLTime)other).encodedTime : this.computeEncodedTime(other.getTime(null));
        int comparison = this.encodedTime < otherEncodedTime ? -1 : (this.encodedTime > otherEncodedTime ? 1 : 0);
        return comparison;
    }

    @Override
    public boolean compare(int op, DataValueDescriptor other, boolean orderedNulls, boolean unknownRV) throws StandardException {
        if (!orderedNulls && (this.isNull() || other.isNull())) {
            return unknownRV;
        }
        return super.compare(op, other, orderedNulls, unknownRV);
    }

    public SQLTime() {
        this.encodedTime = -1;
    }

    public SQLTime(Time value) throws StandardException {
        this.parseTime(value);
    }

    private void parseTime(java.util.Date value) throws StandardException {
        this.encodedTime = this.computeEncodedTime(value);
    }

    private SQLTime(int encodedTime, int encodedTimeFraction) {
        this.encodedTime = encodedTime;
        this.encodedTimeFraction = encodedTimeFraction;
    }

    public SQLTime(String timeStr, boolean isJdbcEscape, LocaleFinder localeFinder) throws StandardException {
        this.parseTime(timeStr, isJdbcEscape, localeFinder, null);
    }

    public SQLTime(String timeStr, boolean isJdbcEscape, LocaleFinder localeFinder, Calendar cal) throws StandardException {
        this.parseTime(timeStr, isJdbcEscape, localeFinder, cal);
    }

    private void parseTime(String timeStr, boolean isJdbcEscape, LocaleFinder localeFinder, Calendar cal) throws StandardException {
        boolean validSyntax = true;
        DateTimeParser parser = new DateTimeParser(timeStr);
        StandardException thrownSE = null;
        int hour = 0;
        int minute = 0;
        int second = 0;
        int amPm = -1;
        try {
            if (parser.nextSeparator() == '-') {
                this.encodedTime = SQLTimestamp.parseDateOrTimestamp(parser, true)[1];
                return;
            }
            hour = parser.parseInt(2, true, ANY_SEPARATOR, false);
            block3 : switch (parser.getCurrentSeparator()) {
                case '.': {
                    if (isJdbcEscape) {
                        validSyntax = false;
                        break;
                    }
                    minute = parser.parseInt(2, false, IBM_EUR_SEPARATOR_OR_END, false);
                    if (parser.getCurrentSeparator() == '.') {
                        second = parser.parseInt(2, false, END_OF_STRING, false);
                    }
                    break;
                }
                case ':': {
                    minute = parser.parseInt(2, false, US_OR_JIS_MINUTE_END, false);
                    switch (parser.getCurrentSeparator()) {
                        case ' ': {
                            if (isJdbcEscape) {
                                validSyntax = false;
                                break block3;
                            }
                            amPm = parser.parseChoice(AM_PM);
                            parser.checkEnd();
                            break block3;
                        }
                        case ':': {
                            second = parser.parseInt(2, false, END_OF_STRING, false);
                        }
                    }
                    break;
                }
                case ' ': {
                    if (isJdbcEscape) {
                        validSyntax = false;
                        break;
                    }
                    amPm = parser.parseChoice(AM_PM);
                    break;
                }
                default: {
                    validSyntax = false;
                    break;
                }
            }
        }
        catch (StandardException se) {
            validSyntax = false;
            thrownSE = se;
        }
        if (validSyntax) {
            if (amPm == 0) {
                if (hour == 12) {
                    hour = minute == 0 && second == 0 ? 24 : 0;
                } else if (hour > 12) {
                    throw StandardException.newException("22007.S.180", new Object[0]);
                }
            } else if (amPm == 1) {
                if (hour < 12) {
                    hour += 12;
                } else if (hour > 12) {
                    throw StandardException.newException("22007.S.180", new Object[0]);
                }
            }
            parser.checkEnd();
            this.encodedTime = SQLTime.computeEncodedTime(hour, minute, second);
        } else {
            timeStr = StringUtil.trimTrailing(timeStr);
            DateFormat timeFormat = null;
            timeFormat = localeFinder == null ? DateFormat.getTimeInstance() : (cal == null ? localeFinder.getTimeFormat() : (DateFormat)localeFinder.getTimeFormat().clone());
            if (cal != null) {
                timeFormat.setCalendar(cal);
            }
            try {
                this.encodedTime = SQLTime.computeEncodedTime(timeFormat.parse(timeStr), cal);
            }
            catch (ParseException pe) {
                try {
                    this.encodedTime = SQLTimestamp.parseLocalTimestamp(timeStr, localeFinder, cal)[1];
                }
                catch (ParseException pe2) {
                    if (thrownSE != null) {
                        throw thrownSE;
                    }
                    throw StandardException.newException("22007.S.181", new Object[0]);
                }
            }
        }
    }

    @Override
    void setObject(Object theValue) throws StandardException {
        this.setValue((Time)theValue);
    }

    @Override
    protected void setFrom(DataValueDescriptor theValue) throws StandardException {
        if (theValue instanceof SQLTime) {
            this.restoreToNull();
            SQLTime tvst = (SQLTime)theValue;
            this.encodedTime = tvst.encodedTime;
            this.encodedTimeFraction = tvst.encodedTimeFraction;
        } else {
            GregorianCalendar cal = new GregorianCalendar();
            this.setValue(theValue.getTime(cal), (Calendar)cal);
        }
    }

    @Override
    public void setValue(Time value, Calendar cal) throws StandardException {
        this.restoreToNull();
        this.encodedTime = SQLTime.computeEncodedTime(value, cal);
    }

    @Override
    public void setValue(Timestamp value, Calendar cal) throws StandardException {
        this.restoreToNull();
        this.encodedTime = SQLTime.computeEncodedTime(value, cal);
    }

    @Override
    public void setValue(String theValue) throws StandardException {
        this.restoreToNull();
        if (theValue != null) {
            DatabaseContext databaseContext = (DatabaseContext)DataValueFactoryImpl.getContext("Database");
            this.parseTime(theValue, false, databaseContext == null ? null : databaseContext.getDatabase(), null);
        }
    }

    NumberDataValue nullValueInt() {
        return new SQLInteger();
    }

    @Override
    public NumberDataValue getYear(NumberDataValue result) throws StandardException {
        throw StandardException.newException("42X25", "getYear", "Time");
    }

    @Override
    public NumberDataValue getMonth(NumberDataValue result) throws StandardException {
        throw StandardException.newException("42X25", "getMonth", "Time");
    }

    @Override
    public NumberDataValue getDate(NumberDataValue result) throws StandardException {
        throw StandardException.newException("42X25", "getDate", "Time");
    }

    @Override
    public NumberDataValue getHours(NumberDataValue result) throws StandardException {
        if (this.isNull()) {
            return this.nullValueInt();
        }
        return SQLDate.setSource(SQLTime.getHour(this.encodedTime), result);
    }

    @Override
    public NumberDataValue getMinutes(NumberDataValue result) throws StandardException {
        if (this.isNull()) {
            return this.nullValueInt();
        }
        return SQLDate.setSource(SQLTime.getMinute(this.encodedTime), result);
    }

    @Override
    public NumberDataValue getSeconds(NumberDataValue result) throws StandardException {
        if (this.isNull()) {
            return this.nullValueInt();
        }
        return SQLDate.setSource(SQLTime.getSecond(this.encodedTime), result);
    }

    public String toString() {
        if (this.isNull()) {
            return "NULL";
        }
        return this.getTime(null).toString();
    }

    public int hashCode() {
        if (this.isNull()) {
            return 0;
        }
        return this.encodedTime + this.encodedTimeFraction + 1;
    }

    @Override
    public int typePrecedence() {
        return 120;
    }

    @Override
    public final boolean isNull() {
        return this.encodedTime == -1;
    }

    @Override
    public Time getTime(Calendar cal) {
        if (this.isNull()) {
            return null;
        }
        return SQLTime.getTime(cal, this.encodedTime, 0);
    }

    static void setTimeInCalendar(Calendar cal, int encodedTime) {
        cal.set(11, SQLTime.getHour(encodedTime));
        cal.set(12, SQLTime.getMinute(encodedTime));
        cal.set(13, SQLTime.getSecond(encodedTime));
    }

    static Time getTime(Calendar cal, int encodedTime, int nanos) {
        if (cal == null) {
            cal = new GregorianCalendar();
        }
        cal.clear();
        cal.set(1970, 0, 1);
        SQLTime.setTimeInCalendar(cal, encodedTime);
        cal.set(14, nanos / 1000000);
        return new Time(cal.getTimeInMillis());
    }

    protected static int getHour(int encodedTime) {
        return encodedTime >>> 16 & 0xFF;
    }

    protected static int getMinute(int encodedTime) {
        return encodedTime >>> 8 & 0xFF;
    }

    protected static int getSecond(int encodedTime) {
        return encodedTime & 0xFF;
    }

    static int computeEncodedTime(Calendar cal) throws StandardException {
        return SQLTime.computeEncodedTime(cal.get(11), cal.get(12), cal.get(13));
    }

    static int computeEncodedTime(int hour, int minute, int second) throws StandardException {
        if (hour == 24 ? minute != 0 || second != 0 : hour < 0 || hour > 23 || minute < 0 || minute > 59 || second < 0 || second > 59) {
            throw StandardException.newException("22007.S.180", new Object[0]);
        }
        return (hour << 16) + (minute << 8) + second;
    }

    static void timeToString(int hour, int minute, int second, StringBuffer sb) {
        String hourStr = Integer.toString(hour);
        String minStr = Integer.toString(minute);
        String secondStr = Integer.toString(second);
        if (hourStr.length() == 1) {
            sb.append("0");
        }
        sb.append(hourStr);
        sb.append(':');
        if (minStr.length() == 1) {
            sb.append("0");
        }
        sb.append(minStr);
        sb.append(':');
        if (secondStr.length() == 1) {
            sb.append("0");
        }
        sb.append(secondStr);
    }

    protected static String encodedTimeToString(int encodedTime) {
        StringBuffer vstr = new StringBuffer();
        SQLTime.timeToString(SQLTime.getHour(encodedTime), SQLTime.getMinute(encodedTime), SQLTime.getSecond(encodedTime), vstr);
        return vstr.toString();
    }

    private int computeEncodedTime(java.util.Date value) throws StandardException {
        return SQLTime.computeEncodedTime(value, null);
    }

    static int computeEncodedTime(java.util.Date value, Calendar currentCal) throws StandardException {
        if (value == null) {
            return -1;
        }
        if (currentCal == null) {
            currentCal = new GregorianCalendar();
        }
        currentCal.setTime(value);
        return SQLTime.computeEncodedTime(currentCal);
    }

    @Override
    public void setInto(PreparedStatement ps, int position) throws SQLException, StandardException {
        ps.setTime(position, this.getTime(null));
    }

    @Override
    public DateTimeDataValue timestampAdd(int intervalType, NumberDataValue intervalCount, Date currentDate, DateTimeDataValue resultHolder) throws StandardException {
        return this.toTimestamp(currentDate).timestampAdd(intervalType, intervalCount, currentDate, resultHolder);
    }

    private SQLTimestamp toTimestamp(Date currentDate) throws StandardException {
        return new SQLTimestamp(SQLDate.computeEncodedDate(currentDate, null), this.getEncodedTime(), 0);
    }

    @Override
    public NumberDataValue timestampDiff(int intervalType, DateTimeDataValue time1, Date currentDate, NumberDataValue resultHolder) throws StandardException {
        return this.toTimestamp(currentDate).timestampDiff(intervalType, time1, currentDate, resultHolder);
    }
}

