/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.ResultDescription;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.execute.ExecIndexRow;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.ExecutionFactory;
import org.apache.derby.iapi.sql.execute.ResultSetStatisticsFactory;
import org.apache.derby.iapi.sql.execute.RowChanger;
import org.apache.derby.iapi.sql.execute.RunTimeStatistics;
import org.apache.derby.iapi.sql.execute.TargetResultSet;
import org.apache.derby.iapi.sql.execute.xplain.XPLAINVisitor;
import org.apache.derby.iapi.store.access.Qualifier;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.LocatedRow;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.sql.execute.BasicNoPutResultSetImpl;
import org.apache.derby.impl.sql.execute.GenericQualifier;
import org.apache.derby.shared.common.sanity.SanityManager;

abstract class NoPutResultSetImpl
extends BasicNoPutResultSetImpl {
    public final int resultSetNumber;
    private boolean needsRowLocation;
    private boolean needsRowLocationForDeferredCheckConstraints;
    protected ExecRow clonedExecRow;
    protected TargetResultSet targetResultSet;
    protected int[] checkNullCols;
    protected int cncLen;

    NoPutResultSetImpl(Activation activation, int resultSetNumber, double optimizerEstimatedRowCount, double optimizerEstimatedCost) {
        super(null, activation, optimizerEstimatedRowCount, optimizerEstimatedCost);
        SanityManager.ASSERT(activation != null, "activation expected to be non-null");
        SanityManager.ASSERT(resultSetNumber >= 0, "resultSetNumber expected to be >= 0");
        this.resultSetNumber = resultSetNumber;
    }

    @Override
    public ResultDescription getResultDescription() {
        return this.activation.getResultDescription();
    }

    @Override
    public String getCursorName() {
        String cursorName = this.activation.getCursorName();
        if (cursorName == null && this.isForUpdate()) {
            this.activation.setCursorName(this.activation.getLanguageConnectionContext().getUniqueCursorName());
            cursorName = this.activation.getCursorName();
        }
        return cursorName;
    }

    @Override
    public int resultSetNumber() {
        return this.resultSetNumber;
    }

    @Override
    public void close() throws StandardException {
        if (!this.isOpen) {
            return;
        }
        if (this.isTopResultSet) {
            LanguageConnectionContext lcc = this.getLanguageConnectionContext();
            if (lcc.getRunTimeStatisticsMode() && !lcc.getStatementContext().getStatementWasInvalidated()) {
                this.endExecutionTime = this.getCurrentTimeMillis();
                ExecutionFactory ef = lcc.getLanguageConnectionFactory().getExecutionFactory();
                ResultSetStatisticsFactory rssf = ef.getResultSetStatisticsFactory();
                RunTimeStatistics rsImpl = rssf.getRunTimeStatistics(this.activation, this, this.subqueryTrackingArray);
                lcc.setRunTimeStatisticsObject(rsImpl);
                XPLAINVisitor visitor = ef.getXPLAINFactory().getXPLAINVisitor();
                visitor.doXPLAIN(rsImpl, this.activation);
            }
            int staLength = this.subqueryTrackingArray == null ? 0 : this.subqueryTrackingArray.length;
            for (int index = 0; index < staLength; ++index) {
                if (this.subqueryTrackingArray[index] == null || this.subqueryTrackingArray[index].isClosed()) continue;
                this.subqueryTrackingArray[index].close();
            }
        }
        this.isOpen = false;
    }

    @Override
    public void setTargetResultSet(TargetResultSet trs) {
        this.targetResultSet = trs;
    }

    @Override
    public void setNeedsRowLocation(boolean needsRowLocation) {
        this.needsRowLocation = needsRowLocation;
    }

    @Override
    public void setHasDeferrableChecks() {
        this.needsRowLocationForDeferredCheckConstraints = true;
    }

    @Override
    public FormatableBitSet getValidColumns() {
        return null;
    }

    @Override
    public DataValueDescriptor[] getNextRowFromRowSource() throws StandardException {
        ExecRow execRow = this.getNextRowCore();
        if (execRow != null) {
            this.clonedExecRow = this.targetResultSet.preprocessSourceRow(execRow);
            return execRow.getRowArray();
        }
        return null;
    }

    @Override
    public boolean needsToClone() {
        return true;
    }

    @Override
    public void closeRowSource() {
    }

    @Override
    public boolean needsRowLocation() {
        return this.needsRowLocation;
    }

    @Override
    public boolean needsRowLocationForDeferredCheckConstraints() {
        return this.needsRowLocationForDeferredCheckConstraints;
    }

    @Override
    public void rowLocation(RowLocation rl) throws StandardException {
        this.targetResultSet.changedRow(this.clonedExecRow, rl);
    }

    @Override
    public void offendingRowLocation(RowLocation rl, long containdId) throws StandardException {
        this.targetResultSet.offendingRowLocation(rl, containdId);
    }

    protected void clearOrderableCache(Qualifier[][] qualifiers) throws StandardException {
        if (qualifiers != null) {
            for (int term = 0; term < qualifiers.length; ++term) {
                for (int index = 0; index < qualifiers[term].length; ++index) {
                    Qualifier qual = qualifiers[term][index];
                    qual.clearOrderableCache();
                    if (((GenericQualifier)qual).variantType == 0) continue;
                    qual.getOrderable();
                }
            }
        }
    }

    @Override
    public final void setCurrentRow(ExecRow row) {
        this.activation.setCurrentRow(row, this.resultSetNumber);
        this.currentRow = row;
    }

    @Override
    public void clearCurrentRow() {
        this.currentRow = null;
        this.activation.clearCurrentRow(this.resultSetNumber);
    }

    @Override
    public boolean isForUpdate() {
        return false;
    }

    protected boolean skipScan(ExecIndexRow startPosition, ExecIndexRow stopPosition) throws StandardException {
        int position;
        int nStartCols = startPosition == null ? 0 : startPosition.nColumns();
        int nStopCols = stopPosition == null ? 0 : stopPosition.nColumns();
        boolean startKeyLonger = false;
        int size = nStopCols;
        if (nStartCols > nStopCols) {
            startKeyLonger = true;
            size = nStartCols;
        }
        if (size == 0) {
            return false;
        }
        if (this.checkNullCols == null || this.checkNullCols.length < size) {
            this.checkNullCols = new int[size];
        }
        this.cncLen = 0;
        boolean returnValue = false;
        for (position = 0; position < nStartCols; ++position) {
            if (startPosition.areNullsOrdered(position)) continue;
            if (startKeyLonger) {
                this.checkNullCols[this.cncLen++] = position + 1;
            }
            if (!startPosition.getColumn(position + 1).isNull()) continue;
            returnValue = true;
            if (!startKeyLonger) break;
        }
        if (startKeyLonger && returnValue) {
            return true;
        }
        for (position = 0; position < nStopCols; ++position) {
            if (stopPosition.areNullsOrdered(position)) continue;
            if (!startKeyLonger) {
                this.checkNullCols[this.cncLen++] = position + 1;
            }
            if (returnValue || !stopPosition.getColumn(position + 1).isNull()) continue;
            returnValue = true;
            if (startKeyLonger) break;
        }
        return returnValue;
    }

    protected boolean skipRow(ExecRow row) throws StandardException {
        for (int i = 0; i < this.cncLen; ++i) {
            if (!row.getColumn(this.checkNullCols[i]).isNull()) continue;
            return true;
        }
        return false;
    }

    public static String printQualifiers(Qualifier[][] qualifiers) {
        String idt = "";
        String output = "";
        if (qualifiers == null) {
            return idt + MessageService.getTextMessage("42Z37.U", new Object[0]);
        }
        for (int term = 0; term < qualifiers.length; ++term) {
            for (int i = 0; i < qualifiers[term].length; ++i) {
                Qualifier qual = qualifiers[term][i];
                output = idt + output + MessageService.getTextMessage("42Z48.U", String.valueOf(term), String.valueOf(i)) + ": " + qual.getColumnId() + "\n";
                int operator = qual.getOperator();
                String opString = null;
                switch (operator) {
                    case 2: {
                        opString = "=";
                        break;
                    }
                    case 3: {
                        opString = "<=";
                        break;
                    }
                    case 1: {
                        opString = "<";
                        break;
                    }
                    default: {
                        SanityManager.THROWASSERT("Unknown operator " + operator);
                        opString = "unknown value (" + operator + ")";
                    }
                }
                output = output + idt + MessageService.getTextMessage("42Z43.U", new Object[0]) + ": " + opString + "\n" + idt + MessageService.getTextMessage("42Z44.U", new Object[0]) + ": " + qual.getOrderedNulls() + "\n" + idt + MessageService.getTextMessage("42Z45.U", new Object[0]) + ": " + qual.getUnknownRV() + "\n" + idt + MessageService.getTextMessage("42Z46.U", new Object[0]) + ": " + qual.negateCompareResult() + "\n";
            }
        }
        return output;
    }

    @Override
    public void updateRow(ExecRow row, RowChanger rowChanger) throws StandardException {
    }

    @Override
    public void markRowAsDeleted() throws StandardException {
    }

    @Override
    public void positionScanAtRowLocation(RowLocation rl) throws StandardException {
    }

    protected DataValueDescriptor[] unpackHashValue(Object hashValue) {
        if (hashValue == null) {
            return null;
        }
        if (hashValue instanceof DataValueDescriptor[]) {
            return (DataValueDescriptor[])hashValue;
        }
        return ((LocatedRow)hashValue).flatten();
    }
}

