/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.memorydb;

import java.io.File;
import java.io.IOException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.tests.memorydb.MemoryDbManager;
import org.apache.derbyTesting.functionTests.util.PrivilegedFileOpsForTests;
import org.apache.derbyTesting.functionTests.util.streams.CharAlphabet;
import org.apache.derbyTesting.functionTests.util.streams.LoopingAlphabetReader;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.SupportFilesSetup;

public class BasicInMemoryDbTest
extends BaseJDBCTestCase {
    private static final MemoryDbManager dbm = MemoryDbManager.getSharedInstance();

    public BasicInMemoryDbTest(String string) {
        super(string);
    }

    @Override
    public void tearDown() throws Exception {
        dbm.cleanUp();
        super.tearDown();
    }

    private void loadDriver() throws SQLException {
        this.getConnection();
    }

    public void testFunctionalityPresent() {
        try {
            dbm.getConnection("nonExistingDb");
        }
        catch (SQLException sQLException) {
            BasicInMemoryDbTest.assertSQLState("XJ004", sQLException);
        }
    }

    public void testCreateBackupBootRestore() throws IOException, SQLException {
        Connection connection = dbm.createDatabase("newMemDb");
        BasicInMemoryDbTest.assertNull((Object)connection.getWarnings());
        Statement statement = dbm.createStatement(connection);
        statement.executeUpdate("create table toverify(id int, val1 varchar(10), val2 clob, primary key(id))");
        PreparedStatement preparedStatement = dbm.prepareStatement(connection, "insert into toverify values (?,?,?)");
        String[][] stringArray = new String[][]{{"1", "one", BasicInMemoryDbTest.getString(1000, CharAlphabet.modernLatinLowercase())}, {"2", "two", BasicInMemoryDbTest.getString(10000, CharAlphabet.tamil())}, {"3", "three", BasicInMemoryDbTest.getString(50000, CharAlphabet.cjkSubset())}};
        for (int i = 0; i < stringArray.length; ++i) {
            preparedStatement.setString(1, stringArray[i][0]);
            preparedStatement.setString(2, stringArray[i][1]);
            preparedStatement.setString(3, stringArray[i][2]);
            preparedStatement.executeUpdate();
        }
        ResultSet resultSet = statement.executeQuery("select * from toverify");
        JDBC.assertFullResultSet(resultSet, stringArray);
        preparedStatement.close();
        statement.close();
        String string = SupportFilesSetup.getReadWrite("backedUpDb").getPath();
        CallableStatement callableStatement = connection.prepareCall("CALL SYSCS_UTIL.SYSCS_BACKUP_DATABASE(?)");
        callableStatement.setString(1, string);
        callableStatement.execute();
        connection.close();
        String string2 = PrivilegedFileOpsForTests.getAbsolutePath(new File(string, "newMemDb"));
        Connection connection2 = DriverManager.getConnection("jdbc:derby:" + string2);
        statement = connection2.createStatement();
        resultSet = statement.executeQuery("select * from toverify");
        JDBC.assertFullResultSet(resultSet, stringArray);
        preparedStatement = connection2.prepareStatement("insert into toverify values (?,?,?)");
        String[] stringArray2 = new String[]{"4", "four", BasicInMemoryDbTest.getString(32768, CharAlphabet.tamil())};
        preparedStatement.setString(1, stringArray2[0]);
        preparedStatement.setString(2, stringArray2[1]);
        preparedStatement.setString(3, stringArray2[2]);
        preparedStatement.executeUpdate();
        preparedStatement.close();
        connection2.close();
        try {
            DriverManager.getConnection("jdbc:derby:" + string2 + ";shutdown=true");
        }
        catch (SQLException sQLException) {
            BasicInMemoryDbTest.assertSQLState("08006", sQLException);
        }
        connection = dbm.getConnection("newMemDb2;createFrom=" + string2);
        statement = dbm.createStatement(connection);
        resultSet = statement.executeQuery("select * from toverify");
        String[][] stringArray3 = new String[4][3];
        System.arraycopy(stringArray, 0, stringArray3, 0, 3);
        System.arraycopy(stringArray2, 0, stringArray3[3], 0, 3);
        JDBC.assertFullResultSet(resultSet, stringArray3);
        dbm.dropDatabase("newMemDb2");
    }

    public void testShutdown() throws SQLException {
        dbm.createDatabase("/tmp/myDB");
        try {
            DriverManager.getConnection("jdbc:derby:memory:/tmp/myDB;shutdown=true");
            BasicInMemoryDbTest.fail((String)"Engine shutdown should have caused exception");
        }
        catch (SQLException sQLException) {
            BasicInMemoryDbTest.assertSQLState("08006", sQLException);
        }
    }

    public void testEnginehutdown() throws SQLException {
        dbm.createDatabase("/tmp/myDB");
        try {
            DriverManager.getConnection("jdbc:derby:;shutdown=true");
            BasicInMemoryDbTest.fail((String)"Engine shutdown should have caused exception");
        }
        catch (SQLException sQLException) {
            BasicInMemoryDbTest.assertSQLState("XJ015", sQLException);
        }
        this.loadDriver();
    }

    public void testBootSameDbDifferentSubSubProtocol() throws SQLException {
        Connection connection = dbm.createDatabase("BSDDSSP");
        Statement statement = dbm.createStatement(connection);
        statement.execute("create table t (text varchar(255))");
        statement.execute("insert into t values ('Inserted into in-memory db')");
        Connection connection2 = DriverManager.getConnection("jdbc:derby:BSDDSSP;create=true");
        Statement statement2 = connection2.createStatement();
        try {
            statement2.executeQuery("select * from t");
            BasicInMemoryDbTest.fail((String)"Table 't' should not exist");
        }
        catch (SQLException sQLException) {
            BasicInMemoryDbTest.assertSQLState("42X05", sQLException);
        }
        connection2.close();
    }

    public void testDelete() throws SQLException {
        this.loadDriver();
        Connection connection = DriverManager.getConnection("jdbc:derby:memory:deleteDbSimple;create=true");
        Statement statement = dbm.createStatement(connection);
        JDBC.assertDrainResults(statement.executeQuery("select * from sys.systables"));
        try {
            DriverManager.getConnection("jdbc:derby:memory:deleteDbSimple;drop=true");
            BasicInMemoryDbTest.fail((String)"Dropping database should have raised exception.");
        }
        catch (SQLException sQLException) {
            BasicInMemoryDbTest.assertSQLState("08006", sQLException);
        }
        try {
            DriverManager.getConnection("jdbc:derby:memory:deleteDbSimple;create=false");
            BasicInMemoryDbTest.fail((String)"Database should not exist after deletion.");
        }
        catch (SQLException sQLException) {
            BasicInMemoryDbTest.assertSQLState("XJ004", sQLException);
        }
        connection = DriverManager.getConnection("jdbc:derby:memory:deleteDbSimple;create=true");
        statement = dbm.createStatement(connection);
        JDBC.assertDrainResults(statement.executeQuery("select * from sys.systables"));
        try {
            DriverManager.getConnection("jdbc:derby:memory:deleteDbSimple;drop=true");
            BasicInMemoryDbTest.fail((String)"Dropping database should have raised exception.");
        }
        catch (SQLException sQLException) {
            BasicInMemoryDbTest.assertSQLState("08006", sQLException);
        }
    }

    public void testDeleteWhenInUse() throws IOException, SQLException {
        this.loadDriver();
        Connection connection = DriverManager.getConnection("jdbc:derby:memory:deleteDb;create=true");
        PreparedStatement preparedStatement = dbm.prepareStatement(connection, "select * from sys.systables");
        JDBC.assertDrainResults(preparedStatement.executeQuery());
        try {
            DriverManager.getConnection("jdbc:derby:memory:deleteDb;drop=true");
            BasicInMemoryDbTest.fail((String)"Dropping database should have raised exception.");
        }
        catch (SQLException sQLException) {
            BasicInMemoryDbTest.assertSQLState("08006", sQLException);
        }
        BasicInMemoryDbTest.assertTrue((boolean)connection.isClosed());
        try {
            JDBC.assertDrainResults(preparedStatement.executeQuery());
            BasicInMemoryDbTest.fail((String)"Database has been dropped, query shouldn't work.");
        }
        catch (SQLException sQLException) {
            BasicInMemoryDbTest.assertSQLState("08003", sQLException);
        }
    }

    public void testShutdownWhenInUse() throws IOException, SQLException {
        Connection connection = dbm.createDatabase("deleteDb");
        PreparedStatement preparedStatement = dbm.prepareStatement(connection, "select * from sys.systables");
        JDBC.assertDrainResults(preparedStatement.executeQuery());
        try {
            DriverManager.getConnection("jdbc:derby:memory:deleteDb;shutdown=true");
            BasicInMemoryDbTest.fail((String)"Database shutdown should have raised exception.");
        }
        catch (SQLException sQLException) {
            BasicInMemoryDbTest.assertSQLState("08006", sQLException);
        }
        BasicInMemoryDbTest.assertTrue((boolean)connection.isClosed());
        try {
            JDBC.assertDrainResults(preparedStatement.executeQuery());
            BasicInMemoryDbTest.fail((String)"Database has been shut down, query shouldn't work.");
        }
        catch (SQLException sQLException) {
            BasicInMemoryDbTest.assertSQLState("08003", sQLException);
        }
    }

    public static Test suite() {
        return new SupportFilesSetup((Test)new BaseTestSuite(BasicInMemoryDbTest.class));
    }

    public static String getString(int n, CharAlphabet charAlphabet) throws IOException {
        int n2;
        LoopingAlphabetReader loopingAlphabetReader = new LoopingAlphabetReader((long)n, charAlphabet);
        char[] cArray = new char[n];
        for (int i = 0; i < n; i += n2) {
            n2 = loopingAlphabetReader.read(cArray, i, n - i);
            if (n2 >= 1) continue;
            BasicInMemoryDbTest.fail((String)("Creating string failed, stream returned " + n2));
        }
        return String.copyValueOf(cArray);
    }
}

