/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.replicationTests;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.tests.replicationTests.ReplicationRun;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.SecurityManagerSetup;

public class ReplicationRun_Local_StateTest_part1
extends ReplicationRun {
    static final String CANNOT_CONNECT_TO_DB_IN_SLAVE_MODE = "08004";
    static final String LOGIN_FAILED = "08004";
    static final String REPLICATION_DB_NOT_BOOTED = "XRE11";
    static final String REPLICATION_MASTER_ALREADY_BOOTED = "XRE22";
    static final String REPLICATION_NOT_IN_MASTER_MODE = "XRE07";
    static final String REPLICATION_SLAVE_STARTED_OK = "XRE08";

    public ReplicationRun_Local_StateTest_part1(String string) {
        super(string);
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("ReplicationRun_Local_StateTest_part1 Suite");
        baseTestSuite.addTestSuite(ReplicationRun_Local_StateTest_part1.class);
        return SecurityManagerSetup.noSecurityManager((Test)baseTestSuite);
    }

    public void testReplication_Local_StateTest_part1() throws Exception {
        this.cleanAllTestHosts();
        this.initEnvironment();
        this._testPreStartedMasterServer();
        this.initMaster(masterServerHost, replicatedDb);
        this.startServer(masterJvmVersion, derbyMasterVersion, masterServerHost, "0.0.0.0", masterServerPort, masterDbSubPath);
        this._testPreStartedSlaveServer();
        this.startServer(slaveJvmVersion, derbySlaveVersion, slaveServerHost, "0.0.0.0", slaveServerPort, slaveDbSubPath);
        this.startServerMonitor(slaveServerHost);
        this.bootMasterDatabase(jvmVersion, masterDatabasePath + FS + masterDbSubPath, replicatedDb, masterServerHost, masterServerPort, null);
        this._testPreInitSlave();
        this.initSlave(slaveServerHost, jvmVersion, replicatedDb);
        this._testPreStartedSlave();
        this.startSlave(jvmVersion, replicatedDb, slaveServerHost, slaveServerPort, slaveServerHost, slaveReplPort, testClientHost);
        this._testPreStartedMaster();
        replicationTest = "org.apache.derbyTesting.functionTests.tests.replicationTests.ReplicationTestRun";
        this.util.DEBUG("replicationTest: " + replicationTest);
        replicationVerify = "org.apache.derbyTesting.functionTests.tests.replicationTests.ReplicationTestRun_Verify";
        this.util.DEBUG("replicationVerify: " + replicationVerify);
        this.runTest(replicationTest, jvmVersion, testClientHost, masterServerHost, masterServerPort, replicatedDb);
        this.failOver(jvmVersion, masterDatabasePath, masterDbSubPath, replicatedDb, masterServerHost, masterServerPort, testClientHost);
        this.connectPing(slaveDatabasePath + FS + slaveDbSubPath + FS + replicatedDb, slaveServerHost, slaveServerPort, testClientHost);
        this.verifySlave();
        this.verifyMaster();
        this.stopServer(jvmVersion, derbyVersion, slaveServerHost, slaveServerPort);
        this.stopServer(jvmVersion, derbyVersion, masterServerHost, masterServerPort);
    }

    private void _testPreStartedMasterServer() {
        Connection connection = null;
        String string = masterDatabasePath + FS + ReplicationRun.masterDbSubPath + FS + replicatedDb;
        String string2 = "jdbc:derby://" + masterServerHost + ":" + masterServerPort + "/" + string + ";startMaster=true;slavehost=" + slaveServerHost + ";slaveport=" + slaveServerPort;
        this.util.DEBUG("testPreStartedMasterServer: " + string2);
        try {
            connection = DriverManager.getConnection(string2);
        }
        catch (SQLException sQLException) {
            int n = sQLException.getErrorCode();
            String string3 = sQLException.getSQLState();
            String string4 = n + " " + string3 + " " + sQLException.getMessage();
            this.util.DEBUG("testStartMasterConnect_Illegal: " + string4);
            ReplicationRun_Local_StateTest_part1.assertTrue((String)("Unexpected SQLException: " + string4), (boolean)"08001".equals(string3));
            this.util.DEBUG("As expected.");
            return;
        }
        ReplicationRun_Local_StateTest_part1.assertTrue((String)("Expected SQLException: '08001 " + string + "'"), (boolean)false);
    }

    private void _testPreStartedSlaveServer() {
        Connection connection = null;
        String string = slaveDatabasePath + FS + ReplicationRun.slaveDbSubPath + FS + replicatedDb;
        String string2 = "jdbc:derby://" + slaveServerHost + ":" + slaveServerPort + "/" + string + ";startSlave=true;slavehost=" + slaveServerHost + ";slaveport=" + slaveServerPort;
        this.util.DEBUG("testPreStartedSlaveServer: " + string2);
        try {
            connection = DriverManager.getConnection(string2);
        }
        catch (SQLException sQLException) {
            int n = sQLException.getErrorCode();
            String string3 = sQLException.getSQLState();
            String string4 = n + " " + string3 + " " + sQLException.getMessage();
            this.util.DEBUG("testStartSlaveConnect_Illegal: " + string4);
            ReplicationRun_Local_StateTest_part1.assertTrue((String)("Unexpected SQLException: " + string4), (boolean)"08001".equals(string3));
            this.util.DEBUG("As expected.");
            return;
        }
        ReplicationRun_Local_StateTest_part1.assertTrue((String)("Expected SQLException: '08001 " + string + "'"), (boolean)false);
    }

    private void _testPreInitSlave() {
        String string;
        String string2;
        int n;
        String string3 = null;
        String string4 = null;
        Connection connection = null;
        string3 = masterDatabasePath + FS + ReplicationRun.masterDbSubPath + FS + replicatedDb;
        string4 = "jdbc:derby://" + masterServerHost + ":" + masterServerPort + "/" + string3 + ";stopMaster=true";
        this.util.DEBUG("1. testPreInitSlave:" + string4);
        try {
            connection = DriverManager.getConnection(string4);
            this.util.DEBUG("Unexpectedly connected: " + string4);
            ReplicationRun_Local_StateTest_part1.assertTrue((String)("Unexpectedly connected: " + string4), (boolean)false);
        }
        catch (SQLException sQLException) {
            n = sQLException.getErrorCode();
            string2 = sQLException.getSQLState();
            string = n + " " + string2 + " " + sQLException.getMessage();
            BaseJDBCTestCase.assertSQLState("stopMaster on master failed: " + string, REPLICATION_NOT_IN_MASTER_MODE, sQLException);
            this.util.DEBUG("stopMaster on master failed as expected: " + string4 + " " + string);
        }
        string3 = slaveDatabasePath + FS + ReplicationRun.slaveDbSubPath + FS + replicatedDb;
        string4 = "jdbc:derby://" + slaveServerHost + ":" + slaveServerPort + "/" + string3 + ";stopSlave=true";
        this.util.DEBUG("2. testPreInitSlave: " + string4);
        try {
            connection = DriverManager.getConnection(string4);
            this.util.DEBUG("Unexpectedly connected: " + string4);
            ReplicationRun_Local_StateTest_part1.assertTrue((String)("Unexpectedly connected: " + string4), (boolean)false);
        }
        catch (SQLException sQLException) {
            n = sQLException.getErrorCode();
            string2 = sQLException.getSQLState();
            string = n + " " + string2 + " " + sQLException.getMessage();
            BaseJDBCTestCase.assertSQLState("stopSlave on slave failed: " + string, REPLICATION_DB_NOT_BOOTED, sQLException);
            this.util.DEBUG("stopSlave on slave failed as expected: " + string4 + " " + string);
        }
    }

    private void _testPreStartedSlave() {
        Object var1_1 = null;
        String string = slaveDatabasePath + FS + ReplicationRun.slaveDbSubPath + FS + replicatedDb;
        String string2 = "jdbc:derby://" + slaveServerHost + ":" + slaveServerPort + "/" + string + ";startSlave=true;slaveHost=" + slaveServerHost + ";slavePort=" + slaveReplPort;
        this.util.DEBUG("testPreStartedSlave: Test moved to TestPostStartedMasterAndSlave! " + string2);
    }

    private void _testPreStartedMaster() throws Exception {
        String string;
        String string2;
        int n;
        Connection connection = null;
        String string3 = masterDatabasePath + FS + ReplicationRun.masterDbSubPath + FS + replicatedDb;
        String string4 = "jdbc:derby://" + masterServerHost + ":" + masterServerPort + "/" + string3 + ";startMaster=true;slaveHost=" + slaveServerHost + ";slavePort=" + slaveReplPort;
        this.util.DEBUG("_testPreStartedMaster: " + string4);
        this.startMaster(jvmVersion, replicatedDb, masterServerHost, masterServerPort, masterServerHost, slaveServerPort, slaveServerHost, slaveReplPort);
        this.util.DEBUG("2. startMaster attempt should fail on: " + string4);
        try {
            connection = DriverManager.getConnection(string4);
            this.util.DEBUG("2. Unexpectedly connected as: " + string4);
            ReplicationRun_Local_StateTest_part1.assertTrue((String)("2. Unexpectedly connected as: " + string4), (boolean)false);
        }
        catch (SQLException sQLException) {
            n = sQLException.getErrorCode();
            string2 = sQLException.getSQLState();
            string = n + " " + string2 + " " + sQLException.getMessage();
            this.util.DEBUG("2. startMaster No connection as expected: " + string);
            BaseJDBCTestCase.assertSQLState("2. Unexpected SQLException: " + string, REPLICATION_MASTER_ALREADY_BOOTED, sQLException);
        }
        this.util.DEBUG("startSlave attempt should fail on: " + string4);
        string3 = slaveDatabasePath + FS + ReplicationRun.slaveDbSubPath + FS + replicatedDb;
        string4 = "jdbc:derby://" + slaveServerHost + ":" + slaveServerPort + "/" + string3 + ";startSlave=true;slaveHost=" + slaveServerHost + ";slavePort=" + slaveReplPort;
        this.util.DEBUG(string4);
        try {
            connection = DriverManager.getConnection(string4);
            this.util.DEBUG("3. startSlave Unexpectedly connected as: " + string4);
            ReplicationRun_Local_StateTest_part1.assertTrue((String)("3. startSlave Unexpectedly connected as: " + string4), (boolean)false);
        }
        catch (SQLException sQLException) {
            n = sQLException.getErrorCode();
            string2 = sQLException.getSQLState();
            string = n + " " + string2 + " " + sQLException.getMessage();
            this.util.DEBUG("3. startSlave No connection as expected: " + string);
            BaseJDBCTestCase.assertSQLState("3. Unexpected SQLException: " + string, "08004", sQLException);
        }
    }
}

