/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.junit;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.derbyTesting.junit.Connector;
import org.apache.derbyTesting.junit.JDBCDataSource;
import org.apache.derbyTesting.junit.TestConfiguration;

public class DataSourceConnector
implements Connector {
    private TestConfiguration config;
    private DataSource ds;

    @Override
    public void setConfiguration(TestConfiguration testConfiguration) {
        this.config = testConfiguration;
        this.ds = JDBCDataSource.getDataSource(testConfiguration, null);
    }

    @Override
    public Connection openConnection() throws SQLException {
        try {
            return this.ds.getConnection();
        }
        catch (SQLException sQLException) {
            String string;
            String string2 = string = this.config.getJDBCClient().isEmbedded() ? "XJ004" : "08004";
            if (!string.equals(sQLException.getSQLState())) {
                throw sQLException;
            }
            return this.singleUseDS(DataSourceConnector.makeCreateDBAttributes(this.config)).getConnection();
        }
    }

    @Override
    public Connection openConnection(String string) throws SQLException {
        JDBCDataSource.setBeanProperty(this.ds, "databaseName", string);
        try {
            return this.ds.getConnection();
        }
        catch (SQLException sQLException) {
            String string2;
            String string3 = string2 = this.config.getJDBCClient().isEmbedded() ? "XJ004" : "08004";
            if (!string2.equals(sQLException.getSQLState())) {
                throw sQLException;
            }
            DataSource dataSource = this.singleUseDS(DataSourceConnector.makeCreateDBAttributes(this.config));
            JDBCDataSource.setBeanProperty(dataSource, "databaseName", string);
            return dataSource.getConnection();
        }
    }

    @Override
    public Connection openConnection(String string, String string2) throws SQLException {
        try {
            return this.ds.getConnection(string, string2);
        }
        catch (SQLException sQLException) {
            if (!"XJ004".equals(sQLException.getSQLState())) {
                throw sQLException;
            }
            return this.singleUseDS(DataSourceConnector.makeCreateDBAttributes(this.config)).getConnection(string, string2);
        }
    }

    @Override
    public Connection openConnection(String string, String string2, String string3) throws SQLException {
        return this.openConnection(string, string2, string3, null);
    }

    @Override
    public Connection openConnection(String string, String string2, String string3, Properties properties) throws SQLException {
        JDBCDataSource.setBeanProperty(this.ds, "databaseName", string);
        try {
            return this.ds.getConnection(string2, string3);
        }
        catch (SQLException sQLException) {
            if (!"XJ004".equals(sQLException.getSQLState())) {
                throw sQLException;
            }
            HashMap<String, Object> hashMap = DataSourceConnector.makeCreateDBAttributes(this.config);
            DataSourceConnector.copyProperties(properties, hashMap);
            DataSource dataSource = this.singleUseDS(hashMap);
            JDBCDataSource.setBeanProperty(dataSource, "databaseName", string);
            return dataSource.getConnection(string2, string3);
        }
    }

    @Override
    public void shutDatabase() throws SQLException {
        this.singleUseDS(DataSourceConnector.makeShutdownDBAttributes(this.config)).getConnection();
        this.config.waitForShutdownComplete(this.getDatabaseName());
    }

    @Override
    public void shutEngine(boolean bl) throws SQLException {
        DataSource dataSource = this.singleUseDS(DataSourceConnector.makeShutdownDBAttributes(this.config));
        JDBCDataSource.setBeanProperty(dataSource, "databaseName", "");
        dataSource.getConnection();
    }

    @Override
    public void setLoginTimeout(int n) throws SQLException {
        this.ds.setLoginTimeout(n);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.ds.getLoginTimeout();
    }

    private DataSource singleUseDS(HashMap hashMap) throws SQLException {
        DataSource dataSource = JDBCDataSource.getDataSource(this.config, hashMap);
        return dataSource;
    }

    static HashMap<String, Object> makeCreateDBAttributes(TestConfiguration testConfiguration) {
        HashMap<String, Object> hashMap = JDBCDataSource.getDataSourceProperties(testConfiguration);
        hashMap.put("createDatabase", "create");
        return hashMap;
    }

    static HashMap<String, Object> makeShutdownDBAttributes(TestConfiguration testConfiguration) {
        HashMap<String, Object> hashMap = JDBCDataSource.getDataSourceProperties(testConfiguration);
        hashMap.put("shutdownDatabase", "shutdown");
        return hashMap;
    }

    @Override
    public String getDatabaseName() {
        String string = null;
        try {
            string = (String)JDBCDataSource.getBeanProperty(this.ds, "databaseName");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string;
    }

    static void copyProperties(Properties properties, Map<String, Object> map) {
        if (properties != null) {
            for (String string : properties.stringPropertyNames()) {
                map.put(string, properties.getProperty(string));
            }
        }
    }
}

