/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.derby.client.am.Configuration;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.shared.common.i18n.MessageUtil;

public abstract class Version {
    private static final MessageUtil msgutil = SqlException.getMessageUtil();

    public static String getDriverVersion() {
        return Configuration.getProductVersionHolder().getVersionBuildString(true);
    }

    public static int getMajorVersion() {
        return Configuration.getProductVersionHolder().getMajorVersion();
    }

    public static int getMinorVersion() {
        return Configuration.getProductVersionHolder().getMinorVersion();
    }

    public static int getProtocolMaintVersion() {
        return Configuration.getProductVersionHolder().getDrdaMaintVersion();
    }

    private static String getDriverNameAndVersion() {
        return "Apache Derby Network Client JDBC Driver " + Configuration.getProductVersionHolder().getVersionBuildString(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void writeDriverConfiguration(PrintWriter printWriter) {
        String header = "[derby] ";
        PrintWriter printWriter2 = printWriter;
        synchronized (printWriter2) {
            printWriter.println(header + "BEGIN TRACE_DRIVER_CONFIGURATION");
            printWriter.println(header + "Driver: " + Version.getDriverNameAndVersion());
            printWriter.print(header + "Compatible JRE versions: { ");
            String[] cv = Configuration.getDncCompatibleJREVersions();
            for (int i = 0; i < cv.length; ++i) {
                printWriter.print(cv[i]);
                if (i == cv.length - 1) continue;
                printWriter.print(", ");
            }
            printWriter.println(" }");
            printWriter.println(header + "Range checking enabled: true");
            printWriter.println(header + "Bug check level: 0x" + Integer.toHexString(255));
            printWriter.println(header + "Default fetch size: 64");
            printWriter.println(header + "Default isolation: 2");
            SecurityManager security = System.getSecurityManager();
            if (security == null) {
                printWriter.println(header + "No security manager detected.");
            } else {
                printWriter.println(header + "Security manager detected.");
            }
            Version.detectLocalHost(System.getSecurityManager(), printWriter);
            Version.printSystemProperty(security, "JDBC 1 system property jdbc.drivers = ", "jdbc.drivers", printWriter);
            Version.printSystemProperty(security, "Java Runtime Environment version ", "java.version", printWriter);
            Version.printSystemProperty(security, "Java Runtime Environment vendor = ", "java.vendor", printWriter);
            Version.printSystemProperty(security, "Java vendor URL = ", "java.vendor.url", printWriter);
            Version.printSystemProperty(security, "Java installation directory = ", "java.home", printWriter);
            Version.printSystemProperty(security, "Java Virtual Machine specification version = ", "java.vm.specification.version", printWriter);
            Version.printSystemProperty(security, "Java Virtual Machine specification vendor = ", "java.vm.specification.vendor", printWriter);
            Version.printSystemProperty(security, "Java Virtual Machine specification name = ", "java.vm.specification.name", printWriter);
            Version.printSystemProperty(security, "Java Virtual Machine implementation version = ", "java.vm.version", printWriter);
            Version.printSystemProperty(security, "Java Virtual Machine implementation vendor = ", "java.vm.vendor", printWriter);
            Version.printSystemProperty(security, "Java Virtual Machine implementation name = ", "java.vm.name", printWriter);
            Version.printSystemProperty(security, "Java Runtime Environment specification version = ", "java.specification.version", printWriter);
            Version.printSystemProperty(security, "Java Runtime Environment specification vendor = ", "java.specification.vendor", printWriter);
            Version.printSystemProperty(security, "Java Runtime Environment specification name = ", "java.specification.name", printWriter);
            Version.printSystemProperty(security, "Java class format version number = ", "java.class.version", printWriter);
            Version.printSystemProperty(security, "Java class path = ", "java.class.path", printWriter);
            Version.printSystemProperty(security, "Java native library path = ", "java.library.path", printWriter);
            Version.printSystemProperty(security, "Path of extension directory or directories = ", "java.ext.dirs", printWriter);
            Version.printSystemProperty(security, "Operating system name = ", "os.name", printWriter);
            Version.printSystemProperty(security, "Operating system architecture = ", "os.arch", printWriter);
            Version.printSystemProperty(security, "Operating system version = ", "os.version", printWriter);
            Version.printSystemProperty(security, "File separator (\"/\" on UNIX) = ", "file.separator", printWriter);
            Version.printSystemProperty(security, "Path separator (\":\" on UNIX) = ", "path.separator", printWriter);
            Version.printSystemProperty(security, "User's account name = ", "user.name", printWriter);
            Version.printSystemProperty(security, "User's home directory = ", "user.home", printWriter);
            Version.printSystemProperty(security, "User's current working directory = ", "user.dir", printWriter);
            printWriter.println(header + "END TRACE_DRIVER_CONFIGURATION");
            printWriter.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void printSystemProperty(SecurityManager security, String prefix, String property, PrintWriter printWriter) {
        String header = "[derby] ";
        PrintWriter printWriter2 = printWriter;
        synchronized (printWriter2) {
            try {
                if (security != null) {
                    security.checkPropertyAccess(property);
                }
                String result = System.getProperty(property);
                printWriter.println(header + prefix + result);
                printWriter.flush();
            }
            catch (SecurityException e) {
                printWriter.println(header + msgutil.getTextMessage("J108", property));
                printWriter.flush();
            }
        }
    }

    private static void detectLocalHost(SecurityManager security, PrintWriter printWriter) {
        String header = "[derby] ";
        if (security == null) {
            try {
                printWriter.print(header + "Detected local client host: ");
                printWriter.println(InetAddress.getLocalHost().toString());
                printWriter.flush();
            }
            catch (UnknownHostException e) {
                printWriter.println(header + msgutil.getTextMessage("J109", e.getMessage()));
                printWriter.flush();
            }
        }
    }
}

