/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbc4;

import java.io.IOException;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLDataException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import junit.framework.Test;
import org.apache.derby.iapi.types.HarmonySerialBlob;
import org.apache.derby.iapi.types.HarmonySerialClob;
import org.apache.derbyTesting.functionTests.tests.jdbc4.CallableStatementTestSetup;
import org.apache.derbyTesting.functionTests.tests.jdbc4.Wrapper41;
import org.apache.derbyTesting.functionTests.tests.jdbc4.Wrapper41Test;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.TestConfiguration;

public class CallableStatementTest
extends Wrapper41Test {
    private CallableStatement cStmt = null;
    private static boolean _nullOutArgs;

    public CallableStatementTest(String name) {
        super(name);
    }

    protected void setUp() throws SQLException {
        this.cStmt = this.prepareCall("? = CALL FLOOR(?)");
        this.cStmt.registerOutParameter(1, 8);
    }

    @Override
    protected void tearDown() throws Exception {
        this.cStmt.close();
        this.cStmt = null;
        super.tearDown();
    }

    public void testNamedParametersAreNotSupported() throws SQLException {
        DatabaseMetaData met = this.getConnection().getMetaData();
        CallableStatementTest.assertFalse((String)"Named parameters are not supported, but the metadata says they are", (boolean)met.supportsNamedParameters());
    }

    public void testGetDoubleIntOnInParameter() throws SQLException {
        this.cStmt.setDouble(2, 3.3);
        this.cStmt.execute();
        try {
            this.cStmt.getDouble(2);
            CallableStatementTest.fail((String)"Calling getDouble on an IN parameter should throw an exception");
        }
        catch (SQLException sqle) {
            String sqlState = CallableStatementTest.usingDerbyNetClient() ? "XJ091" : "XCL26";
            CallableStatementTest.assertSQLState("Unexpected SQLState", sqlState, sqle);
        }
    }

    public void testGetNClobIntNotImplemented() throws SQLException {
        try {
            this.cStmt.getNClob(1);
            CallableStatementTest.fail((String)"CallableStatement.getNClob(int) should not be implemented");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            // empty catch block
        }
    }

    public void testGetNClobStringNotImplemented() throws SQLException {
        try {
            this.cStmt.getNClob("some-parameter-name");
            CallableStatementTest.fail((String)"CallableStatement.getNClob(String) should not be implemented");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            // empty catch block
        }
    }

    public void testGetNStringIntNotImplemented() throws SQLException {
        try {
            this.cStmt.getNString(1);
            CallableStatementTest.fail((String)"CallableStatement.getNString(int) should not be implemented");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            // empty catch block
        }
    }

    public void testGetNStringStringNotImplemented() throws SQLException {
        try {
            this.cStmt.getNString("some-parameter-name");
            CallableStatementTest.fail((String)"CallableStatement.getNString(String) should not be implemented");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            // empty catch block
        }
    }

    public void testGetCharacterStreamIntOnInvalidTypeDOUBLE() throws SQLException {
        this.cStmt.setDouble(2, 3.3);
        this.cStmt.execute();
        try {
            this.cStmt.getCharacterStream(1);
            CallableStatementTest.fail((String)"An exception signalling invalid data type conversion should have been thrown");
        }
        catch (SQLDataException sqlde) {
            CallableStatementTest.assertSQLState("Exception with invalid SQL state thrown on invalid data type conversion", "22005", sqlde);
        }
    }

    public void testGetCharacterStreamIntOnInParameterOfInvalidType() throws SQLException {
        this.cStmt.setDouble(2, 3.3);
        this.cStmt.execute();
        try {
            this.cStmt.getCharacterStream(2);
            CallableStatementTest.fail((String)"Calling getCharacterStream on an IN parameter should throw an exception");
        }
        catch (SQLException sqle) {
            String sqlState = CallableStatementTest.usingDerbyNetClient() ? "XJ091" : "XCL26";
            CallableStatementTest.assertSQLState("Exception with invalid SQL state thrown for getCharacterStream on IN parameter", sqlState, sqle);
        }
    }

    public void testGetCharacterStreamIntOnInParameterOfValidType() throws SQLException {
        this.cStmt = CallableStatementTestSetup.getBinaryDirectProcedure(this.getConnection());
        this.cStmt.setString(1, "A string");
        this.cStmt.execute();
        try {
            this.cStmt.getCharacterStream(1);
            CallableStatementTest.fail((String)"Calling getCharacterStream on an IN parameter should throw an exception");
        }
        catch (SQLException sqle) {
            String sqlState = CallableStatementTest.usingDerbyNetClient() ? "XJ091" : "XCL26";
            CallableStatementTest.assertSQLState("Exception with invalid SQL state thrown for getCharacterStream on IN parameter", sqlState, sqle);
        }
    }

    public void testGetCharacterStreamIntVARCHAR() throws IOException, SQLException {
        this.cStmt = CallableStatementTestSetup.getIntToStringFunction(this.getConnection());
        this.cStmt.setInt(2, 4509);
        CallableStatementTest.assertFalse((String)"No resultsets should be returned", (boolean)this.cStmt.execute());
        CallableStatementTest.assertEquals((String)"Incorrect updatecount", (int)-1, (int)this.cStmt.getUpdateCount());
        Reader cStream = this.cStmt.getCharacterStream(1);
        CallableStatementTest.assertFalse((String)"Stream should not be null", (boolean)this.cStmt.wasNull());
        CallableStatementTest.assertNotNull((String)"Stream is null even though wasNull() returned false", (Object)cStream);
        char[] chars = new char[4];
        CallableStatementTest.assertEquals((String)"Wrong number of characters read", (int)4, (int)cStream.read(chars));
        CallableStatementTest.assertEquals((String)"Expected end of stream, but there were more data", (int)-1, (int)cStream.read());
        cStream.close();
        String result = new String(chars);
        CallableStatementTest.assertEquals((String)"Incorrect result obtained through java.io.Reader", (String)"4509", (String)result);
    }

    public void testGetCharacterStreamIntVARBINARYDirect() throws IOException, SQLException {
        String data = "This is the test string.";
        this.cStmt = CallableStatementTestSetup.getBinaryDirectProcedure(this.getConnection());
        this.cStmt.setString(1, data);
        CallableStatementTest.assertFalse((String)"No resultsets should be returned", (boolean)this.cStmt.execute());
        CallableStatementTest.assertEquals((String)"Incorrect updatecount", (int)(CallableStatementTest.usingEmbedded() ? 0 : -1), (int)this.cStmt.getUpdateCount());
        Reader cStream = this.cStmt.getCharacterStream(2);
        CallableStatementTest.assertFalse((String)"Stream should not be null", (boolean)this.cStmt.wasNull());
        CallableStatementTest.assertNotNull((String)"Stream is null even though wasNull() returned false", (Object)cStream);
        char[] tmpChars = new char[data.length() * 4];
        int curChar = cStream.read();
        int index = 0;
        while (curChar != -1) {
            tmpChars[index] = (char)curChar;
            ++index;
            curChar = cStream.read();
        }
        cStream.close();
        char[] chars = new char[index];
        System.arraycopy(tmpChars, 0, chars, 0, index);
        String result = new String(chars);
        CallableStatementTest.assertEquals((String)"Incorrect result obtained through java.io.Reader", (String)data, (String)result);
    }

    public void testGetCharacterStreamIntVARBINARYFromDb() throws IOException, SQLException {
        this.cStmt = CallableStatementTestSetup.getBinaryFromDbFunction(this.getConnection());
        this.cStmt.setInt(2, 1);
        CallableStatementTest.assertFalse((String)"No resultsets should be returned", (boolean)this.cStmt.execute());
        CallableStatementTest.assertEquals((String)"Incorrect updatecount", (int)-1, (int)this.cStmt.getUpdateCount());
        Reader cStream = this.cStmt.getCharacterStream(1);
        CallableStatementTest.assertFalse((String)"Stream should not be null", (boolean)this.cStmt.wasNull());
        CallableStatementTest.assertNotNull((String)"Stream is null even though wasNull() returned false", (Object)cStream);
        char[] tmpChars = new char[32672];
        int curChar = cStream.read();
        int index = 0;
        while (curChar != -1) {
            tmpChars[index] = (char)curChar;
            ++index;
            curChar = cStream.read();
        }
        char[] chars = new char[index];
        System.arraycopy(tmpChars, 0, chars, 0, index);
        tmpChars = null;
        cStream.close();
        String result = new String(chars);
        CallableStatementTest.assertEquals((String)"Strings not equal", (String)"This is a string, converted to bytes and inserted into the database", (String)result);
    }

    public void testGetCharacterStreamIntOnVARBINARYWithNull() throws SQLException {
        this.cStmt = CallableStatementTestSetup.getBinaryFromDbFunction(this.getConnection());
        this.cStmt.setInt(2, 2);
        CallableStatementTest.assertFalse((String)"No resultsets should be returned", (boolean)this.cStmt.execute());
        CallableStatementTest.assertEquals((String)"Incorrect updatecount", (int)-1, (int)this.cStmt.getUpdateCount());
        Reader cStream = this.cStmt.getCharacterStream(1);
        CallableStatementTest.assertTrue((String)"Stream should be null", (boolean)this.cStmt.wasNull());
        CallableStatementTest.assertNull((String)"Stream is not null even though wasNull() returned true", (Object)cStream);
    }

    public void testGetCharacterStreamIntOnVARCHARWithNull() throws SQLException {
        this.cStmt = CallableStatementTestSetup.getVarcharFromDbFunction(this.getConnection());
        this.cStmt.setInt(2, 2);
        CallableStatementTest.assertFalse((String)"No resultsets should be returned", (boolean)this.cStmt.execute());
        CallableStatementTest.assertEquals((String)"Incorrect updatecount", (int)-1, (int)this.cStmt.getUpdateCount());
        Reader cStream = this.cStmt.getCharacterStream(1);
        CallableStatementTest.assertTrue((String)"Stream should be null", (boolean)this.cStmt.wasNull());
        CallableStatementTest.assertNull((String)"Stream is not null even though wasNull() returned true", (Object)cStream);
    }

    public void testGetCharacterStreamStringNotImplemented() throws SQLException {
        try {
            this.cStmt.getCharacterStream("some-parameter-name");
            CallableStatementTest.fail((String)"CallableStatement.getCharacterStream(String) should not be implemented");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            // empty catch block
        }
    }

    public void testGetNCharacterStreamIntNotImplemented() throws SQLException {
        try {
            this.cStmt.getNCharacterStream(1);
            CallableStatementTest.fail((String)"CallableStatement.getNCharacterStream(int) should not be implemented");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            // empty catch block
        }
    }

    public void testGetNCharacterStreamStringNotImplemented() throws SQLException {
        try {
            this.cStmt.getNCharacterStream("some-parameter-name");
            CallableStatementTest.fail((String)"CallableStatement.getNCharacterStream(String) should not be implemented");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            // empty catch block
        }
    }

    public void testSetBlobNotImplemented() throws SQLException {
        try {
            this.cStmt.setBlob("some-parameter-name", (Blob)null);
            CallableStatementTest.fail((String)"CallableStatement.setBlob(String, Blob) should not be implemented");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            // empty catch block
        }
    }

    public void testSetClobNotImplemented() throws SQLException {
        try {
            this.cStmt.setClob("some-parameter-name", (Clob)null);
            CallableStatementTest.fail((String)"CallableStatement.setClob(String, Clob) should not be implemented");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            // empty catch block
        }
    }

    public void testSetNCharacterStreamNotImplemented() throws SQLException {
        try {
            this.cStmt.setNCharacterStream("some-parameter-name", null, 0L);
            CallableStatementTest.fail((String)"CallableStatement.setNCharacterStream(String,Reader,long) should not be implemented");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            // empty catch block
        }
    }

    public void testSetNClobNClobNotImplemented() throws SQLException {
        try {
            this.cStmt.setNClob("some-parameter-name", (NClob)null);
            CallableStatementTest.fail((String)"CallableStatement.setNClob(String, NClob) should not be implemented");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            // empty catch block
        }
    }

    public void testSetNClobReaderNotImplemented() throws SQLException {
        try {
            this.cStmt.setNClob("some-parameter-name", null, 0L);
            CallableStatementTest.fail((String)"CallableStatement.setNClob(String, Reader, long) should not be implemented");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            // empty catch block
        }
    }

    public void testSetNStringNotImplemented() throws SQLException {
        try {
            this.cStmt.setNString("some-parameter-name", "some-value");
            CallableStatementTest.fail((String)"CallableStatement.setNString(String, String) should not be implemented");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            // empty catch block
        }
    }

    public void testGetSQLXMLIntNotImplemented() throws SQLException {
        try {
            this.cStmt.getSQLXML(1);
            CallableStatementTest.fail((String)"CallableStatement.getSQLXML(int) should not be implemented");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            // empty catch block
        }
    }

    public void testGetSQLXMLStringNotImplemented() throws SQLException {
        try {
            this.cStmt.getSQLXML("some-parameter-name");
            CallableStatementTest.fail((String)"CallableStatement.getSQLXML(String) should not be implemented");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            // empty catch block
        }
    }

    public void testSetSQLXMLNotImplemented() throws SQLException {
        try {
            this.cStmt.setSQLXML("some-parameter-name", null);
            CallableStatementTest.fail((String)"CallableStatement.setSQLXML(String, SQLXML) should not be implemented");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            // empty catch block
        }
    }

    private void testIsWrapperForXXXStatement(Class klass) throws SQLException {
        CallableStatementTest.assertTrue((String)("The CallableStatement is not a wrapper for " + klass.getName()), (boolean)this.cStmt.isWrapperFor(klass));
    }

    public void testIsWrapperForStatement() throws SQLException {
        this.testIsWrapperForXXXStatement(Statement.class);
    }

    public void testIsWrapperForPreparedStatement() throws SQLException {
        this.testIsWrapperForXXXStatement(PreparedStatement.class);
    }

    public void testIsWrapperForCallableStatement() throws SQLException {
        this.testIsWrapperForXXXStatement(CallableStatement.class);
    }

    public void testIsNotWrapperForResultSet() throws SQLException {
        CallableStatementTest.assertFalse((boolean)this.cStmt.isWrapperFor(ResultSet.class));
    }

    public void testIsWrapperForSelf() throws SQLException {
        CallableStatementTest.assertTrue((boolean)this.cStmt.isWrapperFor(this.cStmt.getClass()));
    }

    public void testUnwrapStatement() throws SQLException {
        Statement stmt = this.cStmt.unwrap(Statement.class);
        CallableStatementTest.assertSame((String)"Unwrap returned wrong object.", (Object)this.cStmt, (Object)stmt);
    }

    public void testUnwrapPreparedStatement() throws SQLException {
        PreparedStatement ps = this.cStmt.unwrap(PreparedStatement.class);
        CallableStatementTest.assertSame((String)"Unwrap returned wrong object.", (Object)this.cStmt, (Object)ps);
    }

    public void testUnwrapCallableStatement() throws SQLException {
        Statement cs = this.cStmt.unwrap(CallableStatement.class);
        CallableStatementTest.assertSame((String)"Unwrap returned wrong object.", (Object)this.cStmt, (Object)cs);
    }

    public void testUnwrapAsSelf() throws SQLException {
        PreparedStatement cs = (PreparedStatement)this.cStmt.unwrap(this.cStmt.getClass());
        CallableStatementTest.assertSame((String)"Unwrap returned wrong object.", (Object)this.cStmt, (Object)cs);
    }

    public void testUnwrapResultSet() {
        try {
            ResultSet rs = this.cStmt.unwrap(ResultSet.class);
            CallableStatementTest.fail((String)"Unwrap didn't fail.");
        }
        catch (SQLException e) {
            CallableStatementTest.assertSQLState("XJ128", e);
        }
    }

    public void testSetCharacterStream() throws SQLException {
        try {
            this.cStmt.setCharacterStream("Some String", null, 0L);
            CallableStatementTest.fail((String)"CallableStatement.setCharacterStream() should not be implemented");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            // empty catch block
        }
    }

    public void testSetAsciiStream() throws SQLException {
        try {
            this.cStmt.setAsciiStream("Some String", null, 0L);
            CallableStatementTest.fail((String)"CallableStatement.setAsciiStream() should not be implemented");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            // empty catch block
        }
    }

    public void testSetBinaryStream() throws SQLException {
        try {
            this.cStmt.setBinaryStream("Some String", null, 0L);
            CallableStatementTest.fail((String)"CallableStatement.setBinaryStream() should not be implemented");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            // empty catch block
        }
    }

    public void testJDBC4_1() throws Exception {
        Connection conn = this.getConnection();
        this.vetDataTypeCount(conn);
        PreparedStatement ps = this.prepareStatement(conn, "create procedure allTypesProc\n(\n    out bigintCol bigint,\n    out blobCol blob,\n    out booleanCol boolean,\n    out charCol char(1),\n    out charForBitDataCol char(1) for bit data,\n    out clobCol clob,\n    out dateCol date,\n    out doubleCol double,\n    out floatCol float,\n    out intCol int,\n    out longVarcharCol long varchar,\n    out longVarcharForBitDataCol long varchar for bit data,\n    out numericCol numeric,\n    out realCol real,\n    out smallintCol smallint,\n    out timeCol time,\n    out timestampCol timestamp,\n    out varcharCol varchar( 2 ),\n    out varcharForBitDataCol varchar( 2 ) for bit data\n)\nlanguage java\nparameter style java\nno sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.jdbc4.CallableStatementTest.allTypesProc'\n");
        ps.execute();
        ps.close();
        CallableStatement cs = this.prepareCall(conn, "call allTypesProc(  ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ? )");
        int param = 1;
        cs.registerOutParameter(param++, -5);
        cs.registerOutParameter(param++, 2004);
        cs.registerOutParameter(param++, 16);
        cs.registerOutParameter(param++, 1);
        cs.registerOutParameter(param++, -2);
        cs.registerOutParameter(param++, 2005);
        cs.registerOutParameter(param++, 91);
        cs.registerOutParameter(param++, 8);
        cs.registerOutParameter(param++, 6);
        cs.registerOutParameter(param++, 4);
        cs.registerOutParameter(param++, -1);
        cs.registerOutParameter(param++, -4);
        cs.registerOutParameter(param++, 2);
        cs.registerOutParameter(param++, 7);
        cs.registerOutParameter(param++, 5);
        cs.registerOutParameter(param++, 92);
        cs.registerOutParameter(param++, 93);
        cs.registerOutParameter(param++, 12);
        cs.registerOutParameter(param++, -3);
        _nullOutArgs = false;
        cs.execute();
        this.examineJDBC4_1extensions(new Wrapper41(cs), _nullOutArgs);
        _nullOutArgs = true;
        cs.execute();
        this.examineJDBC4_1extensions(new Wrapper41(cs), _nullOutArgs);
        cs.close();
        ps = this.prepareStatement(conn, "drop procedure allTypesProc");
        ps.execute();
        ps.close();
    }

    private void vetDataTypeCount(Connection conn) throws Exception {
        ResultSet rs = conn.getMetaData().getTypeInfo();
        int actualTypeCount = 0;
        while (rs.next()) {
            ++actualTypeCount;
        }
        rs.close();
        CallableStatementTest.assertEquals((int)22, (int)actualTypeCount);
    }

    public void test_4959() throws Exception {
        Connection conn = this.getConnection();
        PreparedStatement ps = this.prepareStatement(conn, "create procedure blobProc\n(\n    out blobCol blob\n)\nlanguage java\nparameter style java\nno sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.jdbc4.CallableStatementTest.blobProc'\n");
        ps.execute();
        ps.close();
        ps = this.prepareStatement(conn, "create procedure clobProc\n(\n    out clobCol clob\n)\nlanguage java\nparameter style java\nno sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.jdbc4.CallableStatementTest.clobProc'\n");
        ps.execute();
        ps.close();
        CallableStatement cs = this.prepareCall(conn, "call blobProc(  ? )");
        cs.registerOutParameter(1, 2004);
        cs.execute();
        CallableStatementTest.assertNull((Object)cs.getBlob(1));
        cs.close();
        cs = this.prepareCall(conn, "call clobProc(  ? )");
        cs.registerOutParameter(1, 2005);
        cs.execute();
        CallableStatementTest.assertNull((Object)cs.getClob(1));
        cs.close();
        ps = this.prepareStatement(conn, "drop procedure blobProc");
        ps.execute();
        ps.close();
        ps = this.prepareStatement(conn, "drop procedure clobProc");
        ps.execute();
        ps.close();
    }

    public static void allTypesProc(Long[] bigintarg, Blob[] blobarg, Boolean[] booleanarg, String[] chararg, byte[][] charforbitdataarg, Clob[] clobarg, Date[] datearg, Double[] doublearg, Double[] floatarg, Integer[] intarg, String[] longvarchararg, byte[][] longvarcharforbitdataarg, BigDecimal[] numericarg, Float[] realarg, Integer[] smallintarg, Time[] timearg, Timestamp[] timestamparg, String[] varchararg, byte[][] varcharforbitdataarg) throws Exception {
        String stringValue = "a";
        int intValue = 1;
        float floatValue = 1.0f;
        String lobValue = "abc";
        bigintarg[0] = _nullOutArgs ? null : Long.valueOf(intValue);
        blobarg[0] = _nullOutArgs ? null : new HarmonySerialBlob(BINARY_VALUE);
        booleanarg[0] = _nullOutArgs ? null : Boolean.TRUE;
        chararg[0] = _nullOutArgs ? null : stringValue;
        charforbitdataarg[0] = _nullOutArgs ? null : BINARY_VALUE;
        clobarg[0] = _nullOutArgs ? null : new HarmonySerialClob(lobValue);
        datearg[0] = _nullOutArgs ? null : new Date(761990400000L);
        doublearg[0] = _nullOutArgs ? null : Double.valueOf(floatValue);
        floatarg[0] = _nullOutArgs ? null : Double.valueOf(floatValue);
        intarg[0] = _nullOutArgs ? null : Integer.valueOf(intValue);
        longvarchararg[0] = _nullOutArgs ? null : stringValue;
        longvarcharforbitdataarg[0] = _nullOutArgs ? null : BINARY_VALUE;
        numericarg[0] = _nullOutArgs ? null : new BigDecimal("1.0");
        realarg[0] = _nullOutArgs ? null : Float.valueOf(floatValue);
        smallintarg[0] = _nullOutArgs ? null : Integer.valueOf(intValue);
        timearg[0] = _nullOutArgs ? null : new Time(83342000L);
        timestamparg[0] = _nullOutArgs ? null : new Timestamp(-229527385766L);
        varchararg[0] = _nullOutArgs ? null : stringValue;
        varcharforbitdataarg[0] = _nullOutArgs ? null : BINARY_VALUE;
    }

    public static void blobProc(Blob[] blobarg) throws Exception {
        blobarg[0] = null;
    }

    public static void clobProc(Clob[] clobarg) throws Exception {
        clobarg[0] = null;
    }

    public static Test suite() {
        BaseTestSuite suite = new BaseTestSuite("CallableStatementTest suite");
        suite.addTest(CallableStatementTest.baseSuite("CallableStatementTest:embedded"));
        suite.addTest(TestConfiguration.clientServerDecorator(CallableStatementTest.baseSuite("CallableStatementTest:client")));
        suite.addTest(TestConfiguration.clientServerDecorator(TestConfiguration.connectionCPDecorator(CallableStatementTest.baseSuite("CallableStatementTest:logical"))));
        return suite;
    }

    private static Test baseSuite(String name) {
        BaseTestSuite suite = new BaseTestSuite(CallableStatementTest.class, name);
        return new CallableStatementTestSetup((Test)suite);
    }
}

