/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.services.classfile;

import java.io.IOException;
import org.apache.derby.iapi.services.classfile.ClassFormatOutput;
import org.apache.derby.shared.common.sanity.SanityManager;

public abstract class ConstantPoolEntry {
    protected int tag;
    protected boolean doubleSlot;
    protected int index;

    protected ConstantPoolEntry(int tag) {
        this.tag = tag;
    }

    int getIndex() {
        if (this.index <= 0) {
            SanityManager.THROWASSERT("index is expected to be > 0, is " + this.index);
        }
        return this.index;
    }

    void setIndex(int index) {
        this.index = index;
    }

    boolean doubleSlot() {
        return this.doubleSlot;
    }

    Object getKey() {
        return this;
    }

    abstract int classFileSize();

    void put(ClassFormatOutput out) throws IOException {
        out.putU1(this.tag);
    }

    final int getTag() {
        return this.tag;
    }

    int getI1() {
        return 0;
    }

    int getI2() {
        return 0;
    }
}

