/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.derby.catalog.DependableFinder;
import org.apache.derby.catalog.IndexDescriptor;
import org.apache.derby.catalog.UUID;
import org.apache.derby.catalog.types.ReferencedColumnsDescriptorImpl;
import org.apache.derby.catalog.types.StatisticsImpl;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.io.StreamStorable;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.PreparedStatement;
import org.apache.derby.iapi.sql.ResultSet;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.compile.Parser;
import org.apache.derby.iapi.sql.compile.Visitable;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.depend.DependencyManager;
import org.apache.derby.iapi.sql.dictionary.CheckConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptorList;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptorList;
import org.apache.derby.iapi.sql.dictionary.DataDescriptorGenerator;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.DefaultDescriptor;
import org.apache.derby.iapi.sql.dictionary.DependencyDescriptor;
import org.apache.derby.iapi.sql.dictionary.ForeignKeyConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.IndexLister;
import org.apache.derby.iapi.sql.dictionary.IndexRowGenerator;
import org.apache.derby.iapi.sql.dictionary.ReferencedKeyConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.SPSDescriptor;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.SequenceDescriptor;
import org.apache.derby.iapi.sql.dictionary.StatisticsDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.dictionary.TriggerDescriptor;
import org.apache.derby.iapi.sql.dictionary.TupleDescriptor;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.iapi.sql.execute.ExecIndexRow;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.store.access.ColumnOrdering;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.iapi.store.access.GroupFetchScanController;
import org.apache.derby.iapi.store.access.RowLocationRetRowSource;
import org.apache.derby.iapi.store.access.RowUtil;
import org.apache.derby.iapi.store.access.ScanController;
import org.apache.derby.iapi.store.access.SortController;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.iapi.util.IdUtil;
import org.apache.derby.impl.sql.compile.StatementNode;
import org.apache.derby.impl.sql.execute.AlterConstraintConstantAction;
import org.apache.derby.impl.sql.execute.BasicSortObserver;
import org.apache.derby.impl.sql.execute.CardinalityCounter;
import org.apache.derby.impl.sql.execute.ColumnInfo;
import org.apache.derby.impl.sql.execute.ConstraintConstantAction;
import org.apache.derby.impl.sql.execute.CreateConstraintConstantAction;
import org.apache.derby.impl.sql.execute.CreateIndexConstantAction;
import org.apache.derby.impl.sql.execute.CreateSequenceConstantAction;
import org.apache.derby.impl.sql.execute.CreateTableConstantAction;
import org.apache.derby.impl.sql.execute.DDLSingleTableConstantAction;
import org.apache.derby.impl.sql.execute.DeferredConstraintsMemory;
import org.apache.derby.impl.sql.execute.DropConstraintConstantAction;
import org.apache.derby.impl.sql.execute.DropTableConstantAction;
import org.apache.derby.impl.sql.execute.IndexColumnOrder;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

class AlterTableConstantAction
extends DDLSingleTableConstantAction
implements RowLocationRetRowSource {
    private static final int RANGE_TOP = 0;
    private static final int RANGE_BOTTOM = 1;
    private SchemaDescriptor sd;
    private String tableName;
    private UUID schemaId;
    private int tableType;
    private ColumnInfo[] columnInfo;
    private ConstraintConstantAction[] constraintActions;
    private char lockGranularity;
    private long tableConglomerateId;
    private boolean compressTable;
    private int behavior;
    private boolean sequential;
    private boolean truncateTable;
    private boolean purge;
    private boolean defragment;
    private boolean truncateEndOfTable;
    private boolean updateStatistics;
    private boolean updateStatisticsAll;
    private boolean dropStatistics;
    private boolean dropStatisticsAll;
    private String indexNameForStatistics;
    private boolean doneScan;
    private boolean[] needToDropSort;
    private boolean[] validRow;
    private int bulkFetchSize = 16;
    private int currentCompressRow;
    private int numIndexes;
    private int rowCount;
    private long estimatedRowCount;
    private long[] indexConglomerateNumbers;
    private long[] sortIds;
    private FormatableBitSet indexedCols;
    private ConglomerateController compressHeapCC;
    private ExecIndexRow[] indexRows;
    private ExecRow[] baseRow;
    private ExecRow currentRow;
    private GroupFetchScanController compressHeapGSC;
    private IndexRowGenerator[] compressIRGs;
    private DataValueDescriptor[][] baseRowArray;
    private RowLocation[] compressRL;
    private SortController[] sorters;
    private int droppedColumnPosition;
    private ColumnOrdering[][] ordering;
    private int[][] collation;
    private TableDescriptor td;
    private LanguageConnectionContext lcc;
    private DataDictionary dd;
    private DependencyManager dm;
    private TransactionController tc;
    private Activation activation;

    AlterTableConstantAction(SchemaDescriptor sd, String tableName, UUID tableId, long tableConglomerateId, int tableType, ColumnInfo[] columnInfo, ConstraintConstantAction[] constraintActions, char lockGranularity, boolean compressTable, int behavior, boolean sequential, boolean truncateTable, boolean purge, boolean defragment, boolean truncateEndOfTable, boolean updateStatistics, boolean updateStatisticsAll, boolean dropStatistics, boolean dropStatisticsAll, String indexNameForStatistics) {
        super(tableId);
        this.sd = sd;
        this.tableName = tableName;
        this.tableConglomerateId = tableConglomerateId;
        this.tableType = tableType;
        this.columnInfo = columnInfo;
        this.constraintActions = constraintActions;
        this.lockGranularity = lockGranularity;
        this.compressTable = compressTable;
        this.behavior = behavior;
        this.sequential = sequential;
        this.truncateTable = truncateTable;
        this.purge = purge;
        this.defragment = defragment;
        this.truncateEndOfTable = truncateEndOfTable;
        this.updateStatistics = updateStatistics;
        this.updateStatisticsAll = updateStatisticsAll;
        this.dropStatistics = dropStatistics;
        this.dropStatisticsAll = dropStatisticsAll;
        this.indexNameForStatistics = indexNameForStatistics;
        SanityManager.ASSERT(sd != null, "schema descriptor is null");
    }

    public String toString() {
        if (this.truncateTable) {
            return "TRUNCATE TABLE " + this.tableName;
        }
        return "ALTER TABLE " + this.tableName;
    }

    @Override
    public void executeConstantAction(Activation activation) throws StandardException {
        try {
            this.executeConstantActionBody(activation);
        }
        finally {
            this.clearState();
        }
    }

    private void executeConstantActionBody(Activation activation) throws StandardException {
        this.activation = activation;
        this.lcc = activation.getLanguageConnectionContext();
        this.dd = this.lcc.getDataDictionary();
        this.dm = this.dd.getDependencyManager();
        this.tc = this.lcc.getTransactionExecute();
        int numRows = 0;
        boolean tableScanned = false;
        if (this.compressTable || this.truncateTable) {
            DeferredConstraintsMemory.compressOrTruncate(this.lcc, this.tableId, this.tableName);
        }
        if (this.compressTable && (this.purge || this.defragment || this.truncateEndOfTable)) {
            this.td = this.dd.getTableDescriptor(this.tableId);
            if (this.td == null) {
                throw StandardException.newException("X0X05.S", this.tableName);
            }
            if (this.purge) {
                this.purgeRows(this.tc);
            }
            if (this.defragment) {
                this.defragmentRows(this.tc);
            }
            if (this.truncateEndOfTable) {
                this.truncateEnd(this.tc);
            }
            return;
        }
        if (this.updateStatistics) {
            this.updateStatistics();
            return;
        }
        if (this.dropStatistics) {
            this.dropStatistics();
            return;
        }
        this.dd.startWriting(this.lcc);
        if (this.tableConglomerateId == 0L) {
            this.td = this.dd.getTableDescriptor(this.tableId);
            if (this.td == null) {
                throw StandardException.newException("X0X05.S", this.tableName);
            }
            this.tableConglomerateId = this.td.getHeapConglomerateId();
        }
        this.lockTableForDDL(this.tc, this.tableConglomerateId, true);
        this.td = this.dd.getTableDescriptor(this.tableId);
        if (this.td == null) {
            throw StandardException.newException("X0X05.S", this.tableName);
        }
        if (this.truncateTable) {
            this.dm.invalidateFor(this.td, 42, this.lcc);
        } else {
            this.dm.invalidateFor(this.td, 12, this.lcc);
        }
        activation.setDDLTableDescriptor(this.td);
        if (this.sd == null) {
            this.sd = AlterTableConstantAction.getAndCheckSchemaDescriptor(this.dd, this.schemaId, "ALTER TABLE");
        }
        if (this.truncateTable) {
            this.dm.invalidateFor(this.td, 42, this.lcc);
        } else {
            this.dm.invalidateFor(this.td, 12, this.lcc);
        }
        if (this.columnInfo != null) {
            int ix;
            boolean tableNeedsScanning = false;
            for (ix = 0; ix < this.columnInfo.length; ++ix) {
                if (this.columnInfo[ix].action != 0 || this.columnInfo[ix].dataType.isNullable() || this.columnInfo[ix].defaultInfo != null || this.columnInfo[ix].autoincInc != 0L) continue;
                tableNeedsScanning = true;
            }
            if (tableNeedsScanning) {
                numRows = this.getSemiRowCount(this.tc);
                if (numRows > 0) {
                    throw StandardException.newException("X0Y57.S", this.td.getQualifiedName());
                }
                tableScanned = true;
            }
            for (ix = 0; ix < this.columnInfo.length; ++ix) {
                if (this.columnInfo[ix].action == 0) {
                    this.addNewColumnToTable(ix);
                    continue;
                }
                if (this.columnInfo[ix].action == 5 || this.columnInfo[ix].action == 6 || this.columnInfo[ix].action == 10 || this.columnInfo[ix].action == 7) {
                    this.modifyColumnDefault(ix);
                    continue;
                }
                if (this.columnInfo[ix].action == 2) {
                    this.modifyColumnType(ix);
                    continue;
                }
                if (this.columnInfo[ix].action == 3) {
                    this.modifyColumnConstraint(this.columnInfo[ix].name, true);
                    continue;
                }
                if (this.columnInfo[ix].action == 4) {
                    boolean[] nullCols;
                    String[] colNames;
                    if (!tableScanned) {
                        tableScanned = true;
                        numRows = this.getSemiRowCount(this.tc);
                    }
                    if (!this.validateNotNullConstraint(colNames = new String[]{this.columnInfo[ix].name}, nullCols = new boolean[1], numRows, this.lcc, "X0Y80.S")) continue;
                    this.modifyColumnConstraint(this.columnInfo[ix].name, false);
                    continue;
                }
                if (this.columnInfo[ix].action == 1) {
                    this.dropColumnFromTable(this.columnInfo[ix].name);
                    continue;
                }
                if (this.columnInfo[ix].action == 8 || this.columnInfo[ix].action == 9) {
                    this.modifyIdentityState(ix);
                    continue;
                }
                SanityManager.THROWASSERT("Unexpected action in AlterTableConstantAction");
            }
        }
        this.adjustUDTDependencies(this.lcc, this.dd, this.td, this.columnInfo, false);
        if (this.constraintActions != null) {
            for (int conIndex = 0; conIndex < this.constraintActions.length; ++conIndex) {
                ConstraintConstantAction cca = this.constraintActions[conIndex];
                boolean isCheckInitiallyDeferred = false;
                if (cca instanceof CreateConstraintConstantAction) {
                    CreateConstraintConstantAction ccca = (CreateConstraintConstantAction)cca;
                    int constraintType = ccca.getConstraintType();
                    isCheckInitiallyDeferred = constraintType == 4 && ccca.isInitiallyDeferred();
                    switch (constraintType) {
                        case 2: {
                            ConstraintDescriptorList cdl = this.dd.getConstraintDescriptors(this.td);
                            if (cdl.getPrimaryKey() != null) {
                                throw StandardException.newException("X0Y58.S", this.td.getQualifiedName());
                            }
                            if (tableScanned) break;
                            tableScanned = true;
                            numRows = this.getSemiRowCount(this.tc);
                            break;
                        }
                        case 4: {
                            if (!tableScanned) {
                                tableScanned = true;
                                numRows = this.getSemiRowCount(this.tc);
                            }
                            if (isCheckInitiallyDeferred) {
                                this.constraintActions[conIndex].executeConstantAction(activation);
                            }
                            if (numRows <= 0) break;
                            ConstraintConstantAction.validateConstraint(cca.getConstraintName(), ((CreateConstraintConstantAction)cca).getConstraintText(), cca.getConstraintId(), this.td, this.lcc, true, isCheckInitiallyDeferred);
                        }
                    }
                } else if (!(cca instanceof DropConstraintConstantAction) && !(cca instanceof AlterConstraintConstantAction)) {
                    SanityManager.THROWASSERT("constraintActions[" + conIndex + "] expected to be instanceof DropConstraintConstantAction not " + cca.getClass().getName());
                }
                if (isCheckInitiallyDeferred) continue;
                this.constraintActions[conIndex].executeConstantAction(activation);
            }
        }
        if (this.lockGranularity != '\u0000') {
            if (this.lockGranularity != 'T' && this.lockGranularity != 'R') {
                SanityManager.THROWASSERT("lockGranularity expected to be 'T'or 'R', not " + this.lockGranularity);
            }
            this.td.setLockGranularity(this.lockGranularity);
            this.dd.updateLockGranularity(this.td, this.sd, this.lockGranularity, this.tc);
        }
        if (this.compressTable) {
            this.compressTable();
        }
        if (this.truncateTable) {
            this.truncateTable();
        }
    }

    private void clearState() {
        this.td = null;
        this.lcc = null;
        this.dd = null;
        this.dm = null;
        this.tc = null;
        this.activation = null;
    }

    private void dropStatistics() throws StandardException {
        this.td = this.dd.getTableDescriptor(this.tableId);
        this.dd.startWriting(this.lcc);
        this.dm.invalidateFor(this.td, 40, this.lcc);
        if (this.dropStatisticsAll) {
            this.dd.dropStatisticsDescriptors(this.td.getUUID(), null, this.tc);
        } else {
            ConglomerateDescriptor cd = this.dd.getConglomerateDescriptor(this.indexNameForStatistics, this.sd, false);
            this.dd.dropStatisticsDescriptors(this.td.getUUID(), cd.getUUID(), this.tc);
        }
    }

    private void updateStatistics() throws StandardException {
        this.td = this.dd.getTableDescriptor(this.tableId);
        ConglomerateDescriptor[] cds = this.updateStatisticsAll ? null : new ConglomerateDescriptor[]{this.dd.getConglomerateDescriptor(this.indexNameForStatistics, this.sd, false)};
        this.dd.getIndexStatsRefresher(false).runExplicitly(this.lcc, this.td, cds, "ALTER TABLE");
    }

    private void truncateEnd(TransactionController tc) throws StandardException {
        switch (this.td.getTableType()) {
            case 2: 
            case 5: {
                break;
            }
            default: {
                ConglomerateDescriptor[] conglom_descriptors = this.td.getConglomerateDescriptors();
                for (int cd_idx = 0; cd_idx < conglom_descriptors.length; ++cd_idx) {
                    ConglomerateDescriptor cd = conglom_descriptors[cd_idx];
                    tc.compressConglomerate(cd.getConglomerateNumber());
                }
            }
        }
    }

    /*
     * Exception decompiling
     */
    private void defragmentRows(TransactionController tc) throws StandardException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 3[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void setup_indexes(TransactionController tc, TableDescriptor td, int[][] index_col_map, ScanController[] index_scan, ConglomerateController[] index_cc, DataValueDescriptor[][] index_row) throws StandardException {
        ConglomerateDescriptor[] conglom_descriptors = td.getConglomerateDescriptors();
        int index_idx = 0;
        for (int cd_idx = 0; cd_idx < conglom_descriptors.length; ++cd_idx) {
            ConglomerateDescriptor index_cd = conglom_descriptors[cd_idx];
            if (!index_cd.isIndex()) continue;
            index_scan[index_idx] = tc.openScan(index_cd.getConglomerateNumber(), true, 4, 7, 5, null, null, 0, null, null, 0);
            index_cc[index_idx] = tc.openConglomerate(index_cd.getConglomerateNumber(), true, 4, 7, 5);
            int[] baseColumnPositions = index_cd.getIndexDescriptor().baseColumnPositions();
            int[] zero_based_map = new int[baseColumnPositions.length];
            for (int i = 0; i < baseColumnPositions.length; ++i) {
                zero_based_map[i] = baseColumnPositions[i] - 1;
            }
            index_col_map[index_idx] = zero_based_map;
            index_row[index_idx] = new DataValueDescriptor[baseColumnPositions.length + 1];
            ++index_idx;
        }
    }

    private static void fixIndex(DataValueDescriptor[] base_row, DataValueDescriptor[] index_row, RowLocation old_row_loc, RowLocation new_row_loc, ConglomerateController index_cc, ScanController index_scan, int[] index_col_map) throws StandardException {
        SanityManager.ASSERT(index_col_map != null);
        SanityManager.ASSERT(index_row != null);
        SanityManager.ASSERT(index_col_map.length == index_row.length - 1);
        for (int index = 0; index < index_col_map.length; ++index) {
            index_row[index] = base_row[index_col_map[index]];
        }
        index_row[index_row.length - 1] = old_row_loc;
        index_scan.reopenScan(index_row, 1, null, index_row, -1);
        if (index_scan.next()) {
            index_scan.delete();
        } else {
            SanityManager.THROWASSERT("Did not find row to delete.base_row = " + RowUtil.toString(base_row) + "index_row = " + RowUtil.toString(index_row));
        }
        index_row[index_row.length - 1] = new_row_loc;
        index_cc.insert(index_row);
    }

    private void purgeRows(TransactionController tc) throws StandardException {
        switch (this.td.getTableType()) {
            case 2: 
            case 5: {
                break;
            }
            default: {
                ConglomerateDescriptor[] conglom_descriptors = this.td.getConglomerateDescriptors();
                for (int cd_idx = 0; cd_idx < conglom_descriptors.length; ++cd_idx) {
                    ConglomerateDescriptor cd = conglom_descriptors[cd_idx];
                    tc.purgeConglomerate(cd.getConglomerateNumber());
                }
            }
        }
    }

    private void addNewColumnToTable(int ix) throws StandardException {
        ColumnDescriptor columnDescriptor = this.td.getColumnDescriptor(this.columnInfo[ix].name);
        int colNumber = this.td.getMaxColumnID() + ix;
        if (columnDescriptor != null) {
            throw StandardException.newException("X0Y32.S", columnDescriptor.getDescriptorType(), this.columnInfo[ix].name, this.td.getDescriptorType(), this.td.getQualifiedName());
        }
        DataValueDescriptor storableDV = this.columnInfo[ix].defaultValue != null ? this.columnInfo[ix].defaultValue : this.columnInfo[ix].dataType.getNull();
        this.tc.addColumnToConglomerate(this.td.getHeapConglomerateId(), colNumber, storableDV, this.columnInfo[ix].dataType.getCollationType());
        UUID defaultUUID = this.columnInfo[ix].newDefaultUUID;
        if (this.columnInfo[ix].defaultInfo != null && defaultUUID == null) {
            defaultUUID = this.dd.getUUIDFactory().createUUID();
        }
        columnDescriptor = new ColumnDescriptor(this.columnInfo[ix].name, colNumber + 1, this.columnInfo[ix].dataType, this.columnInfo[ix].defaultValue, this.columnInfo[ix].defaultInfo, this.td, defaultUUID, this.columnInfo[ix].autoincStart, this.columnInfo[ix].autoincInc, this.columnInfo[ix].autoinc_create_or_modify_Start_Increment, this.columnInfo[ix].autoincCycle);
        this.dd.addDescriptor(columnDescriptor, this.td, 2, false, this.tc);
        this.td.getColumnDescriptorList().add(columnDescriptor);
        if (columnDescriptor.isAutoincrement()) {
            CreateSequenceConstantAction csca = CreateTableConstantAction.makeCSCA(this.columnInfo[ix], TableDescriptor.makeSequenceName(this.td.getUUID()));
            csca.executeConstantAction(this.activation);
        }
        if (columnDescriptor.isAutoincrement() || columnDescriptor.hasNonNullDefault()) {
            this.updateNewColumnToDefault(columnDescriptor);
        }
        this.addColumnDependencies(this.lcc, this.dd, this.td, this.columnInfo[ix]);
        this.dd.updateSYSCOLPERMSforAddColumnToUserTable(this.td.getUUID(), this.tc);
    }

    private void dropColumnFromTable(String columnName) throws StandardException {
        int i;
        boolean cascade = this.behavior == 0;
        ColumnDescriptorList generatedColumnList = this.td.getGeneratedColumns();
        int generatedColumnCount = generatedColumnList.size();
        ArrayList<String> cascadedDroppedColumns = new ArrayList<String>();
        for (int i2 = 0; i2 < generatedColumnCount; ++i2) {
            ColumnDescriptor generatedColumn = generatedColumnList.elementAt(i2);
            String[] referencedColumnNames = generatedColumn.getDefaultInfo().getReferencedColumnNames();
            int referencedColumnCount = referencedColumnNames.length;
            for (int j = 0; j < referencedColumnCount; ++j) {
                if (!columnName.equals(referencedColumnNames[j])) continue;
                String generatedColumnName = generatedColumn.getColumnName();
                if (!cascade) {
                    throw StandardException.newException("X0Y25.S", this.dm.getActionString(37), columnName, "GENERATED COLUMN", generatedColumnName);
                }
                cascadedDroppedColumns.add(generatedColumnName);
            }
        }
        DataDescriptorGenerator ddg = this.dd.getDataDescriptorGenerator();
        int cascadedDrops = cascadedDroppedColumns.size();
        int sizeAfterCascadedDrops = this.td.getColumnDescriptorList().size() - cascadedDrops;
        if (sizeAfterCascadedDrops == 1) {
            throw StandardException.newException("X0Y25.S", this.dm.getActionString(37), "THE *LAST* COLUMN " + columnName, "TABLE", this.td.getQualifiedName());
        }
        for (int i3 = 0; i3 < cascadedDrops; ++i3) {
            String generatedColumnName = (String)cascadedDroppedColumns.get(i3);
            this.activation.addWarning(StandardException.newWarning("01009", generatedColumnName, this.td.getName()));
            this.dropColumnFromTable(generatedColumnName);
        }
        this.td = this.dd.getTableDescriptor(this.tableId);
        ColumnDescriptor columnDescriptor = this.td.getColumnDescriptor(columnName);
        if (columnDescriptor == null) {
            throw StandardException.newException("42X14", columnName, this.td.getQualifiedName());
        }
        int size = this.td.getColumnDescriptorList().size();
        this.droppedColumnPosition = columnDescriptor.getPosition();
        FormatableBitSet toDrop = new FormatableBitSet(size + 1);
        toDrop.set(this.droppedColumnPosition);
        this.td.setReferencedColumnMap(toDrop);
        this.dm.invalidateFor(this.td, cascade ? 37 : 46, this.lcc);
        if (columnDescriptor.getDefaultInfo() != null) {
            this.dm.clearDependencies(this.lcc, columnDescriptor.getDefaultDescriptor(this.dd));
        }
        if (columnDescriptor.isAutoincrement() && this.dd.checkVersion(230, null)) {
            DropTableConstantAction.dropIdentitySequence(this.dd, this.td, this.activation);
        }
        for (TriggerDescriptor trd : this.dd.getTriggerDescriptors(this.td)) {
            int j;
            int[] referencedColsInTriggerAction;
            boolean triggerDroppedAlready = false;
            int[] referencedCols = trd.getReferencedCols();
            if (referencedCols != null) {
                int j2;
                int refColLen = referencedCols.length;
                boolean changed = false;
                for (j2 = 0; j2 < refColLen; ++j2) {
                    if (referencedCols[j2] > this.droppedColumnPosition) {
                        changed = true;
                        continue;
                    }
                    if (referencedCols[j2] != this.droppedColumnPosition) continue;
                    if (cascade) {
                        trd.drop(this.lcc);
                        triggerDroppedAlready = true;
                        this.activation.addWarning(StandardException.newWarning("01502", trd.getName(), this.td.getName()));
                        break;
                    }
                    throw StandardException.newException("X0Y25.S", this.dm.getActionString(37), columnName, "TRIGGER", trd.getName());
                }
                if (j2 == refColLen && changed) {
                    this.dd.dropTriggerDescriptor(trd, this.tc);
                    for (j2 = 0; j2 < refColLen; ++j2) {
                        if (referencedCols[j2] <= this.droppedColumnPosition) continue;
                        int n = j2;
                        referencedCols[n] = referencedCols[n] - 1;
                    }
                    trd.setReferencedCols(referencedCols);
                    this.dd.addDescriptor(trd, this.sd, 13, false, this.tc);
                }
            }
            if (triggerDroppedAlready || (referencedColsInTriggerAction = trd.getReferencedColsInTriggerAction()) == null) continue;
            int refColInTriggerActionLen = referencedColsInTriggerAction.length;
            boolean changedColPositionInTriggerAction = false;
            for (j = 0; j < refColInTriggerActionLen; ++j) {
                if (referencedColsInTriggerAction[j] > this.droppedColumnPosition) {
                    changedColPositionInTriggerAction = true;
                    continue;
                }
                if (referencedColsInTriggerAction[j] != this.droppedColumnPosition) continue;
                if (cascade) {
                    trd.drop(this.lcc);
                    triggerDroppedAlready = true;
                    this.activation.addWarning(StandardException.newWarning("01502", trd.getName(), this.td.getName()));
                    break;
                }
                throw StandardException.newException("X0Y25.S", this.dm.getActionString(37), columnName, "TRIGGER", trd.getName());
            }
            if (j != refColInTriggerActionLen || !changedColPositionInTriggerAction) continue;
            this.dd.dropTriggerDescriptor(trd, this.tc);
            for (j = 0; j < refColInTriggerActionLen; ++j) {
                if (referencedColsInTriggerAction[j] <= this.droppedColumnPosition) continue;
                int n = j;
                referencedColsInTriggerAction[n] = referencedColsInTriggerAction[n] - 1;
            }
            trd.setReferencedColsInTriggerAction(referencedColsInTriggerAction);
            this.dd.addDescriptor(trd, this.sd, 13, false, this.tc);
        }
        ConstraintDescriptorList csdl = this.dd.getConstraintDescriptors(this.td);
        int csdl_size = csdl.size();
        ArrayList<ConstantAction> newCongloms = new ArrayList<ConstantAction>();
        int tbr_size = 0;
        ConstraintDescriptor[] toBeRemoved = new ConstraintDescriptor[csdl_size];
        for (i = csdl_size - 1; i >= 0; --i) {
            int j;
            ConstraintDescriptor cd = csdl.elementAt(i);
            int[] referencedColumns = cd.getReferencedColumns();
            int numRefCols = referencedColumns.length;
            boolean changed = false;
            for (j = 0; j < numRefCols; ++j) {
                if (referencedColumns[j] > this.droppedColumnPosition) {
                    changed = true;
                }
                if (referencedColumns[j] == this.droppedColumnPosition) break;
            }
            if (j == numRefCols) {
                if (!(cd instanceof CheckConstraintDescriptor) || !changed) continue;
                this.dd.dropConstraintDescriptor(cd, this.tc);
                for (j = 0; j < numRefCols; ++j) {
                    if (referencedColumns[j] <= this.droppedColumnPosition) continue;
                    int n = j;
                    referencedColumns[n] = referencedColumns[n] - 1;
                }
                ((CheckConstraintDescriptor)cd).setReferencedColumnsDescriptor(new ReferencedColumnsDescriptorImpl(referencedColumns));
                this.dd.addConstraintDescriptor(cd, this.tc);
                continue;
            }
            if (!cascade) {
                throw StandardException.newException("X0Y25.S", this.dm.getActionString(37), columnName, "CONSTRAINT", cd.getConstraintName());
            }
            if (cd instanceof ReferencedKeyConstraintDescriptor) {
                toBeRemoved[tbr_size++] = cd;
                continue;
            }
            this.dm.invalidateFor(cd, 19, this.lcc);
            this.dropConstraint(cd, this.td, newCongloms, this.activation, this.lcc, true);
            this.activation.addWarning(StandardException.newWarning("01500", cd.getConstraintName(), this.td.getName()));
        }
        for (i = tbr_size - 1; i >= 0; --i) {
            ConstraintDescriptor cd = toBeRemoved[i];
            this.dropConstraint(cd, this.td, newCongloms, this.activation, this.lcc, false);
            this.activation.addWarning(StandardException.newWarning("01500", cd.getConstraintName(), this.td.getName()));
            if (cascade) {
                ConstraintDescriptorList fkcdl = this.dd.getForeignKeys(cd.getUUID());
                for (ConstraintDescriptor fkcd : fkcdl) {
                    this.dm.invalidateFor(fkcd, 19, this.lcc);
                    this.dropConstraint(fkcd, this.td, newCongloms, this.activation, this.lcc, true);
                    this.activation.addWarning(StandardException.newWarning("01500", fkcd.getConstraintName(), fkcd.getTableDescriptor().getName()));
                }
            }
            this.dm.invalidateFor(cd, 19, this.lcc);
            this.dm.clearDependencies(this.lcc, cd);
        }
        this.createNewBackingCongloms(newCongloms, null);
        this.td = this.dd.getTableDescriptor(this.tableId);
        this.compressTable();
        ColumnDescriptorList tab_cdl = this.td.getColumnDescriptorList();
        this.dd.dropColumnDescriptor(this.td.getUUID(), columnName, this.tc);
        TupleDescriptor[] cdlArray = new ColumnDescriptor[size - columnDescriptor.getPosition()];
        int i4 = columnDescriptor.getPosition();
        int j = 0;
        while (i4 < size) {
            ColumnDescriptor cd = tab_cdl.elementAt(i4);
            this.dd.dropColumnDescriptor(this.td.getUUID(), cd.getColumnName(), this.tc);
            cd.setPosition(i4);
            if (cd.isAutoincrement()) {
                cd.setAutoinc_create_or_modify_Start_Increment(0);
            }
            cdlArray[j] = cd;
            ++i4;
            ++j;
        }
        this.dd.addDescriptorArray(cdlArray, this.td, 2, false, this.tc);
        List<DependencyDescriptor> depsOnAlterTableList = this.dd.getProvidersDescriptorList(this.td.getObjectID().toString());
        for (DependencyDescriptor depOnAT : depsOnAlterTableList) {
            DependableFinder dependent = depOnAT.getDependentFinder();
            if (!dependent.getSQLObjectType().equals("StoredPreparedStatement")) continue;
            List<DependencyDescriptor> depsTrigger = this.dd.getProvidersDescriptorList(depOnAT.getUUID().toString());
            for (DependencyDescriptor depsTriggerDesc : depsTrigger) {
                DependableFinder providerIsTrigger = depsTriggerDesc.getDependentFinder();
                if (!providerIsTrigger.getSQLObjectType().equals("Trigger")) continue;
                TriggerDescriptor trdToBeDropped = this.dd.getTriggerDescriptor(depsTriggerDesc.getUUID());
                UUID whenClauseId = trdToBeDropped.getWhenClauseId();
                boolean gotDropped = false;
                if (whenClauseId != null) {
                    gotDropped = this.columnDroppedAndTriggerDependencies(trdToBeDropped, whenClauseId, true, cascade, columnName);
                }
                if (gotDropped) continue;
                this.columnDroppedAndTriggerDependencies(trdToBeDropped, trdToBeDropped.getActionId(), false, cascade, columnName);
            }
        }
        this.dd.updateSYSCOLPERMSforDropColumn(this.td.getUUID(), this.tc, columnDescriptor);
        tab_cdl.remove(this.td.getColumnDescriptor(columnName));
    }

    private boolean columnDroppedAndTriggerDependencies(TriggerDescriptor trd, UUID spsUUID, boolean isWhenClause, boolean cascade, String columnName) throws StandardException {
        this.dd.dropTriggerDescriptor(trd, this.tc);
        SchemaDescriptor compSchema = this.dd.getSchemaDescriptor(this.dd.getSPSDescriptor(spsUUID).getCompSchemaId(), null);
        CompilerContext newCC = this.lcc.pushCompilerContext(compSchema);
        Parser pa = newCC.getParser();
        String originalSQL = isWhenClause ? trd.getWhenClauseText() : trd.getTriggerDefinition();
        Visitable node = isWhenClause ? pa.parseSearchCondition(originalSQL) : pa.parseStatement(originalSQL);
        this.lcc.popCompilerContext(newCC);
        newCC = null;
        try {
            SPSDescriptor sps = isWhenClause ? trd.getWhenClauseSPS(this.lcc) : trd.getActionSPS(this.lcc);
            int[] referencedColsInTriggerAction = new int[this.td.getNumberOfColumns()];
            Arrays.fill(referencedColsInTriggerAction, -1);
            Object newText = this.dd.getTriggerActionString(node, trd.getOldReferencingName(), trd.getNewReferencingName(), originalSQL, trd.getReferencedCols(), referencedColsInTriggerAction, 0, trd.getTableDescriptor(), trd.getTriggerEventMask(), true, null, null);
            if (isWhenClause) {
                newText = "VALUES " + (String)newText;
            }
            sps.setText((String)newText);
            newCC = this.lcc.pushCompilerContext(compSchema);
            newCC.setReliability(0);
            pa = newCC.getParser();
            StatementNode stmtnode = (StatementNode)pa.parseStatement((String)newText);
            newCC.setCurrentDependent(sps.getPreparedStatement());
            stmtnode.bindStatement();
        }
        catch (StandardException se) {
            if (se.getMessageId().equals("42X04") || se.getMessageId().equals("42X14") || se.getMessageId().equals("42802") || se.getMessageId().equals("42X05")) {
                if (cascade) {
                    trd.drop(this.lcc);
                    this.activation.addWarning(StandardException.newWarning("01502", trd.getName(), this.td.getName()));
                    boolean bl = true;
                    return bl;
                }
                throw StandardException.newException("X0Y25.S", this.dm.getActionString(37), columnName, "TRIGGER", trd.getName());
            }
            throw se;
        }
        finally {
            if (newCC != null) {
                this.lcc.popCompilerContext(newCC);
            }
        }
        this.dd.addDescriptor(trd, this.sd, 13, false, this.tc);
        return false;
    }

    private void modifyColumnType(int ix) throws StandardException {
        ColumnDescriptor columnDescriptor = this.td.getColumnDescriptor(this.columnInfo[ix].name);
        ColumnDescriptor newColumnDescriptor = new ColumnDescriptor(this.columnInfo[ix].name, columnDescriptor.getPosition(), this.columnInfo[ix].dataType, columnDescriptor.getDefaultValue(), columnDescriptor.getDefaultInfo(), this.td, columnDescriptor.getDefaultUUID(), this.columnInfo[ix].autoincStart, this.columnInfo[ix].autoincInc, this.columnInfo[ix].autoincCycle);
        this.dd.dropColumnDescriptor(this.td.getUUID(), this.columnInfo[ix].name, this.tc);
        this.dd.addDescriptor(newColumnDescriptor, this.td, 2, false, this.tc);
    }

    private void modifyColumnConstraint(String colName, boolean nullability) throws StandardException {
        ColumnDescriptor columnDescriptor = this.td.getColumnDescriptor(colName);
        DataTypeDescriptor dataType = columnDescriptor.getType().getNullabilityType(nullability);
        ConstraintDescriptorList cdl = this.dd.getConstraintDescriptors(this.td);
        int columnPostion = columnDescriptor.getPosition();
        for (int i = 0; i < cdl.size(); ++i) {
            ConglomerateDescriptor desc;
            ConstraintDescriptor cd = cdl.elementAt(i);
            if (cd.getConstraintType() != 3) continue;
            ColumnDescriptorList columns = cd.getColumnDescriptors();
            for (int count = 0; count < columns.size() && columns.elementAt(count).getPosition() == columnPostion && ((desc = this.td.getConglomerateDescriptor(cd.getConglomerateId())).getIndexDescriptor().isUnique() || desc.getIndexDescriptor().hasDeferrableChecking()); ++count) {
                this.recreateUniqueConstraintBackingIndexAsUniqueWhenNotNull(desc, this.td, this.activation, this.lcc);
            }
        }
        ColumnDescriptor newColumnDescriptor = new ColumnDescriptor(colName, columnDescriptor.getPosition(), dataType, columnDescriptor.getDefaultValue(), columnDescriptor.getDefaultInfo(), this.td, columnDescriptor.getDefaultUUID(), columnDescriptor.getAutoincStart(), columnDescriptor.getAutoincInc(), columnDescriptor.getAutoincCycle());
        this.dd.dropColumnDescriptor(this.td.getUUID(), colName, this.tc);
        this.dd.addDescriptor(newColumnDescriptor, this.td, 2, false, this.tc);
    }

    private void modifyColumnDefault(int ix) throws StandardException {
        ColumnDescriptor columnDescriptor = this.td.getColumnDescriptor(this.columnInfo[ix].name);
        int columnPosition = columnDescriptor.getPosition();
        if (columnDescriptor.hasNonNullDefault()) {
            DefaultDescriptor defaultDescriptor = new DefaultDescriptor(this.dd, this.columnInfo[ix].oldDefaultUUID, this.td.getUUID(), columnPosition);
            this.dm.invalidateFor(defaultDescriptor, 31, this.lcc);
            this.dm.clearDependencies(this.lcc, defaultDescriptor);
        }
        UUID defaultUUID = this.columnInfo[ix].newDefaultUUID;
        if (this.columnInfo[ix].defaultInfo != null && defaultUUID == null) {
            defaultUUID = this.dd.getUUIDFactory().createUUID();
        }
        columnDescriptor = new ColumnDescriptor(this.columnInfo[ix].name, columnPosition, this.columnInfo[ix].dataType, this.columnInfo[ix].defaultValue, this.columnInfo[ix].defaultInfo, this.td, defaultUUID, this.columnInfo[ix].autoincStart, this.columnInfo[ix].autoincInc, this.columnInfo[ix].autoinc_create_or_modify_Start_Increment, this.columnInfo[ix].autoincCycle);
        this.dd.dropColumnDescriptor(this.td.getUUID(), this.columnInfo[ix].name, this.tc);
        this.dd.addDescriptor(columnDescriptor, this.td, 2, false, this.tc);
        if (this.columnInfo[ix].action == 6) {
            long maxValue = this.getColumnMax(this.td, this.columnInfo[ix].name, this.columnInfo[ix].autoincInc);
            this.dd.setAutoincrementValue(this.tc, this.td.getUUID(), this.columnInfo[ix].name, maxValue, true);
        } else if (this.columnInfo[ix].action == 5) {
            this.dd.setAutoincrementValue(this.tc, this.td.getUUID(), this.columnInfo[ix].name, this.columnInfo[ix].autoincStart, false);
        }
        if ((this.columnInfo[ix].action == 6 || this.columnInfo[ix].action == 5 || this.columnInfo[ix].action == 10) && this.dd.checkVersion(230, null)) {
            Long currentValue = null;
            if (this.columnInfo[ix].action == 6 || this.columnInfo[ix].action == 10) {
                currentValue = this.dd.peekAtIdentity(this.td.getSchemaName(), this.td.getName());
            }
            if (this.columnInfo[ix].action == 10) {
                int topOrBottom;
                if (this.columnInfo[ix].autoincCycle) {
                    if (currentValue == null) {
                        topOrBottom = this.columnInfo[ix].autoincInc > 0L ? 1 : 0;
                        currentValue = this.getRangeBound(this.columnInfo[ix].dataType, topOrBottom);
                    }
                } else {
                    topOrBottom = this.columnInfo[ix].autoincInc > 0L ? 1 : 0;
                    Long rolloverValue = this.getRangeBound(this.columnInfo[ix].dataType, topOrBottom);
                    if (currentValue != null && currentValue.equals(rolloverValue)) {
                        currentValue = null;
                    }
                }
            }
            DropTableConstantAction.dropIdentitySequence(this.dd, this.td, this.activation);
            String sequenceName = TableDescriptor.makeSequenceName(this.td.getUUID());
            CreateSequenceConstantAction csca = CreateTableConstantAction.makeCSCA(this.columnInfo[ix], sequenceName);
            csca.executeConstantAction(this.activation);
            if (this.columnInfo[ix].action == 6 || this.columnInfo[ix].action == 10) {
                SequenceDescriptor sequence = this.dd.getSequenceDescriptor(this.dd.getSystemSchemaDescriptor(), sequenceName);
                RowLocation[] rowLocation = new RowLocation[1];
                SequenceDescriptor[] sequenceDescriptor = new SequenceDescriptor[1];
                this.dd.computeSequenceRowLocation(this.tc, sequence.getUUID().toString(), rowLocation, sequenceDescriptor);
                this.dd.updateCurrentSequenceValue(this.tc, rowLocation[0], true, null, currentValue);
            }
        }
    }

    private long getRangeBound(DataTypeDescriptor dtd, int topOrBottom) throws StandardException {
        boolean bottom;
        TypeId typeId = dtd.getTypeId();
        boolean bl = bottom = topOrBottom == 1;
        if (typeId == TypeId.SMALLINT_ID) {
            return bottom ? Long.valueOf(-32768L) : Long.valueOf(32767L);
        }
        if (typeId == TypeId.INTEGER_ID) {
            return bottom ? Long.valueOf(Integer.MIN_VALUE) : Long.valueOf(Integer.MAX_VALUE);
        }
        if (typeId != TypeId.BIGINT_ID) {
            throw StandardException.newException("0A000.S", new Object[0]);
        }
        return bottom ? Long.MIN_VALUE : Long.MAX_VALUE;
    }

    private void modifyIdentityState(int ix) throws StandardException {
        boolean willBeGeneratedAlways;
        ColumnDescriptor oldColumnDescriptor = this.td.getColumnDescriptor(this.columnInfo[ix].name);
        int columnPosition = oldColumnDescriptor.getPosition();
        boolean wasGeneratedAlways = oldColumnDescriptor.isAutoincAlways();
        boolean bl = willBeGeneratedAlways = this.columnInfo[ix].action == 8;
        if (wasGeneratedAlways == willBeGeneratedAlways) {
            return;
        }
        UUID defaultUUID = willBeGeneratedAlways ? null : this.dd.getUUIDFactory().createUUID();
        ColumnDescriptor newColumnDescriptor = new ColumnDescriptor(this.columnInfo[ix].name, columnPosition, oldColumnDescriptor.getType(), this.columnInfo[ix].defaultValue, this.columnInfo[ix].defaultInfo, this.td, defaultUUID, oldColumnDescriptor.getAutoincStart(), oldColumnDescriptor.getAutoincInc(), 3L, oldColumnDescriptor.getAutoincCycle());
        this.dd.dropColumnDescriptor(this.td.getUUID(), this.columnInfo[ix].name, this.tc);
        this.dd.addDescriptor(newColumnDescriptor, this.td, 2, false, this.tc);
    }

    private void compressTable() throws StandardException {
        Properties properties = new Properties();
        if (this.lockGranularity != '\u0000') {
            SanityManager.THROWASSERT("lockGranularity expected to be '\u0000', not " + this.lockGranularity);
        }
        SanityManager.ASSERT(!this.compressTable || this.columnInfo == null, "columnInfo expected to be null");
        SanityManager.ASSERT(this.constraintActions == null, "constraintActions expected to be null");
        ExecRow emptyHeapRow = this.td.getEmptyExecRow();
        int[] collation_ids = this.td.getColumnCollationIds();
        this.compressHeapCC = this.tc.openConglomerate(this.td.getHeapConglomerateId(), false, 4, 7, 5);
        RowLocation rl = this.compressHeapCC.newRowLocationTemplate();
        this.compressHeapCC.getInternalTablePropertySet(properties);
        this.compressHeapCC.close();
        this.compressHeapCC = null;
        this.baseRow = new ExecRow[this.bulkFetchSize];
        this.baseRowArray = new DataValueDescriptor[this.bulkFetchSize][];
        this.validRow = new boolean[this.bulkFetchSize];
        this.getAffectedIndexes();
        this.compressRL = new RowLocation[this.bulkFetchSize];
        this.indexRows = new ExecIndexRow[this.numIndexes];
        if (!this.compressTable) {
            ExecRow newRow = this.activation.getExecutionFactory().getValueRow(emptyHeapRow.nColumns() - 1);
            int[] new_collation_ids = new int[collation_ids.length - 1];
            for (int i = 0; i < newRow.nColumns(); ++i) {
                newRow.setColumn(i + 1, i < this.droppedColumnPosition - 1 ? emptyHeapRow.getColumn(i + 1) : emptyHeapRow.getColumn(i + 1 + 1));
                new_collation_ids[i] = collation_ids[i < this.droppedColumnPosition - 1 ? i : i + 1];
            }
            emptyHeapRow = newRow;
            collation_ids = new_collation_ids;
        }
        this.setUpAllSorts(emptyHeapRow, rl);
        this.openBulkFetchScan(this.td.getHeapConglomerateId());
        this.estimatedRowCount = this.compressHeapGSC.getEstimatedRowCount();
        for (int i = 0; i < this.bulkFetchSize; ++i) {
            this.baseRow[i] = this.td.getEmptyExecRow();
            this.baseRowArray[i] = this.baseRow[i].getRowArray();
            this.compressRL[i] = this.compressHeapGSC.newRowLocationTemplate();
        }
        long newHeapConglom = this.tc.createAndLoadConglomerate("heap", emptyHeapRow.getRowArray(), null, collation_ids, properties, 0, this, null);
        this.closeBulkFetchScan();
        ScanController compressHeapSC = this.tc.openScan(newHeapConglom, false, 4, 7, 5, null, null, 0, null, null, 0);
        compressHeapSC.setEstimatedRowCount(this.rowCount);
        compressHeapSC.close();
        compressHeapSC = null;
        this.dd.startWriting(this.lcc);
        if (this.compressIRGs.length > 0) {
            this.updateAllIndexes(newHeapConglom, this.dd);
        }
        long oldHeapConglom = this.td.getHeapConglomerateId();
        ConglomerateDescriptor cd = this.td.getConglomerateDescriptor(oldHeapConglom);
        this.dd.updateConglomerateDescriptor(cd, newHeapConglom, this.tc);
        this.dm.invalidateFor(this.td, 33, this.lcc);
        this.tc.dropConglomerate(oldHeapConglom);
        this.cleanUp();
    }

    private void truncateTable() throws StandardException {
        Properties properties = new Properties();
        if (this.lockGranularity != '\u0000') {
            SanityManager.THROWASSERT("lockGranularity expected to be '\u0000', not " + this.lockGranularity);
        }
        SanityManager.ASSERT(this.columnInfo == null, "columnInfo expected to be null");
        SanityManager.ASSERT(this.constraintActions == null, "constraintActions expected to be null");
        for (ConstraintDescriptor cd : this.dd.getConstraintDescriptors(this.td)) {
            ReferencedKeyConstraintDescriptor rfcd;
            Iterator iterator;
            if (!(cd instanceof ReferencedKeyConstraintDescriptor) || !(iterator = (rfcd = (ReferencedKeyConstraintDescriptor)cd).getNonSelfReferencingFK(1).iterator()).hasNext()) continue;
            ConstraintDescriptor fkcd = (ConstraintDescriptor)iterator.next();
            ForeignKeyConstraintDescriptor fk = (ForeignKeyConstraintDescriptor)fkcd;
            throw StandardException.newException("XCL48.S", this.td.getName());
        }
        for (TriggerDescriptor trd : this.dd.getTriggerDescriptors(this.td)) {
            if (!trd.listensForEvent(2) || !trd.isEnabled()) continue;
            throw StandardException.newException("XCL49.S", this.td.getName(), trd.getName());
        }
        ExecRow emptyHeapRow = this.td.getEmptyExecRow();
        this.compressHeapCC = this.tc.openConglomerate(this.td.getHeapConglomerateId(), false, 4, 7, 5);
        RowLocation rl = this.compressHeapCC.newRowLocationTemplate();
        this.compressHeapCC.getInternalTablePropertySet(properties);
        this.compressHeapCC.close();
        this.compressHeapCC = null;
        long newHeapConglom = this.tc.createConglomerate("heap", emptyHeapRow.getRowArray(), null, this.td.getColumnCollationIds(), properties, 0);
        this.getAffectedIndexes();
        if (this.numIndexes > 0) {
            this.indexRows = new ExecIndexRow[this.numIndexes];
            this.ordering = new ColumnOrdering[this.numIndexes][];
            this.collation = new int[this.numIndexes][];
            for (int index = 0; index < this.numIndexes; ++index) {
                IndexRowGenerator curIndex = this.compressIRGs[index];
                this.indexRows[index] = curIndex.getIndexRowTemplate();
                curIndex.getIndexRow(emptyHeapRow, rl, this.indexRows[index], null);
                int[] baseColumnPositions = curIndex.baseColumnPositions();
                boolean[] isAscending = curIndex.isAscending();
                int numColumnOrderings = baseColumnPositions.length + 1;
                this.ordering[index] = new ColumnOrdering[numColumnOrderings];
                this.collation[index] = curIndex.getColumnCollationIds(this.td.getColumnDescriptorList());
                for (int ii = 0; ii < numColumnOrderings - 1; ++ii) {
                    this.ordering[index][ii] = new IndexColumnOrder(ii, isAscending[ii]);
                }
                this.ordering[index][numColumnOrderings - 1] = new IndexColumnOrder(numColumnOrderings - 1);
            }
        }
        this.dd.startWriting(this.lcc);
        if (this.numIndexes > 0) {
            long[] newIndexCongloms = new long[this.numIndexes];
            for (int index = 0; index < this.numIndexes; ++index) {
                this.updateIndex(newHeapConglom, this.dd, index, newIndexCongloms);
            }
        }
        long oldHeapConglom = this.td.getHeapConglomerateId();
        ConglomerateDescriptor cd = this.td.getConglomerateDescriptor(oldHeapConglom);
        this.dd.updateConglomerateDescriptor(cd, newHeapConglom, this.tc);
        this.dm.invalidateFor(this.td, 42, this.lcc);
        this.tc.dropConglomerate(oldHeapConglom);
        this.cleanUp();
    }

    private void updateAllIndexes(long newHeapConglom, DataDictionary dd) throws StandardException {
        long[] newIndexCongloms = new long[this.numIndexes];
        if (this.sequential) {
            if (this.numIndexes >= 1) {
                this.updateIndex(newHeapConglom, dd, 0, newIndexCongloms);
            }
            for (int index = 1; index < this.numIndexes; ++index) {
                this.openBulkFetchScan(newHeapConglom);
                while (this.getNextRowFromRowSource() != null) {
                    this.objectifyStreamingColumns();
                    this.insertIntoSorter(index, this.compressRL[this.currentCompressRow - 1]);
                }
                this.updateIndex(newHeapConglom, dd, index, newIndexCongloms);
                this.closeBulkFetchScan();
            }
        } else {
            for (int index = 0; index < this.numIndexes; ++index) {
                this.updateIndex(newHeapConglom, dd, index, newIndexCongloms);
            }
        }
    }

    private void updateIndex(long newHeapConglom, DataDictionary dd, int index, long[] newIndexCongloms) throws StandardException {
        Properties properties = new Properties();
        ConglomerateDescriptor cd = this.td.getConglomerateDescriptor(this.indexConglomerateNumbers[index]);
        ConglomerateController indexCC = this.tc.openConglomerate(this.indexConglomerateNumbers[index], false, 4, 7, 5);
        indexCC.getInternalTablePropertySet(properties);
        int indexRowLength = this.indexRows[index].nColumns();
        properties.put("baseConglomerateId", Long.toString(newHeapConglom));
        if (cd.getIndexDescriptor().isUnique()) {
            properties.put("nUniqueColumns", Integer.toString(indexRowLength - 1));
        } else {
            properties.put("nUniqueColumns", Integer.toString(indexRowLength));
        }
        if (cd.getIndexDescriptor().isUniqueWithDuplicateNulls() && !cd.getIndexDescriptor().hasDeferrableChecking()) {
            properties.put("uniqueWithDuplicateNulls", Boolean.toString(true));
        }
        properties.put("rowLocationColumn", Integer.toString(indexRowLength - 1));
        properties.put("nKeyFields", Integer.toString(indexRowLength));
        indexCC.close();
        boolean statisticsExist = false;
        if (!this.truncateTable) {
            long numRows;
            CardinalityCounter cCount;
            this.sorters[index].completedInserts();
            this.sorters[index] = null;
            if (this.td.statisticsExist(cd)) {
                cCount = new CardinalityCounter(this.tc.openSortRowSource(this.sortIds[index]));
                statisticsExist = true;
            } else {
                cCount = new CardinalityCounter(this.tc.openSortRowSource(this.sortIds[index]));
            }
            newIndexCongloms[index] = this.tc.createAndLoadConglomerate("BTREE", this.indexRows[index].getRowArray(), this.ordering[index], this.collation[index], properties, 0, cCount, null);
            if (statisticsExist) {
                dd.dropStatisticsDescriptors(this.td.getUUID(), cd.getUUID(), this.tc);
            }
            if ((numRows = cCount.getRowCount()) > 0L) {
                long[] c = cCount.getCardinality();
                for (int i = 0; i < c.length; ++i) {
                    StatisticsDescriptor statDesc = new StatisticsDescriptor(dd, dd.getUUIDFactory().createUUID(), cd.getUUID(), this.td.getUUID(), "I", new StatisticsImpl(numRows, c[i]), i + 1);
                    dd.addDescriptor(statDesc, null, 14, true, this.tc);
                }
            }
        } else {
            newIndexCongloms[index] = this.tc.createConglomerate("BTREE", this.indexRows[index].getRowArray(), this.ordering[index], this.collation[index], properties, 0);
            if (this.td.statisticsExist(cd)) {
                dd.dropStatisticsDescriptors(this.td.getUUID(), cd.getUUID(), this.tc);
            }
        }
        dd.updateConglomerateDescriptor(this.td.getConglomerateDescriptors(this.indexConglomerateNumbers[index]), newIndexCongloms[index], this.tc);
        this.tc.dropConglomerate(this.indexConglomerateNumbers[index]);
    }

    private void getAffectedIndexes() throws StandardException {
        IndexLister indexLister = this.td.getIndexLister();
        this.compressIRGs = indexLister.getIndexRowGenerators();
        this.numIndexes = this.compressIRGs.length;
        this.indexConglomerateNumbers = indexLister.getIndexConglomerateNumbers();
        if (!this.compressTable && !this.truncateTable) {
            ArrayList<ConstantAction> newCongloms = new ArrayList<ConstantAction>();
            for (int i = 0; i < this.compressIRGs.length; ++i) {
                ConglomerateDescriptor cd;
                int j;
                int[] baseColumnPositions = this.compressIRGs[i].baseColumnPositions();
                for (j = 0; j < baseColumnPositions.length && baseColumnPositions[j] != this.droppedColumnPosition; ++j) {
                }
                if (j == baseColumnPositions.length) continue;
                if (baseColumnPositions.length == 1 || this.behavior == 0 && this.compressIRGs[i].isUnique()) {
                    --this.numIndexes;
                    cd = this.td.getConglomerateDescriptor(this.indexConglomerateNumbers[i]);
                    this.dropConglomerate(cd, this.td, true, newCongloms, this.activation, this.activation.getLanguageConnectionContext());
                    this.compressIRGs[i] = null;
                    continue;
                }
                if (!this.compressIRGs[i].isUnique()) continue;
                cd = this.td.getConglomerateDescriptor(this.indexConglomerateNumbers[i]);
                throw StandardException.newException("X0Y25.S", this.dm.getActionString(37), this.columnInfo[0].name, "UNIQUE INDEX", cd.getConglomerateName());
            }
            this.createNewBackingCongloms(newCongloms, this.indexConglomerateNumbers);
            IndexRowGenerator[] newIRGs = new IndexRowGenerator[this.numIndexes];
            long[] newIndexConglomNumbers = new long[this.numIndexes];
            this.collation = new int[this.numIndexes][];
            int i = 0;
            int j = 0;
            while (i < this.numIndexes) {
                while (this.compressIRGs[j] == null) {
                    ++j;
                }
                this.collation[i] = this.compressIRGs[j].getColumnCollationIds(this.td.getColumnDescriptorList());
                int[] baseColumnPositions = this.compressIRGs[j].baseColumnPositions();
                newIRGs[i] = this.compressIRGs[j];
                newIndexConglomNumbers[i] = this.indexConglomerateNumbers[j];
                boolean[] isAscending = this.compressIRGs[j].isAscending();
                boolean reMakeArrays = false;
                boolean rewriteBaseColumnPositions = false;
                int size = baseColumnPositions.length;
                for (int k = 0; k < size; ++k) {
                    if (baseColumnPositions[k] > this.droppedColumnPosition) {
                        int n = k;
                        baseColumnPositions[n] = baseColumnPositions[n] - 1;
                        rewriteBaseColumnPositions = true;
                        continue;
                    }
                    if (baseColumnPositions[k] != this.droppedColumnPosition) continue;
                    baseColumnPositions[k] = 0;
                    reMakeArrays = true;
                }
                if (rewriteBaseColumnPositions) {
                    this.compressIRGs[j].setBaseColumnPositions(baseColumnPositions);
                }
                if (reMakeArrays) {
                    int[] newBCP = new int[--size];
                    boolean[] newIsAscending = new boolean[size];
                    int[] newCollation = new int[this.collation[i].length - 1];
                    int step = 0;
                    for (int k = 0; k < size; ++k) {
                        if (step == 0 && baseColumnPositions[k + step] == 0) {
                            ++step;
                        }
                        newBCP[k] = baseColumnPositions[k + step];
                        newIsAscending[k] = isAscending[k + step];
                        newCollation[k] = this.collation[i][k + step];
                    }
                    IndexDescriptor id = this.compressIRGs[j].getIndexDescriptor();
                    id.setBaseColumnPositions(newBCP);
                    id.setIsAscending(newIsAscending);
                    id.setNumberOfOrderedColumns(id.numberOfOrderedColumns() - 1);
                    this.collation[i] = newCollation;
                }
                ++i;
                ++j;
            }
            this.compressIRGs = newIRGs;
            this.indexConglomerateNumbers = newIndexConglomNumbers;
        } else {
            this.collation = new int[this.numIndexes][];
            for (int i = 0; i < this.numIndexes; ++i) {
                this.collation[i] = this.compressIRGs[i].getColumnCollationIds(this.td.getColumnDescriptorList());
            }
        }
        Object[] compressIndexResult = this.compressIndexArrays(this.indexConglomerateNumbers, this.compressIRGs);
        if (compressIndexResult != null) {
            this.indexConglomerateNumbers = (long[])compressIndexResult[1];
            this.compressIRGs = (IndexRowGenerator[])compressIndexResult[2];
            this.numIndexes = this.indexConglomerateNumbers.length;
        }
        this.indexedCols = new FormatableBitSet(this.compressTable || this.truncateTable ? this.td.getNumberOfColumns() + 1 : this.td.getNumberOfColumns());
        for (int index = 0; index < this.numIndexes; ++index) {
            int[] colIds = this.compressIRGs[index].getIndexDescriptor().baseColumnPositions();
            for (int index2 = 0; index2 < colIds.length; ++index2) {
                this.indexedCols.set(colIds[index2]);
            }
        }
    }

    private void createNewBackingCongloms(ArrayList<ConstantAction> newConglomActions, long[] ixCongNums) throws StandardException {
        int sz = newConglomActions.size();
        for (int i = 0; i < sz; ++i) {
            int j;
            CreateIndexConstantAction ca = (CreateIndexConstantAction)newConglomActions.get(i);
            if (this.dd.getConglomerateDescriptor(ca.getCreatedUUID()) == null) continue;
            this.executeConglomReplacement(ca, this.activation);
            long oldCongNum = ca.getReplacedConglomNumber();
            long newCongNum = ca.getCreatedConglomNumber();
            ConglomerateDescriptor[] tdCDs = this.td.getConglomerateDescriptors(oldCongNum);
            for (j = 0; j < tdCDs.length; ++j) {
                tdCDs[j].setConglomerateNumber(newCongNum);
            }
            if (ixCongNums == null) continue;
            for (j = 0; j < ixCongNums.length; ++j) {
                if (ixCongNums[j] != oldCongNum) continue;
                ixCongNums[j] = newCongNum;
            }
        }
    }

    private void setUpAllSorts(ExecRow sourceRow, RowLocation rl) throws StandardException {
        int index;
        this.ordering = new ColumnOrdering[this.numIndexes][];
        this.needToDropSort = new boolean[this.numIndexes];
        this.sortIds = new long[this.numIndexes];
        for (index = 0; index < this.numIndexes; ++index) {
            this.indexRows[index] = this.compressIRGs[index].getIndexRowTemplate();
            this.compressIRGs[index].getIndexRow(sourceRow, rl, this.indexRows[index], null);
            int[] baseColumnPositions = this.compressIRGs[index].baseColumnPositions();
            boolean[] isAscending = this.compressIRGs[index].isAscending();
            int numColumnOrderings = baseColumnPositions.length + 1;
            boolean reuseWrappers = this.numIndexes == 1;
            BasicSortObserver sortObserver = new BasicSortObserver(false, false, this.indexRows[index], reuseWrappers);
            this.ordering[index] = new ColumnOrdering[numColumnOrderings];
            for (int ii = 0; ii < numColumnOrderings - 1; ++ii) {
                this.ordering[index][ii] = new IndexColumnOrder(ii, isAscending[ii]);
            }
            this.ordering[index][numColumnOrderings - 1] = new IndexColumnOrder(numColumnOrderings - 1);
            this.sortIds[index] = this.tc.createSort(null, this.indexRows[index].getRowArrayClone(), this.ordering[index], sortObserver, false, this.estimatedRowCount, -1);
        }
        this.sorters = new SortController[this.numIndexes];
        for (index = 0; index < this.numIndexes; ++index) {
            this.sorters[index] = this.tc.openSort(this.sortIds[index]);
            this.needToDropSort[index] = true;
        }
    }

    @Override
    public FormatableBitSet getValidColumns() {
        return null;
    }

    @Override
    public DataValueDescriptor[] getNextRowFromRowSource() throws StandardException {
        this.currentRow = null;
        if (!(this.doneScan || this.currentCompressRow != this.bulkFetchSize && this.validRow[this.currentCompressRow])) {
            int index;
            int bulkFetched = this.compressHeapGSC.fetchNextGroup(this.baseRowArray, this.compressRL);
            this.doneScan = bulkFetched != this.bulkFetchSize;
            this.currentCompressRow = 0;
            this.rowCount += bulkFetched;
            for (index = 0; index < bulkFetched; ++index) {
                this.validRow[index] = true;
            }
            for (index = bulkFetched; index < this.bulkFetchSize; ++index) {
                this.validRow[index] = false;
            }
        }
        if (this.validRow[this.currentCompressRow]) {
            if (this.compressTable) {
                this.currentRow = this.baseRow[this.currentCompressRow];
            } else {
                if (this.currentRow == null) {
                    this.currentRow = this.activation.getExecutionFactory().getValueRow(this.baseRowArray[this.currentCompressRow].length - 1);
                }
                for (int i = 0; i < this.currentRow.nColumns(); ++i) {
                    this.currentRow.setColumn(i + 1, i < this.droppedColumnPosition - 1 ? this.baseRow[this.currentCompressRow].getColumn(i + 1) : this.baseRow[this.currentCompressRow].getColumn(i + 1 + 1));
                }
            }
            ++this.currentCompressRow;
        }
        if (this.currentRow != null) {
            if (this.compressIRGs.length > 0) {
                this.currentRow = this.currentRow.getClone(this.indexedCols);
            }
            return this.currentRow.getRowArray();
        }
        return null;
    }

    @Override
    public boolean needsToClone() {
        return true;
    }

    @Override
    public void closeRowSource() {
    }

    @Override
    public boolean needsRowLocation() {
        return this.numIndexes > 0;
    }

    @Override
    public boolean needsRowLocationForDeferredCheckConstraints() {
        return false;
    }

    @Override
    public void rowLocation(RowLocation rl) throws StandardException {
        if (this.compressIRGs.length > 0) {
            this.objectifyStreamingColumns();
            int maxIndex = this.compressIRGs.length;
            if (maxIndex > 1 && this.sequential) {
                maxIndex = 1;
            }
            for (int index = 0; index < maxIndex; ++index) {
                this.insertIntoSorter(index, rl);
            }
        }
    }

    private void objectifyStreamingColumns() throws StandardException {
        for (int i = 0; i < this.currentRow.getRowArray().length; ++i) {
            if (!this.indexedCols.get(i + 1) || !(this.currentRow.getRowArray()[i] instanceof StreamStorable)) continue;
            this.currentRow.getRowArray()[i].getObject();
        }
    }

    private void insertIntoSorter(int index, RowLocation rl) throws StandardException {
        this.indexRows[index].getNewObjectArray();
        this.compressIRGs[index].getIndexRow(this.currentRow, (RowLocation)rl.cloneValue(false), this.indexRows[index], null);
        this.sorters[index].insert(this.indexRows[index].getRowArray());
    }

    private void cleanUp() throws StandardException {
        int index;
        if (this.compressHeapCC != null) {
            this.compressHeapCC.close();
            this.compressHeapCC = null;
        }
        if (this.compressHeapGSC != null) {
            this.closeBulkFetchScan();
        }
        if (this.sorters != null) {
            for (index = 0; index < this.compressIRGs.length; ++index) {
                if (this.sorters[index] != null) {
                    this.sorters[index].completedInserts();
                }
                this.sorters[index] = null;
            }
        }
        if (this.needToDropSort != null) {
            for (index = 0; index < this.needToDropSort.length; ++index) {
                if (!this.needToDropSort[index]) continue;
                this.tc.dropSort(this.sortIds[index]);
                this.needToDropSort[index] = false;
            }
        }
    }

    private int getSemiRowCount(TransactionController tc) throws StandardException {
        int numRows = 0;
        ScanController sc = tc.openScan(this.td.getHeapConglomerateId(), false, 0, 7, 5, RowUtil.EMPTY_ROW_BITSET, null, 1, null, null, -1);
        while (sc.next() && ++numRows != 2) {
        }
        sc.close();
        return numRows;
    }

    private void updateNewColumnToDefault(ColumnDescriptor columnDescriptor) throws StandardException {
        String columnName = columnDescriptor.getColumnName();
        String updateStmt = "UPDATE " + IdUtil.mkQualifiedName(this.td.getSchemaName(), this.td.getName()) + " SET " + IdUtil.normalToDelimited(columnName) + "=DEFAULT";
        AlterTableConstantAction.executeUpdate(this.lcc, updateStmt);
    }

    private static void executeUpdate(LanguageConnectionContext lcc, String updateStmt) throws StandardException {
        PreparedStatement ps = lcc.prepareInternalStatement(updateStmt);
        ResultSet rs = ps.executeSubStatement(lcc, true, 0L);
        rs.close();
    }

    private long getColumnMax(TableDescriptor td, String columnName, long increment) throws StandardException {
        String maxStr = increment > 0L ? "MAX" : "MIN";
        String maxStmt = "SELECT  " + maxStr + "(" + IdUtil.normalToDelimited(columnName) + ") FROM " + IdUtil.mkQualifiedName(td.getSchemaName(), td.getName());
        PreparedStatement ps = this.lcc.prepareInternalStatement(maxStmt);
        ResultSet rs = ps.executeSubStatement(this.lcc, false, 0L);
        DataValueDescriptor[] rowArray = rs.getNextRow().getRowArray();
        rs.close();
        rs.finish();
        return rowArray[0].getLong();
    }

    private void openBulkFetchScan(long heapConglomNumber) throws StandardException {
        this.doneScan = false;
        this.compressHeapGSC = this.tc.openGroupFetchScan(heapConglomNumber, false, 0, 7, 5, null, null, 0, null, null, 0);
    }

    private void closeBulkFetchScan() throws StandardException {
        this.compressHeapGSC.close();
        this.compressHeapGSC = null;
    }

    private boolean validateNotNullConstraint(String[] columnNames, boolean[] nullCols, int numRows, LanguageConnectionContext lcc, String errorMsg) throws StandardException {
        boolean foundNullable = false;
        StringBuilder constraintText = new StringBuilder();
        for (int colCtr = 0; colCtr < columnNames.length; ++colCtr) {
            ColumnDescriptor cd = this.td.getColumnDescriptor(columnNames[colCtr]);
            if (cd == null) {
                throw StandardException.newException("42X14", columnNames[colCtr], this.td.getName());
            }
            if (!cd.getType().isNullable()) continue;
            if (numRows > 0) {
                if (foundNullable) {
                    constraintText.append(" AND ");
                }
                constraintText.append(IdUtil.normalToDelimited(columnNames[colCtr]));
                constraintText.append(" IS NOT NULL ");
            }
            foundNullable = true;
            nullCols[colCtr] = true;
        }
        if (foundNullable && numRows > 0 && !ConstraintConstantAction.validateConstraint(null, constraintText.toString(), null, this.td, lcc, false, false)) {
            if (errorMsg.equals("X0Y63.S")) {
                throw StandardException.newException("X0Y63.S", this.td.getQualifiedName());
            }
            if (errorMsg.equals("X0Y63.S.1")) {
                throw StandardException.newException("X0Y63.S.1", this.td.getQualifiedName());
            }
            throw StandardException.newException("X0Y80.S", this.td.getQualifiedName(), columnNames[0]);
        }
        return foundNullable;
    }

    private Object[] compressIndexArrays(long[] indexCIDS, IndexRowGenerator[] irgs) {
        long[] workSpace = new long[indexCIDS.length];
        int j = 0;
        int k = indexCIDS.length - 1;
        for (int i = 0; i < indexCIDS.length; ++i) {
            int m;
            for (m = 0; m < j; ++m) {
                if (indexCIDS[i] != workSpace[m]) continue;
                workSpace[k--] = i;
                break;
            }
            if (m != j) continue;
            workSpace[j++] = indexCIDS[i];
        }
        if (j < indexCIDS.length) {
            long[] newIndexCIDS = new long[j];
            IndexRowGenerator[] newIrgs = new IndexRowGenerator[j];
            int[] duplicateIndexes = new int[indexCIDS.length - j];
            k = 0;
            int n = indexCIDS.length - 1;
            for (int m = 0; m < indexCIDS.length; ++m) {
                if (m < j) {
                    newIndexCIDS[m] = workSpace[m];
                } else {
                    duplicateIndexes[indexCIDS.length - m - 1] = (int)workSpace[m];
                }
                if (n >= j && m == (int)workSpace[n]) {
                    --n;
                    continue;
                }
                newIrgs[k] = irgs[m];
                ++k;
            }
            Object[] returnValue = new Object[]{duplicateIndexes, newIndexCIDS, newIrgs};
            return returnValue;
        }
        return null;
    }

    @Override
    public void offendingRowLocation(RowLocation rl, long containdId) throws StandardException {
        SanityManager.NOTREACHED();
    }
}

