/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.harness;

import java.io.File;
import java.io.FileOutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import org.apache.derby.shared.common.info.JVMInfo;
import org.apache.derbyTesting.functionTests.harness.BackgroundStreamSaver;
import org.apache.derbyTesting.functionTests.harness.TimedProcess;
import org.apache.derbyTesting.functionTests.harness.jvm;
import org.apache.derbyTesting.functionTests.util.TestUtil;

public class NetServer {
    File homeDir;
    String jvmName = "jdk13";
    String clPath;
    String javaCmd;
    String jvmflags;
    String framework;
    String appsRequiredPassword;
    int timeout = 60;
    static String hostName;
    Object[] frameworkInfo;
    int port;
    Process pr;
    BackgroundStreamSaver outSaver;
    BackgroundStreamSaver errSaver;
    FileOutputStream fosOut;
    FileOutputStream fosErr;
    private boolean startServer;
    Object networkServer;
    Method pingMethod;
    private static String NETWORK_SERVER_CLASS_NAME;
    public static Hashtable<String, Object[]> m;
    public static int PREFIX_POS;
    public static int SUFFIX_POS;
    public static int DRIVER_POS;
    public static int PORT_POS;
    public static int START_CMD_POS;
    public static int STOP_CMD1_POS;
    public static int STOP_CMD2_POS;

    private static String[] serverArgs(String string) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        boolean bl = JVMInfo.isModuleAware();
        if (bl) {
            arrayList.add("-p");
            arrayList.add(JVMInfo.getSystemModulePath());
            arrayList.add("-m");
            arrayList.add("org.apache.derby.server/" + NETWORK_SERVER_CLASS_NAME);
        } else {
            arrayList.add(NETWORK_SERVER_CLASS_NAME);
        }
        arrayList.add(string);
        String[] stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        return stringArray;
    }

    public NetServer(File file, String string, String string2, String string3, String string4, String string5, boolean bl, String string6) throws Exception {
        int n;
        this.homeDir = file;
        this.jvmName = string;
        this.clPath = string2;
        this.javaCmd = string3;
        this.jvmflags = string4;
        this.framework = string5;
        if (string4 != null && string4.length() > 0 && (n = string4.indexOf("-Dtimeout")) >= 0) {
            String string7 = string4.substring(n);
            String[] stringArray = string7.split(" ");
            string7 = stringArray[0];
            string7 = string7.substring(10);
            this.timeout = Integer.parseInt(string7.trim());
        }
        this.appsRequiredPassword = string6;
        this.frameworkInfo = m.get(string5);
        this.port = Integer.parseInt((String)this.frameworkInfo[PORT_POS]);
        this.startServer = bl;
    }

    public void start() throws Exception {
        if (!this.startServer) {
            System.out.println("startServer = false. Bypass server startup");
            return;
        }
        new File(this.homeDir, this.framework + "Server").mkdir();
        String[] stringArray = (String[])this.frameworkInfo[START_CMD_POS];
        if (stringArray == null) {
            return;
        }
        String string = this.homeDir.getCanonicalPath();
        jvm jvm2 = null;
        jvm2 = jvm.getJvm(this.jvmName);
        if (this.jvmName.equals("jview")) {
            jvm2.setJavaCmd("jview");
        } else if (this.javaCmd != null) {
            jvm2.setJavaCmd(this.javaCmd);
        }
        Vector<String> vector = new Vector<String>();
        if (this.clPath != null && this.clPath.length() > 0) {
            jvm2.setClasspath(this.clPath);
        }
        if (this.jvmflags != null && this.jvmflags.length() > 0) {
            jvm2.setFlags(this.jvmflags);
        }
        vector.addElement("derby.system.home=" + string);
        jvm2.setD(vector);
        jvm2.setSecurityProps();
        Vector<String> vector2 = jvm2.getCommandLine();
        for (int i = 0; i < stringArray.length; ++i) {
            vector2.addElement(stringArray[i]);
        }
        String[] stringArray2 = new String[vector2.size()];
        for (int i = 0; i < vector2.size(); ++i) {
            stringArray2[i] = vector2.elementAt(i);
            System.out.print(stringArray2[i] + " ");
        }
        System.out.println("");
        this.pr = Runtime.getRuntime().exec(stringArray2);
        File file = new File(this.homeDir, this.framework + ".out");
        this.fosOut = new FileOutputStream(file);
        this.outSaver = new BackgroundStreamSaver(this.pr.getInputStream(), this.fosOut);
        File file2 = new File(this.homeDir, this.framework + ".err");
        this.fosErr = new FileOutputStream(file2);
        this.errSaver = new BackgroundStreamSaver(this.pr.getErrorStream(), this.fosErr);
        for (int i = 0; i <= 120 && !NetServer.isDB2Connection(this.framework); ++i) {
            try {
                if (NetServer.isNetworkServerConnection(this.framework)) {
                    if (!this.testNetworkServerConnection()) continue;
                    break;
                }
                Socket socket = new Socket(hostName, this.port);
                socket.close();
                break;
            }
            catch (Exception exception) {
                if (file2.length() > 0L) break;
                Thread.sleep(1000L);
            }
        }
    }

    public boolean testNetworkServerConnection() throws Exception {
        if (!this.startServer) {
            System.out.println("startServer = false. Bypass server check");
            return true;
        }
        if (this.networkServer == null) {
            Class<?> clazz = Class.forName(NETWORK_SERVER_CLASS_NAME);
            Constructor<?> constructor = clazz.getConstructor(new Class[0]);
            this.networkServer = constructor.newInstance(new Object[0]);
            this.pingMethod = this.networkServer.getClass().getMethod("ping", new Class[0]);
        }
        this.pingMethod.invoke(this.networkServer, new Object[0]);
        return true;
    }

    public void stop() throws Exception {
        if (!this.startServer) {
            return;
        }
        System.out.println("Attempt to shutdown framework: " + this.framework);
        jvm jvm2 = null;
        jvm2 = jvm.getJvm(this.jvmName);
        Vector<String> vector = jvm2.getCommandLine();
        Vector<String> vector2 = new Vector<String>();
        for (int i = 0; i < vector.size(); ++i) {
            vector2.addElement(vector.elementAt(i));
        }
        String[] stringArray = (String[])this.frameworkInfo[STOP_CMD1_POS];
        if (stringArray == null) {
            return;
        }
        if (this.appsRequiredPassword != null) {
            String[] stringArray2 = new String[stringArray.length + 4];
            System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
            stringArray2[stringArray.length] = "-user";
            stringArray2[stringArray.length + 1] = "app";
            stringArray2[stringArray.length + 2] = "-password";
            stringArray2[stringArray.length + 3] = this.appsRequiredPassword;
            stringArray = stringArray2;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            vector2.addElement(stringArray[i]);
        }
        String[] stringArray3 = new String[vector2.size()];
        for (int i = 0; i < vector2.size(); ++i) {
            stringArray3[i] = (String)vector2.elementAt(i);
        }
        Vector<String> vector3 = new Vector<String>();
        for (int i = 0; i < vector.size(); ++i) {
            vector3.addElement(vector.elementAt(i));
        }
        Process process = Runtime.getRuntime().exec(stringArray3);
        TimedProcess timedProcess = new TimedProcess(process);
        timedProcess.waitFor(this.timeout);
        String[] stringArray4 = (String[])this.frameworkInfo[STOP_CMD2_POS];
        if (stringArray4 != null) {
            for (int i = 0; i < stringArray4.length; ++i) {
                vector3.addElement(stringArray4[i]);
            }
            String[] stringArray5 = new String[vector3.size()];
            for (int i = 0; i < vector3.size(); ++i) {
                stringArray5[i] = (String)vector3.elementAt(i);
            }
            Process process2 = Runtime.getRuntime().exec(stringArray5);
            process2.waitFor();
        }
        timedProcess = new TimedProcess(this.pr);
        timedProcess.waitFor(this.timeout);
        this.outSaver.finish();
        this.errSaver.finish();
    }

    public void printFramworkInfo(String string) {
        System.out.println("PREFIX = " + this.frameworkInfo[PREFIX_POS]);
        System.out.println("SUFFIX = " + this.frameworkInfo[SUFFIX_POS]);
        System.out.println("DRIVER = " + this.frameworkInfo[DRIVER_POS]);
        System.out.println("PORT = " + this.frameworkInfo[PORT_POS]);
        for (int i = START_CMD_POS; i <= STOP_CMD2_POS; ++i) {
            Object object = "";
            String[] stringArray = (String[])this.frameworkInfo[i];
            for (int j = 0; j < stringArray.length; ++j) {
                object = (String)object + " " + stringArray[j];
            }
            if (i == START_CMD_POS) {
                System.out.println("START_CMD =  " + (String)object);
                continue;
            }
            System.out.println("STOP_CMD = " + (String)object);
        }
    }

    public static String getURLPrefix(String string) {
        Object[] objectArray = m.get(string);
        return (String)objectArray[PREFIX_POS];
    }

    public static String getURLSuffix(String string) {
        Object[] objectArray = m.get(string);
        return (String)objectArray[SUFFIX_POS];
    }

    public static String getDriverName(String string) {
        Object[] objectArray = m.get(string);
        if (objectArray != null) {
            return (String)objectArray[DRIVER_POS];
        }
        return null;
    }

    public static boolean isDB2Connection(String string) {
        return string.toUpperCase(Locale.ENGLISH).equals("DB2APP") || string.toUpperCase(Locale.ENGLISH).equals("DB2JCC");
    }

    public static boolean isNetworkServerConnection(String string) {
        return string.toUpperCase(Locale.ENGLISH).startsWith("DERBYNET");
    }

    public static boolean isClientConnection(String string) {
        return string.toUpperCase(Locale.ENGLISH).startsWith("DERBYNET") || string.toUpperCase(Locale.ENGLISH).equals("DB2JCC");
    }

    public static boolean isJCCConnection(String string) {
        return string.toUpperCase(Locale.ENGLISH).equals("DB2JCC") || string.toUpperCase(Locale.ENGLISH).equals("DERBYNET");
    }

    public static String alterURL(String string, String object) {
        String string2 = "jdbc:derby:";
        String string3 = NetServer.getURLPrefix(string);
        String string4 = NetServer.getURLSuffix(string);
        if (string3 == null) {
            return object;
        }
        if (string4 == null) {
            string4 = "";
        }
        if (((String)object).equals(string2)) {
            return string3;
        }
        int n = ((String)object).indexOf(59);
        if (NetServer.isDB2Connection(string) && n != -1) {
            object = ((String)object).substring(0, n);
        }
        if (((String)object).startsWith(string2)) {
            object = string3 + ((String)object).substring(string2.length()) + string4;
        } else if (!((String)object).startsWith("jdbc:")) {
            object = string3 + (String)object + string4;
        }
        return object;
    }

    static {
        NETWORK_SERVER_CLASS_NAME = "org.apache.derby.drda.NetworkServerControl";
        PREFIX_POS = 0;
        SUFFIX_POS = 1;
        DRIVER_POS = 2;
        PORT_POS = 3;
        START_CMD_POS = 4;
        STOP_CMD1_POS = 5;
        STOP_CMD2_POS = 6;
        hostName = TestUtil.getHostName();
        m = new Hashtable();
        String string = "jdbc:derby:net://" + hostName + ":1527/";
        m.put("DerbyNet", new Object[]{string, "", "com.ibm.db2.jcc.DB2Driver", "1527", NetServer.serverArgs("start"), NetServer.serverArgs("shutdown"), null});
        string = "jdbc:derby://" + hostName + ":1527/";
        m.put("DerbyNetClient", new Object[]{string, "", "org.apache.derby.jdbc.ClientDriver", "1527", NetServer.serverArgs("start"), NetServer.serverArgs("shutdown"), null});
        string = "jdbc:db2://" + hostName + ":50000/";
        m.put("DB2jcc", new Object[]{string, "", "com.ibm.db2.jcc.DB2Driver", "50000", null, null, null});
        m.put("DB2app", new Object[]{"jdbc:db2:", "", "COM.ibm.db2.jdbc.app.DB2Driver", "0", null, null, null});
    }
}

