/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.util.Properties;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.tests.lang.LuceneBackupTest;
import org.apache.derbyTesting.functionTests.tests.lang.LuceneCoarseAuthorizationTest;
import org.apache.derbyTesting.functionTests.tests.lang.LuceneCollationTest;
import org.apache.derbyTesting.functionTests.tests.lang.LuceneInMemoryTest;
import org.apache.derbyTesting.functionTests.tests.lang.LuceneJarLoadingTest;
import org.apache.derbyTesting.functionTests.tests.lang.LuceneSupportPermsTest;
import org.apache.derbyTesting.functionTests.tests.lang.LuceneSupportTest;
import org.apache.derbyTesting.junit.BaseTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class LuceneSuite
extends BaseTestCase {
    private LuceneSuite(String string) {
        super(string);
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("LuceneSuite");
        Properties properties = TestConfiguration.getSystemProperties();
        if (LuceneSuite.getBooleanProperty(properties, "derby.tests.omitLucene")) {
            LuceneSuite.assertFalse((String)"Lucene core jar file should not be on the classpath!", (boolean)JDBC.HAVE_LUCENE_CORE);
            LuceneSuite.assertFalse((String)"Lucene analyzer jar file should not be on the classpath!", (boolean)JDBC.HAVE_LUCENE_ANALYZERS);
            LuceneSuite.assertFalse((String)"Lucene query parser jar file should not be on the classpath!", (boolean)JDBC.HAVE_LUCENE_QUERYPARSER);
        } else if (JDBC.HAVE_LUCENE_CORE && LuceneSuite.suffersFromDerby6650()) {
            LuceneSuite.alarm("Lucene tests are skipped on this platform because of DERBY-6650. Please upgrade to Lucene 4.8 or higher if you would like to run them.");
        } else {
            baseTestSuite.addTest(LuceneSupportTest.suite());
            baseTestSuite.addTest(LuceneSupportPermsTest.suite());
            baseTestSuite.addTest(LuceneCollationTest.suite());
            baseTestSuite.addTest(LuceneCoarseAuthorizationTest.suite());
            baseTestSuite.addTest(LuceneInMemoryTest.suite());
            baseTestSuite.addTest(LuceneBackupTest.suite());
            baseTestSuite.addTest(LuceneJarLoadingTest.suite());
        }
        return baseTestSuite;
    }

    private static boolean getBooleanProperty(Properties properties, String string) {
        return Boolean.valueOf(properties.getProperty(string));
    }

    private static boolean suffersFromDerby6650() {
        if (JDBC.vmSupportsJMX()) {
            return false;
        }
        Class<?> clazz = null;
        try {
            clazz = Class.forName("org.apache.lucene.util.Version");
        }
        catch (ClassNotFoundException classNotFoundException) {
            LuceneSuite.fail("Could not check Lucene version", classNotFoundException);
        }
        try {
            clazz.getField("LUCENE_48");
        }
        catch (NoSuchFieldException noSuchFieldException) {
            try {
                clazz.getField("LUCENE_4_8");
            }
            catch (NoSuchFieldException noSuchFieldException2) {
                return true;
            }
        }
        return false;
    }
}

