/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.memorydb;

import java.util.Arrays;
import java.util.Random;
import org.apache.derbyTesting.junit.BaseTestCase;

public class ClusMog {
    public static final int max_n = 6;
    public int n = 0;
    public final double[] weight = new double[6];
    public final double[] mean = new double[6];
    public final double[] var = new double[6];
    protected int[] bracket = new int[7];
    protected int ns = 0;
    protected double[] sample = null;
    public static final int min_sample_size_per_cluster = 32;

    public void cluster(int n, double[] dArray, int n2, double[] dArray2) {
        this.setCenters(n, dArray);
        this.setSamples(n2, dArray2);
        this.initEM();
        double d = Double.MAX_VALUE;
        int n3 = 1;
        while (true) {
            this.expectation();
            this.maximization();
            double d2 = this.measure();
            double d3 = Math.abs(d2 - d);
            double d4 = d3 / (1.0 + d);
            d = d2;
            if (d4 < 1.0E-6) break;
            ++n3;
        }
        this.computeWeights();
        this.printMog("JAVA-COMPUTED", n, this.weight, this.mean, this.var);
        BaseTestCase.println("msr = (" + d + ")");
    }

    public static void uniform(int n, double[] dArray, int n2, double[] dArray2) {
        double d = Double.MAX_VALUE;
        double d2 = -1.7976931348623157E308;
        for (int i = 0; i < n2; ++i) {
            double d3 = dArray2[i];
            if (d > d3) {
                d = d3;
            }
            if (!(d2 < d3)) continue;
            d2 = d3;
        }
        double d4 = d2 - d;
        double d5 = d4 / (double)n;
        dArray[0] = d5 / 2.0;
        for (int i = 1; i < n; ++i) {
            dArray[i] = dArray[i - 1] + d5;
        }
    }

    public static void random(int n, double[] dArray, int n2, double[] dArray2, Random random) {
        double d = Double.MAX_VALUE;
        double d2 = -1.7976931348623157E308;
        for (int i = 0; i < n2; ++i) {
            double d3 = dArray2[i];
            if (d > d3) {
                d = d3;
            }
            if (!(d2 < d3)) continue;
            d2 = d3;
        }
        double d4 = d2 - d;
        for (int i = 0; i < n; ++i) {
            double d5;
            double d6 = random.nextDouble();
            dArray[i] = d5 = d + d6 * d4;
        }
    }

    void setCenters(int n, double[] dArray) {
        if (1 > n || n > 6) {
            String string = "Number of Gaussian components (" + n + ") not in [1, 6].";
            throw new IllegalArgumentException(string);
        }
        this.n = n;
        System.arraycopy(dArray, 0, this.mean, 0, n);
    }

    void setSamples(int n, double[] dArray) {
        int n2 = this.n * 32;
        if (n < n2) {
            String string = "Insufficient sample size (" + n + " < " + n2 + ").";
            throw new IllegalArgumentException(string);
        }
        this.ns = n;
        this.sample = dArray;
    }

    void initEM() {
        Arrays.sort(this.sample, 0, this.ns);
        Arrays.sort(this.mean, 0, this.n);
        this.maximization();
    }

    void expectation() {
        int n;
        int n2;
        int n3 = 0;
        int n4 = 1;
        block0: do {
            n2 = this.bracket[n3];
            while (n4 < this.n) {
                n = this.bracket[n4];
                if (n2 < n) {
                    this.bracket[n3 + 1] = n;
                    ++n3;
                    ++n4;
                    continue block0;
                }
                ++n4;
            }
        } while (n4 < this.n);
        this.n = n3 + 1;
        for (n3 = 0; n3 < this.n; ++n3) {
            double d;
            double d2;
            n4 = this.bracket[n3];
            n2 = this.bracket[n3 + 1];
            n = n2 - n4;
            double d3 = 0.0;
            for (int i = n4; i < n2; ++i) {
                double d4 = this.sample[i];
                d3 += d4;
            }
            this.mean[n3] = d2 = d3 / (double)n;
            d3 = 0.0;
            for (int i = n4; i < n2; ++i) {
                double d5 = this.sample[i];
                double d6 = d5 - d2;
                d3 += d6 * d6;
            }
            this.var[n3] = d = n > 1 ? d3 / (double)(n - 1) : 0.0;
        }
    }

    void maximization() {
        this.bracket[0] = 0;
        for (int i = 1; i < this.n; ++i) {
            double d = this.mean[i - 1];
            double d2 = this.mean[i];
            int n = this.bracket[i - 1];
            int n2 = this.ns;
            while (n < n2 - 1) {
                double d3;
                int n3 = n + n2 >> 1;
                double d4 = this.sample[n3];
                double d5 = Math.abs(d4 - d);
                if (d5 < (d3 = Math.abs(d2 - d4))) {
                    n = n3;
                    continue;
                }
                n2 = n3;
            }
            this.bracket[i] = n2;
        }
        this.bracket[this.n] = this.ns;
    }

    double measure() {
        double d = 0.0;
        for (int i = 0; i < this.n; ++i) {
            int n = this.bracket[i];
            int n2 = this.bracket[i + 1];
            int n3 = n2 - n;
            double d2 = this.var[i];
            d += d2 * (double)(n3 - 1);
        }
        return d /= (double)this.ns;
    }

    void computeWeights() {
        for (int i = 0; i < this.n; ++i) {
            double d;
            int n = this.bracket[i];
            int n2 = this.bracket[i + 1];
            int n3 = n2 - n;
            this.weight[i] = d = this.ns > 0 ? (double)n3 / (double)this.ns : 0.0;
        }
    }

    void printMog(String string, int n, double[] dArray, double[] dArray2, double[] dArray3) {
        BaseTestCase.println(string + ": n = " + n);
        for (int i = 0; i < n; ++i) {
            BaseTestCase.println("(w, m, v) = (" + dArray[i] + ", " + dArray2[i] + ", " + dArray3[i] + ")");
        }
    }
}

