/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.util;

import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.apache.derby.iapi.services.context.Context;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;

public abstract class PropertyUtil
extends org.apache.derby.iapi.util.PropertyUtil {
    public static Serializable getDatabasePropertyDefault(String string) throws Exception {
        LanguageConnectionContext languageConnectionContext = (LanguageConnectionContext)PropertyUtil.getContextOrNull("LanguageConnectionContext");
        if (languageConnectionContext == null) {
            throw new Exception("getPropertyDefault only works in a connection");
        }
        return languageConnectionContext.getTransactionExecute().getPropertyDefault(string);
    }

    public static void setDatabasePropertyDefault(String string, Serializable serializable) throws Exception {
        LanguageConnectionContext languageConnectionContext = (LanguageConnectionContext)PropertyUtil.getContextOrNull("LanguageConnectionContext");
        if (languageConnectionContext == null) {
            throw new Exception("getPropertyDefault only works in a connection");
        }
        languageConnectionContext.getTransactionExecute().setPropertyDefault(string, serializable);
    }

    private static Context getContextOrNull(final String string) {
        if (System.getSecurityManager() == null) {
            return ContextService.getContextOrNull((String)string);
        }
        return AccessController.doPrivileged(new PrivilegedAction<Context>(){

            @Override
            public Context run() {
                return ContextService.getContextOrNull((String)string);
            }
        });
    }
}

