/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.junit;

import java.net.URL;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class Derby {
    public static boolean hasEmbedded() {
        if (!TestConfiguration.isJars) {
            return true;
        }
        return Derby.hasCorrectJar("/derby.jar", "org.apache.derby.authentication.UserAuthenticator");
    }

    public static boolean hasServer() {
        if (JDBC.vmSupportsJSR169()) {
            return false;
        }
        if (!TestConfiguration.isJars) {
            return true;
        }
        return Derby.hasCorrectJar("/derbynet.jar", "org.apache.derby.drda.NetworkServerControl");
    }

    public static boolean hasTools() {
        if (!TestConfiguration.isJars) {
            return true;
        }
        return Derby.hasCorrectJar("/derbytools.jar", "org.apache.derby.tools.ij");
    }

    public static boolean hasClient() {
        if (JDBC.vmSupportsJSR169()) {
            return false;
        }
        if (!TestConfiguration.isJars) {
            return true;
        }
        return Derby.hasCorrectJar("/derbytools.jar", JDBC.vmSupportsJNDI() ? "org.apache.derby.jdbc.ClientDataSource" : "org.apache.derby.jdbc.BasicClientDataSource40");
    }

    private static boolean hasCorrectJar(String jarName, String className) {
        URL url = TestConfiguration.getURL(className);
        if (url == null) {
            return false;
        }
        return url.toExternalForm().endsWith(jarName);
    }
}

